/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.schedule.notification;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.util.HostDBHandler;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.api.RestAPIUtil;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ela.server.common.license.LicenseHandler;
import java.util.Properties;
import java.util.logging.Logger;

public class ELALicenseStatusUpdater
implements Task {
    private static final String CONVERT_HOST_API = "CONVERT_HOST_AND_INHERITEDHOST";
    private static final Logger LOGGER = Logger.getLogger(ELALicenseStatusUpdater.class.getName());

    public void executeTask(TaskContext paramTaskContext) throws TaskExecutionException {
        try {
            this.publishToAllProduct();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    private void publishToAllProduct() throws Exception {
        Object parentProduct = HostDBHandler.getParentProductSeqNumber();
        Properties params = new Properties();
        params.setProperty("PUBLISH_TOALL", "TRUE");
        params.setProperty("UPDATE_ACTION", "TRUE");
        LicenseHandler handler = LicenseHandler.getInstance();
        params.setProperty("SEQUENCE_ID", ProductUniqueSeqGenerator.getCurrentSeqNumber());
        params.setProperty("LICENSE_COUNT", "" + handler.getnoOfWindowsServerDevicesForADAP());
        params.setProperty("WORKSTATION_LICENSE_COUNT", "" + handler.getnoOfWindowsWorkstationDevicesForADAP());
        Criteria crit = new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"SEQUENCE_ID"), parentProduct, 0);
        DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSProductDetails", crit);
        if (!dobj.isEmpty()) {
            RestAPI api = new RestAPI();
            api.execute(RestAPIUtil.getAPIId((Long)((Long)dobj.getFirstValue("ADSProductDetails", "PRODUCT_ID")), (String)CONVERT_HOST_API), params);
            LOGGER.info("Response Text : " + api.getResponseText());
        } else {
            LOGGER.info("Unable to Find product API");
        }
    }
}

