/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.security;

import com.manageengine.ela.server.common.security.ELAEncryptDecrypt;
import com.manageengine.ela.server.common.security.ELAEncryptionAPI;
import com.manageengine.ela.server.common.security.ScharKeyHandler;
import com.manageengine.ela.server.common.security.utils.PasswordGenerator;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class ELAEncryptDecryptImpl
implements ELAEncryptDecrypt {
    private static final int ENCRYPT_MODE = 1;
    private static final int DECRYPT_MODE = 2;
    private static final String UTF8 = "UTF-8";
    private static Cipher cipher;
    private static String ela32BitKey;
    private static Logger log;

    public ELAEncryptDecryptImpl() throws Exception {
        log.finest("ELAEncryptDecryptImpl() - called...");
    }

    @Override
    public String getEla32BitKey() {
        return ela32BitKey;
    }

    @Override
    public void setEla32BitKey(String ela32BitKey) {
        ELAEncryptDecryptImpl.ela32BitKey = ela32BitKey;
    }

    @Override
    public String generateCryptographicKey() throws Exception {
        String aes256Key = null;
        if (ELAEncryptionAPI.is32BitKeyGenerated()) {
            log.info("Key already exists");
            ela32BitKey = aes256Key = ELAEncryptionAPI.get32BitELAConfKey();
            return aes256Key;
        }
        log.info("Creating new key");
        ela32BitKey = aes256Key = PasswordGenerator.generate32BitPasswordKey();
        ELAEncryptionAPI.updateKeyGeneratedEntry("conf_file");
        log.info("updated entry as conf_file");
        this.createELAEncryptKeyConfFile();
        log.info("After createELAEncryptKeyConfFile");
        ScharKeyHandler.GenPasswordKey();
        log.info("Before return aes256Key");
        return aes256Key;
    }

    @Override
    public String getMSSQLMasterKey() {
        return ELAEncryptionAPI.readMSSQLMasterKey();
    }

    @Override
    public byte[] encrypt(String plainText, String key) throws Exception {
        try {
            return this.encrypt(plainText.getBytes("utf-8"), this.padding(key));
        }
        catch (UnsupportedEncodingException ex) {
            log.severe("Exception while encrypt password 1 :" + ex.toString());
            throw new Exception("Exception occurred while encrypting", ex);
        }
    }

    @Override
    public byte[] encrypt(String plainText, byte[] key) throws Exception {
        try {
            return this.encrypt(plainText.getBytes("utf-8"), key);
        }
        catch (UnsupportedEncodingException ex) {
            throw new Exception("Exception occurred while encrypting", ex);
        }
    }

    @Override
    public byte[] encrypt(byte[] plainText, String key) throws Exception {
        return this.encrypt(plainText, this.padding(key));
    }

    @Override
    public synchronized byte[] encrypt(byte[] plainText, byte[] key) throws Exception {
        try {
            byte[] ivArr = this.getIvBytes(plainText, 1);
            this.initCiper(key, 1, ivArr);
            log.info("After initCipher");
            byte[] ciphertext = cipher.doFinal(plainText);
            int len = ciphertext.length;
            byte[] ciphertxtFinal = new byte[len + 16];
            for (int i = 0; i < 16; ++i) {
                ciphertxtFinal[i] = ivArr[i];
            }
            int j = 16;
            for (int i = 0; i < len; ++i) {
                ciphertxtFinal[j] = ciphertext[i];
                ++j;
            }
            return ciphertxtFinal;
        }
        catch (IllegalBlockSizeException ibe) {
            log.info("Exception while encryptpassword : " + ibe.toString());
            ibe.printStackTrace();
            throw new Exception("Exception occurred while encrypting", ibe);
        }
        catch (BadPaddingException ibe) {
            log.severe("Exception while encryptpassword : " + ibe.toString());
            ibe.printStackTrace();
            throw new Exception("Exception occurred while encrypting", ibe);
        }
    }

    @Override
    public byte[] decrypt(byte[] cipherText, String key) throws Exception {
        return this.decrypt(cipherText, this.padding(key));
    }

    @Override
    public synchronized byte[] decrypt(byte[] cipherText, byte[] key) throws Exception {
        try {
            byte[] ivArr = this.getIvBytes(cipherText, 2);
            this.initCiper(key, 2, ivArr);
            byte[] cipherTextFinal = this.getPasswordWOIv(cipherText, 2);
            return cipher.doFinal(cipherTextFinal);
        }
        catch (IllegalBlockSizeException ex) {
            throw new Exception("Exception occurred while encrypting", ex);
        }
        catch (BadPaddingException ex) {
            throw new Exception("Exception occurred while encrypting", ex);
        }
    }

    private void initCiper(byte[] aeskey, int opmode, byte[] ivArr) throws Exception {
        try {
            cipher = Cipher.getInstance("AES/CTR/NoPadding");
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(new String(aeskey, UTF8).toCharArray(), new byte[]{1, 2, 3, 4, 5, 6, 7, 8}, 1024, 256);
            SecretKey temp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(temp.getEncoded(), "AES");
            cipher.init(opmode, (Key)secret, new IvParameterSpec(ivArr));
        }
        catch (NoSuchAlgorithmException ibe) {
            log.severe("Exception in init cipher : " + ibe.toString());
            ibe.printStackTrace();
            throw new Exception("Exception occurred while encrypting", ibe);
        }
        catch (NoSuchPaddingException npe) {
            log.severe("Exception in init cipher : " + npe.toString());
            npe.printStackTrace();
            throw new Exception("Exception occurred while encrypting", npe);
        }
        catch (InvalidKeyException ike) {
            log.severe("Exception in init cipher : " + ike.toString());
            ike.printStackTrace();
            throw new Exception("Exception occurred while encrypting", ike);
        }
        catch (InvalidAlgorithmParameterException iape) {
            log.severe("Exception in init cipher : " + iape.toString());
            iape.printStackTrace();
            throw new Exception("Exception occurred while encrypting", iape);
        }
        catch (InvalidKeySpecException ikse) {
            log.severe("Exception in init cipher : " + ikse.toString());
            ikse.printStackTrace();
            throw new Exception("Exception occurred while encrypting", ikse);
        }
    }

    private byte[] getPasswordWOIv(byte[] password, int opmode) throws Exception {
        if (opmode == 1) {
            return password;
        }
        int pLen = password.length;
        byte[] pwdArr = new byte[pLen - 16];
        int j = 0;
        for (int i = 16; i < pLen; ++i) {
            pwdArr[j] = password[i];
            ++j;
        }
        return pwdArr;
    }

    private byte[] getIvBytes(byte[] password, int opmode) throws Exception {
        int ivLen = 16;
        byte[] ivbyteArr = new byte[16];
        if (opmode == 1) {
            SecureRandom srand = new SecureRandom();
            srand.nextBytes(ivbyteArr);
        } else if (opmode == 2) {
            for (int i = 0; i < 16; ++i) {
                ivbyteArr[i] = password[i];
            }
        }
        return ivbyteArr;
    }

    private byte[] padding(String password) {
        for (int i = password.length(); i < 32; ++i) {
            password = password + " ";
        }
        return password.getBytes();
    }

    @Override
    public ByteArrayInputStream encryptCert(InputStream b) throws Exception {
        ByteArrayInputStream bais = null;
        try {
            if (b != null) {
                byte[] certarr = IOUtils.toByteArray((InputStream)b);
                byte[] encryptedCertArr = this.encrypt(certarr, this.getEla32BitKey());
                bais = new ByteArrayInputStream(encryptedCertArr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bais;
    }

    @Override
    public byte[] decryptCertStream(InputStream in) throws Exception {
        return this.decryptCertStream(in, this.getEla32BitKey());
    }

    @Override
    public byte[] decryptCertStream(InputStream in, String key) throws Exception {
        byte[] decryptedCertArr = null;
        try {
            if (in != null) {
                byte[] certarr = IOUtils.toByteArray((InputStream)in);
                decryptedCertArr = this.decrypt(certarr, key);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return decryptedCertArr;
    }

    @Override
    public ByteArrayInputStream decryptInputStream(InputStream in) throws Exception {
        return this.decryptInputStream(in, this.getEla32BitKey());
    }

    @Override
    public ByteArrayInputStream decryptInputStream(InputStream in, String key) throws Exception {
        ByteArrayInputStream bais = null;
        try {
            if (in != null) {
                byte[] certarr = IOUtils.toByteArray((InputStream)in);
                byte[] decryptedCertArr = this.decrypt(certarr, key);
                bais = new ByteArrayInputStream(decryptedCertArr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bais;
    }

    @Override
    public String encryptPassword(String password, String key) throws Exception {
        if (password == null || "".equals(password)) {
            return password;
        }
        String encryptedPwd = null;
        try {
            byte[] encPwdArr = this.encrypt(password, key);
            encryptedPwd = new String(Base64.encodeBase64((byte[])encPwdArr));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return encryptedPwd;
    }

    @Override
    public String encryptPassword(String password) throws Exception {
        if (password == null || "".equals(password)) {
            log.info("password is null or empty");
            return password;
        }
        String encryptedPwd = null;
        try {
            byte[] encPwdArr = this.encrypt(password, this.getEla32BitKey());
            encryptedPwd = new String(Base64.encodeBase64((byte[])encPwdArr));
        }
        catch (Exception ex) {
            log.severe("Exception while getting encryptedpassword : " + ex.toString());
            ex.printStackTrace();
        }
        return encryptedPwd;
    }

    @Override
    public String decryptPassword(String encryptedPassword, String key) throws Exception {
        String decryptedPassword = null;
        if (encryptedPassword == null || "".equals(encryptedPassword)) {
            return encryptedPassword;
        }
        try {
            byte[] encPwdArr = Base64.decodeBase64((byte[])encryptedPassword.getBytes());
            byte[] decryptedPwdArr = this.decrypt(encPwdArr, key);
            decryptedPassword = new String(decryptedPwdArr, UTF8);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return decryptedPassword;
    }

    @Override
    public String decryptPassword(String encryptedPassword) throws Exception {
        String decryptedPassword = null;
        if (encryptedPassword == null || "".equals(encryptedPassword)) {
            return encryptedPassword;
        }
        try {
            byte[] encPwdArr = Base64.decodeBase64((byte[])encryptedPassword.getBytes());
            byte[] decryptedPwdArr = this.decrypt(encPwdArr, this.getEla32BitKey());
            decryptedPassword = new String(decryptedPwdArr, UTF8);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return decryptedPassword;
    }

    private void createELAEncryptKeyConfFile() throws Exception {
        String genKey = this.getEla32BitKey();
        String home = System.getProperty("server.dir");
        BufferedWriter key = null;
        BufferedWriter keyBackup = null;
        try {
            String fileName = Paths.get(home, "conf", "manage_key.conf").toString();
            String keyFile = Paths.get(home, "conf", "ela_key.key").toString();
            String backupkeyFile = Paths.get(home, "server", "conf", "backup_key.conf").toString();
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            out.write("." + File.separator + "conf" + File.separator + "ela_key.key");
            out.close();
            Properties properties = new Properties();
            properties.setProperty("ENCRYPTIONKEY", genKey);
            key = new BufferedWriter(new FileWriter(keyFile));
            properties.store(key, null);
            keyBackup = new BufferedWriter(new FileWriter(backupkeyFile));
            properties.store(keyBackup, null);
        }
        catch (IOException e) {
            log.severe("Error occured while creating conf file");
            e.printStackTrace();
            throw new Exception("Error occurred while writing the encrypt key");
        }
        finally {
            if (key != null) {
                key.close();
            }
            if (keyBackup != null) {
                keyBackup.close();
            }
        }
    }

    static {
        ela32BitKey = null;
        log = Logger.getLogger(ELAEncryptDecryptImpl.class.getName());
    }
}

