/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.security;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.security.ELAEncryptDecrypt;
import com.manageengine.ela.server.common.security.ELAEncryptDecryptImpl;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELAEncryptionAPI {
    private static ELAEncryptionAPI elaapi = null;
    private static ELAEncryptDecrypt elaEncryptDecrypt = null;
    private static String elaMasterKey = null;
    private static Logger log = Logger.getLogger(ELAEncryptionAPI.class.getName());
    private static Properties dbProps = new Properties();
    private static String home = System.getProperty("server.home");
    private static boolean isCustomEDClass = false;
    private static boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    private static String mssqlMasterKey = null;
    public static boolean useOldDecryption = false;
    public static boolean useNullDecryption = false;
    public static boolean isPPMKeyGenerationRequired = false;
    public static boolean isPPMKeyGenerationChecked = false;
    public static boolean passwordCheckForNull = true;

    public static ELAEncryptionAPI getInstance() throws Exception {
        if (elaapi == null) {
            elaapi = new ELAEncryptionAPI();
            ELAEncryptionAPI.initializeELAED();
        }
        return elaapi;
    }

    public ELAEncryptDecrypt getELAED() {
        return elaEncryptDecrypt;
    }

    public static void setELAKey(String key) {
        elaMasterKey = key;
    }

    public static String getELAKey() {
        return elaMasterKey;
    }

    public static synchronized void initializeELAED() throws Exception {
        if (elaapi == null) {
            elaapi = new ELAEncryptionAPI();
        }
        if (elaEncryptDecrypt == null) {
            try {
                elaEncryptDecrypt = ELAEncryptionAPI.getEDClass();
                if (elaEncryptDecrypt instanceof ELAEncryptDecryptImpl) {
                    elaEncryptDecrypt = (ELAEncryptDecryptImpl)elaEncryptDecrypt;
                    elaEncryptDecrypt.generateCryptographicKey();
                }
                ELAEncryptionAPI.setMSSQLMasterKey(elaEncryptDecrypt.getMSSQLMasterKey());
                ELAEncryptionAPI.setELAKey(ELAEncryptionAPI.getEnterpriseKey());
                log.info(" ## ELA ## Encryptor ## Decryptor ## - Class initialized successfully with " + elaEncryptDecrypt.getClass().getName());
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Exception while initializing ELA Cryptography." + ex.getMessage(), ex);
                ex.printStackTrace();
                ConsoleOut.println((String)("Error: Exception while initializing ELA Cryptography. " + ex.toString()));
                ELAEncryptionAPI.throwException("Error while initializing Cryptography for ELA.");
            }
        }
    }

    public static ELAEncryptDecrypt getEDClass() throws Exception {
        Object elaEDObj = null;
        String edClassName = null;
        try {
            edClassName = ELAEncryptionAPI.getEDClassName();
            elaEDObj = Thread.currentThread().getContextClassLoader().loadClass(edClassName).newInstance();
            if (elaEDObj instanceof ELAEncryptDecrypt) {
                return elaEDObj;
            }
            throw new Exception("Not a valid implementation Class for ELAEncryptDecrypt interface");
        }
        catch (ClassNotFoundException cnfe) {
            ConsoleOut.println((String)"\n Error : Place the jar file inside <ELA_HOME>/lib folder\n");
            cnfe.printStackTrace();
            throw cnfe;
        }
    }

    public static boolean isCustomEDClassInUse() {
        try {
            Object elaEDObj = Thread.currentThread().getContextClassLoader().loadClass(ELAEncryptionAPI.getEDClassName()).newInstance();
            if (elaEDObj instanceof ELAEncryptDecryptImpl) {
                return false;
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception while getting ELAED class " + ex.getMessage(), ex);
            ex.printStackTrace();
        }
        return true;
    }

    public static String getEDClassName() throws Exception {
        String edClassName = "";
        String home = System.getProperty("server.home");
        String edFileName = home + File.separator + "conf" + File.separator + "eventlog_configurations.conf";
        File edConfFile = new File(edFileName).getCanonicalFile();
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(edConfFile));
            edClassName = props.getProperty("encryptdecrypt.implementation");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception while getting ELAED Class Name. " + ex.getMessage(), ex);
            ex.printStackTrace();
            log.info("using default class name as ELAEncryptDecryptImpl");
            edClassName = "com.manageengine.ela.server.common.security.ELAEncryptDecryptImpl";
        }
        return edClassName;
    }

    public static void updateKeyGeneratedEntry(String confValue) throws Exception {
        try {
            DataObject keyDO = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"ENCRYPTION_KEY_TYPE", 0));
            if (!keyDO.isEmpty()) {
                log.info("Adding updating row.. since  keydo is not empty");
                Row keyRw = keyDO.getFirstRow("SystemConfigurations");
                keyRw.set("CONF_VALUE", (Object)confValue);
                keyDO.updateRow(keyRw);
            } else {
                Row newKeyRow = new Row("SystemConfigurations");
                newKeyRow.set("CONF_NAME", (Object)"ENCRYPTION_KEY_TYPE");
                newKeyRow.set("CONF_VALUE", (Object)confValue);
                keyDO.addRow(newKeyRow);
            }
            DataAccess.update((DataObject)keyDO);
        }
        catch (Exception e) {
            log.info("Exception while using persistence update in updateKeyGeneratedEntry : " + e.toString());
        }
    }

    public static String getEnterpriseKey() throws Exception {
        String enterpriseKey = null;
        Object notesOwner = null;
        Object errorMessage = null;
        Criteria crit = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"ELAED", 0);
        DataObject dataObject = DataAccess.get((String)"SystemConfigurations", (Criteria)crit);
        if (!dataObject.isEmpty()) {
            Row SystemConfigurationsRow = dataObject.getFirstRow("SystemConfigurations");
            if (SystemConfigurationsRow != null) {
                log.log(Level.INFO, "Obtained key using criteria and dataaccess.");
                enterpriseKey = (String)SystemConfigurationsRow.get("CONF_VALUE");
                enterpriseKey = ELAEncryptionAPI.getInstance().getELAED().decryptPassword(enterpriseKey);
            } else {
                log.log(Level.INFO, "Improper Encryption Key. SystemConfigurations table does not have ELAED entry");
                ELAEncryptionAPI.throwException("Improper Encryption key. Unable to proceed with the Server start the server.");
            }
        }
        return enterpriseKey;
    }

    public static String get32BitELAConfKey() throws Exception {
        String fileName = ELAEncryptionAPI.getConfKeyPath();
        String elaKey = null;
        try {
            File keyFile = new File(fileName);
            Properties props = new Properties();
            props.load(new FileInputStream(keyFile));
            elaKey = props.getProperty("ENCRYPTIONKEY");
            if (!ELAEncryptionAPI.isValid(elaKey)) {
                ConsoleOut.println((String)("Error: Improper ELA encryption key file. ENCRYPTIONKEY property is not available in " + fileName));
                throw new Exception("Error: Improper ELA encryption key file. ENCRYPTIONKEY property is not available in " + fileName);
            }
            return elaKey;
        }
        catch (FileNotFoundException fnfe) {
            log.info("Exception while fetching file ela_key : " + fnfe.getMessage());
            throw new Exception("Error fetching file ela_key " + fileName);
        }
        catch (IOException e) {
            ConsoleOut.println((String)("Error: ELA encryption key file is not available in " + fileName));
            e.printStackTrace();
            throw new Exception("ELA encryption key file is not available in " + fileName);
        }
    }

    public static void setMSSQLMasterKey(String masterKey) {
        if (!ELAEncryptionAPI.isValid(masterKey)) {
            masterKey = null;
        } else {
            log.log(Level.INFO, "MSSQL DB Master Encryption key is obtained. So assuming that Always-On failover cluster is used as back-end.");
        }
        mssqlMasterKey = masterKey;
    }

    public static String getMSSQLMasterKey() {
        return mssqlMasterKey;
    }

    public static String readMSSQLMasterKey() {
        String masterKey = null;
        try {
            String fileName = ELAEncryptionAPI.getConfKeyPath();
            File keyFile = new File(fileName);
            if (keyFile.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(keyFile));
                if (props.containsKey("MASTERKEY") && !ELAEncryptionAPI.isValid(masterKey = props.getProperty("MASTERKEY"))) {
                    masterKey = null;
                    log.log(Level.FINEST, "DB Master Encryption key is not placed up in ela_key.key file.");
                }
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, "Exception occured while trying to read DB Master encryption key from ela_key file" + e.getMessage(), e);
            log.log(Level.FINEST, e.getMessage(), e);
            masterKey = null;
        }
        return masterKey;
    }

    public static String get32BitKey() throws Exception {
        String key = null;
        String elaEDClassName = ELAEncryptionAPI.getEDClassName();
        elaEncryptDecrypt = (ELAEncryptDecrypt)Thread.currentThread().getContextClassLoader().loadClass(elaEDClassName).newInstance();
        key = elaEncryptDecrypt instanceof ELAEncryptDecryptImpl ? ELAEncryptionAPI.get32BitELAConfKey() : elaEncryptDecrypt.getEla32BitKey();
        return key;
    }

    public static String getConfKeyPath() throws Exception {
        String homeDir = System.getProperty("server.dir");
        homeDir = homeDir == null ? System.getProperty("server.home") : homeDir;
        FilterInputStream dis = null;
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        String record = null;
        String path = null;
        String fileName = Paths.get(homeDir, "conf", "manage_key.conf").toString();
        try {
            File f = new File(fileName).getCanonicalFile();
            fis = new FileInputStream(f);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while ((record = ((DataInputStream)dis).readLine()) != null) {
                path = record;
            }
            if (path.startsWith("." + File.separator)) {
                path = Paths.get(homeDir, path).toString();
            }
            String string = path;
            return string;
        }
        catch (FileNotFoundException fnfe) {
            log.info("Exception while fetching file manage_key : " + fnfe.getMessage());
            throw new Exception("Error in opening " + fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            ConsoleOut.println((String)("Error in opening " + fileName));
            throw new Exception("Error in opening " + fileName);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean is32BitKeyGenerated() throws Exception {
        boolean isKeyGenerated = true;
        String keyTypeConfValue = ELAEncryptionAPI.get32BitKeyTypeConfValue();
        if (ELAEncryptionAPI.isValid(keyTypeConfValue) && keyTypeConfValue.equals("none")) {
            isKeyGenerated = false;
        }
        return isKeyGenerated;
    }

    public static String get32BitKeyTypeConfValue() throws Exception {
        String value = null;
        if (isPPMKeyGenerationRequired && !isPPMKeyGenerationChecked) {
            log.info("IsPPM check is true and isPPMChecked value is false so setting value as none");
            value = "none";
            isPPMKeyGenerationChecked = true;
        } else if (isPPMKeyGenerationRequired) {
            log.info("Isppm and isPPMchecked is true and setting value as conf_file");
            value = "conf_file";
        }
        try {
            DataObject keyDO = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"ENCRYPTION_KEY_TYPE", 0));
            Row keyRw = keyDO.getFirstRow("SystemConfigurations");
            value = (String)keyRw.get("CONF_VALUE");
        }
        catch (Exception exp) {
            log.info("Exception while get32BitKeyTypeConfValue:" + exp.toString() + " \n so checking for file");
            try {
                if (ELAEncryptionAPI.isValid(ELAEncryptionAPI.get32BitELAConfKey())) {
                    log.info("Key is present so updating entry now");
                    ELAEncryptionAPI.updateKeyGeneratedEntry("conf_file");
                    value = "conf_file";
                }
            }
            catch (Exception e) {
                log.info("Exception while trying to get value from file manage_key : " + e.getMessage());
            }
        }
        return value;
    }

    public static boolean isValid(Object value) {
        return value != null && !value.equals("null") && !value.equals("");
    }

    private static void throwException(String errorMessage) throws Exception {
        throw new Exception(errorMessage);
    }

    public static boolean isValidKey(String cryptoKey) throws Exception {
        if (!ELAEncryptionAPI.isValid(cryptoKey)) {
            ConsoleOut.println((String)"Not a valid Encryption Key, either empty or null");
            ELAEncryptionAPI.throwException("Not a valid Encryption Key, either empty or null");
        } else if (cryptoKey.length() < 32) {
            ConsoleOut.println((String)"Encryption Key size too small. Provide atleast a 32 bit key.");
            ELAEncryptionAPI.throwException("Encryption Key size too small. Provide atleast a 32 bit key.");
        }
        return true;
    }

    public static void storeCustomKey(String customCryptoKey) throws Exception {
        FileWriter fw;
        BufferedReader buffReader;
        BufferedWriter buffWriter;
        block6: {
            String homeDir = System.getProperty("server.dir");
            homeDir = homeDir == null ? System.getProperty("server.home") : homeDir;
            String keyFileName = Paths.get(homeDir, "conf", "custom_key.key").toString();
            buffWriter = null;
            buffReader = null;
            fw = null;
            try {
                File customKeyFile = new File(keyFileName).getCanonicalFile();
                if (customKeyFile.exists()) {
                    String line = null;
                    StringBuilder contents = new StringBuilder();
                    buffReader = new BufferedReader(new FileReader(customKeyFile));
                    while (ELAEncryptionAPI.isValid(line = buffReader.readLine())) {
                        line = line.startsWith("#") ? line : "#" + line;
                        contents.append(line + "\n");
                    }
                    contents.append("#" + new Date().toString() + "\n");
                    contents.append("CUSTOMENCRYPTIONKEY=" + customCryptoKey);
                    customKeyFile.delete();
                    fw = new FileWriter(customKeyFile, false);
                    fw.write(contents.toString());
                    fw.flush();
                    break block6;
                }
                buffWriter = new BufferedWriter(new FileWriter(customKeyFile));
                Properties properties = new Properties();
                properties.setProperty("CUSTOMENCRYPTIONKEY", customCryptoKey);
                properties.store(buffWriter, null);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    ConsoleOut.println((String)("Error in opening " + keyFileName));
                    throw new Exception("Error in opening " + keyFileName);
                }
                catch (Throwable throwable) {
                    ELAEncryptionAPI.safeClose(fw);
                    ELAEncryptionAPI.safeClose(buffReader);
                    ELAEncryptionAPI.safeClose(buffWriter);
                    throw throwable;
                }
            }
        }
        ELAEncryptionAPI.safeClose(fw);
        ELAEncryptionAPI.safeClose(buffReader);
        ELAEncryptionAPI.safeClose(buffWriter);
    }

    public static void safeClose(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getSecureKey(String value, int id) {
        try {
            String key = null;
            String password = null;
            password = ELAEncryptionAPI.getELAKey();
            if (password == null && passwordCheckForNull) {
                passwordCheckForNull = false;
                try {
                    ELAEncryptionAPI.setELAKey(ELAEncryptionAPI.getEnterpriseKey());
                    password = ELAEncryptionAPI.getELAKey();
                }
                catch (Exception e) {
                    log.info("Exception while getting securekey using getEnterpriseKey : " + e.getMessage());
                }
            }
            if (id == 1) {
                key = "AES_ENCRYPT(" + value + ", '" + password + "')";
            } else if (id == 2) {
                key = "cast(AES_DECRYPT(" + value + ", '" + password + "') as char)";
            } else if (id == 3) {
                key = password;
            }
            return key;
        }
        catch (Exception ex) {
            log.info("Exception while getting value from get secure key");
            log.log(Level.INFO, ex.getMessage(), ex);
            return null;
        }
    }
}

