/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.security;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.security.SecretKeyInfo;
import com.manageengine.ela.server.common.security.crypto.EnDecryptionHandler;

public class ELASecretKeyHandler {
    private static final long TIMEINTERVAL = 86400000L;

    public static SecretKeyInfo createNewKey() {
        return ELASecretKeyHandler.createNewKey(EnDecryptionHandler.getUniqueKey(), 86400000L);
    }

    public static Row geKeyInfoAsTempRow(long interval) throws DataAccessException {
        Row row = ELASecretKeyHandler.getNewKeyRow(EnDecryptionHandler.getUniqueKey(), interval);
        DataAccess.generateValues((Row)row);
        return row;
    }

    public static SecretKeyInfo createNewKey(String key) {
        return ELASecretKeyHandler.createNewKey(key, 86400000L);
    }

    public static SecretKeyInfo createNewKey(String key, long validity) {
        SecretKeyInfo info = null;
        try {
            info = ELASecretKeyHandler.createNewEntry(key, validity);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return info;
    }

    public static SecretKeyInfo getKeyInfo(Long keyID) {
        if (keyID == null) {
            return null;
        }
        SecretKeyInfo info = null;
        try {
            info = ELASecretKeyHandler.getKeyDetails(keyID);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return info;
    }

    public static void deleteKey(long keyID) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELASecretKeyDetails", (String)"KEY_ID"), (Object)keyID, 0);
        DBUtil.deleteExistingRows("ELASecretKeyDetails", criteria, new boolean[0]);
    }

    private static SecretKeyInfo getKeyDetails(Long keyID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"ELASecretKeyDetails", (String)"KEY_ID"), (Object)keyID, 0);
        DataObject dobj = PersistenceDBUtil.getPersistence().get("ELASecretKeyDetails", criteria);
        if (dobj.containsTable("ELASecretKeyDetails")) {
            return SecretKeyInfo.getKeyInfo(dobj.getFirstRow("ELASecretKeyDetails"));
        }
        return null;
    }

    private static SecretKeyInfo createNewEntry(String key, long validity) throws DataAccessException {
        Row row = ELASecretKeyHandler.getNewKeyRow(key, validity);
        DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
        dobj.addRow(row);
        dobj = PersistenceDBUtil.getPersistence().add(dobj);
        return SecretKeyInfo.getKeyInfo(dobj.getFirstRow("ELASecretKeyDetails"));
    }

    private static Row getNewKeyRow(String key, long validity) {
        Row row = new Row("ELASecretKeyDetails");
        row.set("KEY", (Object)key);
        row.set("CREATEDTIME", (Object)System.currentTimeMillis());
        row.set("TIMEINTERVAL", (Object)validity);
        return row;
    }
}

