/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.security;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.security.ELAEncryptionAPI;
import com.manageengine.ela.server.common.security.utils.PasswordGenerator;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScharKeyHandler {
    private static Logger log = Logger.getLogger(ScharKeyHandler.class.getName());
    public static HashMap<String, HashSet<String>> scharXMLPopulatedTables = null;
    public static HashMap<String, String> scharXMLPopulatedTablesCriteria = null;

    public static void GenPasswordKey() throws Exception {
        try {
            boolean isKey = ScharKeyHandler.isKeyExists();
            if (!isKey) {
                log.info("isKey check :" + isKey);
                String genKey = PasswordGenerator.generatePasswordKey();
                DataObject keyDO = DataAccess.constructDataObject();
                Row keyRw = new Row("SystemConfigurations");
                log.info("After creating row for SystemConfigurations");
                if (genKey != null && !"null".equalsIgnoreCase(genKey) && !"".equals(genKey)) {
                    log.info("genKey is not null and not empty");
                    keyRw.set("CONF_VALUE", (Object)ELAEncryptionAPI.getInstance().getELAED().encryptPassword(genKey));
                    keyRw.set("CONF_NAME", (Object)"ELAED");
                    keyDO.addRow(keyRw);
                }
                DataAccess.update((DataObject)keyDO);
                log.info("After updating keys in SystemConfigurations");
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, e.getMessage(), e);
            log.severe("Exception while GenPasswordKey : " + e.toString());
        }
    }

    public static boolean isKeyExists() throws Exception {
        boolean isExists = false;
        Row keyRow = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"ELAED", 0);
            DataObject dobj = DataAccess.get((String)"SystemConfigurations", (Criteria)crit);
            keyRow = dobj.getFirstRow("SystemConfigurations");
        }
        catch (Exception e) {
            log.info("Exception while getting rows for iskeyexists");
            e.printStackTrace();
        }
        log.info("Row in iskeyExists : " + keyRow);
        if (keyRow != null) {
            log.log(Level.INFO, "key exists in DB");
            isExists = true;
        }
        return isExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRowCount(String tableName, String colName) throws Exception {
        Connection conn = null;
        DataSet dataSet = null;
        try {
            RelationalAPI relAPI = RelationalAPI.getInstance();
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Column col = Column.getColumn((String)tableName, (String)colName);
            col = col.count();
            query.addSelectColumn(col);
            conn = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)query, conn);
            if (dataSet != null) {
                dataSet.next();
                Integer data = (Integer)dataSet.getValue(1);
                int n = data;
                return n;
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Unable to cleanup db resources", e);
            }
        }
        return 0;
    }

    public static DataObject getNewDO() throws Exception {
        return DataAccess.constructDataObject();
    }

    public static void handleScharXmlPopulatedValues() throws Exception {
        log.info("Method handleScharXmlPopulatedValues");
        ScharKeyHandler.getAllScharValues(scharXMLPopulatedTables, scharXMLPopulatedTablesCriteria);
        ELAEncryptionAPI.useNullDecryption = true;
        ScharKeyHandler.correctScharValues(scharXMLPopulatedTables, scharXMLPopulatedTablesCriteria);
        ELAEncryptionAPI.useNullDecryption = false;
    }

    public static void correctScharValues(HashMap<String, HashSet<String>> tableAndColumnMap, HashMap<String, String> scharXMLPopulatedTablesCriteria) {
        try {
            for (Map.Entry<String, HashSet<String>> scharDetails : tableAndColumnMap.entrySet()) {
                String tableName = scharDetails.getKey();
                HashSet<String> columnNameSet = scharDetails.getValue();
                String criteriaColumn = scharXMLPopulatedTablesCriteria.get(tableName);
                for (String columnName : columnNameSet) {
                    log.info("Going to update schar values in :" + tableName + " for column : " + columnName);
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
                    query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
                    DataObject dataObject = null;
                    try {
                        dataObject = DataAccess.get((SelectQuery)query);
                    }
                    catch (DataAccessException dae) {
                        log.info("Skipping " + tableName + " table " + columnName + " since null is not used. Exception received : " + dae.getMessage());
                        continue;
                    }
                    Iterator scharRows = dataObject.getRows(tableName);
                    while (scharRows.hasNext()) {
                        log.info("Iterator having rows");
                        Row scharRow = (Row)scharRows.next();
                        String oldValue = (String)scharRow.get(columnName);
                        UpdateQueryImpl uQuery = new UpdateQueryImpl(tableName);
                        if (criteriaColumn != null) {
                            uQuery.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)criteriaColumn), scharRow.get(criteriaColumn), 0));
                            uQuery.setUpdateColumn(columnName, (Object)oldValue);
                            DataAccess.update((UpdateQuery)uQuery);
                            log.info("After updating in dataaccess using updateQuery ");
                            continue;
                        }
                        log.info("Criteria column is null while updating schar columns for table : " + tableName);
                    }
                }
            }
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Exception occured during schar columns correction : ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAllScharValues(HashMap<String, HashSet<String>> scharColumnVsTableMap, HashMap<String, String> scharCriteriaVsTableMap) {
        RelationalAPI relAPI = RelationalAPI.getInstance();
        Connection conn = null;
        DataSet dataSet = null;
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ColumnDetails"));
        query.addSelectColumn(Column.getColumn((String)"ColumnDetails", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"TableDetails", (String)"*"));
        Join join1 = new Join("ColumnDetails", "TableDetails", new String[]{"TABLE_ID"}, new String[]{"TABLE_ID"}, 2);
        query.addJoin(join1);
        query.setCriteria(new Criteria(Column.getColumn((String)"ColumnDetails", (String)"DATA_TYPE"), (Object)"SCHAR", 0));
        try {
            conn = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)query, conn);
            if (dataSet != null) {
                while (dataSet.next()) {
                    HashSet<Object> scharColumns;
                    String tableName = (String)dataSet.getValue("table_name");
                    String scharColumn = (String)dataSet.getValue("column_name");
                    if (scharColumnVsTableMap.containsKey(tableName)) {
                        scharColumns = scharColumnVsTableMap.get(tableName);
                        scharColumns.add(scharColumn);
                        scharColumnVsTableMap.put(tableName, scharColumns);
                        continue;
                    }
                    scharColumns = new HashSet();
                    scharColumns.add(scharColumn);
                    scharColumnVsTableMap.put(tableName, scharColumns);
                    List primaryKeyColumn = MetaDataUtil.getTableDefinitionByName((String)tableName).getPrimaryKey().getColumnList();
                    if (primaryKeyColumn.isEmpty()) continue;
                    scharCriteriaVsTableMap.put(tableName, (String)primaryKeyColumn.get(0));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    log.info("Exception when closing conn :" + e.toString());
                }
            }
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    log.info("Exception when closing dataset :" + e.toString());
                }
            }
        }
    }

    static {
        try {
            scharXMLPopulatedTables = new HashMap();
            scharXMLPopulatedTablesCriteria = new HashMap();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

