/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.security.utils;

import java.security.SecureRandom;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordGenerator {
    private static Logger logger = Logger.getLogger(PasswordGenerator.class.getName());
    public static SecureRandom sRnd;
    public static Exception lengthException;
    private static int defaultPasswordLength;

    public static int getPasswordLength(int minPassLen, int maxPassLen) {
        int passLen = -1;
        if (minPassLen < 0 || maxPassLen < 0) {
            logger.log(Level.FINE, "Both the minimum password length & maximum password length are negative. So assuming a password length.");
            return defaultPasswordLength;
        }
        if (minPassLen == 0 && maxPassLen == 0) {
            logger.log(Level.FINE, "Both the minimum password length & maximum password length are zero. So assuming a password length.");
            return defaultPasswordLength;
        }
        if (minPassLen == maxPassLen) {
            return minPassLen;
        }
        if (minPassLen > maxPassLen) {
            logger.log(Level.FINE, "Minimum password length is greater than Maximum password length. So assuming the minimum password length as password length.");
            return minPassLen;
        }
        for (passLen = sRnd.nextInt(maxPassLen + 1); passLen < minPassLen; passLen += maxPassLen - minPassLen) {
        }
        return passLen;
    }

    public static String generatePassword(int minPassLen, int maxPassLen, boolean mixedCaseRqd, boolean splCharRqd, int noOfSplChar, boolean startWithLetter, boolean isNumber) {
        char[] alpha = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        char[] upperAlpha = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        char[] numeric = new char[]{'0', '1', '2', '3', '3', '4', '5', '6', '7', '8', '9'};
        char[] splchar = new char[]{'@', '$', '-', '%', '&', '*', '(', ')', '=', '^'};
        int passMinLength = 0;
        if (startWithLetter) {
            ++passMinLength;
        }
        if (mixedCaseRqd) {
            passMinLength = !startWithLetter ? (passMinLength += 2) : ++passMinLength;
        }
        if (isNumber) {
            ++passMinLength;
        }
        if (splCharRqd) {
            passMinLength += noOfSplChar;
        }
        if (minPassLen < passMinLength) {
            minPassLen = passMinLength;
        }
        if (maxPassLen < passMinLength) {
            minPassLen = maxPassLen;
        }
        int passLen = PasswordGenerator.getPasswordLength(minPassLen, maxPassLen);
        StringBuffer password = new StringBuffer(passLen);
        int iCount = 0;
        int types = splCharRqd && noOfSplChar > 0 ? 3 : 2;
        int splCharsAdded = 0;
        boolean toggleCase = false;
        int mixedCount = 0;
        block5: for (int i = 0; i < passLen; ++i) {
            int arrayId = 0;
            if (i == 0 && startWithLetter) {
                arrayId = 0;
            } else if (isNumber) {
                isNumber = false;
                arrayId = 1;
            } else if (mixedCaseRqd && mixedCount == 0) {
                arrayId = 0;
                ++mixedCount;
            } else if (splCharRqd && noOfSplChar > 0) {
                if (splCharsAdded < noOfSplChar) {
                    arrayId = passLen - i == noOfSplChar - splCharsAdded ? 2 : sRnd.nextInt(types);
                } else {
                    types = 2;
                }
            } else {
                arrayId = sRnd.nextInt(types);
            }
            switch (arrayId) {
                case 0: {
                    int alphaIdx = sRnd.nextInt(alpha.length);
                    int upperAlphaIdx = sRnd.nextInt(upperAlpha.length);
                    if (mixedCaseRqd) {
                        if (i == 0) {
                            password.append(alpha[alphaIdx]);
                            continue block5;
                        }
                        int charCase = sRnd.nextInt(2);
                        if (iCount == 0) {
                            charCase = 0;
                        } else if (!toggleCase) {
                            charCase = 1;
                            toggleCase = true;
                        }
                        if (charCase == 0) {
                            password.append(upperAlpha[upperAlphaIdx]);
                            ++iCount;
                            continue block5;
                        }
                        password.append(alpha[alphaIdx]);
                        continue block5;
                    }
                    password.append(alpha[alphaIdx]);
                    continue block5;
                }
                case 1: {
                    int numIdx = sRnd.nextInt(numeric.length);
                    password.append(numeric[numIdx]);
                    continue block5;
                }
                case 2: {
                    int splCharIdx = sRnd.nextInt(splchar.length);
                    password.append(splchar[splCharIdx]);
                    ++splCharsAdded;
                }
            }
        }
        return password.toString();
    }

    public static String generatePassword(int minPassLen, int maxPassLen, boolean mixedCaseRqd, int noOfLower, int noOfUpper, boolean splCharRqd, int noOfSplChar, int noOfNum, boolean startWithLetter, boolean isNumberRqd, String notReqChars) {
        char[] alpha = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        char[] upperAlpha = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        char[] numeric = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        char[] splchar = new char[]{'@', '$', '-', '%', '&', '*', '(', ')', '=', '^'};
        if (notReqChars != null) {
            String alStr = new String(alpha);
            String uppStr = new String(upperAlpha);
            String numStr = new String(numeric);
            String splChStr = new String(splchar);
            for (int i = 0; i < notReqChars.length(); ++i) {
                String ch = notReqChars.substring(i, i + 1);
                if (alStr.indexOf(ch) >= 0) {
                    alStr = alStr.replace(ch, "");
                    continue;
                }
                if (uppStr.indexOf(ch) >= 0) {
                    uppStr = uppStr.replace(ch, "");
                    continue;
                }
                if (numStr.indexOf(ch) >= 0) {
                    numStr = numStr.replace(ch, "");
                    continue;
                }
                if (splChStr.indexOf(ch) < 0) continue;
                splChStr = splChStr.replace(ch, "");
            }
            alpha = alStr.toCharArray();
            upperAlpha = uppStr.toCharArray();
            numeric = numStr.toCharArray();
            splchar = splChStr.toCharArray();
        }
        String toRet = "";
        int passMinLength = 0;
        boolean isLowerRqd = true;
        boolean isUpperRqd = false;
        if (startWithLetter) {
            ++passMinLength;
        }
        if (mixedCaseRqd) {
            isLowerRqd = true;
            isUpperRqd = true;
            passMinLength = !startWithLetter ? passMinLength + noOfLower + noOfUpper : passMinLength + noOfLower + noOfUpper - 1;
        }
        if (isNumberRqd) {
            passMinLength += noOfNum;
        }
        if (splCharRqd) {
            passMinLength += noOfSplChar;
        }
        if (minPassLen < passMinLength) {
            minPassLen = passMinLength;
        }
        if (maxPassLen < passMinLength) {
            minPassLen = maxPassLen;
        }
        int passLen = PasswordGenerator.getPasswordLength(minPassLen, maxPassLen);
        StringBuffer password = new StringBuffer(passLen);
        int types = splCharRqd && noOfSplChar > 0 ? 3 : 2;
        int splCharsAdded = 0;
        int numberAdded = 0;
        int upperCaseAdded = 0;
        int lowerCaseAdded = 0;
        for (int i = 0; i < passLen; ++i) {
            int arrayId = 0;
            arrayId = i == 0 && startWithLetter ? 0 : (isNumberRqd && numberAdded < noOfNum ? 1 : (splCharRqd && splCharsAdded < noOfSplChar ? 2 : (isUpperRqd && upperCaseAdded < noOfUpper || isLowerRqd && lowerCaseAdded < noOfLower ? 0 : sRnd.nextInt(types))));
            switch (arrayId) {
                case 0: {
                    int charCase;
                    int alphaIdx = sRnd.nextInt(alpha.length);
                    int upperAlphaIdx = sRnd.nextInt(upperAlpha.length);
                    if (mixedCaseRqd) {
                        if (i == 0) {
                            password.append(alpha[alphaIdx]);
                            ++lowerCaseAdded;
                            break;
                        }
                        charCase = sRnd.nextInt(2);
                        if (upperCaseAdded < noOfUpper) {
                            charCase = 0;
                        } else if (lowerCaseAdded < noOfLower) {
                            charCase = 1;
                        }
                        if (charCase == 0) {
                            password.append(upperAlpha[upperAlphaIdx]);
                            ++upperCaseAdded;
                            break;
                        }
                        password.append(alpha[alphaIdx]);
                        ++lowerCaseAdded;
                        break;
                    }
                    charCase = sRnd.nextInt(2);
                    if (lowerCaseAdded < noOfLower) {
                        charCase = 1;
                    }
                    if (charCase == 0) {
                        password.append(upperAlpha[upperAlphaIdx]);
                        ++upperCaseAdded;
                        break;
                    }
                    password.append(alpha[alphaIdx]);
                    ++lowerCaseAdded;
                    break;
                }
                case 1: {
                    int numIdx = sRnd.nextInt(numeric.length);
                    password.append(numeric[numIdx]);
                    ++numberAdded;
                    break;
                }
                case 2: {
                    int splCharIdx = sRnd.nextInt(splchar.length);
                    password.append(splchar[splCharIdx]);
                    ++splCharsAdded;
                }
            }
            if (splCharRqd && splCharsAdded >= noOfSplChar) {
                splCharRqd = false;
            }
            if (isNumberRqd && numberAdded >= noOfNum) {
                isNumberRqd = false;
            }
            if (mixedCaseRqd && lowerCaseAdded >= noOfLower && upperCaseAdded >= noOfUpper) {
                mixedCaseRqd = false;
            }
            if (isLowerRqd && lowerCaseAdded >= noOfLower) {
                isLowerRqd = false;
            }
            if (!isUpperRqd || upperCaseAdded < noOfUpper) continue;
            isUpperRqd = false;
        }
        if (startWithLetter) {
            String shuffledStr = PasswordGenerator.shuffle(password.toString().substring(1));
            toRet = password.toString().substring(0, 1) + shuffledStr;
        } else {
            toRet = PasswordGenerator.shuffle(password.toString());
        }
        return toRet;
    }

    public static String shuffle(String input) {
        ArrayList<Character> characters = new ArrayList<Character>();
        for (char c : input.toCharArray()) {
            characters.add(Character.valueOf(c));
        }
        StringBuilder output = new StringBuilder(input.length());
        while (characters.size() != 0) {
            int randPicker = (int)(Math.random() * (double)characters.size());
            output.append(characters.remove(randPicker));
        }
        return output.toString();
    }

    private static boolean isPasswordNotReqChars(String password, String notReqChars) {
        if (notReqChars != null && !notReqChars.equals("")) {
            StringCharacterIterator sci = new StringCharacterIterator(notReqChars);
            char c = sci.first();
            while (c != '\uffff') {
                if (password.indexOf(c) > -1) {
                    return true;
                }
                c = sci.next();
            }
        }
        return false;
    }

    public static String generatePasswordKey() {
        String genKey = PasswordGenerator.generatePassword(16, 16, true, false, 0, true, true);
        boolean isNotRequired = true;
        while (isNotRequired) {
            genKey = PasswordGenerator.generatePassword(16, 16, true, false, 0, true, true);
            isNotRequired = PasswordGenerator.isPasswordNotReqChars(genKey, "$,&,=,'");
        }
        return genKey;
    }

    public static String generate32BitPasswordKey() {
        String genKey = PasswordGenerator.generatePassword(32, 32, true, false, 0, true, true);
        boolean isNotRequired = true;
        while (isNotRequired) {
            genKey = PasswordGenerator.generatePassword(32, 32, true, false, 0, true, true);
            isNotRequired = PasswordGenerator.isPasswordNotReqChars(genKey, "$,&,=,'");
        }
        return genKey;
    }

    static {
        defaultPasswordLength = 10;
        try {
            sRnd = SecureRandom.getInstance("SHA1PRNG", "SUN");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while creating SecureRandom ! ");
        }
    }
}

