/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.settings.notification.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import org.json.JSONObject;

public class NotificationSettingsUtil {
    public static boolean isMailSettingsConfigured() {
        DataObject dobj = NotificationSettingsUtil.getMailServerSettingsDO();
        try {
            Row mailRow = dobj.getRow("ADSMailSettings");
            if (mailRow != null && mailRow.get("FROM_MAIL_ID") != null && !mailRow.get("FROM_MAIL_ID").toString().isEmpty()) {
                return true;
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static DataObject getMailServerSettingsDO() {
        DataObject dobj = null;
        try {
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"ADSConnectionSecurity"));
            sql.addSelectColumn(Column.getColumn((String)"ADSConnectionSecurity", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"ADSMailSettings", (String)"*"));
            sql.addJoin(new Join(Table.getTable((String)"ADSConnectionSecurity"), Table.getTable((String)"ADSMailSettings"), new String[]{"CONNECTION_SECURITY_ID"}, new String[]{"CONNECTION_SECURITY_ID"}, 1));
            dobj = DataAccess.get((SelectQuery)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dobj;
    }

    public static boolean isSMSSettingsConfigured() {
        DataObject dobj = NotificationSettingsUtil.getSMSServerSettingsDO();
        try {
            Row smsRow = dobj.getRow("SmsServerSettings");
            if (smsRow != null && smsRow.get("PORT") != null && !smsRow.get("PORT").toString().isEmpty()) {
                return true;
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static DataObject getSMSServerSettingsDO() {
        DataObject dobj = null;
        try {
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"SmsServerSettings"));
            sql.addSelectColumn(Column.getColumn((String)"SmsServerSettings", (String)"*"));
            sql.setCriteria(new Criteria(Column.getColumn((String)"SmsServerSettings", (String)"TYPE"), (Object)"SYSLOG", 0));
            dobj = DataAccess.get((SelectQuery)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dobj;
    }

    public static JSONObject getServerConfigurationSettings() {
        JSONObject returnObject = new JSONObject();
        JSONObject mailJson = new JSONObject();
        JSONObject smsJson = new JSONObject();
        DataObject dobj = NotificationSettingsUtil.getMailServerSettingsDO();
        try {
            Row mailRow = dobj.getFirstRow("ADSMailSettings");
            if (mailRow != null && NotificationSettingsUtil.isMailSettingsConfigured()) {
                mailJson.put("isMail", true);
                mailJson.put("serverName", (Object)((String)mailRow.get("SERVER_NAME")));
                mailJson.put("port", (Object)((String)mailRow.get("PORT")));
                returnObject.put("mail", (Object)mailJson);
            } else {
                mailJson.put("isMail", false);
                returnObject.put("mail", (Object)mailJson);
            }
        }
        catch (Exception e) {
            try {
                mailJson.put("isMail", false);
                returnObject.put("mail", (Object)mailJson);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        try {
            dobj = NotificationSettingsUtil.getSMSServerSettingsDO();
            if (NotificationSettingsUtil.isSMSSettingsConfigured()) {
                smsJson.put("isSMS", true);
                returnObject.put("sms", (Object)smsJson);
            } else {
                smsJson.put("isSMS", false);
                returnObject.put("sms", (Object)smsJson);
            }
        }
        catch (Exception e) {
            try {
                smsJson.put("isSMS", false);
                returnObject.put("sms", (Object)smsJson);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return returnObject;
    }
}

