/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.util;

import com.adventnet.la.tools.ConnectionUtil;
import com.manageengine.ela.server.common.security.ELAEncryptionAPI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BackUp
extends JFrame {
    private static PrintWriter out = new PrintWriter(System.out, true);
    private static int attempt = 1;
    private Connection conn = null;
    private String separator = File.separator;
    private String backupDir = null;
    private String backupFileName = null;
    private BufferedWriter logout = null;
    private List tableNames = null;
    private String dbserver = null;
    private String dbname = "unknown";
    private boolean isMysql = false;
    private boolean isPostgres = false;
    private boolean isMssql = false;
    private boolean dbbackupstatus = true;
    private boolean dbhealthstatus = true;
    private Hashtable scharTable = new Hashtable();
    private List scharColList = new ArrayList();
    private String build = "";
    private String[] otherDataTables = new String[]{"ImportantEvents", "LAAlertAudit", "AlertAudit_Hr_Trend"};
    private JPanel backUpPanel = new JPanel();
    private JLabel dbTypeLabel;
    private JComboBox dbType;
    private JTextArea dbSizeDesc;
    private JRadioButton onlyConfig;
    private JTextArea onlyConfigDesc;
    private JRadioButton configAndData;
    private JTextArea configAndDataDesc;
    private JLabel selDaysLabel;
    private JComboBox selDays;
    private JRadioButton entireData;
    private JTextArea entireDataDesc;
    private JToggleButton startButton;
    private static String scharEncryptionKey = null;

    public BackUp() {
        this.addScharTables();
    }

    private static boolean isTextColumn(String columnType) {
        boolean flag = false;
        if ("varchar".equalsIgnoreCase(columnType) || "nvarchar".equalsIgnoreCase(columnType) || "citext".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("char".equalsIgnoreCase(columnType) || "nchar".equalsIgnoreCase(columnType) || "bytea".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("text".equalsIgnoreCase(columnType) || "ntext".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("datetime".equalsIgnoreCase(columnType) || "timestamp".equalsIgnoreCase(columnType)) {
            flag = true;
        }
        return flag;
    }

    private static boolean isNTextColumn(String columnType) {
        boolean flag = false;
        if ("text".equalsIgnoreCase(columnType) || "ntext".equalsIgnoreCase(columnType)) {
            flag = true;
        }
        return flag;
    }

    private static String format(String colData) {
        if (colData == null) {
            return null;
        }
        return colData.replaceAll("'", "''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActiveDBServer() throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        FileInputStream fis = null;
        String dbName = "";
        try {
            docBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    try {
                        new File("localhost.dtd").createNewFile();
                        return new InputSource(new FileInputStream("localhost.dtd"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
            String dsfile = System.getProperty("server.home") + File.separator + "conf" + File.separator;
            dsfile = dsfile + "Persistence" + File.separator + "persistence-configurations.xml";
            fis = new FileInputStream(dsfile);
            Document doc = docBuilder.parse(fis);
            NodeList adapter = doc.getElementsByTagName("configuration");
            for (int i = 0; i < adapter.getLength(); ++i) {
                Element ele = (Element)adapter.item(i);
                if (!"DBName".equals(ele.getAttribute("name"))) continue;
                dbName = ele.getAttribute("value");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return dbName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuildNumber() throws Exception {
        String buildFile = "troubleshooting/build.properties";
        FileInputStream fi = null;
        Properties buildProp = new Properties();
        try {
            fi = new FileInputStream(new File(buildFile));
            buildProp.load(fi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception e) {}
        }
        String buildNumber = (String)buildProp.get("buildnumber");
        out.println("Build Number from Installation :::::" + buildNumber);
        return buildNumber;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("server.home", System.getenv("HOME_DIR"));
        BackUp obj = new BackUp();
        try {
            obj.process("init");
            obj.setLocation(300, 150);
            obj.setSize(400, 520);
            obj.setVisible(true);
            obj.setDefaultCloseOperation(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process(String argument) throws Exception {
        this.initBackup();
        this.initComponents();
    }

    public void process() throws Exception {
        try {
            this.startBackup();
            this.endBackup();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.deleteAllTempFiles();
            out.println("\n");
            out.println("\n\nBackup process is completed successfully");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            this.logout.write("\n\nThe stop time is" + dateFormat.format(date));
            ConnectionUtil.shutDownDB();
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
            if (this.logout != null) {
                this.logout.flush();
                this.logout.close();
            }
        }
    }

    public boolean getDBHealthStatus() {
        return this.dbhealthstatus;
    }

    private List getAllTables() throws Exception {
        return ConnectionUtil.getTableList();
    }

    protected void initBackup() throws Exception {
        try {
            String build_number;
            out.println("Starting....");
            this.conn = this.getConnection();
            File file = new File("EventLog_Analyzer_backup.log");
            this.logout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            this.backupDir = this.getBackupDir();
            if (!new File(this.backupDir).isDirectory()) {
                new File(this.backupDir).mkdirs();
            }
            this.build = build_number = BackUp.getBuildNumber();
            this.tableNames = this.getAllTables();
            this.createBuildInfoXml(build_number);
            this.backupFileName = this.getBackupFileName(build_number);
            this.logout.write("\t\t\t\t EventLog Analyzer [" + build_number + "] backup log\n");
            this.logout.write("\t\t\t*************************************************************\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preBackup() {
        out.println("\n\nPreparing to take backup the database........\n\n");
        ArrayList<String> unWantedTables = new ArrayList<String>();
        ArrayList<String> lowerUnWantedTables = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Object[] configDataObj;
            stmt = this.conn.createStatement();
            Object[] configObj = this.onlyConfig.getSelectedObjects();
            if (configObj != null) {
                this.logout.write("\nBackup Type ::::::: Only Configurations");
                rs = stmt.executeQuery("select LOOKUP_TABLENAME from MetaTable");
                while (rs.next()) {
                    unWantedTables.add(rs.getString("LOOKUP_TABLENAME"));
                    lowerUnWantedTables.add(rs.getString("LOOKUP_TABLENAME").toLowerCase());
                }
                rs = null;
                for (int i = 0; i < this.otherDataTables.length; ++i) {
                    unWantedTables.add(this.otherDataTables[i]);
                    lowerUnWantedTables.add(this.otherDataTables[i].toLowerCase());
                }
                if (this.isPostgres) {
                    stmt.execute("drop TABLE IF EXISTS MetaTable_tmp");
                    stmt.execute("create table if not exists MetaTable_tmp (like MetaTable including all)");
                    stmt.execute("insert into MetaTable_tmp (select * from MetaTable)");
                    stmt.execute("delete from MetaTable where END_TIME!='1970-01-01 00:00:00' or LOOKUP_TABLENAME like '%trend_sa%'");
                    stmt.execute("update MetaTable set START_TIME = localtimestamp(0)");
                } else if (this.isMysql) {
                    stmt.execute("drop TABLE IF EXISTS MetaTable_tmp");
                    stmt.execute("create table if not exists MetaTable_tmp like MetaTable");
                    stmt.execute("insert into MetaTable_tmp (select * from MetaTable)");
                    stmt.execute("delete from MetaTable where END_TIME!=0 or LOOKUP_TABLENAME like '%trend_sa%'");
                    stmt.execute("update MetaTable set START_TIME = now()");
                } else {
                    stmt.execute("IF EXISTS(select * from sysobjects where name='MetaTable_tmp') DROP TABLE MetaTable_tmp");
                    stmt.execute("if not exists (select * from sysobjects where name='MetaTable_tmp' and xtype='U') select * into MetaTable_tmp from MetaTable");
                    stmt.execute("delete from MetaTable where END_TIME!='1970-01-01 00:00:00' or LOOKUP_TABLENAME like '%trend_sa%'");
                    stmt.execute("update MetaTable set START_TIME = GETDATE()");
                }
                rs = stmt.executeQuery("select CURRENTBATCHEND from SeqGenState where SEQNAME='LAAlertAudit.AuditID'");
                if (rs.next()) {
                    stmt.execute("update SeqGenState set CURRENTBATCHEND = '300' where SEQNAME='LAAlertAudit.AuditID'");
                }
                rs = null;
                stmt.execute("update SystemConfigurations set CONF_VALUE = '300' where CONF_NAME='AlertStatusId'");
            }
            if ((configDataObj = this.configAndData.getSelectedObjects()) != null) {
                int i;
                String selectedDays = (String)this.selDays.getSelectedItem();
                String timeString = "";
                String truncateTrend = "";
                String truncateAlert = "";
                String truncateBase = "";
                this.logout.write("\nBackup Type ::::::: Configurations and selected days data");
                this.logout.write("\nNo. of days selected ::::::: " + selectedDays);
                if (this.isPostgres) {
                    stmt.execute("drop TABLE IF EXISTS MetaTable_tmp");
                    stmt.execute("create table if not exists MetaTable_tmp (like MetaTable including all)");
                    stmt.execute("insert into MetaTable_tmp (select * from MetaTable)");
                    timeString = "where END_TIME < (localtimestamp(0) -INTERVAL '" + selectedDays + "' DAY) and END_TIME!='1970-01-01 00:00:00'";
                    rs = stmt.executeQuery("select LOOKUP_TABLENAME from MetaTable " + timeString);
                    while (rs.next()) {
                        unWantedTables.add(rs.getString("LOOKUP_TABLENAME"));
                        lowerUnWantedTables.add(rs.getString("LOOKUP_TABLENAME").toLowerCase());
                    }
                    rs = null;
                    truncateTrend = " where (now()::date - HOUR::date) > " + selectedDays;
                    truncateAlert = " where (now()::date - (TO_TIMESTAMP(NOTIFIEDTIME/1000)::date)) > " + selectedDays;
                    truncateBase = " where (now()::date - (TO_TIMESTAMP(TIMESTAMP::bigint/1000)::date)) > " + selectedDays;
                } else if (this.isMysql) {
                    stmt.execute("drop TABLE IF EXISTS MetaTable_tmp");
                    stmt.execute("create table if not exists MetaTable_tmp like MetaTable");
                    stmt.execute("insert into MetaTable_tmp (select * from MetaTable)");
                    timeString = "where END_TIME < (DATE_SUB(now(), INTERVAL " + selectedDays + " DAY)) and END_TIME!=0";
                    rs = stmt.executeQuery("select LOOKUP_TABLENAME from MetaTable " + timeString);
                    while (rs.next()) {
                        unWantedTables.add(rs.getString("LOOKUP_TABLENAME"));
                        lowerUnWantedTables.add(rs.getString("LOOKUP_TABLENAME").toLowerCase());
                    }
                    rs = null;
                    truncateTrend = " where TO_DAYS(now()) - TO_DAYS(HOUR) > " + selectedDays;
                    truncateAlert = " where TO_DAYS(now()) - TO_DAYS(FROM_UNIXTIME(NOTIFIEDTIME/1000)) > " + selectedDays;
                    truncateBase = " where TO_DAYS(now()) - TO_DAYS(FROM_UNIXTIME(TIMESTAMP/1000)) > " + selectedDays;
                } else {
                    stmt.execute("IF EXISTS(select * from sysobjects where name='MetaTable_tmp') DROP TABLE MetaTable_tmp");
                    stmt.execute("if not exists (select * from sysobjects where name='MetaTable_tmp' and xtype='U') select * into MetaTable_tmp from MetaTable");
                    timeString = "where END_TIME < GETDATE() - " + selectedDays + " and END_TIME!='1970-01-01 00:00:00'";
                    rs = stmt.executeQuery("select LOOKUP_TABLENAME from MetaTable " + timeString);
                    while (rs.next()) {
                        unWantedTables.add(rs.getString("LOOKUP_TABLENAME"));
                        lowerUnWantedTables.add(rs.getString("LOOKUP_TABLENAME").toLowerCase());
                    }
                    rs = null;
                    truncateTrend = " where DATEDIFF(dd, '1970-01-01 00:00:00', GETDATE()) - DATEDIFF(dd, '1970-01-01 00:00:00', HOUR) > " + selectedDays;
                    truncateAlert = " where DATEDIFF(dd, '1970-01-01 00:00:00', GETDATE()) - DATEDIFF(dd, '1970-01-01 00:00:00', DATEADD(ss, cast (NOTIFIEDTIME as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101')) > " + selectedDays;
                    truncateBase = " where DATEDIFF(dd, '1970-01-01 00:00:00', GETDATE()) - DATEDIFF(dd, '1970-01-01 00:00:00', DATEADD(ss, cast (TIMESTAMP as bigint)/1000+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101')) > " + selectedDays;
                }
                ArrayList<String> truncateTables = new ArrayList<String>();
                String truncateTable = "";
                rs = stmt.executeQuery("select LOOKUP_TABLENAME from MetaTable where LOOKUP_TABLENAME not in (select LOOKUP_TABLENAME from MetaTable " + timeString + ")");
                while (rs.next()) {
                    truncateTables.add(rs.getString("LOOKUP_TABLENAME"));
                }
                rs = null;
                for (i = 0; i < this.otherDataTables.length; ++i) {
                    truncateTables.add(this.otherDataTables[i]);
                }
                this.logout.write("\nTruncate Tables :::::: " + truncateTables);
                for (i = 0; i < truncateTables.size(); ++i) {
                    truncateTable = (String)truncateTables.get(i);
                    if (truncateTable.indexOf("_Trend") != -1 || truncateTable.indexOf("_trend") != -1 || truncateTable.indexOf("ImportantEvents") != -1 || truncateTable.indexOf("OracleImpEvents") != -1 || truncateTable.indexOf("MssqlImpEvents") != -1 || truncateTable.indexOf("NBA_FE") != -1) {
                        stmt.execute("delete from " + truncateTable + truncateTrend);
                        continue;
                    }
                    if ("LAAlertAudit".equals(truncateTable)) {
                        stmt.execute("delete from " + truncateTable + truncateAlert);
                        continue;
                    }
                    stmt.execute("delete from " + truncateTable + truncateBase);
                }
                stmt.execute("delete from MetaTable " + timeString);
                String maxAudit = "";
                rs = stmt.executeQuery("select max(AUDIT_ID) as maxAudit from LAAlertAudit");
                if (rs.next() && (maxAudit = rs.getString("maxAudit")) == null) {
                    maxAudit = "300";
                }
                rs = null;
                rs = stmt.executeQuery("select CURRENTBATCHEND from SeqGenState where SEQNAME='LAAlertAudit.AuditID'");
                if (rs.next()) {
                    stmt.execute("update SeqGenState set CURRENTBATCHEND = '" + maxAudit + "' where SEQNAME='LAAlertAudit.AuditID'");
                }
                rs = null;
                stmt.execute("update SystemConfigurations set CONF_VALUE = '" + maxAudit + "' where CONF_NAME='AlertStatusId'");
            }
            this.logout.write("\nunWantedTables ::::::: " + unWantedTables);
            this.logout.write("\nLowerUnWantedTables ::::::: " + lowerUnWantedTables);
            this.tableNames.removeAll(unWantedTables);
            this.tableNames.removeAll(lowerUnWantedTables);
            this.logout.write("\nTables to be backed up ::::::: " + this.tableNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    protected void startBackup() throws Exception {
        this.logout.write(" Backup process started....\n ");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        this.logout.write("\n The Start time is" + dateFormat.format(date));
        out.println("Going to take backup of the database");
        this.logout.write("Going to take backup of the database\n");
        if (this.dbbackupstatus) {
            out.println("\n\nPlease wait ! backup in Progress...................");
            out.println("0-----------------------50------------------------100(%)");
            int len = this.tableNames.size();
            int divider = len / 50;
            for (int i = 0; i < len; ++i) {
                if (i % divider == 0) {
                    out.print("=");
                }
                try {
                    this.logout.write(this.tableNames.get(i) + "\n");
                    this.dumpTable(this.tableNames.get(i).toString().toLowerCase());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage() != null && e.getMessage().indexOf("eventlog.table_") >= 0) continue;
                    throw e;
                }
            }
        }
        out.println("");
    }

    protected void endBackup() throws Exception {
        this.logout.write("Compressing backup file\n");
        String rootdir = System.getProperty("server.home");
        ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(this.backupDir + this.separator + this.backupFileName));
        this.addToZip(zipout, this.backupDir + this.separator + "backup_info.xml");
        if (this.dbbackupstatus) {
            int len = this.tableNames.size();
            for (int i = 0; i < len; ++i) {
                this.addToZip(zipout, this.backupDir + this.separator + this.tableNames.get(i).toString().toLowerCase() + ".sql");
            }
        }
        zipout.close();
    }

    private Connection getConnection() throws Exception {
        String sep = File.separator;
        String dsfile = System.getProperty("server.home") + sep + "conf" + sep;
        dsfile = dsfile + "Persistence" + sep + "persistence-configurations.xml";
        if (this.dbserver == null) {
            if (new File(dsfile).isFile()) {
                this.dbserver = BackUp.getActiveDBServer();
                this.isMysql = "mysql".equals(this.dbserver);
                this.isPostgres = "postgres".equals(this.dbserver);
                this.isMssql = "mssql".equals(this.dbserver);
                return ConnectionUtil.getConnection((String)this.dbserver);
            }
            throw new Exception("Data Source file not found : " + dsfile);
        }
        return ConnectionUtil.getConnection((String)this.dbserver);
    }

    private void deleteAllTempFiles() throws Exception {
        new File(this.backupDir + this.separator + "backup_info.xml").delete();
        if (this.tableNames != null) {
            int len = this.tableNames.size();
            for (int i = 0; i < len; ++i) {
                new File(this.backupDir + this.separator + this.tableNames.get(i).toString().toLowerCase() + ".sql").delete();
            }
        }
    }

    private void addToZip(ZipOutputStream zipout, String file) throws Exception {
        ZipEntry ent = new ZipEntry(new File(file).getName());
        zipout.putNextEntry(ent);
        try (FileInputStream fileReader = new FileInputStream(new File(file));){
            int len;
            byte[] data = new byte[1024];
            int j = 0;
            while ((len = fileReader.read(data)) >= 0) {
                zipout.write(data, 0, len);
                zipout.flush();
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getMetaData(String table_name) {
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement("SELECT TABLE_ID FROM TableDetails where TABLE_NAME = '" + table_name + "'");
            rs = stmt.executeQuery();
            if (rs.next()) {
                stmt = this.conn.prepareStatement("SELECT COLUMN_NAME, MAX_SIZE FROM ColumnDetails where TABLE_ID = '" + rs.getString(1) + "'");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    hash.put(rs.getString(1), rs.getString(2));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpTable(String table) throws Exception {
        if (attempt >= 3) {
            throw new Exception("Unable to get the data from [" + table + "] table");
        }
        Statement cstmt = null;
        int count = 0;
        ResultSet rcount = null;
        try {
            String query = "SELECT count(*) FROM " + table;
            cstmt = this.conn.prepareStatement(query);
            rcount = cstmt.executeQuery();
            if (rcount.next()) {
                count = rcount.getInt(1);
            }
        }
        catch (Exception e) {
            this.dbhealthstatus = false;
            ++attempt;
            out.println("ERROR = *" + e.getMessage() + "*");
            this.conn = this.getConnection();
            this.dumpTable(table);
            return;
        }
        finally {
            try {
                if (rcount != null) {
                    rcount.close();
                }
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (Exception exception) {}
        }
        PreparedStatement stmt = null;
        String query = "SELECT * FROM " + table;
        if (this.scharTable.containsKey(table)) {
            query = this.getScharQuery(table);
        }
        if (count > 1000 && (this.isMysql || this.isPostgres)) {
            query = query + " order by 1 limit 1000 offset 0";
        }
        stmt = this.conn.prepareStatement(query);
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
        }
        catch (Exception ex) {
            ++attempt;
            out.println("ERROR = *" + ex.getMessage() + "*");
            this.conn = this.getConnection();
            this.dumpTable(table);
            this.dbhealthstatus = false;
            return;
        }
        ResultSetMetaData metaData = rs.getMetaData();
        int colCount = metaData.getColumnCount();
        HashMap metadata = this.getMetaData(table);
        FileOutputStream fout = new FileOutputStream(new File(this.backupDir + this.separator + table + ".sql"));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, "UTF8"));
        int max_col_size = 0;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO " + table + " (");
            if (!metaData.isAutoIncrement(1)) {
                buffer.append("[").append(metaData.getColumnName(1)).append("]");
            }
            for (int i = 1; i < colCount; ++i) {
                if (metaData.isAutoIncrement(i)) {
                    buffer.append("[").append(metaData.getColumnName(i + 1)).append("]");
                    continue;
                }
                buffer.append(",[").append(metaData.getColumnName(i + 1)).append("]");
            }
            buffer.append(") VALUES\n");
            int rows = 1000;
            while (true) {
                if (rs.next()) {
                    buffer.append("(");
                    for (int i = 0; i < colCount; ++i) {
                        if (metaData.isAutoIncrement(i + 1)) continue;
                        if (i > 0 && !metaData.isAutoIncrement(i)) {
                            buffer.append(", ");
                        }
                        Object value = null;
                        if ("timestamp".equalsIgnoreCase(metaData.getColumnTypeName(i + 1))) {
                            try {
                                value = rs.getObject(i + 1);
                            }
                            catch (Exception e) {
                                value = "1970-01-01 00:00:00";
                                this.logout.write("\n" + e.getMessage());
                            }
                        } else {
                            value = rs.getObject(i + 1);
                        }
                        if (value == null) {
                            if ("timestamp".equalsIgnoreCase(metaData.getColumnTypeName(i + 1)) || "datetime".equalsIgnoreCase(metaData.getColumnTypeName(i + 1))) {
                                buffer.append("-1");
                                continue;
                            }
                            buffer.append("NULL");
                            continue;
                        }
                        String colData = null;
                        if (value instanceof Clob) {
                            Clob clob = (Clob)value;
                            BufferedReader read = (BufferedReader)clob.getCharacterStream();
                            String tmp = read.readLine();
                            while (tmp != null) {
                                colData = colData == null ? tmp : colData + tmp;
                                tmp = read.readLine();
                            }
                            if (colData == null) {
                                colData = "NULL";
                            }
                        } else {
                            colData = value.toString();
                        }
                        if (BackUp.isTextColumn(metaData.getColumnTypeName(i + 1))) {
                            String colName = metaData.getColumnName(i + 1);
                            if (!this.scharColList.contains(colName) || !this.scharTable.containsKey(table)) {
                                colData = BackUp.format(colData);
                            }
                            try {
                                max_col_size = Integer.parseInt(metadata.get(metaData.getColumnName(i + 1)).toString());
                            }
                            catch (Exception e) {
                                max_col_size = 0;
                            }
                            if (max_col_size > 0 && max_col_size < 4000 && colData.length() > max_col_size) {
                                colData = colData.substring(0, --max_col_size);
                                while (colData.endsWith("\\") || colData.endsWith("'") || colData.endsWith("''")) {
                                    colData = colData.substring(0, --max_col_size);
                                }
                            }
                            if (this.scharColList.contains(colName) && this.scharTable.containsKey(table) && this.scharTable.get(table).equals(colName)) {
                                buffer.append("eventlog@adventnetN'" + colData + "'" + ",eventlog@zoho)");
                                continue;
                            }
                            buffer.append("N'" + colData + "'");
                            continue;
                        }
                        if ("bit".equalsIgnoreCase(metaData.getColumnTypeName(i + 1)) || "tinyint".equalsIgnoreCase(metaData.getColumnTypeName(i + 1)) || "bool".equalsIgnoreCase(metaData.getColumnTypeName(i + 1))) {
                            if ("false".equals(colData)) {
                                buffer.append("0");
                                continue;
                            }
                            buffer.append("1");
                            continue;
                        }
                        buffer.append(colData);
                    }
                    buffer.append(");\n");
                    out.write(buffer.toString());
                    buffer = new StringBuffer();
                    continue;
                }
                rs.close();
                if (count >= 1000 && (this.isMysql || this.isPostgres)) {
                    if (rows == count) break;
                    int retrive_rows = 1000;
                    int retrive_offset = rows += 1000;
                    if (rows > count) {
                        rows = count;
                        retrive_rows = count % 1000;
                    }
                    stmt = this.conn.prepareStatement("SELECT * FROM " + table + " order by 1 limit " + retrive_rows + " offset " + (retrive_offset - 1000));
                    rs = stmt.executeQuery();
                }
                if (rows > count || !this.isMysql && !this.isPostgres) break;
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            stmt.close();
            rs.close();
            try {
                fout.close();
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        attempt = 1;
    }

    private void createBuildInfoXml(String build_number) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element root = document.createElement("backup-info");
        document.appendChild(root);
        Element backup_date = document.createElement("backup-date");
        backup_date.appendChild(document.createTextNode(new Date().toString()));
        root.appendChild(backup_date);
        this.dbname = ConnectionUtil.getDataBase();
        Element db = document.createElement("database");
        db.appendChild(document.createTextNode(this.dbname));
        root.appendChild(db);
        Element build_num = document.createElement("build-number");
        build_num.appendChild(document.createTextNode(build_number));
        root.appendChild(build_num);
        Element number_of_table = document.createElement("number-of-table");
        number_of_table.appendChild(document.createTextNode(this.tableNames.size() + ""));
        root.appendChild(number_of_table);
        String build_info = this.backupDir + this.separator + "backup_info.xml";
        out.println("[ creating backup_info.xml ] : " + new File(build_info).createNewFile());
        DOMSource xmlSource = new DOMSource(document);
        StreamResult result = new StreamResult(new FileOutputStream(build_info));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(xmlSource, result);
    }

    public String getBackupFileName(String build_number) throws Exception {
        if (this.backupFileName == null) {
            String date = new SimpleDateFormat("MM_dd_yyyy_HH_mm").format(new Date());
            return "backup_" + this.dbname + "_" + build_number + "_database_" + date + ".data";
        }
        return this.backupFileName;
    }

    private String getBackupDir() throws Exception {
        String backupDir = System.getProperty("eventlog.backupDir").trim();
        String date = new SimpleDateFormat("MM_dd_yyyy_HH_mm_ss").format(new Date());
        if ("\\backup".equals(backupDir)) {
            backupDir = System.getProperty("server.home") + File.separator + "backup";
        }
        if (!new File(backupDir = backupDir + File.separator + "Backup_" + date).exists()) {
            this.logout.write("backupDir " + backupDir + " does not exists. Going to create directory");
            new File(backupDir).mkdirs();
            this.logout.write("\nbackupDir " + backupDir + " created");
        }
        return backupDir;
    }

    public ZipOutputStream zipDirectory(String dir, ZipOutputStream zos) throws Exception {
        File d = new File(dir);
        if (!d.exists()) {
            out.println("Exiting $^$%^&$%^&$%^");
            return zos;
        }
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Compress: not a directory:  " + dir);
        }
        String[] entries = d.list();
        byte[] buffer = new byte[4096];
        int len = entries.length;
        for (int i = 0; i < len; ++i) {
            File f = new File(d, entries[i]);
            out.println("File added to zip " + f);
            if (f.isDirectory()) {
                this.zipDirectory(f.getPath(), zos);
                continue;
            }
            try (FileInputStream in = new FileInputStream(f);){
                int bytes_read;
                String absolutePath = f.getPath();
                int startIndx = absolutePath.indexOf("fileAttachments");
                if (startIndx == -1) {
                    startIndx = absolutePath.indexOf("custom");
                }
                if (startIndx == -1) {
                    startIndx = absolutePath.indexOf("inlineimages");
                }
                String subStr = absolutePath.substring(startIndx);
                ZipEntry entry = new ZipEntry(subStr);
                zos.putNextEntry(entry);
                while ((bytes_read = in.read(buffer)) != -1) {
                    zos.write(buffer, 0, bytes_read);
                }
                continue;
            }
        }
        return zos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDBSize() {
        String sizeGB = "-1";
        BufferedReader buff = null;
        String strSizeBytes = null;
        Statement stmt = null;
        DecimalFormat twoDigit = new DecimalFormat("0.00");
        long sizeBytes = 0L;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            if (this.isMysql) {
                rs = stmt.executeQuery("show variables like 'datadir'");
                String path = "";
                if (rs.next()) {
                    path = (String)rs.getObject("Value");
                }
                rs.close();
                String temp = null;
                Process pro = null;
                Runtime rt = Runtime.getRuntime();
                boolean flag = false;
                this.logout.write("Data dir path ::::: " + path);
                String[] dirPaths = new String[]{path + "\\eventlog", path + "\\ibdata1"};
                long totalBytes = 0L;
                for (int i = 0; i < 2; ++i) {
                    pro = rt.exec("cmd /c DIR /A-D " + dirPaths[i]);
                    buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                    temp = buff.readLine();
                    while (temp.indexOf(" bytes") == -1) {
                        strSizeBytes = temp = buff.readLine();
                    }
                    if (strSizeBytes == null) {
                        pro = rt.exec("cmd /c DIR " + dirPaths[1] + " | FIND \"bytes\"");
                        buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                        strSizeBytes = buff.readLine();
                    }
                    strSizeBytes = strSizeBytes.trim();
                    Pattern p = Pattern.compile("\\s*\\d*\\D*([0-9,]*).*");
                    Matcher m = p.matcher(strSizeBytes);
                    boolean b = m.matches();
                    strSizeBytes = m.group(1);
                    strSizeBytes = strSizeBytes.replaceAll(",", "");
                    strSizeBytes = strSizeBytes.replace('.', ' ');
                    strSizeBytes = strSizeBytes.replaceAll(" ", "");
                    totalBytes = Long.parseLong(strSizeBytes);
                    sizeBytes += totalBytes;
                }
            } else if (this.isPostgres) {
                rs = stmt.executeQuery("SELECT pg_database_size('eventlog') as size ");
                if (rs.next()) {
                    sizeBytes = (Long)rs.getObject("size");
                }
            } else {
                rs = stmt.executeQuery("exec sp_helpfile");
                if (rs.next()) {
                    strSizeBytes = (String)rs.getObject("size");
                }
                rs.close();
                Pattern p = Pattern.compile("(\\d+) KB");
                Matcher m = p.matcher(strSizeBytes);
                boolean b = m.matches();
                strSizeBytes = m.group(1);
                sizeBytes = Long.parseLong(strSizeBytes);
                sizeBytes *= 1024L;
            }
            sizeGB = twoDigit.format((double)sizeBytes / 1.073741824E9);
            this.logout.write("\nDatabase size(GB) ::::::::: " + sizeGB);
        }
        catch (Exception e) {
            e.printStackTrace();
            sizeGB = "-1";
            out.println("Error while calculating Free disk Space, read line : " + strSizeBytes);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (buff != null) {
                    buff.close();
                }
            }
            catch (Exception e) {
                buff = null;
            }
        }
        return sizeGB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDWS() throws Exception {
        String dws = "32";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("select TIMESTAMP from DataManagementTiming where TIMER_NAME='SYS_DATA_WINDOW'");
            if (rs.next()) {
                dws = rs.getString("TIMESTAMP");
            }
        }
        catch (Exception e) {
            out.println("Error while getting data window size : " + e);
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return dws;
    }

    private String getEstimatedTime(String dbSize) {
        String estimatedTime = "Unknown";
        try {
            if (dbSize.indexOf("0.") != -1) {
                long timeInMin = Math.round(Double.parseDouble(dbSize) * 120.0);
                estimatedTime = timeInMin + " Mins";
            } else {
                long timeInHr = Math.round(Double.parseDouble(dbSize)) * 2L;
                estimatedTime = timeInHr + " Hrs";
            }
            return estimatedTime;
        }
        catch (Exception e) {
            e.printStackTrace();
            return estimatedTime;
        }
    }

    private void initComponents() throws Exception {
        this.dbTypeLabel = new JLabel();
        this.dbType = new JComboBox();
        this.dbSizeDesc = new JTextArea();
        this.onlyConfig = new JRadioButton();
        this.onlyConfigDesc = new JTextArea();
        this.configAndData = new JRadioButton();
        this.configAndDataDesc = new JTextArea();
        this.selDaysLabel = new JLabel();
        this.selDays = new JComboBox();
        this.entireData = new JRadioButton();
        this.entireDataDesc = new JTextArea();
        this.startButton = new JToggleButton();
        this.backUpPanel.setBorder(BorderFactory.createTitledBorder("Backup Database Setup Wizard"));
        this.dbTypeLabel.setLocation((int)this.dbTypeLabel.getLocation().getX(), (int)this.dbTypeLabel.getLocation().getY() + 60);
        this.dbTypeLabel.setText("Database Type : ");
        this.add(this.dbTypeLabel);
        this.dbTypeLabel.setBounds(30, 40, 100, 20);
        String[] dbTypeArr = new String[]{this.isPostgres ? "Postgres Server" : (this.isMysql ? "Mysql Server" : "SQL Server")};
        this.dbType.setModel(new DefaultComboBoxModel<String>(dbTypeArr));
        this.add(this.dbType);
        this.dbType.setBounds(215, 40, 150, 20);
        String dbSize = this.getDBSize();
        String estimatedTime = this.getEstimatedTime(dbSize);
        String dbString = dbTypeArr[0];
        this.dbSizeDesc.setLocation((int)this.dbSizeDesc.getLocation().getX(), (int)this.dbSizeDesc.getLocation().getY() + 60);
        this.dbSizeDesc.setText("The size of the " + dbString + " database to be backedup is approximately " + dbSize + " GB. This will take approximately " + estimatedTime + " to backup the whole database. Please select any one the options  to start backup the process");
        this.dbSizeDesc.setLineWrap(true);
        this.dbSizeDesc.setEditable(false);
        this.dbSizeDesc.setDisabledTextColor(Color.BLACK);
        this.add(this.dbSizeDesc);
        this.dbSizeDesc.setBounds(30, 80, 335, 65);
        this.onlyConfig.setLocation((int)this.onlyConfig.getLocation().getX(), (int)this.onlyConfig.getLocation().getY() + 60);
        this.onlyConfig.setText("Backup only Configurations");
        this.add(this.onlyConfig);
        this.onlyConfig.setBounds(25, 150, 300, 20);
        this.onlyConfig.setSelected(true);
        this.onlyConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackUp.this.onlyConfig.setSelected(true);
                BackUp.this.configAndData.setSelected(false);
                BackUp.this.entireData.setSelected(false);
                BackUp.this.selDaysLabel.setVisible(false);
                BackUp.this.selDays.setVisible(false);
            }
        });
        this.onlyConfigDesc.setLocation((int)this.onlyConfigDesc.getLocation().getX(), (int)this.onlyConfigDesc.getLocation().getY() + 60);
        this.onlyConfigDesc.setText("Backup the configuration & setting (i.e) Hosts/Applications\nadded, Report/Alert Profiles created etc.\nEstimated time approximately 2-3 mins");
        this.onlyConfigDesc.setEditable(false);
        this.onlyConfigDesc.setDisabledTextColor(Color.BLACK);
        this.onlyConfigDesc.setSelectionStart(133);
        this.onlyConfigDesc.setSelectionStart(141);
        this.onlyConfigDesc.setSelectionColor(Color.RED);
        this.add(this.onlyConfigDesc);
        this.onlyConfigDesc.setBounds(45, 170, 320, 50);
        this.configAndData.setLocation((int)this.configAndData.getLocation().getX(), (int)this.configAndData.getLocation().getY() + 60);
        this.configAndData.setText("Backup Configurations & Selected days data");
        this.add(this.configAndData);
        this.configAndData.setBounds(25, 230, 300, 20);
        this.configAndData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackUp.this.onlyConfig.setSelected(false);
                BackUp.this.configAndData.setSelected(true);
                BackUp.this.entireData.setSelected(false);
                BackUp.this.selDaysLabel.setVisible(true);
                BackUp.this.selDays.setVisible(true);
            }
        });
        this.configAndDataDesc.setLocation((int)this.configAndDataDesc.getLocation().getX(), (int)this.configAndDataDesc.getLocation().getY() + 60);
        this.configAndDataDesc.setText("Backup the configuration & setting (i.e) Hosts/Applications\nadded, Report/Alert Profiles created etc. and the selected\nnumber of days of data.\nEstimated time approximately ");
        this.configAndDataDesc.setEditable(false);
        this.configAndDataDesc.setDisabledTextColor(Color.BLACK);
        this.add(this.configAndDataDesc);
        this.configAndDataDesc.setBounds(45, 250, 320, 65);
        this.selDaysLabel.setLocation((int)this.selDaysLabel.getLocation().getX(), (int)this.selDaysLabel.getLocation().getY() + 60);
        this.selDaysLabel.setText("Please enter no. of days : ");
        this.add(this.selDaysLabel);
        this.selDaysLabel.setBounds(45, 320, 150, 20);
        this.selDaysLabel.setVisible(false);
        this.selDays.setLocation((int)this.selDays.getLocation().getX(), (int)this.selDays.getLocation().getY() + 60);
        this.selDays.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}));
        this.add(this.selDays);
        this.selDays.setBounds(215, 320, 40, 20);
        this.selDays.setVisible(false);
        final String tempSize = dbSize;
        final String dws = this.getDWS();
        this.selDays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DecimalFormat twoDigit = new DecimalFormat("0.00");
                String selectedDays = BackUp.this.selDays.getSelectedItem().toString();
                String selGB = twoDigit.format(Double.parseDouble(tempSize) / Double.parseDouble(dws) * Double.parseDouble(selectedDays));
                String selEstTime = BackUp.this.getEstimatedTime(selGB);
                BackUp.this.configAndDataDesc.setText("Backup the configuration & setting (i.e) Hosts/Applications\nadded, Report/Alert Profiles created etc. and the selected\nnumber of days of data.\nEstimated time approximately " + selEstTime);
            }
        });
        this.entireData.setLocation((int)this.entireData.getLocation().getX(), (int)this.entireData.getLocation().getY() + 60);
        this.entireData.setText("Backup whole databse");
        this.add(this.entireData);
        this.entireData.setBounds(25, 350, 300, 20);
        this.entireData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackUp.this.onlyConfig.setSelected(false);
                BackUp.this.configAndData.setSelected(false);
                BackUp.this.entireData.setSelected(true);
                BackUp.this.selDaysLabel.setVisible(false);
                BackUp.this.selDays.setVisible(false);
            }
        });
        this.entireDataDesc.setLocation((int)this.entireDataDesc.getLocation().getX(), (int)this.entireDataDesc.getLocation().getY() + 60);
        this.entireDataDesc.setText("Backup the configuration & setting (i.e) Hosts/Applications \nadded, Report/Alert Profiles created etc. and all the data.\nEstimated time approximately " + estimatedTime);
        this.entireDataDesc.setEditable(false);
        this.entireDataDesc.setDisabledTextColor(Color.BLACK);
        this.add(this.entireDataDesc);
        this.entireDataDesc.setBounds(45, 370, 320, 50);
        this.startButton.setLocation((int)this.startButton.getLocation().getX(), (int)this.startButton.getLocation().getY() + 60);
        this.startButton.setText("Start backup >>");
        this.add(this.startButton);
        this.startButton.setBounds(30, 440, 130, 20);
        this.startButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BackUp.this.preBackup();
                BackUp.this.dispose();
                try {
                    BackUp.this.process();
                }
                catch (Exception e) {
                    out.println(e);
                }
            }
        });
        this.add(this.backUpPanel);
        this.backUpPanel.setBounds(0, 0, 350, 460);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScharTables() {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.scharTable = new Hashtable();
            String query = "SELECT TableDetails.TABLE_NAME, ColumnDetails.COLUMN_NAME from TableDetails inner join ColumnDetails on TableDetails.TABLE_ID=ColumnDetails.TABLE_ID and ColumnDetails.DATA_TYPE='SCHAR'";
            this.conn = this.getConnection();
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME").toLowerCase();
                String col = rs.getString("COLUMN_NAME");
                this.scharColList.add(col);
                String prevValue = this.scharTable.put(table, col);
                if (prevValue == null) continue;
                this.scharTable.put(table, col + "," + prevValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    public Hashtable getSCharTable() {
        return this.scharTable;
    }

    public String getScharQuery(String table) throws Exception {
        try {
            if (scharEncryptionKey == null) {
                scharEncryptionKey = this.getNewScharKey();
                out.println("scharEncryptionKey fetched and value is : " + scharEncryptionKey);
            }
        }
        catch (Exception e) {
            out.println("Exception while fetching value for scharEncryptionKey.. :" + e.toString());
            e.printStackTrace();
        }
        int bno = 8000;
        bno = Integer.parseInt(this.build);
        String temp = (String)this.scharTable.get(table);
        String[] scharCol = temp.split(",");
        String selectCol = null;
        Iterator iter = this.getMetaData(table).keySet().iterator();
        while (iter.hasNext()) {
            if (selectCol != null) {
                selectCol = selectCol + "," + iter.next();
                continue;
            }
            selectCol = (String)iter.next();
        }
        for (int i = 0; i < scharCol.length; ++i) {
            String replacement = null;
            if (!this.isMssql) {
                if (bno <= 8000) {
                    replacement = "concat( \"encryptbykey(key_guid('ZOHO_SYMM_KEY'), N'\", decode(" + scharCol[i] + ",'Mickey'),\"')\" ) as " + scharCol[i];
                } else if (bno > 8000) {
                    replacement = this.isMysql ? (bno < 11060 ? "concat( \"encryptbykey(key_guid('ZOHO_SYMM_KEY'), N'\", decode(" + scharCol[i] + ",'MLite'),\"')\" ) as " + scharCol[i] : "concat( \"encryptbykey(key_guid('ZOHO_SYMM_KEY'), N'\", decode(" + scharCol[i] + ",'" + scharEncryptionKey + "'),\"')\" ) as " + scharCol[i]) : (8000 < bno && bno <= 8020 ? "pgp_sym_decrypt(" + scharCol[i] + ",'null','cipher-algo=aes256') as " + scharCol[i] : (bno > 8020 && bno < 11060 ? "pgp_sym_decrypt(" + scharCol[i] + ",'MLite','cipher-algo=aes256') as " + scharCol[i] : "pgp_sym_decrypt(" + scharCol[i] + ",'" + scharEncryptionKey + "','s2k-mode=1,cipher-algo=aes256') as " + scharCol[i]));
                }
            } else {
                String decrpted = "convert(VARBINARY,decryptbykeyautocert(cert_id('ZOHO_CERT'),NULL," + scharCol[i] + "))";
                replacement = "encryptbykey(key_guid('ZOHO_SYMM_KEY')," + decrpted + ") as " + scharCol[i];
            }
            selectCol = selectCol.replace(scharCol[i], replacement);
        }
        String query = "SELECT " + selectCol + " FROM " + table;
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewScharKey() {
        String newKey = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT * from SystemConfigurations where CONF_NAME='ELAED'";
            this.conn = this.getConnection();
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                newKey = rs.getString("CONF_VALUE");
            }
            newKey = ELAEncryptionAPI.getEDClass().decryptPassword(newKey, BackUp.get32BitELAConfKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ee) {
                out.println("Exception while fetching enc key using query:" + ee.toString());
                ee.printStackTrace();
            }
        }
        return newKey;
    }

    public static String get32BitELAConfKey() {
        String fileName = BackUp.getConfKeyPath();
        String elaKey = null;
        try {
            File keyFile = new File(fileName);
            Properties props = new Properties();
            props.load(new FileInputStream(keyFile));
            elaKey = props.getProperty("ENCRYPTIONKEY");
        }
        catch (IOException e) {
            out.println("Error: ELA encryption key file is not available in " + fileName);
            e.printStackTrace();
        }
        return elaKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfKeyPath() {
        String homeDir = System.getProperty("server.home");
        FilterInputStream dis = null;
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        String record = null;
        String path = null;
        String fileName = Paths.get(homeDir, "conf", "manage_key.conf").toString();
        try {
            File f = new File(fileName).getCanonicalFile();
            fis = new FileInputStream(f);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            while ((record = ((DataInputStream)dis).readLine()) != null) {
                path = record;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            out.println("Error in opening " + fileName);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
        return path;
    }
}

