/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.util;

import org.json.JSONException;
import org.json.JSONObject;

public class Credential {
    private String domain = null;
    private String machineName = null;
    private String username = null;
    private String password = null;

    private Credential() {
    }

    public static Credential getCredential(String username, String password, String domain, String machineName) {
        Credential instance = new Credential();
        if (Credential.isValidString(username)) {
            instance.password = password;
            instance.username = username;
        }
        if (Credential.isValidString(domain)) {
            instance.domain = domain;
        }
        if (Credential.isValidString(machineName)) {
            instance.machineName = machineName;
        }
        return instance;
    }

    public static Credential getCredential(JSONObject reqJsonObject) throws JSONException {
        Credential instance = new Credential();
        instance.machineName = Credential.getValue(reqJsonObject.optString("COMPUTER_NAME", null));
        instance.domain = Credential.getValue(reqJsonObject.optString("DOMAIN_NAME", null));
        if (!reqJsonObject.isNull("IS_AUTH_REQUIRED") && reqJsonObject.optString("IS_AUTH_REQUIRED").equalsIgnoreCase("FALSE")) {
            return instance;
        }
        instance.password = reqJsonObject.optString("PASSWORD", null);
        instance.username = Credential.getValue(reqJsonObject.optString("USERNAME", null));
        return instance;
    }

    private static String getValue(String value) {
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    public static Credential getCredential() {
        return new Credential();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserNameWithDomain() {
        if (this.domain != null) {
            return this.domain + "\\" + this.username;
        }
        return this.username;
    }

    public void resolveDomainAndUserName() {
        if (this.username != null && !this.username.isEmpty()) {
            String customDomain = null;
            if (this.username.contains("@")) {
                customDomain = this.username.substring(this.username.indexOf("@") + 1, this.username.length());
                this.username = this.username.substring(0, this.username.indexOf("@"));
            } else if (this.username.contains("\\")) {
                customDomain = this.username.substring(0, this.username.indexOf("\\"));
                this.username = this.username.substring(this.username.indexOf("\\") + 1, this.username.length());
            } else if (this.username.contains("/")) {
                customDomain = this.username.substring(0, this.username.indexOf("/"));
                this.username = this.username.substring(this.username.indexOf("/") + 1, this.username.length());
            }
            if (this.domain == null || this.domain.isEmpty()) {
                this.domain = customDomain;
            }
        }
    }

    private static boolean isValidString(String str) {
        return str != null && !str.isEmpty();
    }
}

