/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.util;

import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtil {
    public static String jsonArrayToString(JSONArray attributeList) throws JSONException {
        if (attributeList == null || attributeList.length() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < attributeList.length(); ++index) {
            if (attributeList.get(index) == null || attributeList.getString(index).isEmpty()) continue;
            if (index == attributeList.length() - 1) {
                buffer.append(attributeList.get(index));
                continue;
            }
            buffer.append(attributeList.get(index)).append(",");
        }
        return buffer.toString();
    }

    public static JSONObject rowToJSON(Row row) throws JSONException {
        JSONObject jsonObject = new JSONObject();
        for (Object columnObject : row.getColumns()) {
            String columnName = String.valueOf(columnObject);
            jsonObject.put(columnName, row.get(columnName));
        }
        return jsonObject;
    }

    public static Long[] toLongArray(JSONArray jsonArray) throws JSONException {
        Long[] array = new Long[jsonArray.length()];
        for (int index = 0; index < jsonArray.length(); ++index) {
            array[index] = jsonArray.getLong(index);
        }
        return array;
    }

    public static String[] toStringArray(JSONArray jsonArray) throws JSONException {
        String[] array = new String[jsonArray.length()];
        for (int index = 0; index < jsonArray.length(); ++index) {
            array[index] = jsonArray.getString(index);
        }
        return array;
    }

    public static Long[] keysToLongArray(JSONObject jsonObject) throws JSONException {
        Iterator itr = jsonObject.keys();
        Long[] array = new Long[jsonObject.length()];
        int index = 0;
        while (itr.hasNext()) {
            array[index++] = Long.valueOf((String)itr.next());
        }
        return array;
    }

    public static List<String> toList(JSONArray jsonArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            list.add(jsonArray.optString(i));
        }
        return list;
    }

    public static String[] listToStringArray(List<String> list) {
        String[] sArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            sArray[i] = list.get(i);
        }
        return sArray;
    }
}

