/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.util;

import com.adventnet.la.tools.ConnectionUtil;
import com.adventnet.tools.update.installer.JarExtractor;
import com.manageengine.ela.server.common.util.BackUp;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class RestoreBackup {
    private static PrintWriter out = new PrintWriter(System.out, true);
    private BufferedWriter logout = null;
    private static boolean dataRestoreState = false;
    private static String errString = "";
    private static int errorCode = -1;
    private Connection con = null;
    private String separator = File.separator;
    private String back_dir = "";
    private Hashtable scharTable;
    private int build;
    private BackUp backup = null;
    private static String symmKeyName = "ZOHO_SYMM_KEY";
    private static String certificateName = "ZOHO_CERT";
    private boolean isMysql = false;
    private boolean isPostgres = false;

    public RestoreBackup() {
        try {
            this.logout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("RestoreBackup.log"), "UTF8"));
            this.scharTable = new BackUp().getSCharTable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1 && new File(args[0]).isFile()) {
            RestoreBackup rbkp = new RestoreBackup();
            rbkp.restoreDatabase(args[0]);
            dataRestoreState = true;
        } else {
            out.println("File not found : " + (args.length == 1 ? args[0] : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDatabase(String backup_file) throws Exception {
        try {
            int build_no;
            this.logout.write("Extracting backup file....\n");
            this.deCompressData(backup_file);
            String dbserver = this.getActiveDBServer();
            this.isMysql = "mysql".equals(dbserver);
            this.isPostgres = "postgres".equals(dbserver);
            this.con = ConnectionUtil.getConnection((String)dbserver);
            List tables = ConnectionUtil.getTableList();
            Hashtable build_info = this.getBuildInfo(this.back_dir + this.separator + "backup_info.xml");
            int build_number = Integer.parseInt(build_info.get("build_number").toString());
            this.build = build_no = Integer.parseInt(BackUp.getBuildNumber());
            if (build_number == build_no) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                Date date = new Date();
                this.logout.write("\n\n The start time is" + dateFormat.format(date));
                out.println("\n\nPlease wait ! Deleting table data in Progress..");
                out.println("0-----------------------50------------------------100(%)");
                this.deleteTableData(dbserver, tables);
                out.println("\n\nPlease wait ! Restoring in Progress...................");
                this.restoreTableData(dbserver, tables, this.back_dir);
                out.println("\n deleting temp files.....");
                this.deleteDir(new File(this.back_dir));
                Date date1 = new Date();
                this.logout.write("\n\nThe stop time is" + dateFormat.format(date1));
                errString = "Data restored successfully";
                RestoreBackup.setErrorCode(0, errString);
                dataRestoreState = false;
            } else {
                out.println("Backup build number not compatible with existing build");
                this.logout.write("Backup build number not compatible with existing build\n");
                ConnectionUtil.shutDownDB();
                if (this.logout != null) {
                    this.logout.close();
                }
                this.deleteDir(new File(this.back_dir));
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dataRestoreState = false;
            out.println("Unable to restore database : " + e.getMessage());
            this.logout.write(e.getMessage() + "\n");
            if (this.logout != null) {
                this.logout.close();
            }
            System.exit(1);
        }
        finally {
            ConnectionUtil.shutDownDB();
            if (this.con != null && !this.con.isClosed()) {
                this.con.close();
            }
            if (this.logout != null) {
                this.logout.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTableData(String dbserver, List tables, String backup_dir) throws Exception {
        String tmp = System.getProperty("sdp.restore.error.ignoretables");
        Vector<String> error_tables = null;
        if (tmp != null) {
            out.println("Error Tables : " + tmp);
            String[] tables_tmp = tmp.split(",");
            int size = tables_tmp.length;
            error_tables = new Vector<String>(size);
            for (int i = 0; i < size; ++i) {
                if (tables_tmp[i].trim().equals("")) continue;
                error_tables.add(tables_tmp[i]);
            }
        }
        long buffer_size = 10240L;
        String bsize = System.getProperty("sdp.restore.buffersize_kb");
        if (bsize != null && !bsize.trim().equals("")) {
            try {
                buffer_size = Long.parseLong(System.getProperty("sdp.restore.buffersize_kb")) * 1024L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try (Statement stmt = null;){
            int i;
            this.con.setAutoCommit(false);
            stmt = this.con.createStatement();
            int size = tables.size();
            if (this.isMysql) {
                stmt.execute("set SESSION FOREIGN_KEY_CHECKS = 0");
            } else if (this.isPostgres) {
                stmt.execute("set session_replication_role ='replica'");
            } else {
                for (int i2 = 0; i2 < size; ++i2) {
                    stmt.executeUpdate("ALTER TABLE " + tables.get(i2) + "  NOCHECK CONSTRAINT ALL");
                }
            }
            String path = backup_dir + File.separator;
            out.println("0-----------------------50------------------------100(%)");
            int div = size / 50;
            String fileName = "";
            File[] files = new File(backup_dir).listFiles();
            for (i = 0; i < files.length; ++i) {
                String query;
                fileName = files[i].getName();
                if (fileName.indexOf(".sql") <= 0) continue;
                this.logout.write("\nWriting " + fileName);
                String file = path + fileName;
                if (!new File(file).exists()) {
                    this.logout.write("File not found : " + fileName);
                    continue;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String header = in.readLine();
                String tableName = fileName.substring(0, fileName.lastIndexOf("."));
                if (error_tables != null && error_tables.contains(tableName.toLowerCase())) continue;
                boolean encrypted = this.scharTable.containsKey(tableName);
                int testSplit = tableName.lastIndexOf("_");
                if (testSplit != -1) {
                    if (tableName.indexOf("archivedtable") != -1) {
                        stmt.executeUpdate(this.getArchiveQuery(dbserver, tableName, header));
                    } else if (!(tableName.indexOf("_sa") == -1 || "app_hr_trend_sa".equals(tableName) || "app_reports_hr_trend_sa".equals(tableName) || "app_longreports_hr_trend_sa".equals(tableName))) {
                        boolean isSplitTable = tableName.matches("sa_(\\d+)");
                        if (isSplitTable) {
                            stmt.executeUpdate(this.constructQuery(dbserver, tableName, "SPLIT"));
                        } else {
                            stmt.executeUpdate(this.constructQuery(dbserver, tableName, "NO_SPLIT"));
                        }
                    } else {
                        try {
                            long lastPart = Long.parseLong(tableName.substring(testSplit + 1));
                            stmt.executeUpdate(this.constructQuery(dbserver, tableName, header));
                        }
                        catch (Exception lastPart) {
                            // empty catch block
                        }
                    }
                }
                if (header == null) {
                    in.close();
                    if ((i + 1) % div != 0) continue;
                    out.print("=");
                    continue;
                }
                String line = in.readLine();
                long size_bytes = line.length();
                try (Statement stmtSym = null;){
                    if (encrypted && !this.isMysql && !this.isPostgres) {
                        stmtSym = this.con.createStatement();
                        query = "OPEN SYMMETRIC KEY " + symmKeyName + " DECRYPTION BY CERTIFICATE " + certificateName;
                        stmtSym.execute(query);
                    }
                    while (line != null) {
                        line = RestoreBackup.replaceUnwantedChar(line);
                        if (encrypted) {
                            line = this.setEncryption(line);
                        }
                        if (!this.isMysql && !this.isPostgres) {
                            stmt.addBatch(header + this.replaceCRTF(line));
                        } else {
                            stmt.addBatch(header + line.replaceAll(", N'", ", '"));
                        }
                        if (size_bytes > buffer_size) {
                            stmt.executeBatch();
                            this.con.commit();
                            size_bytes = 0L;
                        }
                        if ((line = in.readLine()) == null) continue;
                        size_bytes += (long)line.length();
                    }
                }
                if (size_bytes > 0L) {
                    try {
                        stmt.executeBatch();
                        this.con.commit();
                    }
                    catch (Exception ex) {
                        this.logout.write("Exception while executing the query QUERY = " + header + line + ex);
                    }
                }
                if (encrypted && !this.isMysql && !this.isPostgres) {
                    stmtSym = null;
                    try {
                        stmtSym = this.con.createStatement();
                        query = "CLOSE SYMMETRIC KEY " + symmKeyName;
                        stmtSym.execute(query);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (stmtSym != null) {
                            stmtSym.close();
                        }
                    }
                }
                in.close();
                if ((i + 1) % div != 0) continue;
                out.print("=");
            }
            if (this.isMysql) {
                stmt.execute("set SESSION FOREIGN_KEY_CHECKS = 1");
                stmt.execute("update ReportBuildingBlock,ReportBuildingBlock_mysql set ReportBuildingBlock.SQLSTRING=ReportBuildingBlock_mysql.SQLSTRING where ReportBuildingBlock.RBBNAME=ReportBuildingBlock_mysql.RBBNAME");
                stmt.execute("drop table if exists ReportBuildingBlock_mysql");
                stmt.execute("set SESSION FOREIGN_KEY_CHECKS = 1");
                stmt.execute("delete from ReportBuildingBlockParams");
                stmt.execute("insert into ReportBuildingBlockParams (select * from ReportBuildingBlockParams_mysql)");
                stmt.execute("drop table if exists ReportBuildingBlockParams_mysql");
            } else if (this.isPostgres) {
                stmt.execute("set session_replication_role ='origin'");
                stmt.execute("update ReportBuildingBlock,ReportBuildingBlock_postgres set ReportBuildingBlock.SQLSTRING=ReportBuildingBlock_postgres.SQLSTRING where ReportBuildingBlock.RBBNAME=ReportBuildingBlock_postgres.RBBNAME");
                stmt.execute("drop table if exists ReportBuildingBlock_postgres");
                stmt.execute("set session_replication_role ='origin'");
                stmt.execute("delete from ReportBuildingBlockParams");
                stmt.execute("insert into ReportBuildingBlockParams (select * from ReportBuildingBlockParams_postgres)");
                stmt.execute("drop table if exists ReportBuildingBlockParams_postgres");
            } else {
                for (i = 0; i < size; ++i) {
                    stmt.executeUpdate("ALTER TABLE " + tables.get(i) + " CHECK CONSTRAINT ALL");
                }
                stmt.execute("update ReportBuildingBlock set ReportBuildingBlock.SQLSTRING=ReportBuildingBlock_mssql.SQLSTRING from ReportBuildingBlock,ReportBuildingBlock_mssql where ReportBuildingBlock.RBBNAME=ReportBuildingBlock_mssql.RBBNAME");
                stmt.execute("IF EXISTS(select * from sysobjects where name='ReportBuildingBlock_mssql') DROP TABLE ReportBuildingBlock_mssql");
                stmt.execute("delete from ReportBuildingBlockParams");
                stmt.execute("insert into ReportBuildingBlockParams select * from ReportBuildingBlockParams_mssql");
                stmt.execute("IF EXISTS(select * from sysobjects where name='ReportBuildingBlockParams_mssql') DROP TABLE ReportBuildingBlockParams_mssql");
                stmt.execute("update MetaTable set END_TIME='1970-01-01 00:00:00' where LOOKUP_TABLENAME=TABLE_NAME");
                stmt.execute("update DataManagementTiming set TIMESTAMP='1970-01-01 00:00:00' where TIMER_NAME in ('COMP_SYS_TIMER','EVT_HOUR_TIMER','SYS_HOUR_TIMER') and TIMESTAMP='0'");
            }
            stmt.execute("insert into SystemConfigurations values ('regenerateSQL','true')");
            stmt.execute("insert into SystemConfigurations values ('DatabaseMigration','true')");
            this.con.commit();
        }
    }

    private String getArchiveQuery(String dbserver, String tableName, String query) throws Exception {
        boolean evtId;
        String archiveQuery = "";
        boolean hId = query.indexOf(",HOST_ID,") != -1;
        boolean bl = evtId = query.indexOf(",EVENTID,") != -1;
        archiveQuery = this.isMysql ? (hId ? "CREATE TABLE IF NOT EXISTS `" + tableName + "` (`ELID` bigint(19) NOT NULL default '0',`HOST_ID` BIGINT NOT NULL default '', `TIMESTAMP` varchar(25) NOT NULL default '', `EVENTID` int(10) NOT NULL default '0', `SEVERITY` varchar(50) NOT NULL default '', `TYPE` varchar(50) NOT NULL default '', `SOURCE` varchar(100) NOT NULL default '', `MESSAGE` text, `SYSTEM_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP)" : (evtId ? "CREATE TABLE IF NOT EXISTS `" + tableName + "` (`HOST_NAME` varchar(75) NOT NULL default '', `TIMESTAMP` varchar(25) NOT NULL default '', `EVENTID` int(10) NOT NULL default '0', `SEVERITY` varchar(50) NOT NULL default '', `TYPE` varchar(50) NOT NULL default '', `SOURCE` varchar(100) NOT NULL default '', `MESSAGE` text, `SYSTEM_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP)" : "CREATE TABLE IF NOT EXISTS `" + tableName + "` (`HOST_NAME` varchar(75) NOT NULL default '', `TIMESTAMP` varchar(25) NOT NULL default '', `SEVERITY` varchar(250) NOT NULL default '', `FACILITY` varchar(250) NOT NULL default '', `SOURCE` varchar(250) NOT NULL default '', `MESSAGE` varchar(250) default NULL, `SYSTEM_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP)")) : (this.isPostgres ? (hId ? "CREATE TABLE IF NOT EXISTS `" + tableName + "` (`ELID` bigint(19) NOT NULL default '0',`HOST_ID` BIGINT NOT NULL default '', `TIMESTAMP` varchar(25) NOT NULL default '', `EVENTID` int(10) NOT NULL default '0', `SEVERITY` varchar(50) NOT NULL default '', `TYPE` varchar(50) NOT NULL default '', `SOURCE` varchar(100) NOT NULL default '', `MESSAGE` text, `SYSTEM_TIME` timestamp NOT NULL default localtimestamp(0) NOT NULL)" : (evtId ? "CREATE TABLE IF NOT EXISTS `" + tableName + "` (`HOST_NAME` varchar(75) NOT NULL default '', `TIMESTAMP` varchar(25) NOT NULL default '', `EVENTID` int(10) NOT NULL default '0', `SEVERITY` varchar(50) NOT NULL default '', `TYPE` varchar(50) NOT NULL default '', `SOURCE` varchar(100) NOT NULL default '', `MESSAGE` text, `SYSTEM_TIME` timestamp NOT NULL default localtimestamp(0) NOT NULL)" : "CREATE TABLE IF NOT EXISTS `" + tableName + "` (`HOST_NAME` varchar(75) NOT NULL default '', `TIMESTAMP` varchar(25) NOT NULL default '', `SEVERITY` varchar(250) NOT NULL default '', `FACILITY` varchar(250) NOT NULL default '', `SOURCE` varchar(250) NOT NULL default '', `MESSAGE` text default NULL, `SYSTEM_TIME` timestamp NOT NULL default localtimestamp(0) NOT NULL)")) : (hId ? "if not exists (select * from sysobjects where name='" + tableName + "' and xtype='U') CREATE TABLE " + tableName + " (ELID bigint default '0' NOT NULL , HOST_ID bigint DEFAULT  '0' NOT NULL , TIMESTAMP varchar(25) DEFAULT  '' NOT NULL , EVENTID int DEFAULT  '0' NOT NULL , SEVERITY varchar (50) DEFAULT  '' NOT NULL , TYPE varchar (50) DEFAULT  '' NOT NULL , SOURCE varchar (100) DEFAULT  '' NOT NULL , MESSAGE varchar(8000)  , SYSTEM_TIME DATETIME  DEFAULT  GETDATE() NOT NULL)" : (evtId ? "if not exists (select * from sysobjects where name='" + tableName + "' and xtype='U') CREATE TABLE " + tableName + " (HOST_NAME varchar (75) DEFAULT  '' NOT NULL, TIMESTAMP varchar (25) DEFAULT  '' NOT NULL, EVENTID int DEFAULT  '0' NOT NULL, SEVERITY varchar (50) DEFAULT  '' NOT NULL, TYPE varchar (50) DEFAULT  '' NOT NULL, SOURCE varchar (100) DEFAULT  '' NOT NULL, MESSAGE varchar(8000), SYSTEM_TIME DATETIME  DEFAULT  GETDATE() NOT NULL)" : "if not exists (select * from sysobjects where name='" + tableName + "' and xtype='U') CREATE TABLE " + tableName + " (HOST_NAME varchar (75) DEFAULT  '' NOT NULL, TIMESTAMP varchar (25) DEFAULT  '' NOT NULL, SEVERITY varchar (250) DEFAULT  '' NOT NULL, FACILITY varchar (250) DEFAULT  '' NOT NULL, SOURCE varchar (250) DEFAULT  '' NOT NULL, MESSAGE varchar (8000), SYSTEM_TIME DATETIME  DEFAULT  GETDATE() NOT NULL)")));
        return archiveQuery;
    }

    private String constructQuery(String dbserver, String splitTable, String header) throws Exception {
        int appIndex;
        int appReportIndex;
        int appLongReportIndex;
        boolean isEventLog;
        Statement stmt1 = null;
        Statement stmt2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String existingTable = splitTable.substring(0, splitTable.lastIndexOf("_"));
        if ("NO_SPLIT".equals(header)) {
            existingTable = splitTable;
        }
        boolean bl = isEventLog = header.indexOf(",EVENTID,") != -1;
        if ("import".equals(existingTable)) {
            existingTable = isEventLog ? "EventLog" : "SysLog";
        }
        if ((appLongReportIndex = existingTable.indexOf("_longreports_hr_trend_sa")) > -1) {
            existingTable = "app_longreports_hr_trend_sa";
        }
        if ((appReportIndex = existingTable.indexOf("_reports_hr_trend_sa")) > -1) {
            existingTable = "app_reports_hr_trend_sa";
        }
        if ((appIndex = existingTable.indexOf("_hr_trend_sa")) > -1 && appLongReportIndex == -1 && appReportIndex == -1) {
            existingTable = "app_hr_trend_sa";
        }
        this.logout.write("\n" + splitTable + " Query is");
        String finalQuery = "";
        if (this.isMysql) {
            finalQuery = "create table if not exists " + splitTable + " like " + existingTable;
        } else if (this.isPostgres) {
            finalQuery = "create table if not exists " + splitTable + "( like " + existingTable + "including all)";
        } else {
            StringBuffer resultQuery = new StringBuffer("");
            try {
                stmt1 = this.con.createStatement();
                rs1 = stmt1.executeQuery("exec sp_columns " + existingTable);
                resultQuery.append("if not exists (select * from sysobjects where name='" + splitTable + "' and xtype='U') CREATE TABLE " + splitTable + " ( ");
                while (rs1.next()) {
                    String tempStr;
                    int tempInt;
                    String columnName = "";
                    String columnType = "";
                    String columnSize = "";
                    String defaultValue = "";
                    String nullable = "";
                    columnName = (String)rs1.getObject(4) + " ";
                    columnType = (String)rs1.getObject(6) + " ";
                    String lowerColumnType = columnType.toLowerCase();
                    if (lowerColumnType.indexOf("int") == -1 && lowerColumnType.indexOf("datetime") == -1 && lowerColumnType.indexOf("ntext") == -1) {
                        columnSize = lowerColumnType.indexOf("nvarchar") > -1 ? "(4000)" : "(" + (Integer)rs1.getObject(8) + ") ";
                    }
                    if ((tempInt = ((Integer)rs1.getObject(11)).intValue()) == 0) {
                        nullable = "NOT NULL";
                    }
                    if ((tempStr = (String)rs1.getObject(13)) != null) {
                        defaultValue = "DEFAULT " + tempStr + " ";
                    }
                    resultQuery.append(columnName + columnType + columnSize + defaultValue + nullable + ", ");
                }
                resultQuery.append(" ); ");
                stmt1.close();
                rs1.close();
                stmt2 = this.con.createStatement();
                rs2 = stmt2.executeQuery("exec sp_helpindex " + existingTable);
                while (rs2.next()) {
                    String indexName = "";
                    String indexValue = "";
                    indexName = (String)rs2.getObject(1);
                    indexValue = (String)rs2.getObject(3);
                    if (indexName.indexOf("PK") != -1) {
                        resultQuery.insert(resultQuery.indexOf(" );"), "PRIMARY KEY (" + indexValue + ")");
                        continue;
                    }
                    resultQuery.append("CREATE INDEX " + indexName + " ON " + splitTable + " ( " + indexValue + " );");
                }
                stmt2.close();
                rs2.close();
            }
            catch (Exception e) {
                this.logout.write("\nException Executing the constructed SQL  ::  \n" + resultQuery);
                throw e;
            }
            finally {
                try {
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                    rs1.close();
                    rs2.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.logout.write("\n" + resultQuery);
            finalQuery = resultQuery.toString();
        }
        return finalQuery;
    }

    private String replaceCRTF(String data) throws Exception {
        try {
            data = data.replaceAll("\\\\t", "\t");
            data = data.replaceAll("\\\\r", "\r");
            data = data.replaceAll("\\\\n", "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private void deleteDir(File file) throws Exception {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().indexOf(".sql") <= 0) continue;
            files[i].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTableData(String dbserver, List tables) throws Exception {
        String str = null;
        String tmp = null;
        boolean flag = false;
        try (Statement stmt = null;){
            int i;
            this.con.setAutoCommit(false);
            stmt = this.con.createStatement();
            int size = tables.size();
            String rbb_table = "ReportBuildingBlock_" + dbserver;
            String rbbParams_table = "ReportBuildingBlockParams_" + dbserver;
            if (this.isMysql) {
                stmt.execute("create table if not exists " + rbb_table + " like ReportBuildingBlock");
                stmt.execute("insert into " + rbb_table + " (select * from ReportBuildingBlock)");
                stmt.execute("create table if not exists " + rbbParams_table + " like ReportBuildingBlockParams");
                stmt.execute("insert into " + rbbParams_table + " (select * from ReportBuildingBlockParams)");
                stmt.execute("set SESSION FOREIGN_KEY_CHECKS = 0");
            } else if (this.isPostgres) {
                stmt.execute("create table if not exists " + rbb_table + " (like ReportBuildingBlock including all)");
                stmt.execute("insert into " + rbb_table + " (select * from ReportBuildingBlock)");
                stmt.execute("create table if not exists " + rbbParams_table + " (like ReportBuildingBlockParams including all)");
                stmt.execute("insert into " + rbbParams_table + " (select * from ReportBuildingBlockParams)");
                stmt.execute("set session_replication_role ='replica'");
            } else {
                stmt.execute("if not exists (select * from sysobjects where name='" + rbb_table + "' and xtype='U') select * into " + rbb_table + " from ReportBuildingBlock");
                stmt.execute("if not exists (select * from sysobjects where name='" + rbbParams_table + "' and xtype='U') select * into " + rbbParams_table + " from ReportBuildingBlockParams");
                for (int i2 = size - 1; i2 >= 0; --i2) {
                    stmt.executeUpdate("ALTER TABLE " + tables.get(i2) + "  NOCHECK CONSTRAINT ALL");
                }
            }
            int divider = size / 50;
            for (i = size - 1; i >= 0; --i) {
                if (i % divider == 0) {
                    out.print("=");
                }
                if (rbb_table.equalsIgnoreCase(tmp = (String)tables.get(i)) || rbbParams_table.equalsIgnoreCase(tmp)) continue;
                str = "delete from " + tmp;
                try {
                    stmt.executeUpdate(str);
                    continue;
                }
                catch (SQLException e) {
                    this.logout.write(e.getMessage() + " : " + str + "\n");
                    flag = true;
                }
            }
            if (this.isMysql) {
                stmt.execute("set SESSION FOREIGN_KEY_CHECKS = 1");
            } else if (this.isPostgres) {
                stmt.execute("set session_replication_role ='origin'");
            } else {
                for (i = size - 1; i >= 0; --i) {
                    stmt.executeUpdate("ALTER TABLE " + tables.get(i) + " CHECK CONSTRAINT ALL");
                }
            }
            this.con.commit();
            out.println("");
            if (flag) {
                out.println("Error occured while deletion of all table");
                out.println(" data please see the error log");
            }
        }
    }

    private Hashtable getBuildInfo(String backup_info) throws Exception {
        Hashtable<String, String> hash = new Hashtable<String, String>(4);
        if (!new File(backup_info).isFile()) {
            throw new Exception("backup-info.xml not found : " + backup_info);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new FileInputStream(backup_info));
        NodeList nodelist = doc.getElementsByTagName("backup-date");
        out.println("");
        out.println("*************************************************************");
        out.println("\t Backpup data  : " + nodelist.item(0).getFirstChild().getNodeValue());
        hash.put("backup_date", nodelist.item(0).getFirstChild().getNodeValue());
        nodelist = doc.getElementsByTagName("database");
        out.println("\t Database name : " + nodelist.item(0).getFirstChild().getNodeValue());
        hash.put("database", nodelist.item(0).getFirstChild().getNodeValue());
        nodelist = doc.getElementsByTagName("number-of-table");
        out.println("\t Total Tables  : " + nodelist.item(0).getFirstChild().getNodeValue());
        hash.put("no_of_tables", nodelist.item(0).getFirstChild().getNodeValue());
        nodelist = doc.getElementsByTagName("build-number");
        out.println("\t Build Number  : " + nodelist.item(0).getFirstChild().getNodeValue());
        hash.put("build_number", nodelist.item(0).getFirstChild().getNodeValue());
        out.println("*************************************************************");
        out.println("");
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getActiveDBServer() throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        FileInputStream fis = null;
        String dbName = "";
        try {
            docBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    try {
                        new File("localhost.dtd").createNewFile();
                        return new InputSource(new FileInputStream("localhost.dtd"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
            String dsfile = System.getProperty("server.home") + File.separator + "conf" + File.separator;
            dsfile = dsfile + "Persistence" + File.separator + "persistence-configurations.xml";
            fis = new FileInputStream(dsfile);
            Document doc = docBuilder.parse(fis);
            NodeList adapter = doc.getElementsByTagName("configuration");
            for (int i = 0; i < adapter.getLength(); ++i) {
                Element ele = (Element)adapter.item(i);
                if (!"DBName".equals(ele.getAttribute("name"))) continue;
                dbName = ele.getAttribute("value");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return dbName;
    }

    private static String replaceUnwantedChar(String data) {
        StringBuffer buffer = new StringBuffer();
        try {
            StringCharacterIterator iterator = new StringCharacterIterator(data);
            char character = iterator.current();
            while (character != '\uffff') {
                if (character != '\u0000') {
                    buffer.append(character);
                }
                character = iterator.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buffer.append("\n");
        return buffer.toString();
    }

    private void deCompressData(String filename) throws Exception {
        File backupFile = new File(filename);
        this.back_dir = backupFile.getParent();
        out.println("Please wait extracting backup file");
        new File(this.back_dir).mkdir();
        JarExtractor.extract((File)backupFile, (File)new File(this.back_dir));
    }

    public static boolean isDataRestored() {
        return dataRestoreState;
    }

    public static String getErrorString() {
        return errString;
    }

    public static int getErrorCode() {
        return errorCode;
    }

    public static void setErrorCode(int ec, String es) {
        errorCode = ec;
        errString = es;
    }

    public String setEncryption(String line) {
        if (this.isMysql) {
            if (this.build <= 8000) {
                line = line.replaceAll("eventlog@adventnet", "encode(");
                line = line.replaceAll("eventlog@zoho", "'Mickey'");
            } else if (this.build > 8020 && this.build < 11060) {
                line = line.replaceAll("eventlog@adventnet", "encode(");
                line = line.replaceAll("eventlog@zoho", "'MLite'");
            } else {
                line = line.replaceAll("eventlog@adventnet", "encode(");
                line = line.replaceAll("eventlog@zoho", "'null'");
            }
        } else if (this.isPostgres) {
            if (this.build > 8000 && this.build <= 8020) {
                line = line.replaceAll("eventlog@adventnet", "pgp_sym_encrypt(");
                line = line.replaceAll("eventlog@zoho", "'null','s2k-mode=1,cipher-algo=aes256'");
            } else if (this.build > 8020 && this.build < 11060) {
                line = line.replaceAll("eventlog@adventnet", "pgp_sym_encrypt(");
                line = line.replaceAll("eventlog@zoho", "'MLite','s2k-mode=1,cipher-algo=aes256'");
            } else {
                line = line.replaceAll("eventlog@adventnet", "pgp_sym_encrypt(");
                line = line.replaceAll("eventlog@zoho", "'null','s2k-mode=1,cipher-algo=aes256'");
            }
        } else {
            line = line.replaceAll("eventlog@adventnet", "encryptbykey(key_guid('ZOHO_SYMM_KEY'),");
            line = line.replaceAll(",eventlog@zoho", "");
        }
        return line;
    }
}

