/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.settings.notification.util.NotificationSettingsUtil;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerUtil {
    private static final Logger LOGGER = Logger.getLogger(ServerUtil.class.getName());

    public static Locale getServerLocale() {
        Locale locale = ProductBundle.getInstance().getServerBundle().getLocale();
        if (locale == null || locale.toString().length() == 0) {
            locale = new Locale("en", "US");
        }
        return locale;
    }

    public static boolean isUnixLog(Map<String, Object> log) {
        return log.containsKey("HOSTTYPE") && log.get("HOSTTYPE").toString().equalsIgnoreCase("unix");
    }

    public static int getGlobalRetentionPeriod() {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"DataManagementTiming"));
            selectQuery.addSelectColumn(Column.getColumn((String)"DataManagementTiming", (String)"TIMER_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"DataManagementTiming", (String)"TIMESTAMP"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"DataManagementTiming", (String)"TIMER_NAME"), (Object)"SYS_DATA_WINDOW", 0));
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            String retention = (String)dataObject.getFirstValue("DataManagementTiming", "TIMESTAMP");
            return Integer.parseInt(retention);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return -1;
        }
    }

    public static JSONObject getMailServerInfo() {
        JSONObject response = new JSONObject();
        try {
            JSONObject mailServerInfo = NotificationSettingsUtil.getServerConfigurationSettings();
            JSONObject mailJson = mailServerInfo.getJSONObject("mail");
            response.put("MAIL_SERVER_ADDRESS", (Object)mailJson.optString("serverName", "-"));
            response.put("MAIL_SERVER_PORT", (Object)mailJson.optString("port", "-"));
        }
        catch (JSONException exp) {
            LOGGER.log(Level.INFO, "Couldn't fetch mail server information {0}", exp.getMessage());
        }
        return response;
    }
}

