/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public class StringUtil {
    private static final Logger LOGGER = Logger.getLogger(StringUtil.class.getName());
    public static final CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())});

    public static int findNthIndexOf(String str, String needle, int occurence) throws IndexOutOfBoundsException {
        int index = -1;
        Pattern pattern = Pattern.compile(needle, 8);
        Matcher matchr = pattern.matcher(str);
        while (matchr.find()) {
            if (--occurence != 0) continue;
            index = matchr.start();
            break;
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return index;
    }

    public static String encodeHTML(String input) {
        if (input != null) {
            return StringEscapeUtils.escapeHtml4((String)input);
        }
        LOGGER.info("CommonUtil encodeHTML Null Pointer Exception");
        return "";
    }

    public static String decodeHTML(String input) {
        if (input != null) {
            return StringEscapeUtils.unescapeHtml4((String)input);
        }
        LOGGER.info("CommonUtil decodeHTML Null Pointer Exception");
        return "";
    }

    public static String getEscapedString(String value) {
        String result = null;
        if (value != null) {
            result = ESCAPE_JAVA.translate((CharSequence)value);
        }
        return result;
    }

    public static String listToString(List<String> attributeList) {
        if (attributeList == null || attributeList.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < attributeList.size(); ++index) {
            if (attributeList.get(index) == null || attributeList.get(index).isEmpty()) continue;
            if (index == attributeList.size() - 1) {
                buffer.append(attributeList.get(index));
                continue;
            }
            buffer.append(attributeList.get(index)).append(",");
        }
        return buffer.toString();
    }

    public static String longListToString(List<Long> attributeList) {
        if (attributeList == null || attributeList.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < attributeList.size(); ++index) {
            if (attributeList.get(index) == null) continue;
            if (index == attributeList.size() - 1) {
                buffer.append(attributeList.get(index));
                continue;
            }
            buffer.append(attributeList.get(index)).append(",");
        }
        return buffer.toString();
    }

    public static String arrayToString(Object[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < data.length; ++index) {
            buffer.append(data[index].toString());
            if (index >= data.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    public static List<Long> stringArryToLongList(String[] requestedGroupIDs) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (String id : requestedGroupIDs) {
            list.add(Long.parseLong(id));
        }
        return list;
    }

    public static Long[] stringArryToLongArray(String[] requestedGroupIDs) {
        Long[] result = new Long[requestedGroupIDs.length];
        for (int index = 0; index < requestedGroupIDs.length; ++index) {
            result[index] = Long.parseLong(requestedGroupIDs[index]);
        }
        return result;
    }

    public static Long[] stringToLongArray(String deviceIds, String split) {
        String[] array = deviceIds.split(split);
        return StringUtil.stringArryToLongArray(array);
    }

    public static boolean isNumeric(String str) {
        return StringUtils.isNumeric((CharSequence)str);
    }

    public static String escapeString(String query) {
        String[] sequences;
        for (String sequence : sequences = new String[]{"&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":"}) {
            if (!query.contains(sequence)) continue;
            query = query.replaceAll(sequence, String.format("\\%s", sequence));
        }
        return query;
    }
}

