/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TimeZoneList {
    private static JSONArray timeZoneListJsonArray = new JSONArray();

    private static void loadTimeZones() {
        ArrayList<TimeZone> tzList = new ArrayList<TimeZone>();
        String[] ids = TimeZone.getAvailableIDs();
        int value = 0;
        try {
            for (String id : ids) {
                tzList.add(TimeZone.getTimeZone(id));
            }
            Collections.sort(tzList, new Comparator<TimeZone>(){

                @Override
                public int compare(TimeZone s1, TimeZone s2) {
                    return s1.getRawOffset() - s2.getRawOffset();
                }
            });
            for (TimeZone timeZone : tzList) {
                String tz = TimeZoneList.getTimeZone(timeZone);
                JSONObject temp = new JSONObject();
                temp.put("value", value);
                temp.put("key", (Object)timeZone.getID());
                temp.put("title", (Object)tz);
                timeZoneListJsonArray.put((Object)temp);
                ++value;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getTimeZoneListJsonArray() {
        if (timeZoneListJsonArray.length() == 0) {
            TimeZoneList.loadTimeZones();
        }
        return timeZoneListJsonArray;
    }

    private static String getTimeZone(TimeZone tz) {
        long hours = TimeUnit.MILLISECONDS.toHours(tz.getRawOffset());
        long minutes = TimeUnit.MILLISECONDS.toMinutes(tz.getRawOffset()) - TimeUnit.HOURS.toMinutes(hours);
        minutes = Math.abs(minutes);
        String result = hours > 0L ? String.format("(GMT+%d:%02d) %s", hours, minutes, tz.getID()) : String.format("(GMT%d:%02d) %s", hours, minutes, tz.getID());
        return result;
    }

    static {
        TimeZoneList.loadTimeZones();
    }
}

