/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.compliance.schedule;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LaUtil;
import com.adventnet.la.PreReportModel;
import com.adventnet.la.ReportUtil;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.taskengine.util.CalendarRowConfig;
import com.manageengine.ela.server.common.delegation.DelegationRoleContainer;
import com.manageengine.ela.server.common.device.management.DeviceOperations;
import com.manageengine.ela.server.common.export.utils.TableScheduleUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.settings.notification.util.NotificationSettingsUtil;
import com.manageengine.ela.server.common.util.JSONUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ComplianceScheduleHandler {
    private static final Logger LOGGER = Logger.getLogger(ComplianceScheduleHandler.class.getName());
    public static ArrayList predefinedComplianceList = new ArrayList<String>(Arrays.asList("HIPAA", "SOX", "GLBA", "PCI", "FISMA", "ISO 27001:2013", "GPG", "GDPR"));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long addOrUpdateSchedule(JSONObject reqJsonObject, Long userID, Locale locale) throws BaseStatusCode {
        try {
            Row scheduleRow;
            JSONObject request = reqJsonObject.getJSONObject("SCHEDULE_REQUEST_PARAMS");
            DataObject dobj = null;
            JSONObject additionalParams = request.getJSONObject("ADDITIONAL_PARAMS_STR");
            if (additionalParams.has("RUN_ON_WEEKDAYS")) {
                JSONArray daysOfWeek = additionalParams.getJSONArray("RUN_ON_WEEKDAYS");
                int[] array = new int[daysOfWeek.length()];
                for (int index = 0; index < daysOfWeek.length(); ++index) {
                    array[index] = daysOfWeek.getInt(index);
                }
                request.put("FREQUENCY", TableScheduleUtil.Frequency.WEEKLY.ordinal());
                JSONObject timeJSON = request.getJSONObject("TIME");
                Arrays.sort(array);
                int daysOfWeekValue = CalendarRowConfig.encodeDaysOfWeek((int[])array);
                LOGGER.log(Level.FINE, "Setting days of week : {0}", daysOfWeekValue);
                timeJSON.put("DAY_OF_WEEK", daysOfWeekValue);
                request.put("TIME", (Object)timeJSON);
            }
            if (request.getString("OPERATION").equals("CREATE")) {
                if (request.optString("EMAIL_SUBJECT", "").isEmpty()) {
                    request.put("EMAIL_SUBJECT", (Object)(ProductBundle.getInstance().getString(locale, "ela.schedule.compliance.defaultMailSubject") + " : " + request.getString("SCHEDULE_DISPLAY_NAME")));
                }
                dobj = TableScheduleUtil.getNewScheduleDO(request, userID, locale);
                scheduleRow = dobj.getRow("ELATableExportSchedules");
                Row taskInputRow = dobj.getRow("Task_Input");
                if (scheduleRow == null) throw BaseStatusCode.getBaseStatusCode(7428);
                Row row = new Row("ScheduledReports");
                row.set("EXPORT_ID", scheduleRow.get("EXPORT_ID"));
                row.set("REPORT_ID", (Object)request.getLong("REPORT_ID"));
                row.set("TYPE", (Object)ReportUtil.scheduleType.COMPLIANCE.ordinal());
                dobj.addRow(row);
                if (taskInputRow != null) {
                    String schedulerType = request.has("SCHEDULE_TYPE") ? request.getString("SCHEDULE_TYPE") : null;
                    Row reportTaskInputRow = new Row("ReportTaskInput");
                    reportTaskInputRow.set("INSTANCE_ID", taskInputRow.get("INSTANCE_ID"));
                    reportTaskInputRow.set("REPORTID", (Object)request.getLong("REPORT_ID"));
                    if (schedulerType != null) {
                        reportTaskInputRow.set("SCHEDULETYPE", (Object)schedulerType);
                    }
                    dobj.addRow(reportTaskInputRow);
                }
            } else {
                dobj = TableScheduleUtil.getUpdatedScheduleDO(request);
                DataObject reportRowsDO = ComplianceScheduleHandler.updateReportRows(reqJsonObject.getJSONObject("SCHEDULE_REPORT_PARAMS"), reqJsonObject.getLong("REPORT_ID"), request);
                if (reportRowsDO != null) {
                    PersistenceDBUtil.getPersistence().update(reportRowsDO);
                }
                LOGGER.log(Level.FINE, "DO after merge is : {0} ", dobj);
            }
            PersistenceDBUtil.getScheduler().updateSchedule(dobj);
            scheduleRow = dobj.getRow("ELATableExportSchedules");
            return (Long)scheduleRow.get("EXPORT_ID");
        }
        catch (BaseStatusCode bs) {
            bs.printStackTrace();
            throw bs;
        }
        catch (JSONException je) {
            je.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        catch (Exception dae) {
            dae.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
    }

    public static JSONObject editSchedule(long reportID, Locale locale) throws BaseStatusCode {
        return ComplianceScheduleHandler.setComplianceReports(reportID, locale);
    }

    public static void deleteScheduleAndReportRows(JSONArray reportId, JSONArray exportId) throws BaseStatusCode {
        try {
            DeleteQueryImpl delQuery = new DeleteQueryImpl("ReportConfig");
            String[] reportIdArray = new String[]{"REPORTID"};
            String[] filterNameArray = new String[]{"FILTERNAME"};
            Join j1 = new Join("ReportConfig", "ReportConfigToFilters", reportIdArray, reportIdArray, 1);
            Join j2 = new Join("ReportConfigToFilters", "Filters", filterNameArray, filterNameArray, 1);
            Long[] reportID = JSONUtil.toLongArray(reportId);
            Criteria crt = new Criteria(Column.getColumn((String)"ReportConfig", (String)"REPORTID"), (Object)reportID, 8);
            delQuery.addJoin(j1);
            delQuery.addJoin(j2);
            delQuery.setCriteria(crt);
            PersistenceDBUtil.getPersistence().delete((DeleteQuery)delQuery);
            TableScheduleUtil.deleteExportSchedule(exportId);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while removing report rows : {0}", e.getMessage());
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7939);
        }
    }

    public static void deleteScheduleAndReportBasedOnCompliance(long policyId) {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"LAExpression"));
            String[] reportIdArray = new String[]{"REPORTID"};
            String[] filterNameArray = new String[]{"FILTERNAME"};
            Join j1 = new Join("LAExpression", "FilterToLAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 1);
            Join j2 = new Join("FilterToLAExpression", "Filters", filterNameArray, filterNameArray, 1);
            Join j3 = new Join("Filters", "ReportConfigToFilters", filterNameArray, filterNameArray, 1);
            Join j4 = new Join("ReportConfigToFilters", "ReportConfig", reportIdArray, reportIdArray, 1);
            Join j5 = new Join("ReportConfig", "ScheduledReports", reportIdArray, new String[]{"REPORT_ID"}, 1);
            Criteria crit = new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"CompType", 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"LAExpression", (String)"VALUE"), (Object)policyId, 0));
            sql.addSelectColumn(Column.getColumn((String)"LAExpression", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"FilterToLAExpression", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"Filters", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"ReportConfigToFilters", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"REPORTID"));
            sql.addSelectColumn(Column.getColumn((String)"ScheduledReports", (String)"*"));
            sql.addJoin(j1);
            sql.addJoin(j2);
            sql.addJoin(j3);
            sql.addJoin(j4);
            sql.addJoin(j5);
            sql.setCriteria(crit);
            LOGGER.log(Level.FINE, "Check sql for deleting compliance based schedule : {0}", RelationalAPI.getInstance().getSelectSQL((Query)sql));
            DataObject policyIdBasedDO = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            JSONArray reportIdJSONArray = new JSONArray();
            JSONArray exportIdJSONArray = new JSONArray();
            Iterator scheduleItr = policyIdBasedDO.getRows("ScheduledReports");
            while (scheduleItr.hasNext()) {
                Row scheduleRow = (Row)scheduleItr.next();
                exportIdJSONArray.put((Object)((Long)scheduleRow.get("EXPORT_ID")));
                reportIdJSONArray.put((Object)((Long)scheduleRow.get("REPORT_ID")));
            }
            if (exportIdJSONArray.length() > 0 && reportIdJSONArray.length() > 0) {
                ComplianceScheduleHandler.deleteScheduleAndReportRows(reportIdJSONArray, exportIdJSONArray);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while removing schedule and report rows based on policyID : {0}", e.getMessage());
            e.printStackTrace();
        }
    }

    public static void enableDisableSchedule(JSONArray exportId, boolean isEnabled) throws BaseStatusCode {
        TableScheduleUtil.enableDisableSchedule(exportId, isEnabled);
    }

    public static boolean isActionAllowed(long reportID, long userID, DelegationRoleContainer.UserRole userRole) {
        if (userRole == DelegationRoleContainer.UserRole.ADMIN) {
            return true;
        }
        Criteria crit = new Criteria(Column.getColumn((String)"ReportConfig", (String)"REPORTID"), (Object)reportID, 0);
        return DBUtil.getCountInt("ReportConfig", crit = crit.and(new Criteria(Column.getColumn((String)"ReportConfig", (String)"USERID"), (Object)userID, 0))) > 0;
    }

    public static boolean isActionAllowed(JSONArray exportIDJSONArray, long userID, DelegationRoleContainer.UserRole userRole) {
        if (userRole == DelegationRoleContainer.UserRole.ADMIN) {
            return true;
        }
        try {
            Long[] exportIDLongArray = JSONUtil.toLongArray(exportIDJSONArray);
            Criteria crit = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"), (Object)exportIDLongArray, 8);
            crit = crit.and(new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"AUTHOR"), (Object)userID, 0));
            return DBUtil.getCountInt("ELATableExportSchedules", crit) == exportIDLongArray.length;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while getting isActionAllowed response : {0}", e.getMessage());
            return false;
        }
    }

    private static DataObject updateReportRows(JSONObject reportScheduleJSON, long reportId, JSONObject scheduleJSON) throws BaseStatusCode {
        DataObject resultDO = null;
        try {
            int i;
            resultDO = PersistenceDBUtil.getPersistence().constructDataObject();
            DataObject reportDO = DataAccess.get((String)"ReportConfig", (Criteria)new Criteria(Column.getColumn((String)"ReportConfig", (String)"REPORTID"), (Object)reportId, 0));
            Row reportRow = reportDO.getFirstRow("ReportConfig");
            String reportName = (String)reportRow.get("PROFILENAME");
            String reportContent = reportScheduleJSON.getString("REPORT_CONTENT");
            int reportFormat = scheduleJSON.optInt("FORMAT", 0);
            if (scheduleJSON.has("EMAIL_SUBJECT")) {
                reportRow.set("SUBJECT", (Object)scheduleJSON.getString("EMAIL_SUBJECT"));
            }
            if (scheduleJSON.has("EMAIL_ADDRESS")) {
                reportRow.set("MAILID", (Object)scheduleJSON.getString("EMAIL_ADDRESS"));
            }
            if (reportContent != null && !"".equals(reportContent)) {
                reportRow.set("REPORT_CONTENT", (Object)reportContent);
            }
            if (reportFormat != 0) {
                switch (reportFormat) {
                    case 1: {
                        reportRow.set("REPORTFORMAT", (Object)"csv");
                        break;
                    }
                    case 2: {
                        reportRow.set("REPORTFORMAT", (Object)"pdf");
                        break;
                    }
                }
            }
            reportDO.updateRow(reportRow);
            String policyId = "";
            String compGroups = "";
            String compRbbs = "";
            String compEvents = "";
            String columnName = "";
            boolean convertRBBIDsToNames = true;
            policyId = String.valueOf(reportScheduleJSON.get("SELECTED_POLICY"));
            JSONArray groupJSONArray = reportScheduleJSON.getJSONArray("SELECTED_GROUP");
            JSONArray rbbJSONArray = reportScheduleJSON.getJSONArray("SELECTED_RBB");
            JSONArray categoryJSONArray = reportScheduleJSON.getJSONArray("SELECTED_CATEGORY");
            SelectQueryImpl sql2 = new SelectQueryImpl(Table.getTable((String)"AuditPolicyGroups"));
            sql2.addSelectColumn(Column.getColumn((String)"AuditPolicyGroups", (String)"*"));
            sql2.addSelectColumn(Column.getColumn((String)"AuditPolicyGroupsToRBB", (String)"*"));
            sql2.addSelectColumn(Column.getColumn((String)"AuditPolicyRBBs", (String)"*"));
            sql2.addSelectColumn(Column.getColumn((String)"AuditPolicyRBBsToCategory", (String)"*"));
            sql2.addSelectColumn(Column.getColumn((String)"AuditPolicyCategory", (String)"*"));
            String[] groupid = new String[]{"GROUPID"};
            String[] rbbid = new String[]{"RBBID"};
            Join j1 = new Join("AuditPolicyGroups", "AuditPolicyGroupsToRBB", new String[]{"GROUP_ID"}, groupid, 2);
            Join j2 = new Join("AuditPolicyGroupsToRBB", "AuditPolicyRBBs", rbbid, new String[]{"RBB_ID"}, 2);
            Join j3 = new Join("AuditPolicyGroupsToRBB", "AuditPolicyRBBsToCategory", rbbid, rbbid, 1);
            Join j4 = new Join("AuditPolicyRBBsToCategory", "AuditPolicyCategory", new String[]{"CATEGORYID"}, new String[]{"CATEGORY_ID"}, 1);
            sql2.addJoin(j1);
            sql2.addJoin(j2);
            sql2.addJoin(j3);
            sql2.addJoin(j4);
            Long[] groupIDArray = JSONUtil.toLongArray(groupJSONArray);
            Long[] rbbIDArray = JSONUtil.toLongArray(rbbJSONArray);
            Long[] categoryIDArray = JSONUtil.toLongArray(categoryJSONArray);
            Criteria crit = null;
            if (groupIDArray.length > 0) {
                crit = new Criteria(Column.getColumn((String)"AuditPolicyGroups", (String)"GROUP_ID"), (Object)groupIDArray, 8);
            }
            if (rbbIDArray.length > 0) {
                crit = crit == null ? new Criteria(Column.getColumn((String)"AuditPolicyRBBs", (String)"RBB_ID"), (Object)rbbIDArray, 8) : crit.or(new Criteria(Column.getColumn((String)"AuditPolicyRBBs", (String)"RBB_ID"), (Object)rbbIDArray, 8));
            }
            if (categoryIDArray.length > 0) {
                crit = crit == null ? new Criteria(Column.getColumn((String)"AuditPolicyCategory", (String)"CATEGORY_ID"), (Object)categoryIDArray, 8) : crit.or(new Criteria(Column.getColumn((String)"AuditPolicyCategory", (String)"CATEGORY_ID"), (Object)categoryIDArray, 8));
            }
            if (crit != null) {
                sql2.setCriteria(crit);
            }
            LOGGER.log(Level.FINE, " SelectQuery is : {0}", RelationalAPI.getInstance().getSelectSQL((Query)sql2));
            DataObject policyDO = DataAccess.get((SelectQuery)sql2);
            Iterator groupItr = policyDO.getRows("AuditPolicyGroups");
            while (groupItr.hasNext()) {
                Row groupRow = (Row)groupItr.next();
                if ("".equalsIgnoreCase(compGroups)) {
                    compGroups = String.valueOf(groupRow.get("GROUP_NAME"));
                    continue;
                }
                compGroups = compGroups + "','" + String.valueOf(groupRow.get("GROUP_NAME"));
            }
            Iterator rbbItr = policyDO.getRows("AuditPolicyRBBs");
            while (rbbItr.hasNext()) {
                Row rbbRow = (Row)rbbItr.next();
                if ("".equalsIgnoreCase(compRbbs)) {
                    compRbbs = String.valueOf(rbbRow.get("RBB_ID"));
                    continue;
                }
                compRbbs = compRbbs + "','" + String.valueOf(rbbRow.get("RBB_ID"));
            }
            Iterator categoryItr = policyDO.getRows("AuditPolicyCategory");
            while (categoryItr.hasNext()) {
                Row categoryRow = (Row)categoryItr.next();
                if ("".equalsIgnoreCase(compEvents)) {
                    compEvents = String.valueOf(categoryRow.get("CATEGORY_ID"));
                    continue;
                }
                compEvents = compEvents + "','" + String.valueOf(categoryRow.get("CATEGORY_ID"));
            }
            JSONArray hostsJSONArray = reportScheduleJSON.getJSONArray("SELECTED_HOSTS");
            JSONArray hostGroupsJSONArray = reportScheduleJSON.getJSONArray("SELECTED_HOSTGROUPS");
            LOGGER.log(Level.FINE, "updating groupJSONArray : {0} & rbbJSONArray : {1} & categoryJSONArray : {2} & compGroups : {3} & compRbbs : {4} & compEvents : {5} & hostsJSONArray : {6} & hostGroupsJSONArray : {7} & policyId : {8}", new Object[]{groupJSONArray.toString(), rbbJSONArray.toString(), categoryJSONArray.toString(), compGroups, compRbbs, compEvents, hostsJSONArray.toString(), hostGroupsJSONArray.toString(), policyId});
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"FilterToLAExpression"));
            sql.addSelectColumn(Column.getColumn((String)"FilterToLAExpression", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"LAExpression", (String)"*"));
            sql.addJoin(new Join("FilterToLAExpression", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 1));
            sql.setCriteria(new Criteria(Column.getColumn((String)"FilterToLAExpression", (String)"FILTERNAME"), (Object)(reportName + "_" + "*"), 2));
            DataObject expDO = DataAccess.get((SelectQuery)sql);
            Iterator expItr = expDO.getRows("LAExpression");
            while (expItr.hasNext()) {
                Row expRow = (Row)expItr.next();
                columnName = (String)expRow.get("COLUMN_NAME");
                if ("GraphRBB".equals(columnName)) {
                    if (compGroups.contains(",")) {
                        expRow.set("VALUE", (Object)"ComplianceOverview");
                    } else if (compRbbs.contains(",")) {
                        expRow.set("VALUE", (Object)"ComplianceOverview_Group");
                    } else {
                        expRow.set("VALUE", (Object)"ComplianceOverview_Report");
                    }
                } else if ("GROUP_NAME".equals(columnName)) {
                    expRow.set("VALUE", (Object)compGroups);
                } else if ("RBB_NAME".equals(columnName)) {
                    expRow.set("VALUE", (Object)compRbbs);
                } else if ("CATEGORY_NAME".equals(columnName)) {
                    expRow.set("VALUE", (Object)compEvents);
                } else if ("CompType".equals(columnName)) {
                    expRow.set("VALUE", (Object)policyId);
                }
                expDO.updateRow(expRow);
            }
            DataAccess.delete((String)"Hosts2ReportConfig", (Criteria)new Criteria(Column.getColumn((String)"Hosts2ReportConfig", (String)"REPORTID"), (Object)reportId, 0));
            DataAccess.delete((String)"HostGroups2ReportConfig", (Criteria)new Criteria(Column.getColumn((String)"HostGroups2ReportConfig", (String)"REPORTID"), (Object)reportId, 0));
            LOGGER.log(Level.FINE, "expDO : {0}", expDO);
            resultDO.merge(expDO);
            resultDO.merge(reportDO);
            LOGGER.log(Level.FINE, "resultDO : {0}", resultDO);
            for (i = 0; i < hostsJSONArray.length(); ++i) {
                Row hostRow = new Row("Hosts2ReportConfig");
                hostRow.set("HOST_ID", (Object)Long.valueOf(String.valueOf(hostsJSONArray.get(i))));
                hostRow.set("REPORTID", (Object)reportId);
                hostRow.set("TYPE", (Object)"Group");
                resultDO.addRow(hostRow);
            }
            for (i = 0; i < hostGroupsJSONArray.length(); ++i) {
                Row hostGroupRow = new Row("HostGroups2ReportConfig");
                hostGroupRow.set("GROUP_ID", (Object)Long.valueOf(String.valueOf(hostGroupsJSONArray.get(i))));
                hostGroupRow.set("REPORTID", (Object)reportId);
                resultDO.addRow(hostGroupRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return resultDO;
    }

    public static JSONObject complianceDetails(long reportID, Locale locale) throws BaseStatusCode {
        return ComplianceScheduleHandler.setComplianceReports(reportID, locale);
    }

    private static JSONObject setComplianceReports(Long reportId, Locale locale) throws BaseStatusCode {
        try {
            DataObject reportDO = DataAccess.get((String)"ReportConfig", (Criteria)new Criteria(Column.getColumn((String)"ReportConfig", (String)"REPORTID"), (Object)reportId, 0));
            String reportName = (String)reportDO.getFirstValue("ReportConfig", "PROFILENAME");
            String reportContent = (String)reportDO.getFirstValue("ReportConfig", "REPORT_CONTENT");
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"FilterToLAExpression"));
            sql.addSelectColumn(Column.getColumn((String)"FilterToLAExpression", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"LAExpression", (String)"*"));
            sql.addJoin(new Join("FilterToLAExpression", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 1));
            sql.setCriteria(new Criteria(Column.getColumn((String)"FilterToLAExpression", (String)"FILTERNAME"), (Object)(reportName + "_" + "*"), 2));
            LOGGER.log(Level.FINE, "select query is : {0}", RelationalAPI.getInstance().getSelectSQL((Query)sql));
            DataObject expDO = DataAccess.get((SelectQuery)sql);
            String policyId = "";
            String graphRBB = "";
            String compGroups = "";
            String compRbbs = "";
            String compEvents = null;
            String columnName = "";
            String columnValue = "";
            Row row = expDO.getRow("LAExpression", new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"CompType", 0));
            policyId = String.valueOf(row.get("VALUE"));
            Iterator expItr = expDO.getRows("LAExpression");
            while (expItr.hasNext()) {
                Row expRow = (Row)expItr.next();
                columnName = (String)expRow.get("COLUMN_NAME");
                columnValue = (String)expRow.get("VALUE");
                if ("GraphRBB".equals(columnName)) {
                    graphRBB = columnValue;
                    continue;
                }
                if ("GROUP_NAME".equals(columnName)) {
                    compGroups = columnValue;
                    continue;
                }
                if ("RBB_NAME".equals(columnName)) {
                    compRbbs = columnValue;
                    continue;
                }
                if (!"CATEGORY_NAME".equals(columnName)) continue;
                compEvents = columnValue;
            }
            LOGGER.log(Level.FINE, "policyId from table is : {0}", policyId);
            return ComplianceScheduleHandler.setComplianceReports(policyId, graphRBB, compGroups, compRbbs, compEvents, reportId, reportContent, locale);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    private static JSONObject setComplianceReports(String requestPolicyId, String requestGraphRBB, String requestCompGroups, String requestCompRbbs, String requestCompEvents, Long requestReportId, String reportContent, Locale locale) throws BaseStatusCode {
        JSONObject overallPolicyJSON = new JSONObject();
        ResourceBundle bundle = ProductBundle.getInstance().getBundle(locale);
        try {
            LOGGER.log(Level.FINE, "device type list check : {0}", DeviceOperations.deviceTypeSet.isEmpty());
            DeviceOperations.initDeviceTypeSet();
            LOGGER.log(Level.FINE, "requestPolicyId ::::: {0} requestGraphRBB ::::: {1} requestCompGroups :::: {2} requestCompRbbs :::::: {3} requestCompEvents :::: {4}", new Object[]{requestPolicyId, requestGraphRBB, requestCompGroups, requestCompRbbs, requestCompEvents});
            HashMap showIntegratedProductReportsMap = new HashMap();
            Long policyId = null;
            requestCompGroups = requestCompGroups != null ? "'" + requestCompGroups + "'" : null;
            requestCompRbbs = requestCompRbbs != null ? "'" + requestCompRbbs + "'" : null;
            requestCompEvents = requestCompEvents != null ? "'" + requestCompEvents + "'" : null;
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"AuditPolicyNames"));
            sql.addSelectColumn(Column.getColumn((String)"AuditPolicyNames", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"AuditPolicyNamesToGroup", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"AuditPolicyGroups", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"AuditPolicyGroupsToRBB", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"AuditPolicyRBBs", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"AuditPolicyRBBsToCategory", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"AuditPolicyCategory", (String)"*"));
            sql.addSelectColumn(Column.getColumn((String)"AuditPolicyGroupToDeviceType", (String)"*"));
            sql.addSortColumn(new SortColumn("AuditPolicyRBBs", "RBB_ID", true));
            String[] groupid = new String[]{"GROUPID"};
            String[] rbbid = new String[]{"RBBID"};
            Join j1 = new Join("AuditPolicyNames", "AuditPolicyNamesToGroup", new String[]{"POLICY_ID"}, new String[]{"POLICYID"}, 2);
            Join j2 = new Join("AuditPolicyNamesToGroup", "AuditPolicyGroups", groupid, new String[]{"GROUP_ID"}, 2);
            Join j3 = new Join("AuditPolicyNamesToGroup", "AuditPolicyGroupsToRBB", groupid, groupid, 2);
            Join j4 = new Join("AuditPolicyGroupsToRBB", "AuditPolicyRBBs", rbbid, new String[]{"RBB_ID"}, 2);
            Join j5 = new Join("AuditPolicyGroupsToRBB", "AuditPolicyRBBsToCategory", rbbid, rbbid, 1);
            Join j6 = new Join("AuditPolicyRBBsToCategory", "AuditPolicyCategory", new String[]{"CATEGORYID"}, new String[]{"CATEGORY_ID"}, 1);
            Join j7 = new Join("AuditPolicyGroups", "AuditPolicyGroupToDeviceType", new String[]{"GROUP_ID"}, groupid, 1);
            sql.addJoin(j1);
            sql.addJoin(j2);
            sql.addJoin(j3);
            sql.addJoin(j4);
            sql.addJoin(j5);
            sql.addJoin(j6);
            sql.addJoin(j7);
            DataObject policyDO = DataAccess.get((SelectQuery)sql);
            LOGGER.log(Level.FINE, "query : {0}", RelationalAPI.getInstance().getSelectSQL((Query)sql));
            SelectQueryImpl sql2 = new SelectQueryImpl(Table.getTable((String)"InternalProductReportDetails"));
            sql2.addSelectColumn(Column.getColumn((String)"InternalProductReportDetails", (String)"*"));
            sql2.addSelectColumn(Column.getColumn((String)"ADSProductDetails", (String)"*"));
            sql2.addSelectColumn(Column.getColumn((String)"AuditPolicyCategoryToProduct", (String)"*"));
            String[] productId = new String[]{"PRODUCT_ID"};
            String[] reportId = new String[]{"REPORT_ID"};
            Join join1 = new Join("InternalProductReportDetails", "ADSProductDetails", productId, productId, 1);
            Join join2 = new Join("InternalProductReportDetails", "AuditPolicyCategoryToProduct", reportId, new String[]{"PRODUCT_REPORT_ID"}, 2);
            sql2.addJoin(join1);
            sql2.addJoin(join2);
            LOGGER.log(Level.FINE, "select query created for internalProductReportsDO is : {0}", RelationalAPI.getInstance().getSelectSQL((Query)sql2));
            DataObject internalProductReportsDO = DataAccess.get((SelectQuery)sql2);
            Iterator policyItr = policyDO.getRows("AuditPolicyNames");
            JSONArray policyJSONArray = new JSONArray();
            JSONArray policySelectedJSONArray = new JSONArray();
            ArrayList overallGroupSelectedList = new ArrayList();
            ArrayList overallRbbSelectedList = new ArrayList();
            ArrayList overallCategorySelectedList = new ArrayList();
            while (policyItr.hasNext()) {
                Row policyRow = (Row)policyItr.next();
                String policyName = (String)policyRow.get("POLICY_NAME");
                if ("GPG".equals(policyName) || "SecurityEvents".equals(policyName)) continue;
                policyId = (Long)policyRow.get("POLICY_ID");
                JSONObject individualPolicyJSON = new JSONObject();
                individualPolicyJSON.put("POLICY_ID", (Object)policyId);
                individualPolicyJSON.put("POLICY_DISPLAY_NAME", (Object)(bundle.containsKey(policyName + ".Title") ? bundle.getString(policyName + ".Title") : policyName));
                String policyStatus = (Long)policyRow.get("POLICY_STATUS") == 1L ? "checked" : "";
                boolean isEnabled = "checked".equals(policyStatus);
                boolean policySelected = false;
                if (requestPolicyId != null && !"".equals(requestPolicyId) && policyId.equals(Long.valueOf(requestPolicyId))) {
                    policySelected = true;
                    policySelectedJSONArray.put((Object)policyId);
                }
                Iterator groupItr = policyDO.getRows("AuditPolicyGroups", new Criteria(Column.getColumn((String)"AuditPolicyNamesToGroup", (String)"POLICYID"), (Object)((Long)policyRow.get("POLICY_ID")), 0), j2);
                JSONArray groupDetailsJSONArray = new JSONArray();
                ArrayList<Long> groupSelectedArrayList = new ArrayList<Long>();
                while (groupItr.hasNext()) {
                    JSONObject groupDetailsJSON = null;
                    Row groupRow = (Row)groupItr.next();
                    Long groupId = (Long)groupRow.get("GROUP_ID");
                    LOGGER.log(Level.FINE, "groupId is : {0}", groupId);
                    Row auditPolicyGroupToDeviceTypeRow = policyDO.getRow("AuditPolicyGroupToDeviceType", new Criteria(Column.getColumn((String)"AuditPolicyGroupToDeviceType", (String)"GROUPID"), (Object)groupId, 0));
                    LOGGER.log(Level.FINE, "auditPolicyGroupToDeviceTypeRow : {0} && deviceType : {1}", new Object[]{auditPolicyGroupToDeviceTypeRow, auditPolicyGroupToDeviceTypeRow != null ? (String)auditPolicyGroupToDeviceTypeRow.get("DEVICETYPE") : "null"});
                    if (auditPolicyGroupToDeviceTypeRow != null && (auditPolicyGroupToDeviceTypeRow == null || !DeviceOperations.deviceTypeSet.contains(((String)auditPolicyGroupToDeviceTypeRow.get("DEVICETYPE")).toLowerCase())) && predefinedComplianceList.contains(policyName)) continue;
                    groupDetailsJSON = new JSONObject();
                    LOGGER.log(Level.FINE, "deviceTypeSet contains devicetype so adding group : {0}", DeviceOperations.deviceTypeSet);
                    String groupName = (String)groupRow.get("GROUP_NAME");
                    groupDetailsJSON.put("GROUP_NAME", (Object)groupName);
                    groupDetailsJSON.put("GROUP_ID", (Object)groupId);
                    boolean bl = false;
                    if (requestCompGroups != null && policySelected && requestCompGroups.contains("'" + groupName + "'")) {
                        bl = true;
                        groupSelectedArrayList.add(groupId);
                    }
                    groupDetailsJSON.put("GROUP_DISPLAY_NAME", (Object)(bundle.containsKey(groupName) ? bundle.getString(groupName) : groupName));
                    Iterator rbbItr = policyDO.getRows("AuditPolicyRBBs", new Criteria(Column.getColumn((String)"AuditPolicyGroupsToRBB", (String)"GROUPID"), (Object)((Long)groupRow.get("GROUP_ID")), 0), j4);
                    JSONArray rbbJSONArray = new JSONArray();
                    ArrayList<Long> rbbSelectedList = new ArrayList<Long>();
                    int selectedRbbCount = 0;
                    while (rbbItr.hasNext()) {
                        JSONObject rbbJSONObject = new JSONObject();
                        Row rbbRow = (Row)rbbItr.next();
                        String rbbName = (String)rbbRow.get("RBB_NAME");
                        Long rbbId = (Long)rbbRow.get("RBB_ID");
                        rbbJSONObject.put("RBB_NAME", (Object)rbbName);
                        rbbJSONObject.put("RBB_DISPLAY_NAME", (Object)(bundle.containsKey(rbbName) ? bundle.getString(rbbName) : rbbName));
                        rbbJSONObject.put("RBB_ID", (Object)rbbId);
                        rbbJSONObject.put("GROUP_ID", (Object)groupId);
                        boolean rbbSelected = false;
                        JSONArray categoryJSONArray = new JSONArray();
                        ArrayList<Long> categorySelectedList = new ArrayList<Long>();
                        int selectedCategoryCount = 0;
                        Iterator categoryItr = policyDO.getRows("AuditPolicyCategory", new Criteria(Column.getColumn((String)"AuditPolicyRBBsToCategory", (String)"RBBID"), (Object)((Long)rbbRow.get("RBB_ID")), 0), j6);
                        while (categoryItr.hasNext()) {
                            JSONObject categoryJSONObject = null;
                            Row categoryRow = (Row)categoryItr.next();
                            Long categoryId = (Long)categoryRow.get("CATEGORY_ID");
                            String categoryName = (String)categoryRow.get("CATEGORY_NAME");
                            String categoryDisplayName = bundle.containsKey(categoryName) ? bundle.getString(categoryName) : categoryName;
                            Iterator test1 = internalProductReportsDO.getRows("AuditPolicyCategoryToProduct", new Criteria(Column.getColumn((String)"AuditPolicyCategoryToProduct", (String)"CATEGORY_ID"), (Object)((Long)categoryRow.get("CATEGORY_ID")), 0));
                            if (test1.hasNext()) {
                                Row row1 = (Row)test1.next();
                                Iterator test2 = internalProductReportsDO.getRows("InternalProductReportDetails", new Criteria(Column.getColumn((String)"InternalProductReportDetails", (String)"REPORT_ID"), (Object)((Long)row1.get("PRODUCT_REPORT_ID")), 0));
                                if (test2.hasNext()) {
                                    Iterator test3;
                                    boolean showIntegratedReportCheck;
                                    Row row2 = (Row)test2.next();
                                    boolean bl2 = showIntegratedReportCheck = showIntegratedProductReportsMap.get((Long)row2.get("PRODUCT_ID")) == null ? PreReportModel.showIntegratedProductReports((Long)((Long)row2.get("PRODUCT_ID")), showIntegratedProductReportsMap) : (Boolean)showIntegratedProductReportsMap.get((Long)row2.get("PRODUCT_ID"));
                                    if (((Boolean)row2.get("ISENABLED")).booleanValue() && showIntegratedReportCheck && (test3 = internalProductReportsDO.getRows("ADSProductDetails", new Criteria(Column.getColumn((String)"ADSProductDetails", (String)"PRODUCT_ID"), (Object)((Long)row2.get("PRODUCT_ID")), 0))).hasNext()) {
                                        categoryJSONObject = new JSONObject();
                                        categoryJSONObject.put("CATEGORY_NAME", (Object)categoryName);
                                        categoryJSONObject.put("CATEGORY_ID", (Object)categoryId);
                                        categoryJSONObject.put("CATEGORY_DISPLAY_NAME", (Object)categoryDisplayName);
                                        if (requestCompRbbs != null && bl && !rbbSelected && requestCompRbbs.contains("'" + rbbId + "'")) {
                                            ++selectedRbbCount;
                                            rbbSelected = true;
                                            rbbSelectedList.add(rbbId);
                                        }
                                        if (requestCompEvents != null && rbbSelected && requestCompEvents.contains("'" + categoryId + "'")) {
                                            ++selectedCategoryCount;
                                            categorySelectedList.add(categoryId);
                                        }
                                    }
                                }
                            } else {
                                categoryJSONObject = new JSONObject();
                                categoryJSONObject.put("CATEGORY_NAME", (Object)categoryName);
                                categoryJSONObject.put("CATEGORY_ID", (Object)categoryId);
                                categoryJSONObject.put("CATEGORY_DISPLAY_NAME", (Object)categoryDisplayName);
                                if (requestCompRbbs != null && bl && !rbbSelected && requestCompRbbs.contains("'" + rbbId + "'")) {
                                    ++selectedRbbCount;
                                    rbbSelected = true;
                                    rbbSelectedList.add(rbbId);
                                }
                                if (requestCompEvents != null && rbbSelected && requestCompEvents.contains("'" + categoryId + "'")) {
                                    ++selectedCategoryCount;
                                    categorySelectedList.add(categoryId);
                                }
                            }
                            if (categoryJSONObject == null) continue;
                            categoryJSONArray.put((Object)categoryJSONObject);
                        }
                        if (categoryJSONArray.length() <= 0) continue;
                        rbbJSONObject.put("CATEGORY_DETAILS", (Object)categoryJSONArray);
                        rbbJSONObject.put("CATEGORY_TOTAL_COUNT", categoryJSONArray.length());
                        rbbJSONObject.put("CATEGORY_SELECTED_COUNT", selectedCategoryCount);
                        if (selectedCategoryCount < categoryJSONArray.length()) {
                            rbbSelectedList.remove(rbbId);
                            if (categorySelectedList.size() > 0) {
                                overallCategorySelectedList.addAll(categorySelectedList);
                            }
                        }
                        rbbJSONArray.put((Object)rbbJSONObject);
                    }
                    if (rbbJSONArray.length() <= 0) continue;
                    groupDetailsJSON.put("RBB_DETAILS", (Object)rbbJSONArray);
                    groupDetailsJSON.put("RBB_TOTAL_COUNT", rbbJSONArray.length());
                    groupDetailsJSON.put("RBB_SELECTED_COUNT", selectedRbbCount);
                    if (selectedRbbCount < rbbJSONArray.length()) {
                        groupSelectedArrayList.remove(groupId);
                        if (rbbSelectedList.size() > 0) {
                            overallRbbSelectedList.addAll(rbbSelectedList);
                        }
                    }
                    groupDetailsJSONArray.put((Object)groupDetailsJSON);
                }
                if (groupDetailsJSONArray.length() <= 0) continue;
                individualPolicyJSON.put("GROUP_DETAILS", (Object)groupDetailsJSONArray);
                if (groupSelectedArrayList.size() > 0) {
                    overallGroupSelectedList.addAll(groupSelectedArrayList);
                }
                policyJSONArray.put((Object)individualPolicyJSON);
            }
            if (policyJSONArray.length() > 0) {
                overallPolicyJSON.put("POLICY_DETAILS", (Object)policyJSONArray);
                overallPolicyJSON.put("POLICY_SELECTED", (Object)policySelectedJSONArray);
                if (overallGroupSelectedList.size() > 0) {
                    overallPolicyJSON.put("GROUP_SELECTED", overallGroupSelectedList);
                }
                if (overallRbbSelectedList.size() > 0) {
                    overallPolicyJSON.put("RBB_SELECTED", overallRbbSelectedList);
                }
                if (overallCategorySelectedList.size() > 0) {
                    overallPolicyJSON.put("CATEGORY_SELECTED", overallCategorySelectedList);
                }
            }
            SelectQueryImpl hostsSQL = new SelectQueryImpl(Table.getTable((String)"Hosts2ReportConfig"));
            hostsSQL.addSelectColumn(Column.getColumn((String)"Hosts2ReportConfig", (String)"HOST_ID"));
            hostsSQL.addSelectColumn(Column.getColumn((String)"Hosts", (String)"HOST_ID"));
            hostsSQL.addSelectColumn(Column.getColumn((String)"Hosts", (String)"DISPLAY_NAME"));
            hostsSQL.addSelectColumn(Column.getColumn((String)"HostGroupMapping", (String)"GROUPID"));
            hostsSQL.addSelectColumn(Column.getColumn((String)"HostGroupMapping", (String)"HOSTID"));
            hostsSQL.addJoin(new Join("Hosts2ReportConfig", "Hosts", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 1));
            hostsSQL.addJoin(new Join("Hosts", "HostGroupMapping", new String[]{"HOST_ID"}, new String[]{"HOSTID"}, 1));
            hostsSQL.setCriteria(new Criteria(Column.getColumn((String)"Hosts2ReportConfig", (String)"REPORTID"), (Object)requestReportId, 0));
            DataObject hostDO = DataAccess.get((SelectQuery)hostsSQL);
            LOGGER.log(Level.FINE, "hostDO : {0}", hostDO);
            JSONArray hostJSONArray = new JSONArray();
            JSONObject groupBasedHostJSONObject = new JSONObject();
            JSONArray hostDisplayTextArray = new JSONArray();
            if (hostDO != null && hostDO.containsTable("Hosts")) {
                Iterator hostItr = hostDO.getRows("Hosts");
                while (hostItr.hasNext()) {
                    Row hostRow = (Row)hostItr.next();
                    Long hostID = (Long)hostRow.get("HOST_ID");
                    hostJSONArray.put((Object)hostID);
                    Row hostGroupRow = hostDO.getRow("HostGroupMapping", new Criteria(Column.getColumn((String)"HostGroupMapping", (String)"HOSTID"), (Object)hostID, 0));
                    String groupID = String.valueOf(hostGroupRow.get("GROUPID"));
                    int hostCount = groupBasedHostJSONObject.optInt(groupID);
                    groupBasedHostJSONObject.put(groupID, ++hostCount);
                    hostDisplayTextArray.put((Object)((String)hostRow.get("DISPLAY_NAME")));
                }
            }
            LOGGER.log(Level.FINE, "requestReportId : {0}", requestReportId);
            SelectQueryImpl hostGroupSQL = new SelectQueryImpl(Table.getTable((String)"HostGroups2ReportConfig"));
            hostGroupSQL.addSelectColumn(Column.getColumn((String)"HostGroups2ReportConfig", (String)"GROUP_ID"));
            hostGroupSQL.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"ID"));
            hostGroupSQL.addSelectColumn(Column.getColumn((String)"HostGroup", (String)"NAME"));
            hostGroupSQL.addJoin(new Join("HostGroups2ReportConfig", "HostGroup", new String[]{"GROUP_ID"}, new String[]{"ID"}, 1));
            hostGroupSQL.setCriteria(new Criteria(Column.getColumn((String)"HostGroups2ReportConfig", (String)"REPORTID"), (Object)requestReportId, 0));
            DataObject hostGroupDO = DataAccess.get((SelectQuery)hostGroupSQL);
            JSONArray hostGroupJSONArray = new JSONArray();
            LOGGER.log(Level.FINE, "hostGroupDO : {0}", hostGroupDO);
            if (hostGroupDO != null && hostGroupDO.containsTable("HostGroup")) {
                Iterator hostGroupItr = hostGroupDO.getRows("HostGroup");
                while (hostGroupItr.hasNext()) {
                    Row hostGroupRow = (Row)hostGroupItr.next();
                    hostGroupJSONArray.put((Object)((Long)hostGroupRow.get("ID")));
                    hostDisplayTextArray.put((Object)((String)hostGroupRow.get("NAME")));
                }
            }
            overallPolicyJSON.put("SELECTED_HOSTS", (Object)hostJSONArray);
            overallPolicyJSON.put("SELECTED_HOSTS_GROUPS_DISPLAYTEXT", (Object)hostDisplayTextArray);
            overallPolicyJSON.put("SELECTED_HOSTGROUPS", (Object)hostGroupJSONArray);
            overallPolicyJSON.put("SELECTED_GROUPBASEDHOST_COUNT", (Object)groupBasedHostJSONObject);
            overallPolicyJSON.put("REPORT_CONTENT", (Object)reportContent);
            if ("false".equalsIgnoreCase(String.valueOf(LaUtil.getSysConfiguration((String)"workHourAdvCheck")))) {
                int startHour = 10;
                int endHour = 20;
                try {
                    startHour = Integer.parseInt(String.valueOf(LaUtil.getSysConfiguration((String)"workingHourStartTime")));
                    endHour = Integer.parseInt(String.valueOf(LaUtil.getSysConfiguration((String)"workingHourEndTime")));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Exception while getting workingHour  : {0}", ex.getMessage());
                }
                overallPolicyJSON.put("WORKING_HOUR_RANGE", (Object)("( " + bundle.getString("AddSchedule.FromTime") + " " + startHour + " " + bundle.getString("AddSchedule.ToTime") + " " + endHour + " " + bundle.getString("AddSchedule.Hour") + " )"));
                int nonWorkStartHour = endHour + 1;
                int nonWorkEndHour = startHour - 1;
                if (nonWorkStartHour == 24) {
                    nonWorkStartHour = 0;
                }
                if (nonWorkEndHour == -1) {
                    nonWorkEndHour = 23;
                }
                overallPolicyJSON.put("NON_WORKING_HOUR_RANGE", (Object)("( " + bundle.getString("AddSchedule.FromTime") + " " + nonWorkStartHour + " " + bundle.getString("AddSchedule.ToTime") + " " + nonWorkEndHour + " " + bundle.getString("AddSchedule.Hour") + " )"));
            } else {
                String workingAdv = String.valueOf(LaUtil.getSysConfiguration((String)"workingHours"));
                Object[] workingHourArray = workingAdv.split(",");
                ArrayList<String> hoursList = new ArrayList<String>();
                for (int i = 0; i <= 23; ++i) {
                    hoursList.add(String.valueOf(i));
                }
                for (String string : workingHourArray) {
                    hoursList.remove(string);
                }
                overallPolicyJSON.put("WORKING_HOUR_RANGE", (Object)Arrays.toString(workingHourArray));
                overallPolicyJSON.put("NON_WORKING_HOUR_RANGE", hoursList);
            }
            JSONObject serverSettings = NotificationSettingsUtil.getServerConfigurationSettings();
            overallPolicyJSON.put("MAIL", serverSettings.get("mail"));
            overallPolicyJSON.put("SMS", serverSettings.get("sms"));
            LOGGER.log(Level.FINE, "result JSON : {0}", overallPolicyJSON.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, " Exception while getting Compliance Report Details : {0}", e);
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return overallPolicyJSON;
    }
}

