/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.compliance.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.PreReportModel;
import com.adventnet.la.ReportUtil;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.taskengine.util.CalendarRowConfig;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.export.utils.TableScheduleUtil;
import java.io.File;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ScheduleMigrationUtil {
    private static final Logger LOGGER = Logger.getLogger(ScheduleMigrationUtil.class.getName());

    public static void startComplianceScheduleMigration() throws Exception {
        String REPORT_CONFIG_TABLE = "ReportConfig";
        String TASK_DETAILS_TABLE = "TaskDetails";
        String TASK_TO_SCHEDULE_MAP = "TaskToScheduleMap";
        String SCHEDULE = "Schedule";
        String CALENDAR = "Calendar";
        String TASK_INPUT = "Task_Input";
        String TASK_ENGINE_TASK = "TaskEngine_Task";
        SelectQueryImpl selectQuery = new SelectQueryImpl(new Table("ReportConfig"));
        selectQuery.addJoin(new Join("ReportConfig", "TaskDetails", new String[]{"REPORTID"}, new String[]{"REPORTID"}, 1));
        selectQuery.addJoin(new Join("ReportConfig", "ReportTaskInput", new String[]{"REPORTID"}, new String[]{"REPORTID"}, 1));
        selectQuery.addJoin(new Join("TaskDetails", "TaskToScheduleMap", new String[]{"TASKNAME"}, new String[]{"TASKNAME"}, 1));
        selectQuery.addJoin(new Join("TaskToScheduleMap", "Schedule", new String[]{"SCHEDULENAME"}, new String[]{"SCHEDULE_NAME"}, 1));
        selectQuery.addJoin(new Join("Schedule", "Calendar", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        selectQuery.addJoin(new Join("Schedule", "Task_Input", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        selectQuery.addJoin(new Join("Schedule", "TaskEngine_Task", new String[]{"SCHEDULE_NAME"}, new String[]{"TASK_NAME"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"REPORTID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"PROFILENAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"REPORTTYPE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"REPORTFORMAT"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"MAILID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ReportConfig", (String)"LAST_GENERATED_REPORT"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskDetails", (String)"TASKNAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskDetails", (String)"REPORT_CRITERIA"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskDetails", (String)"TYPE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskDetails", (String)"DETAILS"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskDetails", (String)"REPORT_START_TIME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskDetails", (String)"REPORT_END_TIME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskDetails", (String)"NON_WORK_HOUR"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskDetails", (String)"REPORTID", (String)"TREPORT_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ReportTaskInput", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskToScheduleMap", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"TaskEngine_Task", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"INSTANCE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_TIME"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ReportConfig", (String)"REPORTTYPE"), (Object)"SYSLOG-CN", 0);
        DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        Iterator iterator = dataObject.getRows("ReportConfig", criteria);
        while (iterator.hasNext()) {
            try {
                Row scheduleRow;
                Row calendar;
                Calendar calendar2;
                Timestamp timestamp;
                Row reportConfig = (Row)iterator.next();
                String reportName = (String)reportConfig.get("PROFILENAME");
                Long reportID = (Long)reportConfig.get("REPORTID");
                String reportFormat = (String)reportConfig.get("REPORTFORMAT");
                Row taskDetails = dataObject.getRow("TaskDetails", new Criteria(Column.getColumn((String)"TaskDetails", (String)"REPORTID"), (Object)reportID, 0));
                if (taskDetails == null) continue;
                String frequencyType = (String)taskDetails.get("TYPE");
                String taskName = (String)taskDetails.get("TASKNAME");
                Integer criteriaField = Integer.parseInt(taskDetails.get("REPORT_CRITERIA").toString());
                Row taskToSchedule = dataObject.getRow("TaskToScheduleMap", new Criteria(Column.getColumn((String)"TaskToScheduleMap", (String)"TASKNAME"), (Object)taskName, 0));
                String scheduleName = (String)taskToSchedule.get("SCHEDULENAME");
                Row schedule = dataObject.getRow("Schedule", new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)scheduleName, 0));
                Long scheduleID = (Long)schedule.get("SCHEDULE_ID");
                Row taskInput = dataObject.getRow("Task_Input", new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleID, 0));
                JSONObject request = new JSONObject();
                JSONObject time = new JSONObject();
                time.put("TYPE", (Object)criteriaField);
                if (frequencyType.equalsIgnoreCase("Once")) {
                    request.put("FREQUENCY", TableScheduleUtil.Frequency.ONCE.ordinal());
                    String details = (String)taskDetails.get("DETAILS");
                    String timeString = details.substring(details.length() - 16);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                    Date dt = dateFormat.parse(timeString);
                    time.put("SCHEDULE_AT", dt.getTime());
                    time.put("TYPE", Integer.parseInt(taskDetails.get("REPORT_CRITERIA").toString()));
                } else if (frequencyType.equalsIgnoreCase("Hourly")) {
                    request.put("FREQUENCY", TableScheduleUtil.Frequency.HOURLY.ordinal());
                    timestamp = (Timestamp)taskInput.get("SCHEDULE_TIME");
                    calendar2 = Calendar.getInstance();
                    calendar2.setTimeInMillis(timestamp.getTime());
                    int minutes = calendar2.get(12);
                    Double rounded = 5.0 * Math.ceil(Math.abs(minutes / 5));
                    time.put("MINUTES", rounded.intValue());
                } else if (frequencyType.equalsIgnoreCase("Daily")) {
                    request.put("FREQUENCY", TableScheduleUtil.Frequency.DAILY.ordinal());
                    timestamp = (Timestamp)taskInput.get("SCHEDULE_TIME");
                    calendar2 = Calendar.getInstance();
                    calendar2.setTimeInMillis(timestamp.getTime());
                    int minutes = calendar2.get(12);
                    Double rounded = 5.0 * Math.ceil(Math.abs(minutes / 5));
                    time.put("MINUTES", rounded.intValue());
                    time.put("HOURS", calendar2.get(11));
                } else if (frequencyType.equalsIgnoreCase("Weekly")) {
                    request.put("FREQUENCY", TableScheduleUtil.Frequency.WEEKLY.ordinal());
                    calendar = dataObject.getRow("Calendar", new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleID, 0));
                    Object dayOfWeek = calendar.get("DAY_OF_WEEK");
                    time.put("DAY_OF_WEEK", dayOfWeek);
                    String unitOfTime = (String)calendar.get("UNIT_OF_TIME");
                    if (unitOfTime.equalsIgnoreCase("seconds")) {
                        Long timeOfDay = (Long)calendar.get("TIME_OF_DAY");
                        Double minutes = Math.floor(timeOfDay / 60L);
                        Double hours = Math.floor(minutes / 60.0);
                        Double effectMinutes = minutes - hours * 60.0;
                        effectMinutes = 5.0 * Math.ceil(Math.abs(effectMinutes / 5.0));
                        time.put("MINUTES", effectMinutes.intValue());
                        time.put("HOURS", hours.intValue());
                    } else {
                        time.put("MINUTES", 0);
                        time.put("HOURS", calendar.get("TIME_OF_DAY"));
                    }
                } else {
                    if (!frequencyType.equalsIgnoreCase("Monthly")) continue;
                    request.put("FREQUENCY", TableScheduleUtil.Frequency.MONTHLY.ordinal());
                    calendar = dataObject.getRow("Calendar", new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleID, 0));
                    time.put("DATE_OF_MONTH", calendar.get("DATE_OF_MONTH"));
                    String unitOfTime = (String)calendar.get("UNIT_OF_TIME");
                    if (unitOfTime.equalsIgnoreCase("seconds")) {
                        Long timeOfDay = (Long)calendar.get("TIME_OF_DAY");
                        Double minutes = Math.floor(timeOfDay / 60L);
                        Double hours = Math.floor(minutes / 60.0);
                        Double effectMinutes = minutes - hours * 60.0;
                        effectMinutes = 5.0 * Math.ceil(Math.abs(effectMinutes / 5.0));
                        time.put("MINUTES", effectMinutes.intValue());
                        time.put("HOURS", hours.intValue());
                    } else {
                        time.put("MINUTES", 0);
                        time.put("HOURS", calendar.get("TIME_OF_DAY"));
                    }
                }
                request.put("REPORT_ID", (Object)reportID);
                request.put("REQ_UNIQUE_ID", (Object)reportID);
                request.put("EMAIL_ADDRESS", reportConfig.get("MAILID"));
                request.put("EMAIL_SUBJECT", (Object)"EventLog Compliance Report");
                request.put("OPERATION", (Object)"CREATE");
                request.put("SCID", (Object)scheduleID);
                if (reportFormat.equalsIgnoreCase("PDF")) {
                    request.put("FORMAT", 2);
                } else {
                    request.put("FORMAT", 1);
                }
                JSONObject additionalParam = new JSONObject();
                if (DBUtil.getCountInt("TaskToScheduleMap", new Criteria(Column.getColumn((String)"TaskToScheduleMap", (String)"TASKNAME"), (Object)taskName, 0)) == 5) {
                    request.put("FREQUENCY", TableScheduleUtil.Frequency.WEEKLY.ordinal());
                    JSONArray daysOfWeekArray = new JSONArray();
                    daysOfWeekArray.put(2);
                    daysOfWeekArray.put(3);
                    daysOfWeekArray.put(4);
                    daysOfWeekArray.put(5);
                    daysOfWeekArray.put(6);
                    int[] array = new int[daysOfWeekArray.length()];
                    for (int index = 0; index < daysOfWeekArray.length(); ++index) {
                        array[index] = daysOfWeekArray.getInt(index);
                    }
                    Arrays.sort(array);
                    time.put("DAY_OF_WEEK", CalendarRowConfig.encodeDaysOfWeek((int[])array));
                    additionalParam.put("RUN_ON_WEEKDAYS", (Object)daysOfWeekArray);
                }
                request.put("TIME", (Object)time);
                request.put("SCHEDULE_DISPLAY_NAME", (Object)reportName);
                String startTime = String.valueOf(taskDetails.get("REPORT_START_TIME")).split(":")[0];
                String endTime = String.valueOf(taskDetails.get("REPORT_END_TIME")).split(":")[0];
                long reportStartTime = Long.valueOf(startTime != null && !"null".equals(startTime) ? startTime : "0");
                long reportEndTime = Long.valueOf(endTime != null && !"null".equals(endTime) ? endTime : "0");
                additionalParam.put("START_TIME", reportStartTime);
                additionalParam.put("END_TIME", reportEndTime);
                String nonWorkHour = (String)taskDetails.get("NON_WORK_HOUR");
                if ("true".equalsIgnoreCase(nonWorkHour)) {
                    additionalParam.put("HOUR_RANGE_TYPE", 2);
                }
                if (reportStartTime != 0L || reportEndTime != 0L) {
                    additionalParam.put("HOUR_RANGE_TYPE", 3);
                }
                if (criteriaField == 3 || criteriaField == 4 || criteriaField == 7 || criteriaField == 8) {
                    JSONArray daysOfWeekArray = new JSONArray();
                    daysOfWeekArray.put(2);
                    daysOfWeekArray.put(3);
                    daysOfWeekArray.put(4);
                    daysOfWeekArray.put(5);
                    daysOfWeekArray.put(6);
                    additionalParam.put("DAYS_OF_WEEK", (Object)daysOfWeekArray);
                }
                request.put("ADDITIONAL_PARAMS_STR", (Object)additionalParam);
                request.put("ADDITIONAL_PARAMS_ROW", (Object)additionalParam);
                request.put("TABLE_ID", 802);
                Row taskEngineTask = dataObject.getRow("TaskEngine_Task", new Criteria(Column.getColumn((String)"TaskEngine_Task", (String)"TASK_NAME"), (Object)scheduleName, 0));
                dataObject.deleteRow(schedule);
                dataObject.deleteRow(taskDetails);
                if (taskEngineTask != null) {
                    dataObject.deleteRow(taskEngineTask);
                }
                request.put("SCHEDULE_CLASS", (Object)"com.adventnet.sa.SyslogReportTask");
                DataObject dobj = TableScheduleUtil.getNewScheduleDO(request, TechnicianUtil.getDefaultAdminUserID(), ResourceBundleMgr.getInstance().getServerLocale());
                Row taskInputRow = dobj.getRow("Task_Input");
                if (taskInputRow != null) {
                    Row reportTaskInputRow = dataObject.getRow("ReportTaskInput", new Criteria(Column.getColumn((String)"ReportTaskInput", (String)"REPORTID"), (Object)reportID, 0));
                    String schedulerType = String.valueOf(reportTaskInputRow.get("SCHEDULETYPE"));
                    dataObject.deleteRow(reportTaskInputRow);
                    reportTaskInputRow = new Row("ReportTaskInput");
                    reportTaskInputRow.set("INSTANCE_ID", taskInputRow.get("INSTANCE_ID"));
                    reportTaskInputRow.set("REPORTID", (Object)reportID);
                    if (schedulerType != null && !"null".equals(schedulerType) && !"".equals(schedulerType)) {
                        reportTaskInputRow.set("SCHEDULETYPE", (Object)schedulerType);
                    }
                    dobj.addRow(reportTaskInputRow);
                }
                if ((scheduleRow = dobj.getRow("ELATableExportSchedules")) != null) {
                    Row row = new Row("ScheduledReports");
                    row.set("EXPORT_ID", scheduleRow.get("EXPORT_ID"));
                    row.set("REPORT_ID", (Object)request.getLong("REPORT_ID"));
                    row.set("TYPE", (Object)ReportUtil.scheduleType.COMPLIANCE.ordinal());
                    dobj.addRow(row);
                }
                PersistenceDBUtil.getPersistence().update(dobj);
                String lastGeneratedReport = (String)reportConfig.get("LAST_GENERATED_REPORT");
                if (lastGeneratedReport != null && !lastGeneratedReport.trim().isEmpty()) {
                    String generatedFile = lastGeneratedReport + "." + reportFormat;
                    String filenameWithoutUnsupportedCharacters = generatedFile.replaceAll("[\\[\\]\\\\~#%&*{}/:<>?|\"-]", "_");
                    generatedFile = System.getProperty("server.home") + File.separator + "ReportHistory" + File.separator + "schedule_" + reportID + File.separator + filenameWithoutUnsupportedCharacters;
                    LOGGER.log(Level.INFO, "Old generated file name is : {0}", generatedFile);
                    File oldFile = new File(generatedFile);
                    if (oldFile.exists()) {
                        SimpleDateFormat oldFileFormat = new SimpleDateFormat("MMM_dd_yyyy_HH_mm_ss");
                        Date dt = oldFileFormat.parse(lastGeneratedReport.substring(lastGeneratedReport.length() - 20));
                        if (dt == null) {
                            LOGGER.log(Level.WARNING, "Cant parse date for scheduled report {0}", new Object[]{lastGeneratedReport});
                            continue;
                        }
                        Row row = new Row("ELATableExportScheduleHistory");
                        row.set("EXPORT_ID", scheduleRow.get("EXPORT_ID"));
                        row.set("EXPORT_START_TIME", (Object)dt.getTime());
                        row.set("EXPORT_END_TIME", (Object)dt.getTime());
                        row.set("DOWNLOAD_PATH", (Object)oldFile.getAbsolutePath());
                        dataObject.addRow(row);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            PersistenceDBUtil.getPersistence().update(dataObject);
        }
        try {
            ScheduleMigrationUtil.nameToIDMigration();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private static void nameToIDMigration() {
        try {
            SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"LAExpression"));
            sql.addSelectColumn(Column.getColumn((String)"LAExpression", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"RBB_NAME", 0);
            crit = crit.or(new Criteria(Column.getColumn((String)"LAExpression", (String)"COLUMN_NAME"), (Object)"CATEGORY_NAME", 0));
            sql.setCriteria(crit);
            DataObject dataObject = DataAccess.get((SelectQuery)sql);
            if (dataObject != null) {
                Iterator rbbItr = dataObject.getRows("LAExpression");
                while (rbbItr.hasNext()) {
                    Row laexpressionRow = (Row)rbbItr.next();
                    String columnName = String.valueOf(laexpressionRow.get("COLUMN_NAME"));
                    String columnValue = String.valueOf(laexpressionRow.get("VALUE"));
                    String valueChangedToId = null;
                    if ("RBB_NAME".equalsIgnoreCase(columnName)) {
                        valueChangedToId = PreReportModel.convertBetweenComplianceIDAndNames((String)"AuditPolicyRBBs", (String)"RBB_NAME", (String)"RBB_ID", (String)columnValue);
                    } else if ("CATEGORY_NAME".equalsIgnoreCase(columnName)) {
                        valueChangedToId = PreReportModel.convertBetweenComplianceIDAndNames((String)"AuditPolicyCategory", (String)"CATEGORY_NAME", (String)"CATEGORY_ID", (String)columnValue);
                    }
                    if ("".equals(valueChangedToId) || valueChangedToId == null) continue;
                    laexpressionRow.set("VALUE", (Object)valueChangedToId);
                    dataObject.updateRow(laexpressionRow);
                }
                PersistenceDBUtil.getPersistence().update(dataObject);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception while converting rbbnames to ids : {0}", e.toString());
            e.printStackTrace();
        }
    }
}

