/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.adapter;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.manageengine.ela.server.common.client.adapters.ClientDBArchiveAdapter;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.correlation.auditdata.CorrelationArchivedData;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CorrelationArchiveAdapter
implements ClientDBArchiveAdapter {
    private final TimePack timePack;
    private final List<Map<String, Object>> archivetableInfo;

    public CorrelationArchiveAdapter(TimePack pack) {
        this.timePack = pack;
        this.archivetableInfo = CorrelationArchivedData.get().getArchivedTablesInfo(pack);
    }

    @Override
    public long getTotalCount(SelectQuery query) {
        if (this.archivetableInfo != null && !this.archivetableInfo.isEmpty()) {
            Object ruleID = this.findRuleID(query.getCriteria());
            return CorrelationArchivedData.get().getHistoryCount(this.archivetableInfo, ruleID, this.timePack);
        }
        return 0L;
    }

    @Override
    public LinkedList<HashMap<Column, Object>> page(SelectQuery query, int offset, int limit) throws Exception {
        if (limit == 0 || this.archivetableInfo == null || this.archivetableInfo.isEmpty()) {
            return null;
        }
        if (limit > 500) {
            limit = 500;
        }
        LinkedList<HashMap<Column, Object>> outterTable = new LinkedList<HashMap<Column, Object>>();
        Column column = Column.getColumn((String)"CorrArchivedTablesInfo", (String)"DOCID_ARCHIVED_TABLE_ID");
        Object ruleID = this.findRuleID(query.getCriteria());
        for (Map<String, Object> tableInfo : this.archivetableInfo) {
            String archivedTableName = (String)tableInfo.get("CorrRuleSuccessHistory");
            Long docIDarchiveTableID = (Long)tableInfo.get("DOCID_ARCHIVED_TABLE_ID");
            long totalCount = 0L;
            if (offset != 0 && (totalCount = CorrelationArchivedData.get().getHistoryCount(archivedTableName, ruleID, this.timePack)) < (long)offset) {
                offset = (int)((long)offset - totalCount);
                continue;
            }
            SelectQueryImpl customQuery = new SelectQueryImpl(Table.getTable((String)archivedTableName));
            customQuery.setRange(new Range(offset, limit));
            List columns = query.getSelectColumns();
            for (Column col : columns) {
                customQuery.addSelectColumn(Column.getColumn((String)archivedTableName, (String)col.getColumnName(), (String)col.getColumnAlias()));
            }
            Criteria timeCriteria = CorrelationUtil.getTimeBasedCustomTableSuccessCriteria(archivedTableName, this.timePack);
            customQuery.setCriteria(ruleID != null ? timeCriteria.and(new Criteria(Column.getColumn((String)archivedTableName, (String)"RULE_ID"), ruleID, 0)) : timeCriteria);
            LinkedList<HashMap<Column, Object>> archivedDataInfo = new LinkedList<HashMap<Column, Object>>();
            limit -= DefaultDataSource.loadArchiveRequestResult("CorrRuleSuccessHistory", (SelectQuery)customQuery, archivedDataInfo);
            for (HashMap hashMap : archivedDataInfo) {
                hashMap.put(column, docIDarchiveTableID);
                outterTable.add(hashMap);
            }
            if (limit <= 0) break;
            offset = 0;
        }
        return outterTable;
    }

    private Object findRuleID(Criteria parentCriteria) {
        if (parentCriteria == null) {
            return null;
        }
        if (parentCriteria.getLeftCriteria() != null && parentCriteria.getRightCriteria() != null) {
            Object ruleID = this.findRuleID(parentCriteria.getLeftCriteria());
            if (ruleID != null) {
                return ruleID;
            }
            ruleID = this.findRuleID(parentCriteria.getRightCriteria());
            if (ruleID != null) {
                return ruleID;
            }
            return null;
        }
        if (this.isValidCriteria(parentCriteria)) {
            return parentCriteria.getValue();
        }
        return null;
    }

    private boolean isValidCriteria(Criteria result) {
        Column column = result.getColumn();
        return column.getTableAlias().equals("CorrRuleSuccessHistory") && column.getColumnName().equals("RULE_ID");
    }
}

