/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.auditdata;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.client.structure.ClientTableStructure;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.common.export.generators.MultiColumnJRXMLGenerator;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.auditdata.CorrelationNosqlData;
import com.manageengine.ela.server.correlation.common.constants.WindowsLogSeverityConstants;
import com.manageengine.ela.server.correlation.common.data.CommonDataHelper;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CorrCustomDataHandler {
    public static long fillTrendData(DataSet dataSet, long interval, Map<Long, Long> timeMap) throws SQLException {
        long totalLength = 0L;
        while (dataSet.next()) {
            long l;
            ++totalLength;
            long insertTime = dataSet.getAsLong(1);
            Long count = timeMap.get(insertTime = CorrCustomDataHandler.getNormalizedTime(insertTime, interval));
            if (count != null) {
                count = count + 1L;
                l = count;
            } else {
                l = 1L;
            }
            count = l;
            timeMap.put(insertTime, count);
        }
        return totalLength;
    }

    public static long getNormalizedTime(long insertTime, long interval) {
        DateTime dt = new DateTime(insertTime);
        insertTime = interval == 31536000000L ? dt.withMonthOfYear(1).withDayOfMonth(1).withTime(0, 0, 0, 0).getMillis() : (interval == 2678400000L ? dt.withDayOfMonth(1).withTime(0, 0, 0, 0).getMillis() : (interval == 86400000L ? dt.withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0).getMillis() : (interval == 3600000L ? dt.withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0).getMillis() : (interval == 60000L ? dt.withSecondOfMinute(0).withMillisOfSecond(0).getMillis() : dt.withMillisOfSecond(0).getMillis()))));
        return insertTime;
    }

    public static JSONArray getActionSearchResults(String searchText, Locale locale) {
        Column actionIDcolumn = Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID");
        Column actionNameColumn = Column.getColumn((String)"CorrActionInfo", (String)"DISPLAY_NAME", (String)"ACTION_DISPLAY_NAME");
        Column categoryIDcolumn = Column.getColumn((String)"CorrActionCategory", (String)"CATEGORY_ID");
        Column categoryNameColumn = Column.getColumn((String)"CorrActionCategory", (String)"DISPLAY_NAME");
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrActionInfo", (String)"CATEGORY_ID"), (Object)Column.getColumn((String)"CorrActionCategory", (String)"CATEGORY_ID"), 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrActionCategory", (String)"CATEGORY_ID"), (Object)CorrelationUtil.getDisabledActionCategories(), 9));
        return CorrCustomDataHandler.getSearchResults(actionIDcolumn, actionNameColumn, categoryIDcolumn, categoryNameColumn, criteria, 100, searchText, locale);
    }

    public static JSONArray getRuleSearchResults(String searchText, Locale locale) {
        Column actionIDcolumn = Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID");
        Column actionNameColumn = Column.getColumn((String)"CorrRuleInfo", (String)"RULE_DISPLAY_NAME");
        Column categoryIDcolumn = Column.getColumn((String)"CorrRuleCategory", (String)"CATEGORY_ID");
        Column categoryNameColumn = Column.getColumn((String)"CorrRuleCategory", (String)"DISPLAY_NAME");
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"CATEGORY_ID"), (Object)Column.getColumn((String)"CorrRuleCategory", (String)"CATEGORY_ID"), 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"REPORT_ENABLED"), (Object)true, 0));
        criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)CorrelationUtil.getOmitedRules(), 9));
        return CorrCustomDataHandler.getSearchResults(actionIDcolumn, actionNameColumn, categoryIDcolumn, categoryNameColumn, criteria, 100, searchText, locale);
    }

    private static JSONArray getSearchResults(Column firstTableFirstColm, Column firstTableSecColm, Column secondTableFirstColm, Column secondTableSecColm, Criteria joinCriteria, int max, String searchText, Locale locale) {
        LinkedHashMap storage = new LinkedHashMap();
        JSONArray result = null;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)firstTableFirstColm.getTableAlias()));
            selectQuery.addJoin(new Join(firstTableFirstColm.getTableAlias(), secondTableFirstColm.getTableAlias(), joinCriteria, 1));
            Column sysgenfirstTableColm = Column.getColumn((String)firstTableFirstColm.getTableAlias(), (String)"IS_SYSTEMGENERATED", (String)"SYSGEN_TABLE_1");
            Column sysgensecondTableColm = Column.getColumn((String)secondTableFirstColm.getTableAlias(), (String)"IS_SYSTEMGENERATED", (String)"SYSGEN_TABLE_2");
            selectQuery.addSelectColumn(firstTableFirstColm);
            selectQuery.addSelectColumn(firstTableSecColm);
            selectQuery.addSelectColumn(sysgenfirstTableColm);
            selectQuery.addSelectColumn(secondTableFirstColm);
            selectQuery.addSelectColumn(secondTableSecColm);
            selectQuery.addSelectColumn(sysgensecondTableColm);
            LinkedList<HashMap<Column, Object>> searchResult = DefaultDataSource.getKeyBasedSearchResult(firstTableSecColm, searchText, (SelectQuery)selectQuery, sysgenfirstTableColm, locale, 1, max).getResultList();
            searchResult.forEach(element -> {
                try {
                    Long categoryId = (Long)element.get(secondTableFirstColm);
                    if (!storage.containsKey(categoryId)) {
                        JSONObject categoryObject = new JSONObject();
                        categoryObject.put("ID", (Object)categoryId);
                        if (!Boolean.valueOf(element.get(sysgensecondTableColm).toString()).booleanValue()) {
                            categoryObject.put("NAME", element.get(secondTableSecColm));
                        } else {
                            categoryObject.put("NAME", (Object)ProductBundle.getInstance().getString(locale, (String)element.get(secondTableSecColm)));
                        }
                        categoryObject.put("LIST", (Object)new JSONArray());
                        storage.put(categoryId, categoryObject);
                    }
                    JSONObject obj = new JSONObject();
                    obj.put("ID", element.get(firstTableFirstColm));
                    if (!Boolean.valueOf(element.get(sysgenfirstTableColm).toString()).booleanValue()) {
                        obj.put("NAME", element.get(firstTableSecColm));
                    } else {
                        obj.put("NAME", (Object)ProductBundle.getInstance().getString(locale, (String)element.get(firstTableSecColm)));
                    }
                    ((JSONArray)((JSONObject)storage.get(categoryId)).get("LIST")).put((Object)obj);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            result = new JSONArray(storage.values());
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public static JSONArray getCorrelationOverviewTableData(JSONObject request, TimePack time, Locale locale) {
        JSONArray tableData = new JSONArray();
        try {
            boolean sortAscending = true;
            if (request.has("SORTTYPE")) {
                sortAscending = request.getInt("SORTTYPE") == 1;
            }
            int startFrom = request.getInt("STARTFROM");
            int limit = request.getInt("LIMIT");
            int fetchLimit = limit + startFrom - 1;
            Map<Long, JSONObject> corrOverviewData = CorrelationUtil.getOverviewData(time, new Range(1, fetchLimit), locale, sortAscending);
            Map<Long, JSONObject> activityOverviewData = ActivityUtil.getOverviewData(time, new Range(1, fetchLimit), locale, sortAscending);
            NavigableSet<JSONObject> recentData = CommonDataHelper.mergeResults(corrOverviewData, activityOverviewData, sortAscending);
            JSONObject[] combinedData = recentData.toArray(new JSONObject[recentData.size()]);
            for (int i = startFrom - 1; i < fetchLimit && i < combinedData.length; ++i) {
                JSONObject data = combinedData[i];
                try {
                    JSONObject resObject = new JSONObject();
                    Integer type = data.getInt("TYPE");
                    resObject.put("Common_TYPE", (Object)type);
                    resObject.put("CorrRuleSuccessHistory_RULE_ID", data.getLong("RULE_ID"));
                    resObject.put("CorrRuleInfo_COUNT", data.getLong("HITS"));
                    resObject.put("CorrRuleInfo_RULE_DISPLAY_NAME", (Object)data.getString("RULE_NAME"));
                    resObject.put("CorrRuleCategory_DISPLAY_NAME", (Object)data.getString("CATEGORY_NAME"));
                    if (type == 2) {
                        resObject.put("Common_IS_SYSTEMGENERATED", data.getBoolean("IS_SYSTEMGENERATED"));
                        resObject.put("Common_IS_WINDOWS_DEFAULT", data.getBoolean("IS_WINDOWS_DEFAULT"));
                    }
                    tableData.put((Object)resObject);
                    continue;
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tableData;
    }

    public static void processCustomTextEntries(Map<String, Object> response, Locale locale) {
        Object severityText;
        block19: {
            List<String> syslogSeverities;
            int severity;
            block20: {
                Object devicetype;
                block18: {
                    block17: {
                        severityText = response.get("SEVERITY");
                        devicetype = response.get("HOSTTYPE");
                        if (severityText == null) {
                            return;
                        }
                        response.remove("SEVERITY");
                        if (devicetype == null) {
                            try {
                                Row row;
                                DataObject dobj;
                                if (response.get("HOSTID") != null) {
                                    Criteria criteria = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), response.get("HOST_ID"), 0);
                                    dobj = PersistenceDBUtil.getPersistence().get("HostDetails", criteria);
                                    row = dobj.getRow("HostDetails");
                                    if (row == null) {
                                        return;
                                    }
                                    devicetype = row.get("TYPE");
                                    break block17;
                                }
                                if (response.get("APPID") != null) {
                                    SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AppResources"));
                                    selectQuery.addJoin(new Join("AppResources", "HostDetails", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 2));
                                    selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"HOST_ID", (String)"DEVICE_ID"));
                                    selectQuery.addSelectColumn(Column.getColumn((String)"AppResources", (String)"APPID", (String)"APP_ID"));
                                    selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"TYPE", (String)"DEVICE_TYPE"));
                                    selectQuery.setCriteria(new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), response.get("APPID"), 0));
                                    dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
                                    row = dobj.getRow("HostDetails");
                                    if (row == null) {
                                        return;
                                    }
                                    devicetype = row.get("TYPE");
                                    break block17;
                                }
                                return;
                            }
                            catch (Exception exp) {
                                return;
                            }
                        }
                    }
                    severity = Integer.parseInt(severityText.toString());
                    syslogSeverities = Arrays.asList("emergency", "alert", "critical", "error", "warning", "notice", "information", "debug");
                    if (!((String)devicetype).toLowerCase().contains("windows")) break block18;
                    WindowsLogSeverityConstants sev = WindowsLogSeverityConstants.getType(severity);
                    if (sev != WindowsLogSeverityConstants.OTHERS) {
                        severityText = sev;
                    }
                    break block19;
                }
                if (!((String)devicetype).toLowerCase().contains("ibm")) break block20;
                switch (severity) {
                    case 2: {
                        severityText = "escape";
                        break block19;
                    }
                    case 3: {
                        severityText = "diagnostic";
                        break block19;
                    }
                    case 5: {
                        severityText = "inquiry";
                        break block19;
                    }
                    case 7: {
                        severityText = "request";
                        break block19;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (severity < syslogSeverities.size()) {
                severityText = syslogSeverities.get(severity);
            } else {
                return;
            }
        }
        response.put("SEVERITY", ProductBundle.getInstance().getString(locale, "ela.severity.".concat(severityText.toString())));
    }

    public static JSONArray getAllColumns(Long ruleID, Locale locale) throws JSONException, DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrConfiguredActions"));
        query.addJoin(new Join("CorrConfiguredActions", "CorrActionCondnFields", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
        query.addJoin(new Join("CorrActionCondnFields", "NoSqlIndexFields", new String[]{"CONDN_FIELD_ID"}, new String[]{"FIELD_ID"}, 2));
        query.addJoin(new Join("CorrConfiguredActions", "CorrTableViewConfig", new String[]{"CONFIG_ID"}, new String[]{"ACTION_CONFIG_ID"}, 1));
        query.addJoin(new Join("CorrConfiguredActions", "CorrActionInfo", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 1));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"ACTION_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID", (String)"ACTION_CONDN_FIELDID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"DISPLAY_NAME"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"DESCRIPTION"));
        query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
        query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_DISPLAY_NAME"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"TABLE_VIEW_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"ACTION_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"FIELD_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"DISPLAY_NAME"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"DISPLAY_TYPE"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"DISPLAY_ORDER"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"IS_RESOLVED"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID", (String)"CORR_ACTION_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"IS_SYSTEMGENERATED"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"DESCRIPTION"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ORDER"), true));
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), (Object)ruleID, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"TABLECOLUMN_ALLOWED"), (Object)true, 0));
        query.setCriteria(criteria);
        DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        return CorrCustomDataHandler.loadColSelectionData(dobj, "CorrTableViewConfig", locale);
    }

    public static JSONArray loadColSelectionData(DataObject dobj, String tableName, Locale locale) throws JSONException, DataAccessException {
        Iterator iter = dobj.getRows("CorrConfiguredActions");
        JSONArray columns = new JSONArray();
        while (iter.hasNext()) {
            Boolean isSystemGenerated;
            Row row = (Row)iter.next();
            Criteria crit = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"), row.get("ACTION_ID"), 0);
            Criteria correlationActionCriteria = new Criteria(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID"), row.get("ACTION_ID"), 0);
            Row corractionInfo = dobj.getRow("CorrActionInfo", correlationActionCriteria);
            String actionDisplayName = (String)corractionInfo.get("DESCRIPTION");
            if (corractionInfo != null && corractionInfo.get("IS_SYSTEMGENERATED") != null && (isSystemGenerated = (Boolean)corractionInfo.get("IS_SYSTEMGENERATED")).booleanValue()) {
                actionDisplayName = ProductBundle.getInstance().getString(ResourceBundleMgr.getInstance().getServerLocale(), actionDisplayName);
            }
            JSONObject actionObject = new JSONObject();
            actionObject.put("ACTION_CONFIG_ID", row.get("CONFIG_ID"));
            actionObject.put("ACTION_DISPLAY_NAME", (Object)actionDisplayName);
            JSONArray fields = new JSONArray();
            actionObject.put("FIELDS", (Object)fields);
            Iterator iterator = dobj.getRows("CorrActionCondnFields", crit);
            while (iterator.hasNext()) {
                Row innerRow = (Row)iterator.next();
                JSONObject obj = new JSONObject();
                obj.put("FIELD_CONFIG_ID", innerRow.get("FIELD_CONFIG_ID"));
                obj.put("FIELD_NAME", (Object)ProductBundle.getInstance().getString(locale, (String)innerRow.get("DISPLAY_NAME")));
                String description = (String)innerRow.get("DESCRIPTION");
                if (description != null) {
                    obj.put("FIELD_DESCRIPTION", (Object)ProductBundle.getInstance().getString(locale, description));
                }
                Criteria innerCriteria = new Criteria(Column.getColumn((String)tableName, (String)"ACTION_CONFIG_ID"), row.get("CONFIG_ID"), 0);
                Row preConfiguredRow = dobj.getRow(tableName, innerCriteria = innerCriteria.and(new Criteria(Column.getColumn((String)tableName, (String)"FIELD_CONFIG_ID"), innerRow.get("FIELD_CONFIG_ID"), 0)));
                if (preConfiguredRow == null) {
                    obj.put("DISPLAY_NAME", (Object)ProductBundle.getInstance().getString(locale, (String)innerRow.get("DISPLAY_NAME")));
                    obj.put("DISPLAY_TYPE", 0L);
                    obj.put("DISPLAY_ORDER", 0L);
                } else {
                    Boolean isResolveNeeded = (Boolean)preConfiguredRow.get("IS_RESOLVED");
                    String dispName = (String)preConfiguredRow.get("DISPLAY_NAME");
                    if (isResolveNeeded != null && isResolveNeeded.booleanValue()) {
                        dispName = ProductBundle.getInstance().getString(locale, dispName);
                    }
                    obj.put("DISPLAY_NAME", (Object)dispName);
                    obj.put("DISPLAY_TYPE", preConfiguredRow.get("DISPLAY_TYPE"));
                    obj.put("DISPLAY_ORDER", preConfiguredRow.get("DISPLAY_ORDER"));
                    obj.put("IS_PRE_CONF", true);
                }
                fields.put((Object)obj);
            }
            columns.put((Object)actionObject);
        }
        return columns;
    }

    public static boolean addRemColumn(JSONObject request, Locale locale) throws JSONException, DataAccessException, BaseStatusCode {
        Long ruleID = request.getLong("RULE_ID");
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrTableViewConfig"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"TABLE_VIEW_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"ACTION_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"FIELD_CONFIG_ID"));
        query.setCriteria(new Criteria(Column.getColumn((String)"CorrTableViewConfig", (String)"RULE_ID"), (Object)ruleID, 0));
        DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        query = new SelectQueryImpl(Table.getTable((String)"CorrConfiguredActions"));
        query.addJoin(new Join("CorrConfiguredActions", "CorrActionInfo", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
        query.addJoin(new Join("CorrActionInfo", "CorrActionCondnFields", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"ACTION_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID", (String)"ACTN_INFO_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID", (String)"CNDN_ACTN_ID"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID", (String)"ACTN_CNDN_FIELD_CONF"));
        query.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"DISPLAY_NAME"));
        query.setCriteria(new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), (Object)ruleID, 0));
        DataObject actionCondnFields = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
        JSONArray arr = request.getJSONArray("CONFIGURED_COLUMNS");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject action = arr.getJSONObject(i);
            Long actionConfigID = action.getLong("ACTION_CONFIG_ID");
            JSONArray fieldinfo = action.getJSONArray("FIELDS");
            Long[] fields = new Long[fieldinfo.length()];
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrTableViewConfig", (String)"ACTION_CONFIG_ID"), (Object)actionConfigID, 0);
            for (int j = 0; j < fieldinfo.length(); ++j) {
                JSONObject field = fieldinfo.getJSONObject(j);
                fields[j] = field.getLong("FIELD_CONFIG_ID");
                if (field.get("DISPLAY_NAME") == null || field.getString("DISPLAY_NAME").trim().isEmpty()) {
                    throw BaseStatusCode.getBaseStatusCode(7428);
                }
                Criteria criteria1 = criteria.and(new Criteria(Column.getColumn((String)"CorrTableViewConfig", (String)"FIELD_CONFIG_ID"), (Object)field.getLong("FIELD_CONFIG_ID"), 0));
                Criteria fieldCritiera = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"), (Object)field.getLong("FIELD_CONFIG_ID"), 0);
                Row row = dataObject.getRow("CorrTableViewConfig", criteria1);
                Row fieldRow = actionCondnFields.getRow("CorrActionCondnFields", fieldCritiera);
                String displayName = field.getString("DISPLAY_NAME");
                Boolean isResolutionRequired = Boolean.FALSE;
                if (fieldRow != null && fieldRow.get("DISPLAY_NAME") != null) {
                    String dispNameForField = (String)fieldRow.get("DISPLAY_NAME");
                    String resolvedDispName = ProductBundle.getInstance().getString(locale, dispNameForField);
                    if (resolvedDispName.equals(displayName.trim())) {
                        displayName = dispNameForField;
                        isResolutionRequired = Boolean.TRUE;
                    }
                }
                if (row == null) {
                    row = new Row("CorrTableViewConfig");
                    row.set("RULE_ID", (Object)ruleID);
                    row.set("ACTION_CONFIG_ID", (Object)actionConfigID);
                    row.set("FIELD_CONFIG_ID", (Object)field.getLong("FIELD_CONFIG_ID"));
                    row.set("DISPLAY_NAME", (Object)displayName);
                    row.set("DISPLAY_TYPE", (Object)field.getInt("DISPLAY_TYPE"));
                    row.set("DISPLAY_ORDER", (Object)field.getInt("DISPLAY_ORDER"));
                    row.set("IS_RESOLVED", (Object)isResolutionRequired);
                    dataObject.addRow(row);
                    continue;
                }
                row.set("DISPLAY_NAME", (Object)displayName);
                row.set("DISPLAY_TYPE", (Object)field.getInt("DISPLAY_TYPE"));
                row.set("DISPLAY_ORDER", (Object)field.getInt("DISPLAY_ORDER"));
                row.set("IS_RESOLVED", (Object)isResolutionRequired);
                dataObject.updateRow(row);
            }
            Criteria subCrit = criteria.and(new Criteria(Column.getColumn((String)"CorrTableViewConfig", (String)"FIELD_CONFIG_ID"), (Object)fields, 9));
            dataObject.deleteRows("CorrTableViewConfig", subCrit);
        }
        PersistenceDBUtil.getPersistence().update(dataObject);
        ClientTableStructure.removeTableStructureFromCache(request.getString("UNIQUE_ID"));
        MultiColumnJRXMLGenerator.removeJRXMLCache(request.getString("UNIQUE_ID"));
        return true;
    }

    public static JSONArray getActionCategoryList() throws BaseStatusCode {
        try {
            JSONArray formatList = new JSONArray();
            Table table = new Table("CorrActionCategory");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn((String)"CorrActionCategory", (String)"CATEGORY_ID"));
            query.addSelectColumn(Column.getColumn((String)"CorrActionCategory", (String)"DISPLAY_NAME"));
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            Iterator iterator = dObj.getRows("CorrActionCategory");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONObject catData = new JSONObject();
                catData.put("categoryID", row.get("CATEGORY_ID"));
                catData.put("categoryName", row.get("DISPLAY_NAME"));
                formatList.put((Object)catData);
            }
            return formatList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(4097);
        }
    }

    public static JSONArray getNoSqlIndexFieldsList() throws BaseStatusCode {
        try {
            JSONArray fieldList = new JSONArray();
            Table table = new Table("NoSqlIndexFields");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
            query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"ACTUAL_DISPLAY_NAME"));
            query.addSortColumn(new SortColumn("NoSqlIndexFields", "FIELD_ID", true));
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            Iterator iterator = dObj.getRows("NoSqlIndexFields");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONObject fieldData = new JSONObject();
                fieldData.put("fieldID", row.get("FIELD_ID"));
                fieldData.put("fieldName", row.get("ACTUAL_DISPLAY_NAME"));
                fieldList.put((Object)fieldData);
            }
            return fieldList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(4097);
        }
    }

    public static JSONArray customizeScheduleTableResults(JSONArray result) throws BaseStatusCode {
        try {
            for (int i = 0; i < result.length(); ++i) {
                JSONObject entry = (JSONObject)result.get(i);
                Integer ruleType = entry.getInt("CorrRuleInfo_TYPE");
                boolean showFilterOption = false;
                if (ruleType == 2) {
                    if (entry.optBoolean("CorrRuleInfo_IS_SYSTEMGENERATED", false)) {
                        showFilterOption = true;
                    }
                    entry.put("CorrRuleInfo_RULE_DISPLAY_NAME", (Object)ActivityUtil.getProviderNameFromRule((Long)entry.get("CorrRuleInfo_RULE_ID")));
                }
                entry.put("IS_FILTER_SUPPORTED", showFilterOption);
            }
            return result;
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static JSONArray customizeTableResults(Long ruleID, JSONArray resultJsonArray, Integer limit, TimePack pack) throws BaseStatusCode {
        return CorrCustomDataHandler.customizeTableResults(CorrCustomDataHandler.getConfiguredColumns(ruleID), resultJsonArray, limit, pack);
    }

    public static JSONArray customizeTableResults(Map<Long, List<Map<String, Object>>> configuredColumns, JSONArray resultJsonArray, Integer limit, TimePack pack) {
        try {
            if (resultJsonArray != null) {
                ArrayList<Long> historyID_direct = new ArrayList<Long>();
                HashMap<Long, List<Long>> docID_archive = new HashMap<Long, List<Long>>();
                String archiveColumn = "CorrArchivedTablesInfo_DOCID_ARCHIVED_TABLE_ID";
                for (int index = 0; index < resultJsonArray.length(); ++index) {
                    JSONObject object = resultJsonArray.getJSONObject(index);
                    Long historyID = object.getLong("CorrRuleSuccessHistory_HISTORY_ID");
                    if (object.has(archiveColumn)) {
                        Long docarchivetableID = object.getLong(archiveColumn);
                        ArrayList<Long> list2 = (ArrayList<Long>)docID_archive.get(docarchivetableID);
                        if (list2 == null) {
                            list2 = new ArrayList<Long>();
                            docID_archive.put(docarchivetableID, list2);
                        }
                        list2.add(historyID);
                        continue;
                    }
                    historyID_direct.add(historyID);
                }
                Map<Long, Map<Long, List<Map<String, Object>>>> historyIDvsCustomFields = CorrelationNosqlData.resolveCustomFieldsInfo(historyID_direct, docID_archive, pack);
                for (int index = 0; index < resultJsonArray.length(); ++index) {
                    JSONObject object = resultJsonArray.getJSONObject(index);
                    Long historyID = object.getLong("CorrRuleSuccessHistory_HISTORY_ID");
                    Map<Long, List<Map<String, Object>>> resolveExtendedFields = historyIDvsCustomFields.get(historyID);
                    if (resolveExtendedFields == null) continue;
                    configuredColumns.forEach((actionId, list) -> {
                        List data = (List)resolveExtendedFields.get(actionId);
                        if (data != null) {
                            list.forEach(map -> {
                                try {
                                    Integer occurance = (Integer)map.get("DISPLAY_TYPE");
                                    String displayName = (String)map.get("DISPLAY_NAME");
                                    String indexName = (String)map.get("INDEX_NAME");
                                    StringBuilder builder = new StringBuilder();
                                    block1 : switch (occurance) {
                                        case 0: {
                                            for (int i = data.size() - 1; i >= 0; --i) {
                                                Object obj = ((Map)data.get(i)).get(indexName);
                                                if (obj == null) continue;
                                                builder.append(obj);
                                                break block1;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            for (Map indexes : data) {
                                                Object obj = indexes.get(indexName);
                                                if (obj == null) continue;
                                                builder.append(obj);
                                                break block1;
                                            }
                                            break;
                                        }
                                        case 2: {
                                            int commIndex;
                                            Integer limitIndex = 0;
                                            for (Map indexes : data) {
                                                Object obj = indexes.get(indexName);
                                                if (obj == null) continue;
                                                builder.append(obj).append(",");
                                                Integer n2 = limitIndex;
                                                Integer n3 = limitIndex = Integer.valueOf(limitIndex + 1);
                                                if (limit != null && limitIndex >= limit) {
                                                    builder.append("...");
                                                    break;
                                                }
                                                builder.append(" ");
                                            }
                                            if ((commIndex = builder.lastIndexOf(",")) == -1) break;
                                            builder.deleteCharAt(commIndex);
                                            break;
                                        }
                                        default: {
                                            throw BaseStatusCode.getBaseStatusCode(7428);
                                        }
                                    }
                                    object.put(displayName, (Object)(builder.length() > 0 ? builder.toString() : "-"));
                                }
                                catch (BaseStatusCode | JSONException e) {
                                    e.printStackTrace();
                                }
                            });
                        }
                    });
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return resultJsonArray;
    }

    public static Map<Long, List<Map<String, Object>>> getConfiguredColumns(Long ruleID) throws BaseStatusCode {
        try {
            SelectQueryImpl configuredFields = new SelectQueryImpl(Table.getTable((String)"CorrTableViewConfig"));
            configuredFields.addJoin(new Join(Table.getTable((String)"CorrTableViewConfig"), Table.getTable((String)"CorrConfiguredActions"), new String[]{"ACTION_CONFIG_ID"}, new String[]{"CONFIG_ID"}, 2));
            configuredFields.addJoin(new Join(Table.getTable((String)"CorrConfiguredActions"), Table.getTable((String)"CorrActionCondnFields"), new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
            configuredFields.addJoin(new Join(Table.getTable((String)"CorrActionCondnFields"), Table.getTable((String)"NoSqlIndexFields"), new String[]{"CONDN_FIELD_ID"}, new String[]{"FIELD_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), (Object)ruleID, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrTableViewConfig", (String)"FIELD_CONFIG_ID"), (Object)Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"), 0));
            configuredFields.setCriteria(criteria);
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"TABLE_VIEW_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_INDEX_NAME"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"DISPLAY_NAME"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"DISPLAY_TYPE"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"FIELD_CONFIG_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"ACTION_CONFIG_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"));
            configuredFields.addSortColumn(new SortColumn(Column.getColumn((String)"CorrTableViewConfig", (String)"DISPLAY_ORDER"), true));
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)configuredFields);
            Iterator iterator = dobj.getRows("CorrTableViewConfig");
            HashMap<Long, List<Map<String, Object>>> actionList = new HashMap<Long, List<Map<String, Object>>>();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (actionList.get((Long)row.get("ACTION_CONFIG_ID")) == null) {
                    actionList.put((Long)row.get("ACTION_CONFIG_ID"), new ArrayList());
                }
                List columnList = (List)actionList.get((Long)row.get("ACTION_CONFIG_ID"));
                HashMap<String, Object> obj = new HashMap<String, Object>();
                Criteria crit = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"), row.get("FIELD_CONFIG_ID"), 0);
                Row actionCondnRow = dobj.getRow("CorrActionCondnFields", crit);
                crit = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), actionCondnRow.get("CONDN_FIELD_ID"), 0);
                Row indexRow = dobj.getRow("NoSqlIndexFields", crit);
                obj.put("DISPLAY_NAME", "Action" + row.get("ACTION_CONFIG_ID") + "_Field" + row.get("FIELD_CONFIG_ID"));
                obj.put("INDEX_NAME", indexRow.get("FIELD_INDEX_NAME"));
                obj.put("DISPLAY_TYPE", row.get("DISPLAY_TYPE"));
                columnList.add(obj);
            }
            return actionList;
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static String getSearchQueryBasedOnRules(Long ruleID, Long historyID, TimeZone timeZone, Locale locale, TimePack timePack) throws BaseStatusCode {
        int uniqueFieldThreshold = 20;
        String ORCondition = "OR ";
        String ANDCondition = "AND ";
        String[] defaultFields = new String[]{"HOSTNAME", "USERNAME"};
        ArrayList<String> queryFields = new ArrayList<String>(CorrCustomDataHandler.getConfiguredFields(ruleID));
        for (String defaultField : defaultFields) {
            if (queryFields.contains(defaultField)) continue;
            queryFields.add(defaultField);
        }
        StringBuilder query = new StringBuilder();
        ArrayList<String> queryData = new ArrayList<String>();
        try {
            JSONArray logs = CorrelationNosqlData.getCorrIndexTimeLineView(historyID, timeZone, locale, timePack);
            for (String queryField : queryFields) {
                queryData.clear();
                int repetitionCount = 0;
                StringBuilder fieldQuery = new StringBuilder("(");
                block4: for (int j = 0; j < logs.length(); ++j) {
                    JSONArray fields = logs.getJSONObject(j).getJSONArray("COMPLETE_DATA");
                    for (int k = 0; k < fields.length(); ++k) {
                        if (!fields.getJSONObject(k).optString("NAME", "").equals(queryField)) continue;
                        String value = fields.getJSONObject(k).getString("VALUE").replace("#", "*");
                        if (queryData.contains(value)) {
                            ++repetitionCount;
                            continue block4;
                        }
                        fieldQuery.append(queryField).append("= \"").append(value).append("\" ").append("OR ");
                        queryData.add(value);
                        continue block4;
                    }
                }
                if (repetitionCount + queryData.size() != logs.length()) continue;
                if (queryData.size() > 20) {
                    query.append("( ").append(queryField).append("= \"*\") ").append("AND ");
                    continue;
                }
                query.append(fieldQuery.substring(0, fieldQuery.length() - "OR ".length())).append(") ").append("AND ");
            }
            query = new StringBuilder(query.length() > 0 ? query.substring(0, query.length() - "AND ".length()) : query.toString());
            return query.toString();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(4097);
        }
    }

    public static ArrayList<String> getConfiguredFields(Long ruleID) throws BaseStatusCode {
        try {
            SelectQueryImpl configuredFields = new SelectQueryImpl(Table.getTable((String)"NoSqlIndexFields"));
            configuredFields.addJoin(new Join(Table.getTable((String)"NoSqlIndexFields"), Table.getTable((String)"CorrActionConditions"), new String[]{"FIELD_ID"}, new String[]{"FIELD_ID"}, 2));
            configuredFields.addJoin(new Join(Table.getTable((String)"CorrActionConditions"), Table.getTable((String)"CorrActionGroups"), new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 2));
            configuredFields.addJoin(new Join(Table.getTable((String)"CorrActionGroups"), Table.getTable((String)"CorrConfiguredActions"), new String[]{"ACTION_CONFIG_ID"}, new String[]{"CONFIG_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), (Object)ruleID, 0);
            configuredFields.setCriteria(criteria);
            configuredFields.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
            configuredFields.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_INDEX_NAME"));
            ArrayList<String> fieldList = new ArrayList<String>();
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)configuredFields);
            Iterator iterator = dobj.getRows("NoSqlIndexFields");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                fieldList.add((String)row.get("FIELD_INDEX_NAME"));
            }
            return fieldList;
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }
}

