/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.auditdata;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.logsearch.index.api.UniqueIdGenerator;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.cache.Cache;
import com.zoho.za.dae.elastic.Node;
import com.zoho.za.dae.schedule.ArchiveManager;
import com.zoho.za.dae.utils.ElasticUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;

public class CorrNosqlIndexHandler {
    private static final Cache<String, Long> INDEXIDCACHE = new Cache();
    private static final Lock INDEXID_LOCK = new ReentrantLock(true);
    public static final String LOG_INDEXER_KEY_COR_ACTION_ID = "cor_action_id";
    public static final String LOG_INDEXER_KEY_COR_RULE_ID = "cor_rule_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getIndexID(String indexName) throws DataAccessException {
        INDEXID_LOCK.lock();
        try {
            Long indexID = INDEXIDCACHE.get(indexName);
            if (indexID != null) {
                Long l = indexID;
                return l;
            }
            try {
                Criteria indexNameCrit = new Criteria(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_NAME"), (Object)indexName, 0);
                DataObject dobj = PersistenceDBUtil.getPersistence().get("NoSqlIndexDetails", indexNameCrit);
                if (dobj.isEmpty()) {
                    Row row = new Row("NoSqlIndexDetails");
                    row.set("CREATED_TIME", (Object)System.currentTimeMillis());
                    row.set("INDEX_NAME", (Object)indexName);
                    dobj.addRow(row);
                    dobj = PersistenceDBUtil.getPersistence().add(dobj);
                }
                indexID = (Long)dobj.getFirstValue("NoSqlIndexDetails", "INDEX_ID");
                INDEXIDCACHE.put(indexName, indexID);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            Long l = indexID;
            return l;
        }
        finally {
            INDEXID_LOCK.unlock();
        }
    }

    public static Map<Long, String> getIndexName(Long[] indexID) throws DataAccessException {
        Criteria indexNameCrit = new Criteria(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_ID"), (Object)indexID, 8);
        DataObject dobj = PersistenceDBUtil.getPersistence().get("NoSqlIndexDetails", indexNameCrit);
        HashMap<Long, String> indexInfo = new HashMap<Long, String>();
        Iterator itr = dobj.getRows("NoSqlIndexDetails");
        while (itr.hasNext()) {
            Row indexRow = (Row)itr.next();
            indexInfo.put((Long)indexRow.get("INDEX_ID"), (String)indexRow.get("INDEX_NAME"));
        }
        return indexInfo;
    }

    public static Map<String, Object> getIndexedDocInfo(String indexName, String docID, TimePack pack) {
        Map<String, Object> indexDoc = CorrNosqlIndexHandler.getIndexedDocInfo(indexName, docID);
        if (indexDoc == null) {
            ArchiveManager.unArchiveIndices((Client)Node.getClient(), (Long)(pack.getStartTimeInLong() / 1000L), (Long)(pack.getEndTimeInLong() / 1000L), (boolean)true, (String)"corr_");
            return CorrNosqlIndexHandler.getIndexedDocInfo(indexName, docID);
        }
        return indexDoc;
    }

    private static Map<String, Object> getIndexedDocInfo(String indexName, String docID) {
        try {
            GetResponse response = (GetResponse)Node.getClient().prepareGet(indexName, "logs", docID).get();
            if (response != null && response.getSource() != null) {
                return response.getSource();
            }
            return null;
        }
        catch (Exception exp) {
            return null;
        }
    }

    public static String getMessageField(Map<String, Object> keyValuePair) {
        for (String msgField : ElasticUtils.DEFAULT_MESSAGE_FIELDS) {
            String message;
            if (!keyValuePair.containsKey(msgField) || (message = keyValuePair.get(msgField).toString()) == null) continue;
            keyValuePair.remove(msgField);
            return message;
        }
        return null;
    }

    public static Map.Entry<String, String> indexCorrelationDocInfo(String indexName, String docID, Long actionID, Long ruleID) {
        LogIndexingAPI indexingAPI = LogIndexingAPI.getInstance();
        Map<String, Object> source = CorrNosqlIndexHandler.getIndexedDocInfo(indexName, docID);
        if (source != null) {
            String newDocID = UniqueIdGenerator.getInstance().getNextId();
            source.put(LOG_INDEXER_KEY_COR_ACTION_ID, actionID);
            source.put("$id$", newDocID);
            source.put(LOG_INDEXER_KEY_COR_RULE_ID, ruleID);
            Map result = indexingAPI.indexRecordIntoCorrel(source);
            if (result == null || String.valueOf(result.get("INDEX_NAME")).equals(indexName)) {
                return null;
            }
            return new AbstractMap.SimpleEntry<String, String>(String.valueOf(result.get("INDEX_NAME")), newDocID);
        }
        return null;
    }
}

