/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.auditdata;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.correlation.common.archive.ArchivedData;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.util.List;
import java.util.Map;

public class CorrelationArchivedData
extends ArchivedData {
    private static final CorrelationArchivedData INSTANCE = new CorrelationArchivedData();

    public static CorrelationArchivedData get() {
        return INSTANCE;
    }

    @Override
    public long getHistoryCount(String customTableName, Object ruleID, TimePack timePack) {
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)customTableName));
        Column countColumn = Column.getColumn(null, (String)"*");
        sq.addSelectColumn(countColumn.count());
        Criteria criteria = new Criteria(Column.getColumn((String)customTableName, (String)"RULE_ID"), ruleID, 0);
        sq.setCriteria(criteria.and(CorrelationUtil.getTimeBasedCustomTableSuccessCriteria(customTableName, timePack)));
        return DBUtil.getTotalLongCountArchiveTable((SelectQuery)sq);
    }

    public long loadCorrelationTrendData(Long ruleID, TimePack time, long interval, Map<Long, Long> timeMap) throws Exception {
        List<Map<String, Object>> archivetableInfo = this.getArchivedTablesInfo(time);
        long totalLength = 0L;
        for (Map<String, Object> map : archivetableInfo) {
            String tableName = (String)map.get("CorrRuleSuccessHistory");
            SelectQueryImpl archiveQuery = new SelectQueryImpl(Table.getTable((String)tableName));
            archiveQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"END_TIME"));
            Criteria archiveCriteria = new Criteria(Column.getColumn((String)tableName, (String)"RULE_ID"), (Object)ruleID, 0);
            archiveQuery.setCriteria(archiveCriteria.and(CorrelationUtil.getTimeBasedCustomTableSuccessCriteria(tableName, time)));
            totalLength += this.fillArchiveTrendInformation((SelectQuery)archiveQuery, interval, timeMap);
        }
        return totalLength;
    }

    public Map<Long, Map<Long, Map<Long, List<String>>>> getArchivedDocInfo(Long docidtable, Long historyid) throws DataAccessException {
        String tableName = this.getArchivedTableName(docidtable);
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"ACTION_CONFIG_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"RULE_HISTORY_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"INDEX_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"DOC_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"DOC_HISTORY_ID"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"DOC_HISTORY_ID"), true));
        query.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)"RULE_HISTORY_ID"), (Object)historyid, 0));
        return this.getArchivedDocIDInfo((SelectQuery)query);
    }

    @Override
    public Map<Long, Map<Long, Map<Long, List<String>>>> getArchivedDocInfoLimited(Long docidtable, List<Long> historyidList) throws DataAccessException {
        String tableName = this.getArchivedTableName(docidtable);
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"ACTION_CONFIG_ID").distinct());
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"RULE_HISTORY_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"INDEX_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"DOC_ID"));
        query.addSelectColumn(Column.getColumn((String)tableName, (String)"DOC_HISTORY_ID"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"DOC_HISTORY_ID"), true));
        query.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)"RULE_HISTORY_ID"), (Object)historyidList.toArray(new Long[historyidList.size()]), 8));
        return this.getArchivedDocIDInfo((SelectQuery)query);
    }

    @Override
    protected String getArchiveDataTableName() {
        return "CorrArchivedTablesInfo";
    }

    @Override
    protected String getBaseTableName() {
        return "CorrRuleSuccessHistory";
    }
}

