/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.auditdata;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.util.DateFormatUtil;
import com.manageengine.ela.server.correlation.auditdata.CorrCustomDataHandler;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.auditdata.CorrelationArchivedData;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.index.IndexNotFoundException;
import org.json.JSONArray;
import org.json.JSONObject;

public class CorrelationNosqlData {
    private static final Logger LOGGER = Logger.getLogger(CorrelationNosqlData.class.getName());
    private static final String[] SOURCE_KEY = new String[]{"SOURCE_NAME", "SOURCE_IP", "REMOTEHOST", "REMOTEHOST_IP"};
    private static final String[] DESTINATION_KEY = new String[]{"DESTINATION_IP", "HOSTNAME"};
    public static final String LOG_INDEXER_KEY_COR_ACTION_ID = "cor_action_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Map<Long, List<Map<String, Object>>>> resolveCustomFieldsInfo(List<Long> historyID_direct, Map<Long, List<Long>> docID_archive, TimePack pack) throws DataAccessException {
        Map<Long, Map<Long, Map<String, List<String>>>> liveDocIDs;
        HashMap<Long, Map<Long, Map<String, List<String>>>> formattedDocIDs;
        block8: {
            Map<Long, Map<Long, Map<String, List<String>>>> liveDocIDs2;
            block7: {
                formattedDocIDs = new HashMap<Long, Map<Long, Map<String, List<String>>>>();
                if (historyID_direct == null || historyID_direct.isEmpty()) break block8;
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrDocIDDetails"));
                query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"ACTION_CONFIG_ID").distinct());
                query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"RULE_HISTORY_ID"));
                query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"DOC_ID"));
                query.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_NAME"));
                query.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"DOC_HISTORY_ID"));
                query.addSortColumn(new SortColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"DOC_HISTORY_ID"), true));
                query.setCriteria(new Criteria(Column.getColumn((String)"CorrDocIDDetails", (String)"RULE_HISTORY_ID"), (Object)historyID_direct.toArray(new Long[historyID_direct.size()]), 8));
                query.addJoin(new Join("CorrDocIDDetails", "NoSqlIndexDetails", new String[]{"INDEX_ID"}, new String[]{"INDEX_ID"}, 2));
                liveDocIDs2 = null;
                Connection connection = null;
                DataSet dataSet = null;
                try {
                    RelationalAPI api = RelationalAPI.getInstance();
                    connection = api.getConnection();
                    dataSet = api.executeQuery((Query)query, connection);
                    liveDocIDs2 = CorrelationNosqlData.getFormattedDocIDInfo(historyID_direct, dataSet);
                    DBUtil.closeResultSetOrDataSet(null, dataSet);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                    break block7;
                }
                finally {
                    DBUtil.closeResultSetOrDataSet(null, dataSet);
                    DBUtil.closeStmtAndConnection(null, connection);
                }
                DBUtil.closeStmtAndConnection(null, connection);
            }
            if (liveDocIDs2 != null) {
                formattedDocIDs.putAll(liveDocIDs2);
            }
        }
        if (docID_archive != null && !docID_archive.isEmpty() && (liveDocIDs = CorrelationNosqlData.getFormattedDocIDInfoFromArchiveLimited(docID_archive)) != null) {
            formattedDocIDs.putAll(liveDocIDs);
        }
        return CorrelationNosqlData.searchIndexForCustomFields(formattedDocIDs, pack);
    }

    public static Map<Long, Map<Long, List<Map<String, Object>>>> searchIndexForCustomFields(Map<Long, Map<Long, Map<String, List<String>>>> formattedDocIDs, TimePack pack) throws DataAccessException {
        HashMap<Long, Map<Long, List<Map<String, Object>>>> searchedFieldInfo = new HashMap<Long, Map<Long, List<Map<String, Object>>>>();
        formattedDocIDs.forEach((historyID, docIDinfo) -> {
            HashMap extendedFields = new HashMap();
            docIDinfo.forEach((actionId, value) -> value.forEach((indexName, docIDs) -> {
                for (String docID : docIDs) {
                    try {
                        Map<String, Object> response = CorrNosqlIndexHandler.getIndexedDocInfo(indexName, docID, pack);
                        if (response == null) continue;
                        if (extendedFields.get(actionId) == null) {
                            extendedFields.put(actionId, new LinkedList());
                        }
                        ((List)extendedFields.get(actionId)).add(response);
                    }
                    catch (IndexNotFoundException exp) {
                        LOGGER.log(Level.INFO, "Index Not Found for log {0}", docID);
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                }
            }));
            searchedFieldInfo.put((Long)historyID, extendedFields);
        });
        return searchedFieldInfo;
    }

    private static String getAttribute(Map<String, Object> response, String[] searchKey) {
        for (String key : searchKey) {
            Object value = response.get(key);
            if (value == null || value.equals("-")) continue;
            return value.toString();
        }
        return null;
    }

    public static JSONArray getCorrIndexTimeLineView(Long historyID, TimeZone timezone, Locale locale, TimePack pack) throws DataAccessException {
        SelectQueryImpl sl = new SelectQueryImpl(Table.getTable((String)"CorrDocIDDetails"));
        sl.addJoin(new Join("CorrDocIDDetails", "CorrConfiguredActions", new String[]{"ACTION_CONFIG_ID"}, new String[]{"CONFIG_ID"}, 2));
        sl.addJoin(new Join("CorrDocIDDetails", "NoSqlIndexDetails", new String[]{"INDEX_ID"}, new String[]{"INDEX_ID"}, 2));
        sl.addJoin(new Join("CorrConfiguredActions", "CorrActionInfo", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
        sl.addSelectColumn(Column.getColumn((String)"CorrDocIDDetails", (String)"*"));
        sl.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"*"));
        sl.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"*"));
        sl.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID"));
        sl.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"DESCRIPTION"));
        sl.setCriteria(new Criteria(Column.getColumn((String)"CorrDocIDDetails", (String)"RULE_HISTORY_ID"), (Object)historyID, 0));
        DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)sl);
        HashMap<Long, String> actionDisplayName = new HashMap<Long, String>();
        Iterator allActions = dobj.getRows("CorrConfiguredActions");
        while (allActions.hasNext()) {
            Row action = (Row)allActions.next();
            Row actionInfoRow = dobj.getRow("CorrActionInfo", action);
            actionDisplayName.put((Long)action.get("CONFIG_ID"), ProductBundle.getInstance().getString(locale, (String)actionInfoRow.get("DESCRIPTION")));
        }
        Map<Long, Map<String, List<String>>> formattedDocIDs = CorrelationNosqlData.getFormattedDocIDInfo(historyID, dobj);
        return CorrelationNosqlData.getCorrHistoryTimeLineView(formattedDocIDs, actionDisplayName, timezone, locale, pack);
    }

    public static JSONArray getCorrIndexTimeLineViewFromArchivedData(Long historyID, Long docIDarchiveTableID, TimeZone timeZone, Locale locale, TimePack pack) throws DataAccessException {
        Map<Long, Map<Long, Map<Long, List<String>>>> unresolvedIndexAndDocIDMap = CorrelationArchivedData.get().getArchivedDocInfo(docIDarchiveTableID, historyID);
        Map<Long, Map<Long, Map<String, List<String>>>> resovedResponse = CorrelationNosqlData.resolveIndexNameFromIndexID(unresolvedIndexAndDocIDMap);
        Map<Long, Map<String, List<String>>> docIDInfo = resovedResponse.get(historyID);
        Set<Long> actionConfigID = docIDInfo.keySet();
        HashMap<Long, String> actionDisplayName = new HashMap<Long, String>();
        SelectQueryImpl sl = new SelectQueryImpl(Table.getTable((String)"CorrConfiguredActions"));
        sl.addJoin(new Join("CorrConfiguredActions", "CorrActionInfo", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
        sl.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
        sl.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID"));
        sl.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"DESCRIPTION"));
        sl.setCriteria(new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"), (Object)actionConfigID.toArray(new Long[actionConfigID.size()]), 8));
        DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)sl);
        Iterator allActions = dobj.getRows("CorrConfiguredActions");
        while (allActions.hasNext()) {
            Row action = (Row)allActions.next();
            Row actionInfo = dobj.getRow("CorrActionInfo", action);
            actionDisplayName.put((Long)action.get("CONFIG_ID"), ProductBundle.getInstance().getString(locale, (String)actionInfo.get("DESCRIPTION")));
        }
        return CorrelationNosqlData.getCorrHistoryTimeLineView(docIDInfo, actionDisplayName, timeZone, locale, pack);
    }

    private static JSONArray getCorrHistoryTimeLineView(Map<Long, Map<String, List<String>>> formattedDocIDs, Map<Long, String> actionDisplayName, TimeZone timezone, Locale locale, TimePack pack) throws DataAccessException {
        TreeMap orderedMap = new TreeMap();
        try {
            formattedDocIDs.forEach((actionID, indexMap) -> indexMap.forEach((index, docIDList) -> {
                for (String docID : docIDList) {
                    Map<String, Object> response = CorrNosqlIndexHandler.getIndexedDocInfo(index, docID, pack);
                    if (response == null) continue;
                    try {
                        ArrayList<JSONObject> docIDs;
                        Long time = Long.valueOf(response.get("TIME").toString());
                        JSONObject formattedResponse = CorrelationNosqlData.getIndexResponseResult(actionDisplayName, time, actionID, response, timezone, locale);
                        TreeMap<Long, ArrayList<JSONObject>> actionGroups = (TreeMap<Long, ArrayList<JSONObject>>)orderedMap.get(actionID);
                        if (actionGroups == null) {
                            actionGroups = new TreeMap<Long, ArrayList<JSONObject>>();
                            orderedMap.put(actionID, actionGroups);
                        }
                        if ((docIDs = (ArrayList<JSONObject>)actionGroups.get(time)) == null) {
                            docIDs = new ArrayList<JSONObject>();
                            actionGroups.put(time, docIDs);
                        }
                        docIDs.add(formattedResponse);
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                }
            }));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        JSONArray result = new JSONArray();
        orderedMap.descendingMap().values().stream().forEach(actionmap -> actionmap.descendingMap().values().stream().forEach(list -> list.forEach(arg_0 -> ((JSONArray)result).put(arg_0))));
        return result;
    }

    private static JSONObject getIndexResponseResult(Map<Long, String> actionDisplayName, Long time, Long actionID, Map<String, Object> response, TimeZone timezone, Locale locale) {
        JSONObject info = new JSONObject();
        try {
            info.put("TIME", (Object)DateFormatUtil.getFormattedTimeForClient_1(time, timezone));
            String message = CorrNosqlIndexHandler.getMessageField(response);
            if (message != null) {
                info.put("DISPLAY_TEXT", (Object)(message.length() < 100 ? message : message.substring(0, 100)));
            }
            info.put("ACTION_NAME", (Object)actionDisplayName.get(actionID));
            JSONArray completeData = new JSONArray();
            CorrelationNosqlData.normalizeFieldNames(response, locale);
            completeData.put((Object)new JSONObject().put("NAME", (Object)"TIME").put("VALUE", info.get("TIME")));
            response.forEach((key, value) -> {
                try {
                    completeData.put((Object)new JSONObject().put("NAME", key).put("VALUE", value));
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            });
            completeData.put((Object)new JSONObject().put("NAME", (Object)"MESSAGE").put("VALUE", (Object)message));
            info.put("COMPLETE_DATA", (Object)completeData);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return info;
    }

    public static void normalizeFieldNames(Map<String, Object> response, Locale locale) {
        List<String> valuesToRemove = Arrays.asList(LOG_INDEXER_KEY_COR_ACTION_ID, "cor_rule_id", "ACT_FLAG", "$id$", "HOSTID", "TIME", "DATE", "APPID", "FORMATID");
        response.keySet().removeAll(valuesToRemove);
        response.keySet().removeIf(fieldName -> fieldName.startsWith("ACTDATA"));
        response.keySet().removeIf(fieldName -> fieldName.startsWith("ACTION"));
        CorrCustomDataHandler.processCustomTextEntries(response, locale);
    }

    protected static Map<Long, Map<Long, Map<String, List<String>>>> getFormattedDocIDInfo(List<Long> historyIDList, DataSet dataSet) throws SQLException {
        HashMap<Long, Map<Long, Map<String, List<String>>>> historyDocInfo = new HashMap<Long, Map<Long, Map<String, List<String>>>>();
        while (dataSet.next()) {
            ArrayList<String> docIDList;
            HashMap<String, ArrayList<String>> actionvsIndex;
            Long actionID = dataSet.getAsLong(1);
            Long ruleHistoryID = dataSet.getAsLong(2);
            String docID = dataSet.getAsString(3);
            String indexName = dataSet.getAsString(4);
            HashMap docIDDetailsMap = (HashMap)historyDocInfo.get(ruleHistoryID);
            if (docIDDetailsMap == null) {
                docIDDetailsMap = new HashMap();
                historyDocInfo.put(ruleHistoryID, docIDDetailsMap);
            }
            if ((actionvsIndex = (HashMap<String, ArrayList<String>>)docIDDetailsMap.get(actionID)) == null) {
                actionvsIndex = new HashMap<String, ArrayList<String>>();
                docIDDetailsMap.put(actionID, actionvsIndex);
            }
            if ((docIDList = (ArrayList<String>)actionvsIndex.get(indexName)) == null) {
                docIDList = new ArrayList<String>();
                actionvsIndex.put(indexName, docIDList);
            }
            docIDList.add(docID);
        }
        return historyDocInfo;
    }

    private static Map<Long, Map<String, List<String>>> getFormattedDocIDInfo(Long historyID, DataObject dobj) throws DataAccessException {
        Criteria historyIDcriteria = new Criteria(Column.getColumn((String)"CorrDocIDDetails", (String)"RULE_HISTORY_ID"), (Object)historyID, 0);
        Iterator docIDItr = dobj.getRows("CorrDocIDDetails", historyIDcriteria);
        LinkedHashMap<Long, Map<String, List<String>>> docIDDetailsMap = new LinkedHashMap<Long, Map<String, List<String>>>();
        while (docIDItr.hasNext()) {
            Criteria indexCriteria;
            Row indexInfo;
            String indexName;
            ArrayList<String> docIDList;
            Row docIDRow = (Row)docIDItr.next();
            Long actionID = (Long)docIDRow.get("ACTION_CONFIG_ID");
            LinkedHashMap<String, ArrayList<String>> actionvsIndex = (LinkedHashMap<String, ArrayList<String>>)docIDDetailsMap.get(actionID);
            if (actionvsIndex == null) {
                actionvsIndex = new LinkedHashMap<String, ArrayList<String>>();
                docIDDetailsMap.put(actionID, actionvsIndex);
            }
            if ((docIDList = (ArrayList<String>)actionvsIndex.get(indexName = (String)(indexInfo = dobj.getRow("NoSqlIndexDetails", indexCriteria = new Criteria(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_ID"), docIDRow.get("INDEX_ID"), 0))).get("INDEX_NAME"))) == null) {
                docIDList = new ArrayList<String>();
                actionvsIndex.put(indexName, docIDList);
            }
            docIDList.add((String)docIDRow.get("DOC_ID"));
        }
        return docIDDetailsMap;
    }

    protected static Map<Long, Map<Long, Map<String, List<String>>>> getFormattedDocIDInfoFromArchiveLimited(Map<Long, List<Long>> docID_archive) throws DataAccessException {
        HashMap<Long, Map<Long, Map<Long, List<String>>>> unresolvedIndexAndDocIDMap = new HashMap<Long, Map<Long, Map<Long, List<String>>>>();
        docID_archive.forEach((docidtable, historyidList) -> {
            try {
                Map<Long, Map<Long, Map<Long, List<String>>>> indInfo = CorrelationArchivedData.get().getArchivedDocInfoLimited((Long)docidtable, (List<Long>)historyidList);
                if (indInfo != null && !indInfo.isEmpty()) {
                    unresolvedIndexAndDocIDMap.putAll(indInfo);
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        });
        return CorrelationNosqlData.resolveIndexNameFromIndexID(unresolvedIndexAndDocIDMap);
    }

    public static Map<Long, Map<Long, Map<String, List<String>>>> resolveIndexNameFromIndexID(Map<Long, Map<Long, Map<Long, List<String>>>> unresolvedIndexAndDocIDMap) throws DataAccessException {
        HashMap<Long, Map<Long, Map<String, List<String>>>> historyDocInfo = new HashMap<Long, Map<Long, Map<String, List<String>>>>();
        HashSet indexIDTobeResolved = new HashSet();
        unresolvedIndexAndDocIDMap.forEach((history, actionContainer) -> actionContainer.forEach((actionConfigID, indexContainer) -> indexIDTobeResolved.addAll(indexContainer.keySet())));
        Map<Long, String> indexInfo = CorrNosqlIndexHandler.getIndexName(indexIDTobeResolved.toArray(new Long[indexIDTobeResolved.size()]));
        unresolvedIndexAndDocIDMap.forEach((historyID, actionContainer) -> {
            HashMap actionContainercopy = new HashMap();
            actionContainer.forEach((actionConfigID, indexContainer) -> {
                HashMap indexContainercopy = new HashMap();
                indexContainer.forEach((indexID, docIDContainer) -> {
                    String indexName = (String)indexInfo.get(indexID);
                    if (indexName != null) {
                        indexContainercopy.put(indexName, docIDContainer);
                    }
                });
                actionContainercopy.put(actionConfigID, indexContainercopy);
            });
            historyDocInfo.put((Long)historyID, actionContainercopy);
        });
        return historyDocInfo;
    }
}

