/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.callback;

import com.adventnet.la.util.ProductBundle;
import com.adventnet.sa.server.nf.NotificationHandler;
import com.manageengine.ela.server.common.callback.CallBackArguments;
import com.manageengine.ela.server.common.callback.DocIdsResolvedCallBack;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;

public class CorrAuditHistoryResolvedCallBack
implements DocIdsResolvedCallBack {
    private Long ruleId;
    private Long startTime;
    private Long endTime;
    private Long notifId;
    private HashMap<Long, LinkedHashMap<String, Object>> docIds = new HashMap();
    private long remainingCount = 0L;

    public CorrAuditHistoryResolvedCallBack(Long ruleId, Long notifId, Long startTime, Long endTime, HashMap<Long, LinkedHashMap<String, Object>> actionIdsTodocIds) {
        this.ruleId = ruleId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.notifId = notifId;
        this.docIds = actionIdsTodocIds;
        this.docIds.entrySet().forEach(entry -> this.remainingCount += (long)((LinkedHashMap)entry.getValue()).size());
    }

    @Override
    public void setResolvedValues(Long actionId, String docId, Object resolvedValues) {
        if (resolvedValues != null) {
            long time = Long.parseLong(((Map)resolvedValues).get("TIME").toString());
            Date date = new Date(time);
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
            String timeString = dateFormat.format(date);
            ((Map)resolvedValues).put("ACTNDATE", timeString.substring(0, 11));
            ((Map)resolvedValues).put("ACTNTIME", timeString.substring(12, timeString.length()));
            this.docIds.get(actionId).put(docId, resolvedValues);
            --this.remainingCount;
        }
    }

    @Override
    public Map<Long, LinkedHashMap<String, Object>> getDocDetails() {
        return this.docIds;
    }

    public Long getRuleId() {
        return this.ruleId;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getNotifId() {
        return this.notifId;
    }

    @Override
    public void callBack(CallBackArguments arguments) {
        try {
            Hashtable<String, Object> log = new Hashtable<String, Object>();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ProductBundle instance = ProductBundle.getInstance();
            String commonMessage = instance.getString("ela.correlation.notif.alert.description");
            String ruleName = CorrelationUtil.getRuleName(this.ruleId);
            log.put("DISPLAY_NAME", "-");
            log.put("SOURCE", instance.getString("Correlation.Title"));
            log.put("MESSAGE", MessageFormat.format(commonMessage, ruleName));
            log.put("NOTIFID", this.notifId.toString());
            log.put("RULE_ID", this.ruleId);
            log.put("RULE_NAME", ruleName);
            log.put("START_TIME", dateFormat.format(this.startTime));
            log.put("TRIGGERED_TIME", dateFormat.format(this.endTime));
            log.put("TIME", this.endTime);
            log.put("FIELD_VALUES", this.docIds);
            NotificationHandler.addLogIntoQueue(log);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isEverythingIndexed() {
        return this.remainingCount == 0L;
    }
}

