/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.common.archive;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.correlation.auditdata.CorrCustomDataHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ArchivedData {
    protected abstract String getArchiveDataTableName();

    protected abstract String getBaseTableName();

    public abstract long getHistoryCount(String var1, Object var2, TimePack var3);

    public abstract Map<Long, Map<Long, Map<Long, List<String>>>> getArchivedDocInfoLimited(Long var1, List<Long> var2) throws DataAccessException;

    public List<Map<String, Object>> getArchivedTablesInfo(TimePack time) {
        long startTime = time.getStartTimeInLong();
        long endTime = time.getEndTimeInLong();
        String tableName = this.getArchiveDataTableName();
        Criteria first = new Criteria(Column.getColumn((String)tableName, (String)"START_TIME"), (Object)startTime, 6).and(new Criteria(Column.getColumn((String)tableName, (String)"END_TIME"), (Object)startTime, 4));
        Criteria second = new Criteria(Column.getColumn((String)tableName, (String)"START_TIME"), (Object)endTime, 6).and(new Criteria(Column.getColumn((String)tableName, (String)"END_TIME"), (Object)endTime, 4));
        Criteria third = new Criteria(Column.getColumn((String)tableName, (String)"START_TIME"), (Object)startTime, 4).and(new Criteria(Column.getColumn((String)tableName, (String)"END_TIME"), (Object)endTime, 6));
        return this.getArchivedTablesInfo(first.or(second).or(third));
    }

    public List<Map<String, Object>> getArchivedTablesInfoFromEnd(long endbeforeThis) {
        return this.getArchivedTablesInfo(new Criteria(Column.getColumn((String)this.getArchiveDataTableName(), (String)"END_TIME"), (Object)endbeforeThis, 6));
    }

    protected List<Map<String, Object>> getArchivedTablesInfo(Criteria criteria) {
        String tableName = this.getArchiveDataTableName();
        Table corrArchiveInfo = Table.getTable((String)tableName);
        ArrayList<Map<String, Object>> archivedTables = new ArrayList<Map<String, Object>>();
        SelectQueryImpl query = new SelectQueryImpl(corrArchiveInfo);
        query.addJoin(new Join(corrArchiveInfo, Table.getTable((String)"ArchiveTableDetails", (String)"HISTORY_TABLE"), new String[]{"HISTORY_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 2));
        query.addJoin(new Join(corrArchiveInfo, Table.getTable((String)"ArchiveTableDetails", (String)"DOCID_TABLE"), new String[]{"DOCID_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 2));
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"ARCHIVE_ID"), true));
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (dobj.isEmpty()) {
                return archivedTables;
            }
            Iterator itr = dobj.getRows(tableName);
            while (itr.hasNext()) {
                HashMap<String, Object> tableMap = new HashMap<String, Object>();
                Row row = (Row)itr.next();
                Criteria archiveFile = new Criteria(Column.getColumn((String)"HISTORY_TABLE", (String)"ARCHIVE_TABLE_ID"), row.get("HISTORY_TABLE_ID"), 0);
                Row historytableRow = dobj.getRow("HISTORY_TABLE", archiveFile);
                tableMap.put((String)historytableRow.get("ACTUAL_TABLENAME"), (String)historytableRow.get("ARCHIVED_TABLENAME"));
                archiveFile = new Criteria(Column.getColumn((String)"DOCID_TABLE", (String)"ARCHIVE_TABLE_ID"), row.get("DOCID_TABLE_ID"), 0);
                Row docIDtableRow = dobj.getRow("DOCID_TABLE", archiveFile);
                tableMap.put((String)docIDtableRow.get("ACTUAL_TABLENAME"), (String)docIDtableRow.get("ARCHIVED_TABLENAME"));
                tableMap.put("DOCID_ARCHIVED_TABLE_ID", row.get("DOCID_TABLE_ID"));
                tableMap.put("START_TIME", row.get("START_TIME"));
                tableMap.put("END_TIME", row.get("END_TIME"));
                archivedTables.add(tableMap);
            }
            return archivedTables;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return archivedTables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Long, Map<Long, Map<Long, List<String>>>> getArchivedDocIDInfo(SelectQuery query) throws DataAccessException {
        HashMap<Long, Map<Long, Map<Long, List<String>>>> indInfo;
        block9: {
            indInfo = new HashMap<Long, Map<Long, Map<Long, List<String>>>>();
            Connection connection = null;
            DataSet dataSet = null;
            try {
                RelationalAPI api = RelationalAPI.getInstance();
                connection = api.getConnection();
                dataSet = api.getArchiveAdapter().getArchiveData(query, connection);
                while (dataSet.next()) {
                    ArrayList<String> docIDContainer;
                    HashMap<Long, ArrayList<String>> actionContainer;
                    Long actionID = dataSet.getAsLong(1);
                    Long docHistoryId = dataSet.getAsLong(2);
                    Long indexID = dataSet.getAsLong(3);
                    String docID = dataSet.getAsString(4);
                    HashMap historyIDContainer = (HashMap)indInfo.get(docHistoryId);
                    if (historyIDContainer == null) {
                        historyIDContainer = new HashMap();
                        indInfo.put(docHistoryId, historyIDContainer);
                    }
                    if ((actionContainer = (HashMap<Long, ArrayList<String>>)historyIDContainer.get(actionID)) == null) {
                        actionContainer = new HashMap<Long, ArrayList<String>>();
                        historyIDContainer.put(actionID, actionContainer);
                    }
                    if ((docIDContainer = (ArrayList<String>)actionContainer.get(indexID)) == null) {
                        docIDContainer = new ArrayList<String>();
                        actionContainer.put(indexID, docIDContainer);
                    }
                    docIDContainer.add(docID);
                }
                DBUtil.closeResultSetOrDataSet(null, dataSet);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break block9;
            }
            finally {
                DBUtil.closeResultSetOrDataSet(null, dataSet);
                DBUtil.closeStmtAndConnection(null, connection);
            }
            DBUtil.closeStmtAndConnection(null, connection);
        }
        return indInfo;
    }

    public long getHistoryCount(List<Map<String, Object>> fileList, Object ruleID, TimePack timePack) {
        long count = 0L;
        int listSize = fileList.size();
        if (listSize == 0) {
            return count;
        }
        for (int index = 0; index < listSize; ++index) {
            Map<String, Object> tableInfo = fileList.get(index);
            String customTableName = (String)tableInfo.get(this.getBaseTableName());
            count += this.getHistoryCount(customTableName, ruleID, timePack);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public long fillArchiveTrendInformation(SelectQuery query, long interval, Map<Long, Long> timeMap) throws SQLException {
        block5: {
            long l;
            Connection connection = null;
            DataSet dataSet = null;
            try {
                RelationalAPI api = RelationalAPI.getInstance();
                connection = api.getConnection();
                dataSet = api.getArchiveAdapter().getArchiveData(query, connection);
                l = CorrCustomDataHandler.fillTrendData(dataSet, interval, timeMap);
                DBUtil.closeResultSetOrDataSet(null, dataSet);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                break block5;
            }
            finally {
                DBUtil.closeResultSetOrDataSet(null, dataSet);
                DBUtil.closeStmtAndConnection(null, connection);
            }
            DBUtil.closeStmtAndConnection(null, connection);
            return l;
        }
        return 0L;
    }

    public String getArchivedTableName(Long archivetableID) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"ArchiveTableDetails", (String)"ARCHIVE_TABLE_ID"), (Object)archivetableID, 0);
        DataObject dobj = PersistenceDBUtil.getPersistence().get("ArchiveTableDetails", criteria);
        return (String)dobj.getFirstValue("ArchiveTableDetails", "ARCHIVED_TABLENAME");
    }
}

