/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.common.data;

import com.manageengine.ela.server.common.database.DBCleanupProcessor;
import com.manageengine.ela.server.correlation.common.data.PreProcessDataHandler;
import com.manageengine.ela.server.correlation.core.CorrelationRuleContainer;
import com.manageengine.ela.server.correlation.core.analyzer.selector.CorrPreProcessDataHandler;
import com.manageengine.ela.server.correlation.core.data.RuleContainer;
import com.manageengine.ela.server.correlation.core.schedule.CorrelationColdDataProcessor;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.data.ActPreProcessDataHandler;
import com.manageengine.ela.server.correlation.session.schedule.ActColdDataProcessor;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.joda.time.DateTime;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonDataHelper {
    private static final Logger LOGGER = Logger.getLogger(CommonDataHelper.class.getName());

    public static PreProcessDataHandler getPreProcessDataHandler(RuleContainer ruleContainer) {
        Long ruleID = ruleContainer.getId();
        if (CorrelationRuleContainer.isRuleRegistered(ruleID).booleanValue()) {
            return new CorrPreProcessDataHandler(ruleID, ruleContainer.getDirectMap(), ruleContainer.getConfiguedActions());
        }
        return new ActPreProcessDataHandler(ruleID, ruleContainer.getConfiguedActions(), ruleContainer.getDirectMap(), ActivityRuleType.INIT_TERMINATOR_RULE);
    }

    public static NavigableSet<JSONObject> mergeResults(Map<Long, JSONObject> dataOne, Map<Long, JSONObject> dataTwo, boolean sortAscending) {
        TreeSet<JSONObject> recentData = new TreeSet<JSONObject>((one, two) -> {
            try {
                Long hits1 = one.getLong("HITS");
                Long hits2 = two.getLong("HITS");
                if (hits2 >= hits1) {
                    return 1;
                }
                if (hits2 < hits1) {
                    return -1;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return 0;
        });
        dataOne.forEach((ruleID, jsonObject) -> {
            try {
                jsonObject = jsonObject.put("RULE_ID", ruleID);
                jsonObject = jsonObject.put("TYPE", 1);
                recentData.add((JSONObject)jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        });
        dataTwo.forEach((ruleID, jsonObject) -> {
            try {
                jsonObject = jsonObject.put("RULE_ID", ruleID);
                jsonObject = jsonObject.put("TYPE", 2);
                recentData.add((JSONObject)jsonObject);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        });
        if (sortAscending) {
            return recentData;
        }
        return recentData.descendingSet();
    }

    public static TreeMap<Long, Long> normalizeGraphData(long interval, TreeMap<Long, Long> map) {
        if (map.size() <= 1) {
            return map;
        }
        Long point = map.firstKey();
        Long lastTime = map.lastKey();
        while (point < lastTime) {
            if (!map.containsKey(point)) {
                map.put(point, 0L);
            }
            point = CommonDataHelper.getNextTime(point, interval);
        }
        return map;
    }

    private static Long getNextTime(Long point, Long interval) {
        DateTime dateTime = new DateTime((Object)point);
        dateTime = interval == 31536000000L ? dateTime.plusYears(1) : (interval == 2678400000L ? dateTime.plusMonths(1) : (interval == 86400000L ? dateTime.plusDays(1) : (interval == 3600000L ? dateTime.plusHours(1) : (interval == 60000L ? dateTime.plusMinutes(1) : dateTime.plusSeconds(1)))));
        return dateTime.getMillis();
    }

    public static void initializeArchiveProcessors() {
        DBCleanupProcessor.registerCleanupTask(new CorrelationColdDataProcessor());
        DBCleanupProcessor.registerCleanupTask(new ActColdDataProcessor());
    }
}

