/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.common.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutorServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(ExecutorServiceHandler.class.getName());
    private static final List<ExecutorService> EXECUTOR_LIST = Collections.synchronizedList(new ArrayList());

    public static void registerExecutorForShutdown(ExecutorService service) {
        EXECUTOR_LIST.add(service);
    }

    public static void removeExecutor(ExecutorService service) {
        EXECUTOR_LIST.remove(service);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LOGGER.log(Level.INFO, "Shutting down {0} executors.", EXECUTOR_LIST.size());
            for (ExecutorService executorService : EXECUTOR_LIST) {
                try {
                    executorService.shutdown();
                }
                catch (Exception exp) {
                    LOGGER.log(Level.INFO, "Exception occurred during executor service shutdown {0}", new Object[]{exp});
                }
            }
        }));
    }
}

