/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.delegation.info.UserAccessResource;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.config.CorrelationRuleHandler;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.notification.CorrNFProfile;
import com.manageengine.ela.server.correlation.notification.CorrNFProfileHandler;
import com.manageengine.ela.server.correlation.notification.CorrelationNotificationHandler;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import com.zoho.za.ela.logsearch.criteria.ConvertToLuceneSyntax;
import com.zoho.za.ela.logsearch.criteria.JSONCriteriaHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CorrelationConfigHandler {
    private static int maximum_threshold_hits = 999;

    public static CorrRuleConfigData reConfigureCorrelationRule(JSONObject jsonObject, Locale locale) throws BaseStatusCode {
        try {
            Long ruleId = jsonObject.getLong("RULE_ID");
            DataObject dobj = CorrelationConfigHandler.getUpdatedRuleInfoDobj(jsonObject, CorrelationUtil.getCorrelationRuleCompleteData(ruleId), locale);
            Row ruleInfo = dobj.getFirstRow("CorrRuleInfo");
            CorrRuleConfigData configData = CorrelationConfigHandler.updateActionAndGetDeletedAction(jsonObject, ruleInfo, dobj);
            Set<Long> deletedActionSet = configData.getDeletedActionIDSet();
            PersistenceDBUtil.getPersistence().update(dobj);
            if (jsonObject.optBoolean("CONF_CHANGED", false)) {
                CorrelationNotificationHandler.getInstance().reconfigureAlertMailContent(ruleId);
            }
            CorrelationRuleHandler.postRuleModificationCall(ruleId, deletedActionSet != null ? deletedActionSet.toArray(new Long[deletedActionSet.size()]) : null);
            return configData;
        }
        catch (BaseStatusCode statusCode) {
            throw statusCode;
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static boolean addNewCorrelationRule(JSONObject jsonObject, UserAccessResource accessControl, Locale locale) throws BaseStatusCode {
        try {
            if (CorrelationUtil.checkIfRuleAvailable(jsonObject.getString("RULE_NAME"), locale)) {
                throw BaseStatusCode.getBaseStatusCode(7432);
            }
            DataObject dobj = PersistenceDBUtil.getPersistence().constructDataObject();
            Row ruleInfo = new Row("CorrRuleInfo");
            JSONObject category = jsonObject.getJSONObject("CATEGORY");
            if (category.has("ID")) {
                ruleInfo.set("CATEGORY_ID", (Object)category.getLong("ID"));
            } else if (category.has("NAME") && !category.getString("NAME").trim().isEmpty()) {
                long categoryID = CorrelationUtil.getCategoryIDIfAvailable(category.getString("NAME").trim(), locale);
                if (categoryID == -1L) {
                    Row ruleCategory = new Row("CorrRuleCategory");
                    ruleCategory.set("DISPLAY_NAME", (Object)category.getString("NAME"));
                    dobj.addRow(ruleCategory);
                    ruleInfo.set("CATEGORY_ID", ruleCategory.get("CATEGORY_ID"));
                } else {
                    ruleInfo.set("CATEGORY_ID", (Object)categoryID);
                }
            } else {
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
            if (jsonObject.getString("RULE_NAME").length() > 50) {
                throw new Exception();
            }
            ruleInfo.set("AUTHOR", (Object)accessControl.getUserID());
            ruleInfo.set("RULE_DISPLAY_NAME", (Object)jsonObject.getString("RULE_NAME"));
            ruleInfo.set("DESCRIPTION", (Object)jsonObject.optString("DESCRIPTION", null));
            ruleInfo.set("IS_EDITABLE", (Object)Boolean.TRUE);
            ruleInfo.set("IS_SYSTEMGENERATED", (Object)Boolean.FALSE);
            ruleInfo.set("STATUS", (Object)CorrelationStatus.ENABLE.getValue());
            ruleInfo.set("REPORT_ENABLED", (Object)jsonObject.optBoolean("REPORT_ENABLED", Boolean.FALSE.booleanValue()));
            dobj.addRow(ruleInfo);
            JSONArray actionConfig = jsonObject.getJSONArray("ACTIONS");
            JSONObject sharedLinkConfig = jsonObject.getJSONObject("SHARED_LINKS");
            Map<Long, Long> actionMap = CorrelationConfigHandler.fillActionConfigurations(actionConfig, sharedLinkConfig, ruleInfo, dobj);
            CorrelationConfigHandler.fillCorrTableViewConfig(ruleInfo.get("RULE_ID"), actionMap, dobj);
            CorrelationConfigHandler.fillAlertNotificationInfo(jsonObject.getString("RULE_NAME"), accessControl.getUserID(), -1002L, ruleInfo.get("RULE_ID"), dobj);
            dobj = PersistenceDBUtil.getPersistence().update(dobj);
            Long ruleID = (Long)dobj.getFirstValue("CorrRuleInfo", "RULE_ID");
            Long notifID = (Long)dobj.getFirstValue("NotificationType", "NOTIFID");
            NotificationManager.getInstance().changeProfNotificationStatus(notifID, false);
            CorrelationRuleHandler.postRuleAddCall(ruleID);
        }
        catch (BaseStatusCode baseStatusCode) {
            throw baseStatusCode;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return true;
    }

    private static CorrRuleConfigData updateActionAndGetDeletedAction(JSONObject ruleConfig, Row rulInfo, DataObject dobj) throws JSONException, DataAccessException, BaseStatusCode {
        HashSet<Long> notDeletedConfigID = new HashSet<Long>();
        HashSet<Long> deletedActionID = new HashSet<Long>();
        HashMap<String, Long> UIDMap = new HashMap<String, Long>();
        JSONArray actionConfig = ruleConfig.getJSONArray("ACTIONS");
        for (int index = 0; index < actionConfig.length(); ++index) {
            JSONObject actionInfo = actionConfig.getJSONObject(index);
            if (!actionInfo.has("CONFIG_ID")) continue;
            notDeletedConfigID.add(actionInfo.getLong("CONFIG_ID"));
        }
        Criteria delCriteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"), (Object)notDeletedConfigID.toArray(new Long[notDeletedConfigID.size()]), 9);
        Iterator deletedActionsItr = dobj.getRows("CorrConfiguredActions", delCriteria);
        while (deletedActionsItr.hasNext()) {
            Row deletedAction = (Row)deletedActionsItr.next();
            dobj.deleteRow(deletedAction);
            deletedActionID.add((Long)deletedAction.get("ACTION_ID"));
        }
        JSONObject sharedLinkConfig = ruleConfig.getJSONObject("SHARED_LINKS");
        CorrelationConfigHandler.fillActionConfigurations(actionConfig, sharedLinkConfig, UIDMap, rulInfo, dobj);
        return CorrRuleConfigData.getCorrRuleConfigData(UIDMap, deletedActionID);
    }

    public static void fillAlertNotificationInfo(String ruleName, long userID, long notifType, Object ruleID, DataObject dobj) throws DataAccessException {
        Row criteria_row = new Row("LACriteria");
        criteria_row.set("CRITERIA_NAME", (Object)ruleName);
        dobj.addRow(criteria_row);
        Row expression_row = new Row("LAExpression");
        expression_row.set("TABLE_NAME", (Object)"EventLog");
        expression_row.set("COLUMN_NAME", (Object)"EnableHostsStatus");
        expression_row.set("COMPARATOR", (Object)"=");
        expression_row.set("VALUE", (Object)"true");
        dobj.addRow(expression_row);
        Row row = new Row("LACriteria2Expressions");
        row.set("CRIT_ID", criteria_row.get("CRIT_ID"));
        row.set("EXP_ID", expression_row.get("EXP_ID"));
        dobj.addRow(row);
        row = new Row("NotificationType");
        row.set("NOTIFID", criteria_row.get("CRIT_ID"));
        row.set("NOTIFNAME", (Object)ruleName);
        row.set("TYPE", (Object)notifType);
        row.set("NOOFOCCURRENCE", (Object)1);
        row.set("NOTIFINTERVAL", (Object)1);
        row.set("STATUS", (Object)0);
        row.set("CRITICALITY", (Object)"High");
        row.set("TRIGGERTIME", (Object)0);
        dobj.addRow(row);
        row = new Row("NotfnConfigType");
        row.set("NOTIFID", criteria_row.get("CRIT_ID"));
        row.set("NOTIFTYPE", (Object)"POPUP");
        dobj.addRow(row);
        row = new Row("UserToNotificationType");
        row.set("NOTIFID", criteria_row.get("CRIT_ID"));
        row.set("USER_ID", (Object)userID);
        dobj.addRow(row);
        Row mappingRow = new Row("CorrNotificationMapping");
        mappingRow.set("NOTIFID", criteria_row.get("CRIT_ID"));
        mappingRow.set("RULE_ID", ruleID);
        dobj.addRow(mappingRow);
    }

    public static Map<Long, Long> fillActionConfigurations(JSONArray actionConfig, JSONObject sharedLinkConfig, Row rulInfo, DataObject dobj) throws JSONException, DataAccessException, BaseStatusCode {
        return CorrelationConfigHandler.fillActionConfigurations(actionConfig, sharedLinkConfig, new HashMap<String, Long>(), rulInfo, dobj);
    }

    public static Map<Long, Long> fillActionConfigurations(JSONArray actionConfig, JSONObject sharedLinkConfig, Map<String, Long> actionUID2ConfigMap, Row rulInfo, DataObject dobj) throws JSONException, DataAccessException, BaseStatusCode {
        HashMap<Long, Long> actionMap = new HashMap<Long, Long>();
        List<String> tableList = Arrays.asList("CorrActionCondnFields", "NoSqlIndexFields", "NoSqlIndexCriteria", "NoSqlIndexCriteriaFields");
        DataObject fieldConditionDobj = PersistenceDBUtil.getPersistence().get(tableList, (Criteria)null);
        for (int index = 0; index < actionConfig.length(); ++index) {
            JSONObject actionData = actionConfig.getJSONObject(index);
            if (actionData.optInt("THRESHOLD_HITS") > maximum_threshold_hits) {
                throw BaseStatusCode.getBaseStatusCode(12291);
            }
            Boolean isUpdate = actionData.has("CONFIG_ID");
            Row configuredAction = null;
            Row actionDynamics = null;
            if (isUpdate.booleanValue()) {
                Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"), actionData.get("CONFIG_ID"), 0);
                configuredAction = dobj.getRow("CorrConfiguredActions", criteria);
                criteria = new Criteria(Column.getColumn((String)"CorrActionDynamics", (String)"ACTION_CONFIG_ID"), actionData.get("CONFIG_ID"), 0);
                actionDynamics = dobj.getRow("CorrActionDynamics", criteria);
                criteria = new Criteria(Column.getColumn((String)"CorrActionGroups", (String)"ACTION_CONFIG_ID"), actionData.get("CONFIG_ID"), 0);
                dobj.deleteRows("CorrActionGroups", criteria);
            } else {
                configuredAction = new Row("CorrConfiguredActions");
                DataAccess.generateValues((Row)configuredAction);
                configuredAction.set("RULE_ID", rulInfo.get("RULE_ID"));
                configuredAction.set("ACTION_ID", (Object)actionData.getLong("ACTION_ID"));
                actionDynamics = new Row("CorrActionDynamics");
                actionDynamics.set("ACTION_CONFIG_ID", configuredAction.get("CONFIG_ID"));
            }
            configuredAction.set("CONFIG_ORDER", (Object)index);
            actionDynamics.set("FOLLOWEDBY_TIME", actionData.opt("FOLLOWEDBY_TIME"));
            actionDynamics.set("THRESHOLD_HITS", (Object)actionData.optInt("THRESHOLD_HITS", 1));
            actionDynamics.set("THRESHOLD_TIME", actionData.opt("THRESHOLD_TIME"));
            JSONArray groups = actionData.getJSONArray("GROUPS");
            for (int groupIndex = 0; groupIndex < groups.length(); ++groupIndex) {
                JSONObject group = groups.getJSONObject(groupIndex);
                Row groupRow = new Row("CorrActionGroups");
                DataAccess.generateValues((Row)groupRow);
                groupRow.set("ACTION_CONFIG_ID", configuredAction.get("CONFIG_ID"));
                groupRow.set("GROUP_ORDER", (Object)groupIndex);
                groupRow.set("LINK_TO_PREV", (Object)group.optInt("LINK_TO_PREV", 0));
                dobj.addRow(groupRow);
                JSONArray conditions = group.getJSONArray("CONDITIONS");
                for (int conditionIndex = 0; conditionIndex < conditions.length(); ++conditionIndex) {
                    JSONObject condition = conditions.getJSONObject(conditionIndex);
                    Row conditionRow = new Row("CorrActionConditions");
                    DataAccess.generateValues((Row)conditionRow);
                    conditionRow.set("GROUP_ID", groupRow.get("GROUP_ID"));
                    conditionRow.set("FIELD_ID", (Object)condition.getLong("FIELD_ID"));
                    conditionRow.set("CONDITION_ORDER", (Object)conditionIndex);
                    conditionRow.set("LINK_TO_PREV", (Object)condition.optInt("LINK_TO_PREV", 0));
                    if (!CorrelationUtil.isValidOperation(fieldConditionDobj, condition.getInt("TYPE"), condition.getInt("OPERATION"), condition.getLong("FIELD_ID"), actionData.getLong("ACTION_ID"))) {
                        throw BaseStatusCode.getBaseStatusCode(12292);
                    }
                    switch (condition.getInt("TYPE")) {
                        case 0: {
                            Row comparisonRow = new Row("CorrCondnComparisons");
                            comparisonRow.set("CONDITION_ID", conditionRow.get("CONDITION_ID"));
                            comparisonRow.set("CRITERIA_STRING", (Object)condition.getString("CRITERIA_STRING"));
                            dobj.addRow(comparisonRow);
                            break;
                        }
                        case 1: {
                            Row uniqueRow = new Row("CorrCondnUniqueConstrain");
                            uniqueRow.set("CONDITION_ID", conditionRow.get("CONDITION_ID"));
                            dobj.addRow(uniqueRow);
                            break;
                        }
                    }
                    conditionRow.set("OPERATION", (Object)condition.getInt("OPERATION"));
                    dobj.addRow(conditionRow);
                }
            }
            if (isUpdate.booleanValue()) {
                dobj.updateRow(configuredAction);
                dobj.updateRow(actionDynamics);
            } else {
                dobj.addRow(configuredAction);
                dobj.addRow(actionDynamics);
            }
            actionMap.put(actionData.getLong("ACTION_ID"), (Long)configuredAction.get("CONFIG_ID"));
            actionUID2ConfigMap.put(actionData.getString("ACTION_UID"), (Long)configuredAction.get("CONFIG_ID"));
        }
        CorrelationConfigHandler.fillCorrSharedLinks(dobj, fieldConditionDobj, actionUID2ConfigMap, sharedLinkConfig);
        return actionMap;
    }

    private static void fillCorrSharedLinks(DataObject dobj, DataObject fieldConditionDobj, Map<String, Long> actionUID2ConfigMap, JSONObject sharedLinkConfig) throws BaseStatusCode {
        Iterator iter = sharedLinkConfig.keys();
        while (iter.hasNext()) {
            try {
                String actionUID = (String)iter.next();
                Long actionConfigID = actionUID2ConfigMap.get(actionUID);
                JSONObject fieldLinks = sharedLinkConfig.getJSONObject(actionUID);
                Iterator fieldLinkIter = fieldLinks.keys();
                while (fieldLinkIter.hasNext()) {
                    String fieldId = (String)fieldLinkIter.next();
                    Long fieldConfigId = Long.parseLong(fieldId);
                    JSONObject linkedActionList = fieldLinks.getJSONObject(fieldId);
                    Iterator linkedActionIter = linkedActionList.keys();
                    if (!linkedActionIter.hasNext()) continue;
                    Criteria criteria = new Criteria(Column.getColumn((String)"CorrActionGroups", (String)"ACTION_CONFIG_ID"), (Object)actionConfigID, 0);
                    Iterator groups = dobj.getRows("CorrActionGroups", criteria);
                    Long linkedConditionId = null;
                    Row conditionType = fieldConditionDobj.getRow("NoSqlIndexCriteria", new Criteria(Column.getColumn((String)"NoSqlIndexCriteria", (String)"TYPE"), (Object)2, 0));
                    while (groups.hasNext()) {
                        Row row = (Row)groups.next();
                        Long groupId = (Long)row.get("GROUP_ID");
                        Criteria criteria1 = new Criteria(Column.getColumn((String)"CorrActionConditions", (String)"GROUP_ID"), (Object)groupId, 0);
                        criteria1 = criteria1.and(new Criteria(Column.getColumn((String)"CorrActionConditions", (String)"OPERATION"), conditionType.get("OPERATION"), 0));
                        Row conditionRow = dobj.getRow("CorrActionConditions", criteria1 = criteria1.and(new Criteria(Column.getColumn((String)"CorrActionConditions", (String)"FIELD_ID"), (Object)fieldConfigId, 0)));
                        if (conditionRow == null) continue;
                        linkedConditionId = (Long)conditionRow.get("CONDITION_ID");
                        break;
                    }
                    if (linkedConditionId == null) {
                        Row groupRow = new Row("CorrActionGroups");
                        DataAccess.generateValues((Row)groupRow);
                        groupRow.set("ACTION_CONFIG_ID", (Object)actionConfigID);
                        groupRow.set("GROUP_ORDER", (Object)0);
                        groupRow.set("LINK_TO_PREV", (Object)0);
                        groupRow.set("REPRESENTATION_TYPE", (Object)1);
                        dobj.addRow(groupRow);
                        Row conditionRow = new Row("CorrActionConditions");
                        DataAccess.generateValues((Row)conditionRow);
                        conditionRow.set("GROUP_ID", groupRow.get("GROUP_ID"));
                        conditionRow.set("FIELD_ID", (Object)fieldConfigId);
                        conditionRow.set("CONDITION_ORDER", (Object)0);
                        conditionRow.set("LINK_TO_PREV", (Object)0);
                        conditionRow.set("OPERATION", conditionType.get("OPERATION"));
                        dobj.addRow(conditionRow);
                        linkedConditionId = (Long)conditionRow.get("CONDITION_ID");
                    }
                    while (linkedActionIter.hasNext()) {
                        String linkedActionUID = (String)linkedActionIter.next();
                        JSONObject linkedAction = linkedActionList.getJSONObject(linkedActionUID);
                        Row row = new Row("CorrConditionLinkedFields");
                        row.set("CONDITION_ID", linkedConditionId);
                        row.set("LINKED_ACTION_CONFIG_ID", (Object)actionUID2ConfigMap.get(linkedActionUID));
                        row.set("LINKED_FIELD_ID", (Object)linkedAction.getLong("fieldId"));
                        row.set("IS_IMPLIED", (Object)linkedAction.optBoolean("isImplied", false));
                        dobj.addRow(row);
                    }
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(7428);
            }
        }
    }

    private static void fillCorrTableViewConfig(Object ruleId, Map<Long, Long> actionMap, DataObject dataObject) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(new Table("CorrActionCondnFields"));
        selectQuery.addJoin(new Join("CorrActionCondnFields", "NoSqlIndexFields", new String[]{"CONDN_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"*"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"), (Object)actionMap.keySet().toArray(), 8).and(new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"TABLECOLUMN_ALLOWED"), (Object)true, 0)));
        DataObject db = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        Iterator iterator = db.getRows("CorrActionCondnFields");
        int counter = 0;
        HashSet<String> selectedFields = new HashSet<String>();
        while (iterator.hasNext()) {
            Row corrActionCondnField = (Row)iterator.next();
            Long condn_field_id = (Long)corrActionCondnField.get("CONDN_FIELD_ID");
            Long fieldConfigID = (Long)corrActionCondnField.get("FIELD_CONFIG_ID");
            Long actionID = (Long)corrActionCondnField.get("ACTION_ID");
            Long actionConfigID = actionMap.get(actionID);
            Row noSqlIndex = db.getRow("NoSqlIndexFields", new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), (Object)condn_field_id, 0));
            String displayName = (String)noSqlIndex.get("FIELD_DISPLAY_NAME");
            if (!selectedFields.contains(displayName)) {
                Row corrTableViewConfig = new Row("CorrTableViewConfig");
                corrTableViewConfig.set("RULE_ID", ruleId);
                corrTableViewConfig.set("ACTION_CONFIG_ID", (Object)actionConfigID);
                corrTableViewConfig.set("FIELD_CONFIG_ID", (Object)fieldConfigID);
                corrTableViewConfig.set("DISPLAY_NAME", (Object)displayName);
                corrTableViewConfig.set("IS_RESOLVED", (Object)Boolean.TRUE);
                selectedFields.add(displayName);
                dataObject.addRow(corrTableViewConfig);
                ++counter;
            }
            if (counter <= 2) continue;
            return;
        }
    }

    public static boolean updateCorrelationInfo(JSONObject jsonObject, Locale locale) throws JSONException {
        try {
            Long[] ruleId = CorrelationConfigHandler.jsonArrayToLongarray(jsonObject.getJSONArray("RULE_ID"));
            DataObject dobj = CorrelationUtil.getCorrelationRuleInfoDO(ruleId);
            PersistenceDBUtil.getPersistence().update(CorrelationConfigHandler.getUpdatedRuleInfoDobj(jsonObject, dobj, locale));
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean enableDisableCorrelationRule(JSONArray ruleID, CorrelationStatus status) throws JSONException {
        try {
            Long[] ruleIDs = ruleID == null ? CorrelationUtil.getAllConfiguredRuleIds() : CorrelationConfigHandler.jsonArrayToLongarray(ruleID);
            DataBaseReqestProcessor.executeUpdateQuery("CorrRuleInfo", "STATUS", status.getValue(), new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleIDs, 8), new boolean[0]);
            CorrelationRuleHandler.postRuleEnableDisableCall(status, ruleIDs);
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean enableDisableCorrelationNotification(JSONArray ruleIDs, Boolean status) throws JSONException {
        try {
            int totalIds = ruleIDs.length();
            ArrayList<Long> notifIDs = new ArrayList<Long>(totalIds);
            ArrayList<Long> ruleIDList = new ArrayList<Long>(totalIds);
            for (int index = 0; index < totalIds; ++index) {
                CorrNFProfile profile = CorrNFProfileHandler.getNotificationProfile(ruleIDs.getLong(index));
                if (profile == null) continue;
                notifIDs.add(profile.getNfID());
                ruleIDList.add(ruleIDs.getLong(index));
            }
            DataBaseReqestProcessor.executeUpdateQuery("NotificationType", "STATUS", status != false ? 1 : 0, new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifIDs.toArray(), 8), new boolean[0]);
            if (status.booleanValue()) {
                notifIDs.forEach(notifID -> NotificationManager.getInstance().changeProfNotificationStatus((long)notifID, true));
            } else {
                notifIDs.forEach(notifID -> NotificationManager.getInstance().changeProfNotificationStatus((long)notifID, false));
            }
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static void toggleCorrelationNotificationStatus(Long notifID) {
        SelectQueryImpl select = new SelectQueryImpl(new Table("CorrNotificationMapping"));
        select.addSelectColumn(Column.getColumn((String)"CorrNotificationMapping", (String)"*"));
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)select);
            Iterator iterator = dobj.getRows("CorrNotificationMapping", new Criteria(Column.getColumn((String)"CorrNotificationMapping", (String)"NOTIFID"), (Object)notifID, 0));
            JSONArray ruleIDArray = new JSONArray();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (row == null) continue;
                ruleIDArray.put(row.get("RULE_ID"));
            }
            SelectQueryImpl notifQuery = new SelectQueryImpl(new Table("NotificationType"));
            notifQuery.addSelectColumn(Column.getColumn((String)"NotificationType", (String)"*"));
            notifQuery.setCriteria(new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifID, 0));
            dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)notifQuery);
            Row notifRow = dobj.getFirstRow("NotificationType");
            if (notifRow != null) {
                Integer status = (Integer)notifRow.get("STATUS");
                if (status > 0) {
                    CorrelationConfigHandler.enableDisableCorrelationNotification(ruleIDArray, false);
                } else {
                    CorrelationConfigHandler.enableDisableCorrelationNotification(ruleIDArray, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean enableDisableCorrelationReport(JSONArray ruleID, Boolean status) throws JSONException {
        try {
            DataBaseReqestProcessor.executeUpdateQuery("CorrRuleInfo", "REPORT_ENABLED", status, new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)CorrelationConfigHandler.jsonArrayToLongarray(ruleID), 8), new boolean[0]);
            return true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    public static boolean deleteCorrelationRule(long ruleID) throws JSONException {
        try {
            if (CorrelationUtil.isEditableRule(ruleID).booleanValue()) {
                DataObject dobj = CorrelationUtil.getPartialCorrelationRuleActionNotifData(ruleID);
                CorrelationUtil.removeSchedulesForRule(ruleID);
                DBUtil.deleteExistingRows("CorrRuleInfo", new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 0), new boolean[0]);
                CorrNFProfile profile = CorrNFProfileHandler.getNotificationProfile(ruleID);
                if (profile != null) {
                    NotificationManager.getInstance().deleteProfile(profile.getNfID());
                    CorrNFProfileHandler.remove(ruleID);
                }
                CorrelationRuleHandler.postRuleDeleteCall(ruleID, dobj);
                return true;
            }
            throw BaseStatusCode.getBaseStatusCode(7426);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    private static Long[] jsonArrayToLongarray(JSONArray array) throws JSONException {
        Long[] result = new Long[array.length()];
        for (int index = 0; index < array.length(); ++index) {
            result[index] = array.getLong(index);
        }
        return result;
    }

    private static DataObject getUpdatedRuleInfoDobj(JSONObject jsonObject, DataObject dobj, Locale locale) throws JSONException, DataAccessException {
        Object categoryID = null;
        String description = jsonObject.optString("DESCRIPTION", null);
        if (jsonObject.has("CATEGORY")) {
            JSONObject category = jsonObject.getJSONObject("CATEGORY");
            if (category.has("ID")) {
                categoryID = category.getLong("ID");
            } else if (category.has("NAME") && !category.getString("NAME").trim().isEmpty()) {
                try {
                    long storedCategoryId = CorrelationUtil.getCategoryIDIfAvailable(category.getString("NAME").trim(), locale);
                    if (storedCategoryId == -1L) {
                        Row ruleCategory = new Row("CorrRuleCategory");
                        ruleCategory.set("DISPLAY_NAME", (Object)category.getString("NAME"));
                        dobj.addRow(ruleCategory);
                        categoryID = ruleCategory.get("CATEGORY_ID");
                    } else {
                        categoryID = storedCategoryId;
                    }
                }
                catch (Exception exp) {
                    categoryID = null;
                }
            }
        }
        Iterator ruleItr = dobj.getRows("CorrRuleInfo");
        while (ruleItr.hasNext()) {
            Row ruleInfo = (Row)ruleItr.next();
            if (categoryID != null) {
                ruleInfo.set("CATEGORY_ID", categoryID);
            }
            if (description != null) {
                ruleInfo.set("DESCRIPTION", (Object)description);
            }
            if (jsonObject.has("REPORT_ENABLED")) {
                ruleInfo.set("REPORT_ENABLED", (Object)jsonObject.getBoolean("REPORT_ENABLED"));
            }
            dobj.updateRow(ruleInfo);
        }
        return dobj;
    }

    public static boolean createCustomAction(JSONObject reqJsonObject, long uID, Locale locale) throws BaseStatusCode {
        try {
            String actionName = reqJsonObject.getString("ACTIONNAME");
            if (CorrelationUtil.checkIfActionAvailable(actionName, locale)) {
                throw BaseStatusCode.getBaseStatusCode(7432);
            }
            String actionCategory = reqJsonObject.getString("ACTIONCATEGORY");
            String actionDescription = reqJsonObject.getString("ACTIONDESCRIPTION").trim();
            actionDescription = actionDescription.isEmpty() ? actionName : actionDescription;
            String criteria = reqJsonObject.getString("CRITERIA");
            JSONObject jsonObj = new JSONObject(reqJsonObject.getString("CONDN_FIELDS"));
            JSONArray fieldList = jsonObj.getJSONArray("VALUES");
            criteria = ConvertToLuceneSyntax.getInstance().convert(criteria);
            criteria = new JSONCriteriaHandler(criteria).getJSONString();
            Persistence persistence = PersistenceDBUtil.getPersistence();
            DataObject db = persistence.constructDataObject();
            Row expRow = new Row("LAExpression");
            expRow.set("TABLE_NAME", (Object)"EventLog");
            expRow.set("COLUMN_NAME", (Object)"JSONAlertCrit");
            expRow.set("COMPARATOR", (Object)"=");
            expRow.set("VALUE", (Object)criteria);
            db.addRow(expRow);
            Row crtRow = new Row("LACriteria");
            crtRow.set("CRITERIA_NAME", (Object)actionName);
            db.addRow(crtRow);
            Row crt2expRow = new Row("LACriteria2Expressions");
            crt2expRow.set("CRIT_ID", crtRow.get("CRIT_ID"));
            crt2expRow.set("EXP_ID", expRow.get("EXP_ID"));
            db.addRow(crt2expRow);
            Row notifRow = new Row("NotificationType");
            notifRow.set("NOTIFID", crtRow.get("CRIT_ID"));
            notifRow.set("NOTIFNAME", (Object)actionName);
            notifRow.set("TYPE", (Object)-1001L);
            notifRow.set("NOOFOCCURRENCE", (Object)1);
            notifRow.set("NOTIFINTERVAL", (Object)1);
            notifRow.set("STATUS", (Object)0);
            notifRow.set("CRITICALITY", (Object)"High");
            notifRow.set("TRIGGERTIME", (Object)0);
            db.addRow(notifRow);
            Row usr2Notif = new Row("UserToNotificationType");
            usr2Notif.set("NOTIFID", notifRow.get("NOTIFID"));
            usr2Notif.set("USER_ID", (Object)uID);
            db.addRow(usr2Notif);
            Row actionRow = new Row("CorrActionInfo");
            actionRow.set("AUTHOR", (Object)uID);
            actionRow.set("CATEGORY_ID", (Object)actionCategory);
            actionRow.set("DISPLAY_NAME", (Object)actionName);
            actionRow.set("DESCRIPTION", (Object)actionDescription);
            actionRow.set("IS_EDITABLE", (Object)true);
            actionRow.set("IS_SYSTEMGENERATED", (Object)false);
            db.addRow(actionRow);
            Row profMappingRow = new Row("CorrActionProfileMapping");
            profMappingRow.set("ACTION_ID", actionRow.get("ACTION_ID"));
            profMappingRow.set("NOTIFID", notifRow.get("NOTIFID"));
            db.addRow(profMappingRow);
            for (int i = 0; i < fieldList.length(); ++i) {
                boolean fieldType = CorrelationConfigHandler.getCustomComparison(fieldList.getInt(i));
                Row condnFieldsRow = new Row("CorrActionCondnFields");
                condnFieldsRow.set("ACTION_ID", actionRow.get("ACTION_ID"));
                condnFieldsRow.set("CONDN_FIELD_ID", (Object)fieldList.getInt(i));
                condnFieldsRow.set("FIELD_INPUTTYPE", (Object)0);
                condnFieldsRow.set("SHAREDACTION_ALLOWED", (Object)fieldType);
                condnFieldsRow.set("UNIQUEACTION_ALLOWED", (Object)fieldType);
                condnFieldsRow.set("TABLECOLUMN_ALLOWED", (Object)fieldType);
                condnFieldsRow.set("DISPLAY_NAME", (Object)CorrelationConfigHandler.getNoSqlIndexFieldsDisplayName(fieldList.getInt(i)));
                db.addRow(condnFieldsRow);
            }
            persistence.add(db);
            NotificationManager.getInstance().addCustomActionProfile(db, db.getRow("NotificationType"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7432);
        }
        return true;
    }

    public static boolean checkCriteriaValidity(JSONObject reqJsonObject) throws BaseStatusCode {
        try {
            String criteria = reqJsonObject.getString("CRITERIA");
            criteria = ConvertToLuceneSyntax.getInstance().convert(criteria);
            criteria = new JSONCriteriaHandler(criteria).getJSONString();
            if (criteria.length() > 4000) {
                throw BaseStatusCode.getBaseStatusCode(7937);
            }
            if (criteria.equals("{}")) {
                throw BaseStatusCode.getBaseStatusCode(7938);
            }
            throw BaseStatusCode.getBaseStatusCode(0);
        }
        catch (BaseStatusCode baseStatusCode) {
            throw baseStatusCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7937);
        }
    }

    public static boolean getCustomComparison(Integer fieldID) throws BaseStatusCode {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("NoSqlIndexFields"));
            query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
            query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"CUSTOM_COMPARISON_ALLOWED"));
            Criteria crit = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), (Object)fieldID, 0);
            query.setCriteria(crit);
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            return (Boolean)dObj.getFirstValue("NoSqlIndexFields", "CUSTOM_COMPARISON_ALLOWED");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(4097);
        }
    }

    public static String getNoSqlIndexFieldsDisplayName(Integer fieldID) throws BaseStatusCode {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("NoSqlIndexFields"));
            query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
            query.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_DISPLAY_NAME"));
            Criteria crit = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), (Object)fieldID, 0);
            query.setCriteria(crit);
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            return dObj.getFirstValue("NoSqlIndexFields", "FIELD_DISPLAY_NAME").toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(4097);
        }
    }

    public static class CorrRuleConfigData {
        Map<String, Long> uidMap;
        Set<Long> deletedActionIDSet;

        private CorrRuleConfigData(Map<String, Long> uidMap, Set<Long> deletedActionIDs) {
            this.uidMap = uidMap;
            this.deletedActionIDSet = deletedActionIDs;
        }

        public Map<String, Long> getUidMap() {
            return this.uidMap;
        }

        public Set<Long> getDeletedActionIDSet() {
            return this.deletedActionIDSet;
        }

        public static CorrRuleConfigData getCorrRuleConfigData(Map<String, Long> uidMap, Set<Long> deletedActionIDs) {
            return new CorrRuleConfigData(uidMap, deletedActionIDs);
        }
    }
}

