/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.config;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotificationManager;
import com.google.common.collect.ImmutableList;
import com.manageengine.ela.server.common.database.actions.DataBaseReqestProcessor;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.core.builder.CorrelationBuilder;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.listener.CorrelationAuditListener;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.json.JSONException;

public class CorrelationRuleHandler {
    private static final AtomicBoolean ISINITIALIZED = new AtomicBoolean(false);
    private static final Logger LOGGER = Logger.getLogger(CorrelationRuleHandler.class.getName());

    public static void postRuleEnableDisableCall(CorrelationStatus status, Long ... ruleID) throws BaseStatusCode, DataAccessException {
        block3: {
            CorrelationBuilder builder;
            block2: {
                builder = CorrelationBuilder.create();
                if (CorrelationStatus.ENABLE != status) break block2;
                List<Long> notifIDList = CorrelationRuleHandler.analyzeRuleNotifIDStatus(1, ruleID);
                CorrelationRuleHandler.updateNotifActionStatus(notifIDList, true);
                for (Long ruleid : ruleID) {
                    builder.setIdentity(ruleid).enable();
                }
                break block3;
            }
            if (CorrelationStatus.DISABLE != status) break block3;
            List<Long> notifIDList = CorrelationRuleHandler.analyzeRuleNotifIDStatus(0, ruleID);
            CorrelationRuleHandler.checkAndDisableNotifAction(notifIDList);
            for (Long ruleid : ruleID) {
                builder.setIdentity(ruleid).disable();
            }
        }
    }

    public static void postRuleDeleteCall(Long ruleId, DataObject dobj) throws BaseStatusCode, DataAccessException {
        List<Long> notifIDList = CorrelationRuleHandler.analyzeRuleNotifIDStatus(0, dobj);
        CorrelationRuleHandler.checkAndDisableNotifAction(notifIDList);
        CorrelationBuilder.create().setIdentity(ruleId).delete();
    }

    public static void postRuleAddCall(Long ruleID) throws BaseStatusCode, DataAccessException, JSONException, NullPointerException, IllegalAccessException {
        List<Long> notifIDList = CorrelationRuleHandler.analyzeRuleNotifIDStatus(1, ruleID);
        CorrelationRuleHandler.initializeCorrelationRule(ruleID, CorrelationStatus.ENABLE);
        CorrelationRuleHandler.updateNotifActionStatus(notifIDList, true);
    }

    public static void postRuleModificationCall(Long ruleID, Long[] deletedActions) throws BaseStatusCode, DataAccessException, JSONException, NullPointerException, IllegalAccessException {
        if (deletedActions != null && deletedActions.length > 0) {
            CorrelationRuleHandler.postActionDeleteCall(deletedActions);
        }
        CorrelationBuilder.create().setIdentity(ruleID).delete();
        if (CorrelationUtil.getRuleType(ruleID) == 1) {
            CorrelationRuleHandler.initializeCorrelationRule(ruleID, CorrelationStatus.ENABLE);
            CorrelationRuleHandler.postRuleEnableDisableCall(CorrelationStatus.ENABLE, ruleID);
        }
    }

    public static void postActionDeleteCall(Long ... actionIDs) throws BaseStatusCode, DataAccessException {
        List<Long> notifIDList = CorrelationRuleHandler.analyzeActionNotifIDStatus(0, actionIDs);
        CorrelationRuleHandler.checkAndDisableNotifAction(notifIDList);
    }

    private static void checkAndDisableNotifAction(List<Long> notifIDList) throws BaseStatusCode, DataAccessException {
        if (notifIDList != null && notifIDList.size() > 0) {
            List<String> tableList = Arrays.asList("CorrRuleInfo", "CorrConfiguredActions", "CorrActionInfo", "CorrActionProfileMapping", "NotificationType");
            Criteria criteria = new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifIDList.toArray(new Long[notifIDList.size()]), 8);
            Criteria corrCriteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"STATUS"), (Object)CorrelationStatus.ENABLE.getValue(), 0);
            Set<Long> activityRules = ActivityUtil.getActEnabledRules();
            corrCriteria = corrCriteria.or(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)activityRules.toArray(new Long[activityRules.size()]), 8);
            criteria = criteria.and(corrCriteria);
            SelectQuery query = QueryConstructor.get(tableList, (Criteria)criteria);
            DataObject dobj = PersistenceDBUtil.getPersistence().get(query);
            Iterator itr = dobj.getRows("NotificationType");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                notifIDList.remove((Long)row.get("NOTIFID"));
            }
            CorrelationRuleHandler.updateNotifActionStatus(notifIDList, false);
        }
    }

    public static void updateNotifActionStatus(List<Long> notifIDList, boolean status) throws BaseStatusCode, DataAccessException {
        if (notifIDList != null && notifIDList.size() > 0) {
            Criteria criteria = new Criteria(Column.getColumn((String)"NotificationType", (String)"NOTIFID"), (Object)notifIDList.toArray(new Long[notifIDList.size()]), 8);
            DataBaseReqestProcessor.executeUpdateQuery("NotificationType", "STATUS", status ? 1 : 0, criteria, new boolean[0]);
            for (Long notifID : notifIDList) {
                NotificationManager.getInstance().changeNotificationStatus(notifID, status ? 1 : 0);
            }
        }
    }

    public static List<Long> analyzeRuleNotifIDStatus(int status, Long ... ruleID) throws BaseStatusCode, DataAccessException {
        DataObject dobj = CorrelationUtil.getPartialCorrelationRuleActionNotifData(ruleID);
        return CorrelationRuleHandler.analyzeRuleNotifIDStatus(status, dobj);
    }

    private static List<Long> analyzeRuleNotifIDStatus(int status, DataObject dobj) throws BaseStatusCode, DataAccessException {
        ArrayList<Long> changesNeeded = new ArrayList<Long>();
        Iterator itr = dobj.getRows("NotificationType");
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            Object notificationStatus = row.get("STATUS");
            if (notificationStatus == null || (Integer)notificationStatus == status) continue;
            changesNeeded.add((Long)row.get("NOTIFID"));
        }
        return changesNeeded;
    }

    private static List<Long> analyzeActionNotifIDStatus(int status, Long ... actionIDs) throws BaseStatusCode, DataAccessException {
        DataObject dobj = CorrelationUtil.getPartialCorrelationActionNotifData(actionIDs);
        ArrayList<Long> changesNeeded = new ArrayList<Long>();
        Iterator itr = dobj.getRows("NotificationType");
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            Object notificationStatus = row.get("STATUS");
            if (notificationStatus == null || (Integer)notificationStatus == status) continue;
            changesNeeded.add((Long)row.get("NOTIFID"));
        }
        return changesNeeded;
    }

    public static boolean isCorrelationRulesInitialized() {
        return ISINITIALIZED.get();
    }

    public static List<Long> initializeCorrelationRules() throws BaseStatusCode {
        if (ISINITIALIZED.get()) {
            throw BaseStatusCode.getBaseStatusCode(7429);
        }
        ISINITIALIZED.set(true);
        try {
            DataObject dobj = CorrelationUtil.getCompleteCorrelationRuleActionNotifData(null, 1);
            int rulesize = dobj.size("CorrRuleInfo");
            if (rulesize <= 0) {
                LOGGER.info("No rules Configured");
                return null;
            }
            ArrayList<Long> configuredRules = new ArrayList<Long>(rulesize);
            Iterator ruleItr = dobj.getRows("CorrRuleInfo");
            CorrelationBuilder builder = CorrelationBuilder.create().setDataContainer(dobj);
            while (ruleItr.hasNext()) {
                try {
                    Row ruleInfo = (Row)ruleItr.next();
                    CorrelationStatus status = CorrelationStatus.getStatus((Long)ruleInfo.get("STATUS"));
                    Long ruleID = (Long)ruleInfo.get("RULE_ID");
                    builder.setIdentity(ruleID).setCallBack(CorrelationAuditListener.get()).setStatus(status).build();
                    configuredRules.add(ruleID);
                }
                catch (Exception exp) {
                    exp.printStackTrace();
                }
            }
            return ImmutableList.copyOf(configuredRules);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return null;
        }
    }

    public static void initializeCorrelationRule(Long ruleID, CorrelationStatus status) throws BaseStatusCode, DataAccessException, JSONException, NullPointerException, IllegalAccessException {
        DataObject dobj = CorrelationUtil.getCompleteCorrelationRuleActionNotifData(ruleID, 1);
        CorrelationBuilder.create().setDataContainer(dobj).setIdentity(ruleID).setCallBack(CorrelationAuditListener.get()).setStatus(status).build();
    }
}

