/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core;

import com.manageengine.ela.server.correlation.core.action.CorrelationAction;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.criteria.ActionDelimiter;
import com.manageengine.ela.server.correlation.core.criteria.UniqueFieldChain;
import com.manageengine.ela.server.correlation.core.listener.NotificationListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CorrelationRuleContainer {
    private static final Map<Long, Map<Long, CorrelationAction>> CONFIGUREDRULESINFO = new HashMap<Long, Map<Long, CorrelationAction>>();
    private static final Lock SYNC = new ReentrantLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(Long ruleID, Map<Long, CorrelationAction> actionInfo, CorrelationStatus status) {
        SYNC.lock();
        try {
            CONFIGUREDRULESINFO.put(ruleID, actionInfo);
            if (status == CorrelationStatus.ENABLE) {
                Map<Long, Map<Long, CorrelationAction>> configInfo = CorrelationRuleContainer.getReceiverConfiguration(actionInfo);
                NotificationListener.registerCorrelationActions(configInfo);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void unload(Long ruleID) {
        SYNC.lock();
        try {
            Map<Long, CorrelationAction> actionMap = CONFIGUREDRULESINFO.remove(ruleID);
            if (actionMap != null) {
                Map<Long, List<Long>> currentActionList = CorrelationRuleContainer.getReceiverExistingConfiguration(actionMap);
                NotificationListener.removeCorrelationActions(currentActionList);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void enable(Long ruleID) {
        SYNC.lock();
        try {
            Map<Long, CorrelationAction> actionMap = CONFIGUREDRULESINFO.get(ruleID);
            if (actionMap != null) {
                Map<Long, Map<Long, CorrelationAction>> configInfo = CorrelationRuleContainer.getReceiverConfiguration(actionMap);
                NotificationListener.registerCorrelationActions(configInfo);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void disable(Long ruleID) {
        SYNC.lock();
        try {
            Map<Long, CorrelationAction> actionMap = CONFIGUREDRULESINFO.get(ruleID);
            if (actionMap != null) {
                Map<Long, List<Long>> currentActionList = CorrelationRuleContainer.getReceiverExistingConfiguration(actionMap);
                NotificationListener.removeCorrelationActions(currentActionList);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static Set<Long> getProcessingOrder(Long ruleID) {
        return CONFIGUREDRULESINFO.get(ruleID).keySet();
    }

    public static int getActionType(Long ruleID, Long actionConfigID) {
        return CONFIGUREDRULESINFO.get(ruleID).get(actionConfigID).getActionType();
    }

    public static Map<String, List<Map.Entry<Long, String>>> getSharedFieldRef(Long ruleID, Long configuredAction) {
        return CONFIGUREDRULESINFO.get(ruleID).get(configuredAction).getSharedFieldRef();
    }

    public static List<Map.Entry<Long, String>> getSharedFieldCondn(Long ruleID, Long configuredAction, String field) {
        return CONFIGUREDRULESINFO.get(ruleID).get(configuredAction).getSharedFieldRef().get(field);
    }

    public static UniqueFieldChain getUniqueFieldCondn(Long ruleID, Long configuredAction) {
        return CONFIGUREDRULESINFO.get(ruleID).get(configuredAction).getUniqueField();
    }

    public static ActionDelimiter getActionDelimiter(Long ruleID, Long actionConfigID) {
        return CONFIGUREDRULESINFO.get(ruleID).get(actionConfigID).getActionDelimiter();
    }

    public static Map<Long, CorrelationAction> getActionContainer(Long ruleID) {
        return CONFIGUREDRULESINFO.get(ruleID);
    }

    private static Map<Long, Map<Long, CorrelationAction>> getReceiverConfiguration(Map<Long, CorrelationAction> actionInfo) {
        HashMap<Long, Map<Long, CorrelationAction>> correlation = new HashMap<Long, Map<Long, CorrelationAction>>();
        actionInfo.entrySet().forEach(entry -> {
            CorrelationAction action = (CorrelationAction)entry.getValue();
            HashMap actionMap = (HashMap)correlation.get(action.getNotificationID());
            if (actionMap == null) {
                actionMap = new HashMap();
                correlation.put(action.getNotificationID(), actionMap);
            }
            actionMap.put(entry.getKey(), action);
        });
        return correlation;
    }

    private static Map<Long, List<Long>> getReceiverExistingConfiguration(Map<Long, CorrelationAction> allActions) {
        HashMap<Long, List<Long>> correlation = new HashMap<Long, List<Long>>();
        allActions.entrySet().forEach(entry -> {
            Long actionID = (Long)entry.getKey();
            CorrelationAction action = (CorrelationAction)entry.getValue();
            ArrayList<Long> actionIDList = (ArrayList<Long>)correlation.get(action.getNotificationID());
            if (actionIDList == null) {
                actionIDList = new ArrayList<Long>();
                correlation.put(action.getNotificationID(), actionIDList);
            }
            actionIDList.add(actionID);
        });
        return correlation;
    }

    public static Boolean isRuleRegistered(Long ruleID) {
        return CONFIGUREDRULESINFO.containsKey(ruleID);
    }
}

