/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.action;

import com.manageengine.ela.server.correlation.callback.ActionCallBack;
import com.manageengine.ela.server.correlation.core.action.ActionInput;
import com.manageengine.ela.server.correlation.core.constants.ActionType;
import com.manageengine.ela.server.correlation.core.constants.ExecutorStatus;
import com.manageengine.ela.server.correlation.core.data.RuleContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.core.matcher.CommonRelationMatcher;
import com.manageengine.ela.server.correlation.core.matcher.SharedFieldMatcher;
import com.manageengine.ela.server.correlation.core.matcher.UniqueFieldMatcher;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ActionCondnvalidator
implements CorrelationExecutor {
    private final Lock sync = new ReentrantLock(true);
    private volatile ExecutorStatus status = ExecutorStatus.IDLE;
    private final ActionInput input;
    private final ActionCallBack successCallBack;
    private final RuleContainer container;

    private ActionCondnvalidator(ActionInput input, RuleContainer container, ActionCallBack successCallBack) {
        this.container = Objects.requireNonNull(container);
        this.input = Objects.requireNonNull(input);
        this.successCallBack = Objects.requireNonNull(successCallBack);
    }

    public static ActionCondnvalidator get(ActionInput input, RuleContainer container, ActionCallBack successCallBack) {
        return new ActionCondnvalidator(input, container, successCallBack);
    }

    @Override
    public void execute() {
        if (!this.successCallBack.skipVerification(this.input.getIdentity())) {
            if (this.input.getActiontype() % ActionType.SHARED.getValue() == 0) {
                boolean status = true;
                if (this.input.getActiontype() % ActionType.UNIQUE.getValue() == 0) {
                    status &= UniqueFieldMatcher.get().match(this.input.getIdentity(), this.input.getUniqueField(), this.input.getActionDelimiter(), this.container);
                }
                Map<String, List<Map.Entry<Long, String>>> shFields = this.input.getSharedFieldRef();
                if (status &= SharedFieldMatcher.get().match(this.input.getIdentity(), shFields, this.input.getActionDelimiter(), this.container)) {
                    this.successCallBack.register(this.input.getIdentity());
                    shFields.forEach((key, ref) -> ref.forEach(entry -> this.successCallBack.register((Long)entry.getKey())));
                }
            } else if (this.input.getActiontype() % ActionType.UNIQUE.getValue() == 0) {
                if (UniqueFieldMatcher.get().match(this.input.getIdentity(), this.input.getUniqueField(), this.input.getActionDelimiter(), this.container)) {
                    this.successCallBack.register(this.input.getIdentity());
                }
            } else {
                SortedContainer doccontainer = this.container.getFieldDataContainer(this.input.getIdentity()).getContainer();
                if (CommonRelationMatcher.get().match(this.input.getActionDelimiter(), doccontainer)) {
                    this.successCallBack.register(this.input.getIdentity());
                }
            }
        }
    }

    @Override
    public void setStatus(ExecutorStatus status) {
        this.sync.lock();
        try {
            this.status = status;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public boolean isBusy() {
        this.sync.lock();
        try {
            boolean bl = this.status == ExecutorStatus.QUEUED;
            return bl;
        }
        finally {
            this.sync.unlock();
        }
    }

    @Override
    public Object getIdentity() {
        return this.input.getIdentity();
    }
}

