/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.action;

import com.manageengine.ela.server.correlation.core.constants.ActionType;
import com.manageengine.ela.server.correlation.core.criteria.ActionDelimiter;
import com.manageengine.ela.server.correlation.core.criteria.FieldCriteria;
import com.manageengine.ela.server.correlation.core.criteria.UniqueFieldChain;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActionInput {
    private Long ruleID = null;
    private Long identity = null;
    private Long notificationID = null;
    private FieldCriteria fieldCriteria = null;
    private ActionDelimiter actionDelimiter = null;
    private Set<String> indexFields = null;
    private UniqueFieldChain uniqueFieldChain = null;
    private Map<String, List<Map.Entry<Long, String>>> sharedFieldRef = null;
    private int actiontype = ActionType.COMMON.getValue();
    private Map<String, String> fieldConversion = null;
    private Map<String, List<String>> reversefieldConversion = null;

    public ActionInput(Long ruleID, Long identity) {
        this.ruleID = ruleID;
        this.identity = identity;
    }

    public Long getRuleID() {
        return this.ruleID;
    }

    public Long getIdentity() {
        return this.identity;
    }

    public ActionDelimiter getActionDelimiter() {
        return this.actionDelimiter;
    }

    public void setActionDelimiter(ActionDelimiter actionRelation) {
        this.actionDelimiter = actionRelation;
    }

    public boolean isValid() {
        return this.ruleID != null && this.identity != null && this.notificationID != null && !this.indexFieldverification();
    }

    private boolean indexFieldverification() {
        return this.actiontype % ActionType.UNIQUE.getValue() == 0 && this.uniqueFieldChain == null || this.actiontype % ActionType.SHARED.getValue() == 0 && (this.sharedFieldRef == null || this.sharedFieldRef.isEmpty());
    }

    public FieldCriteria getFieldCriteria() {
        return this.fieldCriteria;
    }

    public void setFieldCriteria(FieldCriteria fieldCriteria) {
        this.fieldCriteria = fieldCriteria;
    }

    public Set<String> getIndexFields() {
        return this.indexFields;
    }

    public void setIndexFields(Set<String> indexFields) {
        this.indexFields = indexFields;
    }

    public int getActiontype() {
        return this.actiontype;
    }

    public void setActiontype(int actiontype) {
        this.actiontype = actiontype;
    }

    public UniqueFieldChain getUniqueField() {
        return this.uniqueFieldChain;
    }

    public void setUniqueField(UniqueFieldChain uniqueFields) {
        this.uniqueFieldChain = uniqueFields;
    }

    public Map<String, List<Map.Entry<Long, String>>> getSharedFieldRef() {
        return this.sharedFieldRef;
    }

    public void setSharedFieldRef(Map<String, List<Map.Entry<Long, String>>> sharedFieldRef) {
        this.sharedFieldRef = sharedFieldRef;
    }

    public Long getNotificationID() {
        return this.notificationID;
    }

    public void setNotificationID(Long notificationID) {
        this.notificationID = notificationID;
    }

    public Map<String, String> getFieldConversion() {
        return this.fieldConversion;
    }

    public Map<String, List<String>> getReverseFieldConversion() {
        return this.reversefieldConversion;
    }

    public void setReverseFieldConversion(Map<String, List<String>> reversefieldConversion) {
        this.reversefieldConversion = reversefieldConversion;
        if (this.reversefieldConversion != null) {
            this.fieldConversion = new HashMap<String, String>();
            this.reversefieldConversion.forEach((key, value) -> value.forEach(destination -> this.fieldConversion.put((String)destination, (String)key)));
        }
    }

    public String toString() {
        return "ActionInput{ruleID=" + this.ruleID + ", identity=" + this.identity + ", notificationID=" + this.notificationID + ", fieldCriteria=" + this.fieldCriteria + ", actionDelimiter=" + this.actionDelimiter + ", indexFields=" + this.indexFields + ", uniqueFieldChain=" + this.uniqueFieldChain + ", sharedFieldRef=" + this.sharedFieldRef + ", actiontype=" + this.actiontype + ", fieldConversion=" + this.fieldConversion + ", reversefieldConversion=" + this.reversefieldConversion + '}';
    }
}

