/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.action;

import com.manageengine.ela.server.correlation.callback.ActionCallBack;
import com.manageengine.ela.server.correlation.core.action.ActionCondnvalidator;
import com.manageengine.ela.server.correlation.core.action.ActionInput;
import com.manageengine.ela.server.correlation.core.action.CorrelationAction;
import com.manageengine.ela.server.correlation.core.constants.ActionType;
import com.manageengine.ela.server.correlation.core.criteria.ActionDelimiter;
import com.manageengine.ela.server.correlation.core.criteria.UniqueFieldChain;
import com.manageengine.ela.server.correlation.core.data.FieldDataContainer;
import com.manageengine.ela.server.correlation.core.data.RuleContainer;
import com.manageengine.ela.server.correlation.core.executors.CorrelationActionExecutor;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.core.matcher.FieldCriteriaMatcher;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorrelationActionImpl
implements CorrelationAction {
    private final ActionInput input;
    private final CorrelationExecutor executor;
    private final FieldDataContainer fieldDataContainer;
    private final AtomicBoolean addActionInQueue = new AtomicBoolean(true);
    private final AtomicBoolean pendingProcess = new AtomicBoolean(false);
    private static final Logger LOGGER = Logger.getLogger(CorrelationActionImpl.class.getName());

    public CorrelationActionImpl(ActionInput input, ActionCallBack successCallBack, RuleContainer container) throws IllegalArgumentException {
        this(input, ActionCondnvalidator.get(input, Objects.requireNonNull(container), successCallBack), container);
    }

    public CorrelationActionImpl(ActionInput input, CorrelationExecutor executor, RuleContainer container) throws IllegalArgumentException {
        this.input = Objects.requireNonNull(input);
        this.fieldDataContainer = container.getFieldDataContainer(input.getIdentity());
        this.executor = Objects.requireNonNull(executor);
        if (!input.isValid()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean process(Long time, Map<?, ?> log, String docID) {
        Map<String, List<String>> reversefieldTranslation = this.input.getReverseFieldConversion();
        if (this.input.getFieldCriteria() != null && !FieldCriteriaMatcher.get().match(this.input.getFieldCriteria(), log, reversefieldTranslation)) {
            LOGGER.log(Level.FINE, "Criteria not satisfied : {0}", this.input.getIdentity());
            return false;
        }
        Map<String, String> fieldTranslation = this.input.getFieldConversion();
        if (this.input.getActiontype() % ActionType.SHARED.getValue() == 0 || this.input.getActiontype() % ActionType.UNIQUE.getValue() == 0) {
            if (fieldTranslation == null) {
                for (String field : this.input.getIndexFields()) {
                    Object object = log.get(field);
                    if (object == null) continue;
                    this.fieldDataContainer.store(field, object.toString().toLowerCase(), time, docID);
                }
            } else {
                for (String field : this.input.getIndexFields()) {
                    Object object = log.get(field);
                    String convertedField = fieldTranslation.get(field);
                    if (object == null) continue;
                    if (convertedField == null) {
                        this.fieldDataContainer.store(field, object.toString().toLowerCase(), time, docID);
                        continue;
                    }
                    this.fieldDataContainer.store(convertedField, object.toString().toLowerCase(), time, docID);
                }
            }
        } else {
            this.fieldDataContainer.store(time, docID);
        }
        if (this.addActionInQueue.get()) {
            CorrelationActionExecutor.put(this.executor);
        } else {
            this.pendingProcess.set(true);
        }
        return true;
    }

    @Override
    public Long getNotificationID() {
        return this.input.getNotificationID();
    }

    @Override
    public int getActionType() {
        return this.input.getActiontype();
    }

    @Override
    public ActionDelimiter getActionDelimiter() {
        return this.input.getActionDelimiter();
    }

    @Override
    public UniqueFieldChain getUniqueField() {
        return this.input.getUniqueField();
    }

    @Override
    public Map<String, List<Map.Entry<Long, String>>> getSharedFieldRef() {
        return this.input.getSharedFieldRef();
    }

    @Override
    public void forceEnqueue() {
        CorrelationActionExecutor.put(this.executor);
    }

    @Override
    public void enableExecution() {
        this.addActionInQueue.set(true);
        if (this.pendingProcess.get()) {
            this.forceEnqueue();
            this.pendingProcess.set(false);
        }
    }

    @Override
    public void disableExecution() {
        this.addActionInQueue.set(false);
    }

    public String toString() {
        return "CorrelationActionImpl{input=" + this.input + ", executor=" + this.executor + '}';
    }
}

