/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer;

import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerCursor;
import com.manageengine.ela.server.correlation.core.criteria.CrossActionChain;
import java.util.List;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

class AnalyzerCursorImpl
implements AnalyzerCursor {
    private final NavigableMap<Long, List<String>> originalContainer;
    private final Long dependentActionEndKey;
    private final CrossActionChain actionChainPoint;
    private NavigableMap<Long, List<String>> derivedContainer;
    private Long startPoint;
    private Long endPoint;
    private Long maxLimit;
    private static final Logger LOGGER = Logger.getLogger(AnalyzerCursorImpl.class.getName());

    public AnalyzerCursorImpl(Long dependentActionEndKey, NavigableMap<Long, List<String>> originalContainer, CrossActionChain actionChainPoint) throws BaseStatusCode {
        this.actionChainPoint = Objects.requireNonNull(actionChainPoint);
        this.dependentActionEndKey = dependentActionEndKey;
        this.originalContainer = Objects.requireNonNull(originalContainer);
        this.maxLimit = this.getMaxLimit(this.originalContainer);
        this.startPoint = this.findValidStartPoint(this.dependentActionEndKey, actionChainPoint.getTimeLimit(), originalContainer);
        if (this.startPoint == null) {
            LOGGER.log(Level.FINER, "No valid cursor found");
        } else {
            this.endPoint = this.getAllowedEndPoint(this.dependentActionEndKey, this.startPoint, actionChainPoint.getTimeLimit(), this.maxLimit, originalContainer);
            this.derivedContainer = this.getContainerFromPoints(originalContainer, this.startPoint, this.endPoint);
            LOGGER.log(Level.FINER, "New cursor initialized  start : {0}  and   End : {1}", new Object[]{this.startPoint, this.endPoint});
        }
    }

    AnalyzerCursorImpl(NavigableMap<Long, List<String>> originalContainer, CrossActionChain actionChainPoint, Long optimalStartPoint) throws BaseStatusCode {
        this.actionChainPoint = Objects.requireNonNull(actionChainPoint);
        this.originalContainer = Objects.requireNonNull(originalContainer);
        this.dependentActionEndKey = null;
        this.maxLimit = this.getMaxLimit(this.originalContainer);
        this.startPoint = this.findValidStartPoint(optimalStartPoint, actionChainPoint.getTimeLimit(), originalContainer);
        if (this.startPoint == null) {
            LOGGER.log(Level.FINER, "No valid cursor found");
        } else {
            this.endPoint = this.getAllowedEndPoint(null, this.startPoint, actionChainPoint.getTimeLimit(), this.maxLimit, originalContainer);
            this.derivedContainer = this.getContainerFromPoints(originalContainer, this.startPoint, this.endPoint);
            LOGGER.log(Level.FINER, "New cursor initialized  start : {0}  and   End : {1}", new Object[]{this.startPoint, this.endPoint});
        }
    }

    @Override
    public void moveStartingPoint() throws BaseStatusCode {
        Long nextStartPoint = this.originalContainer.higherKey(this.startPoint);
        this.resetDynamicData();
        LOGGER.log(Level.FINER, "Moving current cursor : {0}", this.startPoint);
        if (nextStartPoint == null || !this.isValidStartKey(nextStartPoint)) {
            LOGGER.log(Level.FINER, "No valid cursor found");
        } else {
            this.startPoint = nextStartPoint;
            this.endPoint = this.getAllowedEndPoint(this.dependentActionEndKey, this.startPoint, this.actionChainPoint.getTimeLimit(), this.maxLimit, this.originalContainer);
            this.derivedContainer = this.getContainerFromPoints(this.originalContainer, this.startPoint, this.endPoint);
            LOGGER.log(Level.FINER, "New cursor initialized  start : {0}  and   End : {1}", new Object[]{this.startPoint, this.endPoint});
        }
    }

    private boolean isValidStartKey(Long nextStartPoint) {
        return this.actionChainPoint.getTimeLimit() == null || this.dependentActionEndKey == null || nextStartPoint <= this.actionChainPoint.getTimeLimit() + this.dependentActionEndKey;
    }

    @Override
    public void rebuildDerivedContainer(Long newStartPoint) throws BaseStatusCode {
        this.resetDynamicData();
        LOGGER.log(Level.FINER, "Rebuilding current cursor : {0}", this.startPoint);
        this.startPoint = this.findStartPoint(newStartPoint, this.originalContainer);
        if (this.startPoint == null) {
            LOGGER.log(Level.FINER, "No valid cursor found");
        } else {
            this.endPoint = this.getAllowedEndPoint(this.dependentActionEndKey, this.startPoint, this.actionChainPoint.getTimeLimit(), this.maxLimit, this.originalContainer);
            this.derivedContainer = this.getContainerFromPoints(this.originalContainer, this.startPoint, this.endPoint);
            LOGGER.log(Level.FINER, "New cursor initialized  start : {0}  and   End : {1}", new Object[]{this.startPoint, this.endPoint});
        }
    }

    private void resetDynamicData() {
        this.startPoint = null;
        this.endPoint = null;
        this.derivedContainer = null;
    }

    private Long getMaxLimit(NavigableMap<Long, List<String>> container) throws BaseStatusCode {
        try {
            return (Long)container.lastKey();
        }
        catch (NoSuchElementException exp) {
            throw BaseStatusCode.getBaseStatusCode(12289);
        }
    }

    private Long findValidStartPoint(Long previousActionEnd, Long timeLimit, NavigableMap<Long, List<String>> container) throws BaseStatusCode {
        Long startingCursor = this.findStartPoint(previousActionEnd, container);
        if (previousActionEnd != null && startingCursor != null && timeLimit != null) {
            Long derived = timeLimit + previousActionEnd;
            if (startingCursor > derived) {
                return null;
            }
        }
        return startingCursor;
    }

    private Long findStartPoint(Long previousActionEnd, NavigableMap<Long, List<String>> container) throws BaseStatusCode {
        Long startingCursor;
        if (previousActionEnd == null) {
            try {
                startingCursor = (Long)container.firstKey();
            }
            catch (NoSuchElementException exp) {
                throw BaseStatusCode.getBaseStatusCode(12289);
            }
        } else {
            startingCursor = container.ceilingKey(previousActionEnd);
        }
        return startingCursor;
    }

    private Long getAllowedEndPoint(Long dependentEndKey, Long currentStartingKey, Long within, Long maxCursorLimit, NavigableMap<Long, List<String>> container) throws BaseStatusCode {
        if (within == null) {
            return maxCursorLimit;
        }
        Long derived = dependentEndKey == null ? Long.valueOf(currentStartingKey + within) : Long.valueOf(dependentEndKey + within);
        if (derived > maxCursorLimit) {
            return maxCursorLimit;
        }
        return container.floorKey(derived);
    }

    private NavigableMap<Long, List<String>> getContainerFromPoints(NavigableMap<Long, List<String>> container, Long startingCursor, Long endCursorLimit) {
        return container.subMap(startingCursor, true, endCursorLimit, true);
    }

    @Override
    public boolean isValidCursor() {
        return this.startPoint != null && this.endPoint != null && this.maxLimit != null;
    }

    @Override
    public CrossActionChain getActionChainPoint() {
        return this.actionChainPoint;
    }

    @Override
    public NavigableMap<Long, List<String>> getDerivedContainer() {
        return this.derivedContainer;
    }

    @Override
    public boolean isNextPointAvailable() {
        return this.startPoint != null && this.maxLimit != null && this.startPoint < this.maxLimit;
    }
}

