/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer;

import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.common.data.CommonDataHelper;
import com.manageengine.ela.server.correlation.common.data.PreProcessDataHandler;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerInput;
import com.manageengine.ela.server.correlation.core.analyzer.selector.PreProcessDataSelector;
import com.manageengine.ela.server.correlation.core.analyzer.selector.RuleSelector;
import com.manageengine.ela.server.correlation.core.constants.ExecutorStatus;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.core.status.StatusHandler;
import com.manageengine.ela.server.correlation.core.status.StatusHandlerImpl;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class CommonAnalyzer
implements CorrelationExecutor {
    private static final Logger LOGGER = Logger.getLogger(CommonAnalyzer.class.getName());
    private final CorrelationCallBack callBack;
    private final AnalyzerInput input;
    private final StatusHandler statusHandler;

    public CommonAnalyzer(AnalyzerInput input, CorrelationCallBack callBack) {
        this.callBack = Objects.requireNonNull(callBack);
        this.input = Objects.requireNonNull(input);
        this.statusHandler = new StatusHandlerImpl();
    }

    public CommonAnalyzer(AnalyzerInput input, CorrelationCallBack callBack, StatusHandler statusHandler) {
        this.callBack = Objects.requireNonNull(callBack);
        this.input = Objects.requireNonNull(input);
        this.statusHandler = Objects.requireNonNull(statusHandler);
    }

    @Override
    public final void execute() {
        long startTime = System.nanoTime();
        LOGGER.log(Level.FINER, "Correlation Analyzer initiated for : {0}", this.input.getIdentity());
        if (this.input.isLockNeeded() && this.input.getProcessingLock() != null) {
            LOGGER.log(Level.FINER, "Correlation Analyzer entered in lock block : {0}", this.input.getIdentity());
            this.input.getProcessingLock().lock();
            try {
                LOGGER.log(Level.FINER, "Correlation Analyzer process started : {0}", this.input.getIdentity());
                this.startCorrelationAnalysisProcess();
                LOGGER.log(Level.FINER, "Correlation Analysis process completed Time taken : ", System.nanoTime() - startTime);
            }
            finally {
                this.input.getProcessingLock().unlock();
            }
        } else {
            LOGGER.log(Level.FINER, "Correlation Analyzer process started : {0}", this.input.getIdentity());
            this.startCorrelationAnalysisProcess();
            LOGGER.log(Level.FINER, "Correlation Analysis process completed Time taken : ", System.nanoTime() - startTime);
        }
    }

    protected abstract void startCorrelationAnalysisProcess();

    @Override
    public void setStatus(ExecutorStatus status) {
        this.statusHandler.setStatus(status);
    }

    @Override
    public boolean isBusy() {
        return this.statusHandler.isBusy();
    }

    protected final void removeProcessedInfoCacheInCustomContainer(Map<Long, SortedContainer> processThis, Map<Long, ResponseContainer> response) {
        processThis.forEach((actionID, container) -> {
            ResponseContainer responseCon = (ResponseContainer)response.get(actionID);
            SortedContainer originalContainer = responseCon.getOriginalContainer();
            if (originalContainer.isDuplicateContainer()) {
                responseCon.getSelectedData().forEach((time, limit) -> {
                    List<String> existing = originalContainer.get((Long)time);
                    if (existing != null) {
                        List<String> dataCopy = existing.stream().limit(limit.intValue()).collect(Collectors.toList());
                        container.clearCorrelatedActions((Long)time, dataCopy);
                    }
                });
            }
        });
    }

    protected RuleSelector getDefaultRuleSelector(AnalyzerInput input) {
        PreProcessDataHandler dataHandler = CommonDataHelper.getPreProcessDataHandler(input.getContainer());
        Map<Long, Map<String, Map<String, Long>>> limitMap = PreProcessDataSelector.getCurrentProcessingLimitMap(dataHandler);
        if (limitMap == null || limitMap.isEmpty()) {
            return null;
        }
        return PreProcessDataSelector.createRuleContainerSelector(limitMap, dataHandler);
    }

    protected void clean(RuleSelector selector, Map<Long, SortedContainer> data, Map<Long, ResponseContainer> response) {
        selector.clean(response);
        this.removeProcessedInfoCacheInCustomContainer(data, response);
    }

    public CorrelationCallBack getCallBack() {
        return this.callBack;
    }

    public AnalyzerInput getAnalyzerInput() {
        return this.input;
    }

    @Override
    public Object getIdentity() {
        return this.input.getIdentity();
    }

    public StatusHandler getStatusHandler() {
        return this.statusHandler;
    }
}

