/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer;

import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerInput;
import com.manageengine.ela.server.correlation.core.analyzer.CommonAnalyzer;
import com.manageengine.ela.server.correlation.core.analyzer.selector.RuleSelector;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.status.StatusHandler;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class DSelectorBAnalyzer
extends CommonAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(DSelectorBAnalyzer.class.getName());

    public DSelectorBAnalyzer(AnalyzerInput input, CorrelationCallBack callBack) {
        super(input, callBack);
    }

    public DSelectorBAnalyzer(AnalyzerInput input, CorrelationCallBack callBack, StatusHandler handler) {
        super(input, callBack, handler);
    }

    @Override
    protected final void startCorrelationAnalysisProcess() {
        AnalyzerInput input = super.getAnalyzerInput();
        RuleSelector selector = super.getDefaultRuleSelector(input);
        if (selector == null) {
            LOGGER.log(Level.FINER, "createRuleContainerSelector returned null");
            return;
        }
        int combinations = 0;
        do {
            Map<Long, SortedContainer> processThis;
            if ((processThis = selector.next()) == null || processThis.isEmpty()) continue;
            ++combinations;
            LOGGER.log(Level.FINER, "Selector moved to next point : {0}", processThis);
            this.process(selector, processThis);
        } while (selector.hasNext());
        LOGGER.log(Level.FINER, "Correlation analyzer process completed for rule : {0},  combinations {1}", new Object[]{input.getIdentity(), combinations});
    }

    protected abstract void process(RuleSelector var1, Map<Long, SortedContainer> var2);
}

