/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer;

import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerCursor;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerCursorImpl;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerDataFiller;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerInput;
import com.manageengine.ela.server.correlation.core.analyzer.DSelectorBAnalyzer;
import com.manageengine.ela.server.correlation.core.analyzer.SkipDataAnalyzer;
import com.manageengine.ela.server.correlation.core.analyzer.selector.RuleSelector;
import com.manageengine.ela.server.correlation.core.criteria.CrossActionChain;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.status.StatusHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiActionAnalyzer
extends DSelectorBAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(MultiActionAnalyzer.class.getName());

    public MultiActionAnalyzer(AnalyzerInput input, CorrelationCallBack callBack) {
        super(input, callBack);
    }

    public MultiActionAnalyzer(AnalyzerInput input, CorrelationCallBack callBack, StatusHandler handler) {
        super(input, callBack, handler);
    }

    @Override
    protected void process(RuleSelector selector, Map<Long, SortedContainer> data) {
        AnalyzerInput input = super.getAnalyzerInput();
        CorrelationCallBack callBack = super.getCallBack();
        try {
            CrossActionChain chainHead = input.getCorssChainAction().getHead();
            int iterations = 0;
            int successIteration = 0;
            Long primaryActionID = chainHead.getConfigActionID();
            Long optimizedStartPoint = SkipDataAnalyzer.getPossibleMASPoint(data, chainHead);
            AnalyzerCursorImpl cursor = new AnalyzerCursorImpl(data.get(primaryActionID).getDirectMap(), chainHead, optimizedStartPoint);
            HashMap<Long, ResponseContainer> response = new HashMap<Long, ResponseContainer>();
            while (true) {
                ++iterations;
                if (!this.process(cursor, chainHead, data, response)) break;
                ++successIteration;
                callBack.callBack(input.getIdentity(), response);
                super.clean(selector, data, response);
                cursor.rebuildDerivedContainer(((ResponseContainer)response.get(primaryActionID)).lastKey());
                response.clear();
            }
            LOGGER.log(Level.FINER, "Rule analyzer total iteration : {0} , success : {1} ", new Object[]{iterations, successIteration});
        }
        catch (BaseStatusCode statusCode) {
            if (statusCode.getOrgStatusCode() == 12289L) {
                LOGGER.log(Level.FINER, "Rule analyzer chain broken - invalid rule request");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    private boolean process(AnalyzerCursor initiatedCursor, CrossActionChain startPoint, Map<Long, SortedContainer> data, Map<Long, ResponseContainer> response) throws BaseStatusCode {
        AnalyzerCursor dynamicCursor = initiatedCursor;
        CrossActionChain dynamiccaChain = startPoint;
        boolean matchResult = false;
        LinkedList<AnalyzerCursor> cursorSeqList = new LinkedList<AnalyzerCursor>();
        while (true) {
            Long currentActionID;
            ResponseContainer responseContainer;
            if ((responseContainer = response.get(currentActionID = dynamiccaChain.getConfigActionID())) == null) {
                responseContainer = new ResponseContainer(data.get(currentActionID));
                response.put(currentActionID, responseContainer);
            } else {
                responseContainer.reset();
            }
            if (dynamicCursor.isValidCursor()) {
                if (AnalyzerDataFiller.fillDataFromDataPool(dynamicCursor, dynamiccaChain, responseContainer, true)) {
                    cursorSeqList.add(dynamicCursor);
                    if (dynamiccaChain.hasNext()) {
                        Long lastKey = responseContainer.lastKey();
                        dynamiccaChain = dynamiccaChain.next();
                        dynamicCursor = new AnalyzerCursorImpl(lastKey, data.get(dynamiccaChain.getConfigActionID()).getDirectMap(), dynamiccaChain);
                        continue;
                    }
                    matchResult = true;
                    break;
                }
                if (dynamicCursor.isNextPointAvailable()) {
                    dynamicCursor.moveStartingPoint();
                    continue;
                }
                dynamicCursor = this.reOrderActionCursor(cursorSeqList);
                if (dynamicCursor == null) break;
                dynamiccaChain = dynamicCursor.getActionChainPoint();
                continue;
            }
            dynamicCursor = this.reOrderActionCursor(cursorSeqList);
            if (dynamicCursor == null) break;
            dynamiccaChain = dynamicCursor.getActionChainPoint();
        }
        return matchResult;
    }

    private AnalyzerCursor reOrderActionCursor(LinkedList<AnalyzerCursor> cursorSeqList) throws BaseStatusCode {
        while (cursorSeqList.size() > 0) {
            AnalyzerCursor dynamicCursor = cursorSeqList.removeLast();
            if (!dynamicCursor.isNextPointAvailable()) continue;
            dynamicCursor.moveStartingPoint();
            return dynamicCursor;
        }
        return null;
    }
}

