/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer;

import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerCursorImpl;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerDataFiller;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerInput;
import com.manageengine.ela.server.correlation.core.analyzer.DSelectorBAnalyzer;
import com.manageengine.ela.server.correlation.core.analyzer.SkipDataAnalyzer;
import com.manageengine.ela.server.correlation.core.analyzer.selector.RuleSelector;
import com.manageengine.ela.server.correlation.core.criteria.CrossActionChain;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SingleActionAnalyzer
extends DSelectorBAnalyzer {
    private static final Logger LOGGER = Logger.getLogger(SingleActionAnalyzer.class.getName());

    public SingleActionAnalyzer(AnalyzerInput input, CorrelationCallBack callBack) {
        super(input, callBack);
    }

    @Override
    protected void process(RuleSelector selector, Map<Long, SortedContainer> data) {
        AnalyzerInput input = super.getAnalyzerInput();
        CorrelationCallBack callBack = super.getCallBack();
        try {
            CrossActionChain chainHead = input.getCorssChainAction().getHead();
            int iterations = 0;
            int successIteration = 0;
            Long actionID = chainHead.getConfigActionID();
            SortedContainer cHeadData = data.get(actionID);
            AnalyzerCursorImpl cursor = new AnalyzerCursorImpl(null, cHeadData.getDirectMap(), chainHead);
            ResponseContainer responseContainer = new ResponseContainer(data.get(actionID));
            while (true) {
                ++iterations;
                LOGGER.log(Level.FINER, "ProcessThis : {0}", data);
                if (cursor == null || !cursor.isValidCursor()) break;
                responseContainer.reset();
                if (AnalyzerDataFiller.fillDataFromDataPool(cursor, chainHead, responseContainer, true)) {
                    ++successIteration;
                    HashMap<Long, ResponseContainer> response = new HashMap<Long, ResponseContainer>();
                    response.put(actionID, responseContainer);
                    callBack.callBack(input.getIdentity(), response);
                    super.clean(selector, data, response);
                    cursor.rebuildDerivedContainer(responseContainer.lastKey());
                    continue;
                }
                if (!cursor.isNextPointAvailable()) break;
                cursor.moveStartingPoint();
            }
            SkipDataAnalyzer.updateDataMarker(cHeadData);
            LOGGER.log(Level.FINER, "Rule analyzer total iteration : {0} , success : {1} ", new Object[]{iterations, successIteration});
        }
        catch (BaseStatusCode statuscode) {
            if (statuscode.getOrgStatusCode() == 12289L) {
                LOGGER.log(Level.FINER, "Rule analyzer chain broken - invalid rule request");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

