/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer;

import com.manageengine.ela.server.correlation.core.criteria.CrossActionChain;
import com.manageengine.ela.server.correlation.core.data.DataMarker;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class SkipDataAnalyzer {
    public static Long getPossibleMASPoint(Map<Long, SortedContainer> data, CrossActionChain actionChain) {
        TreeMap<Long, CrossActionChain> actionMap = new TreeMap<Long, CrossActionChain>();
        actionChain = actionChain.getHead();
        actionMap.put(data.get(actionChain.getConfigActionID()).firstKey(), actionChain);
        while (actionChain.hasNext()) {
            actionChain = actionChain.next();
            actionMap.put(data.get(actionChain.getConfigActionID()).firstKey(), actionChain);
        }
        Map.Entry maxStartTime = actionMap.lastEntry();
        CrossActionChain customActionList = (CrossActionChain)maxStartTime.getValue();
        Long startPoint = null;
        Long nextActionTimeLimit = 0L;
        do {
            SortedContainer dataContainer = data.get(customActionList.getConfigActionID());
            startPoint = SkipDataAnalyzer.getPossiblePoint(startPoint, dataContainer, customActionList.getTimeLimit(), nextActionTimeLimit);
            nextActionTimeLimit = customActionList.getTimeLimit();
        } while ((customActionList = customActionList.getPrevious()) != null);
        return startPoint;
    }

    private static Long getPossiblePoint(Long startPoint, SortedContainer dataContainer, Long curActionTimeLimit, Long nextActionTimeLimit) {
        if (startPoint == null || nextActionTimeLimit == null) {
            return dataContainer.firstKey();
        }
        Long timeBarrier = (curActionTimeLimit != null ? curActionTimeLimit : 0L) + nextActionTimeLimit;
        Long optimalStart = dataContainer.floorKey(startPoint - timeBarrier);
        return optimalStart == null ? dataContainer.firstKey() : optimalStart;
    }

    public static Long getPossibleSASPoint(SortedContainer cHeadData, int maxPossibleCount, boolean reset) {
        DataMarker dataMarker = cHeadData.getDataMarker();
        if (dataMarker == null) {
            return null;
        }
        Long possibleStartPoint = dataMarker.getLastCommitPoint();
        if (possibleStartPoint == 0L) {
            return null;
        }
        if (dataMarker.isDelayedCommit()) {
            possibleStartPoint = reset ? Long.valueOf(dataMarker.fetchDelayedCommitPointAndReset()) : Long.valueOf(dataMarker.fetchDelayedCommitPoint());
        }
        NavigableMap<Long, List<String>> dataMap = cHeadData.getDirectMap();
        while (maxPossibleCount-- > 0 && possibleStartPoint != null) {
            possibleStartPoint = dataMap.lowerKey(possibleStartPoint);
        }
        return possibleStartPoint;
    }

    public static void updateDataMarker(SortedContainer cHeadData) {
        DataMarker dataMarker = cHeadData.getDataMarker();
        if (dataMarker != null) {
            if (cHeadData.isEmpty()) {
                dataMarker.setLastCommitPoint(0L);
            } else {
                dataMarker.setLastCommitPoint(cHeadData.lastKey());
            }
        }
    }
}

