/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer.selector;

import com.manageengine.ela.server.correlation.core.analyzer.selector.FieldSelector;
import com.manageengine.ela.server.correlation.core.analyzer.selector.MultiFieldResolver;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ActionSelector {
    private final Map<String, FieldSelector> container;
    private Map<String, FieldSelector> dependentContainers;
    protected SortedContainer currentResult = null;
    private List<String> keyList;
    private int size;
    private boolean rotateNeeded = false;
    private int rotateInitiater;

    public ActionSelector(List<String> list, Map<String, FieldSelector> container) {
        this.container = container;
        this.keyList = list;
        this.size = this.keyList.size();
        this.rotateInitiater = this.size - 1;
        this.currentResult = this.next();
    }

    public SortedContainer next() {
        this.currentResult = null;
        HashMap<String, SortedContainer> fillThis = new HashMap<String, SortedContainer>();
        if (this.rotateNeeded && !this.performRotation(this.rotateInitiater, this.container)) {
            return null;
        }
        for (int index = 0; index < this.size; ++index) {
            String key = this.keyList.get(index);
            FieldSelector value = this.container.get(key);
            SortedContainer result = value.getCurrentResult();
            if (result == null || result.isEmpty()) {
                value.setFieldBroken(true);
                this.rotateNeeded = true;
                this.rotateInitiater = index;
                return null;
            }
            value.setFieldBroken(false);
            fillThis.put(key, result);
        }
        this.currentResult = MultiFieldResolver.resolve(fillThis);
        if (!this.rotateNeeded) {
            this.rotateNeeded = true;
            this.rotateInitiater = this.size - 1;
        }
        return this.currentResult;
    }

    public boolean hasNext() {
        FieldSelector fieldSelector = this.container.get(this.keyList.get(0));
        if (!fieldSelector.hasNext() && fieldSelector.isFieldBroken()) {
            return false;
        }
        AtomicBoolean flag = new AtomicBoolean();
        for (String key : this.keyList) {
            FieldSelector selector = this.container.get(key);
            if (selector.isEmpty()) {
                return false;
            }
            flag.set(flag.get() | selector.hasNext());
        }
        return flag.get();
    }

    void setDependentContainers(Map<String, FieldSelector> dependency) {
        this.dependentContainers = dependency;
    }

    void resetDependentFields() {
        this.dependentContainers = null;
    }

    void updateRotationInitIndex() {
        int index;
        if (this.rotateNeeded && (index = this.getNextEntry()) > this.rotateInitiater) {
            this.rotateInitiater = index;
        }
    }

    private int getNextEntry() {
        for (int i = 0; i < this.keyList.size(); ++i) {
            String key = this.keyList.get(i);
            FieldSelector selector = this.container.get(key);
            if (!selector.hasNext()) continue;
            return i;
        }
        return this.keyList.size() - 1;
    }

    private boolean performRotation(int position, Map<String, FieldSelector> container) {
        do {
            FieldSelector selector;
            if (!this.moveToNextElement(selector = container.get(this.keyList.get(position)))) continue;
            this.resetAllRightAfter(position);
            return true;
        } while (--position >= 0);
        return false;
    }

    private boolean moveToNextElement(FieldSelector selector) {
        while (selector.hasNext()) {
            if (selector.next() == null) continue;
            return true;
        }
        return false;
    }

    public SortedContainer getCurrentResult() {
        return this.currentResult;
    }

    public boolean reset() {
        for (int index = 0; index < this.size; ++index) {
            this.container.get(this.keyList.get(index)).reset();
        }
        this.rotateNeeded = false;
        this.currentResult = this.next();
        return true;
    }

    private void resetAllRightAfter(int position) {
        for (int index = position + 1; index < this.size; ++index) {
            this.container.get(this.keyList.get(index)).reset();
        }
    }

    public String toString() {
        return this.container.toString();
    }

    public void clean(ResponseContainer sContainer) {
        SortedContainer original = sContainer.getOriginalContainer();
        sContainer.getSelectedData().forEach((time, limit) -> {
            List<String> originalData = original.get((Long)time);
            ArrayList<String> dataCopy = new ArrayList<String>((int)limit);
            for (int index = 0; index < limit; ++index) {
                dataCopy.add(originalData.get(index));
            }
            this.container.forEach((key, value) -> value.clean((Long)time, (List<String>)dataCopy));
            if (this.dependentContainers != null) {
                this.dependentContainers.forEach((key, value) -> value.clean((Long)time, (List<String>)dataCopy));
            }
        });
    }
}

