/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer.selector;

import com.manageengine.ela.server.correlation.core.analyzer.selector.FieldController;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldSelector {
    private final Map<String, SortedContainer> derivedContainer;
    private Iterator<String> iterator;
    private final Set<String> fieldSet;
    private SortedContainer currentResult = null;
    private FieldController controller = null;
    private boolean isIndependent = false;
    private boolean isFieldBroken = false;
    private static final Logger LOGGER = Logger.getLogger(FieldSelector.class.getName());

    public FieldSelector(Long actionId, Set<String> fieldSet, Map<String, SortedContainer> derived, FieldController controller) {
        if (actionId == null || fieldSet == null || derived == null) {
            throw new NullPointerException();
        }
        this.fieldSet = fieldSet;
        this.derivedContainer = derived;
        this.iterator = fieldSet.iterator();
        this.controller = controller;
        if (controller == null || controller.getOwner() == actionId) {
            this.isIndependent = true;
            this.currentResult = this.next();
        } else {
            LOGGER.log(Level.FINER, "Selecting from controller(container)  {0}", this.currentResult);
            this.currentResult = derived.get(controller.getField());
        }
    }

    public SortedContainer remove(String key) {
        this.fieldSet.remove(key);
        this.iterator = this.fieldSet.iterator();
        return this.derivedContainer.get(key);
    }

    public void setController(FieldController controller) {
        this.controller = controller;
    }

    public boolean isEmpty() {
        return this.fieldSet.isEmpty();
    }

    public boolean reset() {
        this.iterator = this.fieldSet.iterator();
        if (this.isIndependent) {
            this.currentResult = this.next();
        } else {
            LOGGER.log(Level.FINER, "Selecting from controller(reset)  {0}", this.currentResult);
            this.currentResult = this.derivedContainer.get(this.controller.getField());
        }
        return true;
    }

    public SortedContainer next() {
        SortedContainer result;
        String key;
        this.currentResult = null;
        while (true) {
            key = this.findKey();
            LOGGER.log(Level.FINER, "Key selected  {0}", key);
            if (key == null) {
                return null;
            }
            result = this.derivedContainer.get(key);
            if (!result.isEmpty()) break;
            LOGGER.log(Level.FINER, "removing field  {0}", key);
            this.iterator.remove();
        }
        if (this.isIndependent && this.controller != null) {
            this.controller.setField(key);
        }
        this.currentResult = result;
        return result;
    }

    private String findKey() {
        if (this.hasNext()) {
            return this.iterator.next();
        }
        return null;
    }

    public boolean hasNext() {
        if (this.isIndependent) {
            return this.iterator.hasNext();
        }
        return false;
    }

    public SortedContainer getCurrentResult() {
        LOGGER.log(Level.FINER, "getCurrentResult  {0}", this.currentResult);
        return this.currentResult;
    }

    public String toString() {
        return "{ CONTAINER: " + this.derivedContainer + ", FIELDSET: " + this.fieldSet + ", CONTROLLER: " + this.controller + ", SELECTED:" + this.currentResult + " }";
    }

    public void clean(Long time, List<String> dataCopy) {
        this.derivedContainer.forEach((key, value) -> value.clearCorrelatedActions(time, dataCopy));
    }

    public boolean isFieldBroken() {
        return this.isFieldBroken;
    }

    public void setFieldBroken(boolean isFieldBroken) {
        this.isFieldBroken = isFieldBroken;
    }
}

