/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer.selector;

import com.manageengine.ela.server.correlation.common.data.PreProcessDataHandler;
import com.manageengine.ela.server.correlation.core.analyzer.SkipDataAnalyzer;
import com.manageengine.ela.server.correlation.core.analyzer.selector.ActionSelector;
import com.manageengine.ela.server.correlation.core.analyzer.selector.FieldController;
import com.manageengine.ela.server.correlation.core.analyzer.selector.FieldSelector;
import com.manageengine.ela.server.correlation.core.analyzer.selector.RuleSelector;
import com.manageengine.ela.server.correlation.core.constants.ActionType;
import com.manageengine.ela.server.correlation.core.criteria.ActionDelimiter;
import com.manageengine.ela.server.correlation.core.criteria.UniqueFieldChain;
import com.manageengine.ela.server.correlation.core.data.FieldDataContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.matcher.CommonRelationMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreProcessDataSelector {
    private static final Logger LOGGER = Logger.getLogger(PreProcessDataSelector.class.getName());

    public static Map<Long, Map<String, Map<String, Long>>> getCurrentProcessingLimitMap(PreProcessDataHandler dataHandler) {
        HashMap<Long, Map<String, Map<String, Long>>> limitMap = new HashMap<Long, Map<String, Map<String, Long>>>();
        if (dataHandler.getOriginalContainer().entrySet().stream().allMatch(entry -> {
            Long configuredAction = (Long)entry.getKey();
            Map<String, Map<String, SortedContainer>> orgChildContainer = ((FieldDataContainer)entry.getValue()).getDirectMap();
            int actionType = dataHandler.getActionType(configuredAction);
            Map<String, List<Map.Entry<Long, String>>> sharedFieldRef = dataHandler.getSharedFieldData(configuredAction);
            UniqueFieldChain uniqueFieldCondn = dataHandler.getUniqueFieldChain(configuredAction);
            if (actionType % ActionType.SHARED.getValue() == 0) {
                Map<String, Map<String, Long>> action = PreProcessDataSelector.getHybridFieldsLimit(actionType, uniqueFieldCondn, sharedFieldRef, orgChildContainer, dataHandler.getOriginalContainer());
                if (action == null || action.isEmpty()) {
                    return false;
                }
                limitMap.put(configuredAction, action);
            } else if (actionType % ActionType.UNIQUE.getValue() == 0) {
                Map<String, Map<String, Long>> action = PreProcessDataSelector.getUniqueFieldsLimit(uniqueFieldCondn, null, orgChildContainer);
                if (action == null || action.isEmpty()) {
                    return false;
                }
                limitMap.put(configuredAction, action);
            } else {
                Map<String, Map<String, Long>> action = PreProcessDataSelector.getCommonFieldsLimit(orgChildContainer);
                if (action == null || action.isEmpty()) {
                    return false;
                }
                limitMap.put(configuredAction, action);
            }
            return true;
        })) {
            LOGGER.log(Level.FINER, "Limit map formatted : {0}", limitMap);
            return limitMap;
        }
        LOGGER.log(Level.FINER, "Unable to get Limit map");
        return null;
    }

    private static Map<String, Map<String, Long>> getUniqueFieldsLimit(UniqueFieldChain uniqueFieldCondn, Set<String> only, Map<String, Map<String, SortedContainer>> orgChildContainer) {
        ConcurrentHashMap<String, Map<String, Long>> action = new ConcurrentHashMap<String, Map<String, Long>>();
        uniqueFieldCondn = uniqueFieldCondn.getHead();
        do {
            if (only != null && !only.contains(uniqueFieldCondn.getFieldName())) {
                LOGGER.log(Level.FINER, "Field rejected from given condn");
                continue;
            }
            String fieldName = uniqueFieldCondn.getFieldName();
            Map<String, SortedContainer> sourceContainer = orgChildContainer.get(fieldName);
            if (sourceContainer.isEmpty()) {
                return null;
            }
            ConcurrentHashMap childField = new ConcurrentHashMap();
            action.put(fieldName, childField);
            sourceContainer.forEach((fieldSource, docContainer) -> {
                if (!docContainer.isEmpty()) {
                    childField.put(fieldSource, docContainer.lastKey());
                }
            });
        } while ((uniqueFieldCondn = uniqueFieldCondn.next()) != null);
        return action;
    }

    private static Map<String, Map<String, Long>> getHybridFieldsLimit(int actiontype, UniqueFieldChain uniqueFieldCondn, Map<String, List<Map.Entry<Long, String>>> sharedFieldRef, Map<String, Map<String, SortedContainer>> orgChildContainer, Map<Long, FieldDataContainer> originalContainer) {
        ConcurrentHashMap<String, Map<String, Long>> action = new ConcurrentHashMap<String, Map<String, Long>>();
        if (actiontype % ActionType.UNIQUE.getValue() == 0 && actiontype % ActionType.SHARED.getValue() == 0) {
            HashSet<String> uniqueFields = new HashSet<String>();
            UniqueFieldChain temp = uniqueFieldCondn.getHead();
            do {
                uniqueFields.add(temp.getFieldName());
            } while ((temp = temp.next()) != null);
            uniqueFields.removeAll(sharedFieldRef.keySet());
            if (!uniqueFields.isEmpty()) {
                Map<String, Map<String, Long>> uniqueAction = PreProcessDataSelector.getUniqueFieldsLimit(uniqueFieldCondn, uniqueFields, orgChildContainer);
                if (uniqueAction == null || uniqueAction.isEmpty()) {
                    return null;
                }
                action.putAll(uniqueAction);
            }
        }
        if (actiontype % ActionType.SHARED.getValue() == 0) {
            Map<String, Map<String, Long>> sharedAction = PreProcessDataSelector.getSharedFieldsLimit(sharedFieldRef, orgChildContainer, originalContainer);
            if (sharedAction == null || sharedAction.isEmpty()) {
                return null;
            }
            action.putAll(sharedAction);
        }
        return action;
    }

    private static Map<String, Map<String, Long>> getSharedFieldsLimit(Map<String, List<Map.Entry<Long, String>>> sharedFieldRef, Map<String, Map<String, SortedContainer>> orgChildContainer, Map<Long, FieldDataContainer> originalContainer) {
        ConcurrentHashMap<String, Map<String, Long>> action = new ConcurrentHashMap<String, Map<String, Long>>();
        if (!sharedFieldRef.entrySet().stream().allMatch(entry -> {
            String field = (String)entry.getKey();
            List ref = (List)entry.getValue();
            Map orgchildField = (Map)orgChildContainer.get(field);
            ArrayList selectedFieldSource = new ArrayList();
            orgchildField.forEach((source, value) -> {
                if (ref.stream().allMatch(remoteLink -> {
                    Map<String, SortedContainer> container = ((FieldDataContainer)originalContainer.get(remoteLink.getKey())).getDirectMap().get(remoteLink.getValue());
                    return container.containsKey(source);
                })) {
                    selectedFieldSource.add(source);
                }
            });
            if (selectedFieldSource.isEmpty()) {
                return false;
            }
            ConcurrentHashMap<String, Long> childField = new ConcurrentHashMap<String, Long>();
            for (int index = 0; index < selectedFieldSource.size(); ++index) {
                String fieldSource = (String)selectedFieldSource.get(index);
                SortedContainer docContainer = (SortedContainer)orgchildField.get(fieldSource);
                if (docContainer.isEmpty()) continue;
                childField.put(fieldSource, docContainer.lastKey());
            }
            if (childField.isEmpty()) {
                return false;
            }
            action.put(field, childField);
            return true;
        })) {
            return null;
        }
        return action;
    }

    private static Map<String, Map<String, Long>> getCommonFieldsLimit(Map<String, Map<String, SortedContainer>> orgChildContainer) {
        ConcurrentHashMap<String, Map<String, Long>> action = new ConcurrentHashMap<String, Map<String, Long>>();
        orgChildContainer.forEach((field, orgchildField) -> {
            ConcurrentHashMap childField = new ConcurrentHashMap();
            action.put((String)field, childField);
            orgchildField.forEach((fieldSource, docContainer) -> {
                if (!docContainer.isEmpty()) {
                    childField.put(fieldSource, docContainer.lastKey());
                }
            });
        });
        return action;
    }

    public static RuleSelector createRuleContainerSelector(Map<Long, Map<String, Map<String, Long>>> limitMap, PreProcessDataHandler dataHandler) {
        HashMap<Long, ActionSelector> actionSelectorMap = new HashMap<Long, ActionSelector>();
        HashMap fieldControllerMap = new HashMap();
        for (Long actionID2 : dataHandler.getActionList()) {
            Map actionShFieldMap;
            Map<String, List<Map.Entry<Long, String>>> sharedFieldRef = dataHandler.getSharedFieldData(actionID2);
            if (sharedFieldRef == null) continue;
            if (fieldControllerMap.containsKey(actionID2)) {
                actionShFieldMap = (Map)fieldControllerMap.get(actionID2);
            } else {
                actionShFieldMap = new HashMap();
                fieldControllerMap.put(actionID2, actionShFieldMap);
            }
            sharedFieldRef.forEach((field, ref) -> actionShFieldMap.put(field, PreProcessDataSelector.findSharedFieldFef(actionID2, fieldControllerMap, ref)));
        }
        LOGGER.log(Level.FINER, "fieldControllerMap : {0}", fieldControllerMap);
        if (!dataHandler.getActionList().stream().allMatch(actionID -> {
            Map<String, Map<String, SortedContainer>> actionContainer = dataHandler.getOriginalContainer().get(actionID).getDirectMap();
            ActionDelimiter delimiter = dataHandler.getActionDelimiter((Long)actionID);
            Map controllerMap = (Map)fieldControllerMap.get(actionID);
            Map actionLimitMap = (Map)limitMap.get(actionID);
            LOGGER.log(Level.FINER, "Action Map : {0}", actionLimitMap);
            ActionSelector selector = PreProcessDataSelector.createActionContainerSelector(actionID, delimiter, actionLimitMap, controllerMap, actionContainer);
            if (selector == null) {
                return false;
            }
            actionSelectorMap.put((Long)actionID, selector);
            return true;
        })) {
            LOGGER.log(Level.FINER, "Invalid Rule container returned for : {0}", dataHandler.getActionList());
            return null;
        }
        LOGGER.log(Level.FINER, "Rule container selected : {0}", actionSelectorMap);
        return new RuleSelector(dataHandler.getActionList(), actionSelectorMap);
    }

    private static FieldController findSharedFieldFef(Long actionID, Map<Long, Map<String, FieldController>> fieldControllerMap, List<Map.Entry<Long, String>> ref) {
        int size = ref.size();
        for (int index = 0; index < size; ++index) {
            Map.Entry<Long, String> refEntry = ref.get(index);
            Long remoteActionID = refEntry.getKey();
            String remoteField = refEntry.getValue();
            Map<String, FieldController> fieldMap = fieldControllerMap.get(remoteActionID);
            if (fieldMap == null || !fieldMap.containsKey(remoteField)) continue;
            return fieldMap.get(remoteField);
        }
        return new FieldController(actionID);
    }

    public static ActionSelector createActionContainerSelector(Long actionID, ActionDelimiter delimiter, Map<String, Map<String, Long>> limitMap, Map<String, FieldController> controllerMap, Map<String, Map<String, SortedContainer>> actionContainer) {
        HashMap<String, FieldSelector> seclectorsMap = new HashMap<String, FieldSelector>();
        if (!limitMap.entrySet().stream().allMatch(entry -> {
            try {
                String field = (String)entry.getKey();
                Map fieldSourceMap = (Map)entry.getValue();
                Map originalfieldSourceMap = (Map)actionContainer.get(field);
                ConcurrentHashMap<String, SortedContainer> derivedfieldSourceMap = new ConcurrentHashMap<String, SortedContainer>();
                fieldSourceMap.forEach((fieldSource, containerLimit) -> {
                    SortedContainer container = (SortedContainer)originalfieldSourceMap.get(fieldSource);
                    if (delimiter == null) {
                        container = SortedContainer.getCustomContainer(container.headMap((Long)containerLimit, true), false, container.getDataMarker());
                        derivedfieldSourceMap.put((String)fieldSource, container);
                    } else {
                        Long startPoint = null;
                        container = delimiter.getOccurrence() > 1 ? ((startPoint = SkipDataAnalyzer.getPossibleSASPoint(container, delimiter.getOccurrence(), true)) != null ? SortedContainer.getCustomContainer(container.subMap(startPoint, (Long)containerLimit), false, container.getDataMarker()) : SortedContainer.getCustomContainer(container.headMap((Long)containerLimit, true), false, container.getDataMarker())) : SortedContainer.getCustomContainer(container.headMap((Long)containerLimit, true), false, container.getDataMarker());
                        if (CommonRelationMatcher.get().match(delimiter, container)) {
                            derivedfieldSourceMap.put((String)fieldSource, container);
                        } else {
                            LOGGER.log(Level.FINER, "CommonRelationMatcher returned false for  : {0}", container);
                        }
                    }
                });
                LOGGER.log(Level.FINER, "derivedfieldSourceMap created  : {0}", derivedfieldSourceMap);
                if (derivedfieldSourceMap.isEmpty()) {
                    return false;
                }
                FieldController controller = null;
                if (controllerMap != null && controllerMap.containsKey(field)) {
                    controller = (FieldController)controllerMap.get(field);
                }
                seclectorsMap.put(field, new FieldSelector(actionID, derivedfieldSourceMap.keySet(), derivedfieldSourceMap, controller));
                return true;
            }
            catch (Exception exp) {
                exp.printStackTrace();
                return false;
            }
        })) {
            return null;
        }
        return new ActionSelector(new ArrayList<String>(seclectorsMap.keySet()), seclectorsMap);
    }
}

