/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.analyzer.selector;

import com.manageengine.ela.server.correlation.core.analyzer.selector.ActionSelector;
import com.manageengine.ela.server.correlation.core.analyzer.selector.FieldSelector;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RuleSelector {
    private final Map<Long, ActionSelector> container;
    protected final Map<Long, SortedContainer> currentResult = new ConcurrentHashMap<Long, SortedContainer>();
    private List<Long> keyList;
    private int size;
    private boolean rotateNeeded = false;
    private int rotateInitiater;

    public RuleSelector(List<Long> list, Map<Long, ActionSelector> container) {
        this.container = container;
        this.keyList = list;
        this.size = this.keyList.size();
        this.rotateInitiater = this.size - 1;
    }

    public Map<Long, SortedContainer> next() {
        if (this.rotateNeeded) {
            this.performRotation(this.rotateInitiater, this.container);
        }
        this.currentResult.clear();
        for (int index = 0; index < this.size; ++index) {
            Long key = this.keyList.get(index);
            ActionSelector value = this.container.get(key);
            SortedContainer rContainer = value.getCurrentResult();
            if (rContainer == null || rContainer.isEmpty()) {
                this.rotateNeeded = true;
                this.rotateInitiater = index;
                return null;
            }
            this.currentResult.put(key, rContainer);
        }
        if (!this.rotateNeeded) {
            this.rotateNeeded = true;
            this.rotateInitiater = this.size - 1;
        }
        return this.currentResult;
    }

    public boolean hasNext() {
        ActionSelector actionSelector = this.container.get(this.keyList.get(0));
        if (!actionSelector.hasNext() && actionSelector.getCurrentResult() == null) {
            return false;
        }
        return this.keyList.stream().anyMatch(key -> this.container.get(key).hasNext());
    }

    public Map<Long, SortedContainer> getCurrentResult() {
        return this.currentResult;
    }

    private boolean performRotation(int position, Map<Long, ActionSelector> container) {
        do {
            ActionSelector selector;
            if (!this.moveToNextElement(selector = container.get(this.keyList.get(position)))) continue;
            this.resetAllRightAfter(position);
            return true;
        } while (--position >= 0);
        return false;
    }

    private boolean moveToNextElement(ActionSelector selector) {
        while (selector.hasNext()) {
            if (selector.next() != null) {
                return true;
            }
            if (!selector.hasNext()) continue;
            selector.updateRotationInitIndex();
        }
        return false;
    }

    public boolean reset() {
        for (int index = 0; index < this.size; ++index) {
            this.container.get(this.keyList.get(index)).reset();
        }
        this.rotateNeeded = false;
        return true;
    }

    private void resetAllRightAfter(int position) {
        for (int index = position + 1; index < this.size; ++index) {
            this.container.get(this.keyList.get(index)).reset();
        }
    }

    public void attachDependentFields(Long actionID, Map<String, FieldSelector> dependentFields) {
        this.container.get(actionID).setDependentContainers(dependentFields);
    }

    public void resetDependentFields(Long actionID) {
        this.container.get(actionID).resetDependentFields();
    }

    public String toString() {
        return this.container.toString();
    }

    public void clean(Map<Long, ResponseContainer> clean) {
        clean.forEach((actionID, value) -> this.container.get(actionID).clean((ResponseContainer)value));
    }
}

