/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.batchprocess;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DOBatchProcessor {
    private DataObject datacache;
    private final int maxcache = CorrConfigInfo.getResult_dispatcher_row_maxcache_size();
    private volatile int currentEntries = 0;
    private final Lock sync = new ReentrantLock(true);
    private final ScheduledExecutorService flushscheduler;
    private static final Persistence PERSISTENCE = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(DOBatchProcessor.class.getName());

    private DOBatchProcessor() throws DataAccessException {
        this.datacache = PERSISTENCE.constructDataObject();
        long processingInterval = CorrConfigInfo.getResult_dispatcher_cold_processing_period();
        this.flushscheduler = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
                paramThread.setName("correlation[dispatcher][flush]");
                super.beforeExecute(paramThread, paramRunnable);
            }
        };
        this.flushscheduler.scheduleWithFixedDelay(this::directCommit, processingInterval, processingInterval, TimeUnit.MILLISECONDS);
    }

    public static DOBatchProcessor create() throws DataAccessException {
        return new DOBatchProcessor();
    }

    public void insert(DataObject data) {
        long count = 0L;
        try {
            List tableNames = data.getTableNames();
            for (Object table : tableNames) {
                count += (long)data.size(table.toString());
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Unable to process insert request", exp.getMessage());
        }
        this.delayedCommit(count, data);
    }

    public void shutdown() {
        this.flushscheduler.shutdown();
        this.directCommit();
    }

    private void directCommit() {
        this.sync.lock();
        try {
            if (this.currentEntries > 0) {
                this.commitChanges();
            }
        }
        finally {
            this.sync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayedCommit(long currentCount, DataObject data) {
        this.sync.lock();
        try {
            try {
                this.datacache.merge(data);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            this.currentEntries = (int)((long)this.currentEntries + currentCount);
            if (this.currentEntries >= this.maxcache) {
                this.commitChanges();
            }
        }
        finally {
            this.sync.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitChanges() {
        try {
            long time = System.currentTimeMillis();
            PersistenceDBUtil.getPersistenceLite().update(this.datacache);
            LOGGER.log(Level.FINER, "DocIDBatchProcessor processed {0} entries, Total time taken : {1}", new Object[]{this.currentEntries, System.currentTimeMillis() - time});
            return;
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINER, "Unable to process database update", exp);
            return;
        }
        finally {
            try {
                this.datacache = PERSISTENCE.constructDataObject();
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                this.currentEntries = 0;
            }
        }
    }
}

