/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.builder;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.CorrelationRuleContainer;
import com.manageengine.ela.server.correlation.core.builder.CorrelationInitializer;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.data.DocDataManager;
import java.util.Objects;
import org.json.JSONException;

public class CorrelationBuilder {
    private DataObject dataContainer;
    private CorrelationCallBack callBAck;
    private Long ruleID;
    private CorrelationStatus status = CorrelationStatus.ENABLE;

    private CorrelationBuilder() {
    }

    public static CorrelationBuilder create() {
        return new CorrelationBuilder();
    }

    public CorrelationBuilder setDataContainer(DataObject dobj) {
        this.dataContainer = Objects.requireNonNull(dobj);
        return this;
    }

    public CorrelationBuilder setIdentity(Long ruleID) {
        this.ruleID = Objects.requireNonNull(ruleID);
        return this;
    }

    public CorrelationBuilder setCallBack(CorrelationCallBack callBack) {
        this.callBAck = Objects.requireNonNull(callBack);
        return this;
    }

    public CorrelationBuilder setStatus(CorrelationStatus status) {
        this.status = Objects.requireNonNull(status);
        return this;
    }

    public void build() throws NullPointerException, IllegalAccessException, BaseStatusCode, DataAccessException, JSONException {
        if (this.ruleID == null || this.dataContainer == null || this.callBAck == null) {
            throw new NullPointerException();
        }
        CorrelationInitializer.CorrelationInitializedRule correlationInitializedRule = CorrelationInitializer.initializeCorrelationRule(this.ruleID, this.dataContainer, this.callBAck);
        CorrelationRuleContainer.load(this.ruleID, correlationInitializedRule.getActionMap(), this.status);
        correlationInitializedRule.getActionListener().build();
    }

    public void enable() {
        if (this.ruleID == null) {
            throw new NullPointerException();
        }
        CorrelationRuleContainer.enable(this.ruleID);
    }

    public void disable() {
        if (this.ruleID == null) {
            throw new NullPointerException();
        }
        CorrelationRuleContainer.disable(this.ruleID);
    }

    public void delete() {
        if (this.ruleID == null) {
            throw new NullPointerException();
        }
        CorrelationRuleContainer.unload(this.ruleID);
        DocDataManager.get().removeRuleCache(this.ruleID);
    }
}

