/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.builder;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.action.ActionInput;
import com.manageengine.ela.server.correlation.core.action.CorrelationAction;
import com.manageengine.ela.server.correlation.core.action.CorrelationActionImpl;
import com.manageengine.ela.server.correlation.core.analyzer.AnalyzerInput;
import com.manageengine.ela.server.correlation.core.analyzer.MultiActionAnalyzer;
import com.manageengine.ela.server.correlation.core.analyzer.SingleActionAnalyzer;
import com.manageengine.ela.server.correlation.core.constants.ActionType;
import com.manageengine.ela.server.correlation.core.criteria.ActionDelimiter;
import com.manageengine.ela.server.correlation.core.criteria.CrossActionChain;
import com.manageengine.ela.server.correlation.core.criteria.FieldCriteria;
import com.manageengine.ela.server.correlation.core.criteria.UniqueFieldChain;
import com.manageengine.ela.server.correlation.core.data.DataStore;
import com.manageengine.ela.server.correlation.core.data.DocDataManager;
import com.manageengine.ela.server.correlation.core.data.RuleContainer;
import com.manageengine.ela.server.correlation.core.listener.CorrelationActionListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;

class CorrelationInitializer {
    CorrelationInitializer() {
    }

    public static CorrelationInitializedRule initializeCorrelationRule(Long ruleID, DataObject dataContainer, CorrelationCallBack callback) throws BaseStatusCode, DataAccessException, JSONException, NullPointerException, IllegalAccessException {
        RuleContainer container = DocDataManager.get().createRuleContainer(ruleID);
        Criteria ruleCriteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"), (Object)ruleID, 0);
        if (dataContainer.containsTable("CorrActionGroups")) {
            if (dataContainer.containsTable("CorrActionConditions")) {
                dataContainer.sortRows("CorrActionConditions", new SortColumn[]{new SortColumn("CorrActionConditions", "CONDITION_ORDER", true)});
            }
            dataContainer.sortRows("CorrActionGroups", new SortColumn[]{new SortColumn("CorrActionGroups", "GROUP_ORDER", true)});
        }
        dataContainer.sortRows("CorrConfiguredActions", new SortColumn[]{new SortColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ORDER"), true)});
        Iterator configuredActionItr = dataContainer.getRows("CorrConfiguredActions", ruleCriteria);
        LinkedHashMap<Long, ActionInfo> derivedActions = new LinkedHashMap<Long, ActionInfo>();
        CrossActionChain crossActionChain = null;
        while (configuredActionItr.hasNext()) {
            Row configuredAction = (Row)configuredActionItr.next();
            Long actionConfigID = (Long)configuredAction.get("CONFIG_ID");
            Long actionID = (Long)configuredAction.get("ACTION_ID");
            ActionInfo actionINfo = new ActionInfo(dataContainer, actionID, actionConfigID);
            Row actionDynamics = actionINfo.actionDynamics;
            if (actionDynamics != null) {
                Integer threashold = (Integer)actionDynamics.get("THRESHOLD_HITS");
                Long threasholdTime = (Long)actionDynamics.get("THRESHOLD_TIME");
                crossActionChain = crossActionChain == null ? CrossActionChain.create(actionConfigID, threasholdTime, threashold) : crossActionChain.add(actionConfigID, threasholdTime, threashold);
            } else {
                crossActionChain = crossActionChain == null ? CrossActionChain.create(actionConfigID, null, null) : crossActionChain.add(actionConfigID, null, null);
            }
            derivedActions.put(actionConfigID, actionINfo);
        }
        AnalyzerInput correlationRuleInput = new AnalyzerInput(ruleID, crossActionChain, container);
        CorrelationActionListener correlatedActionReceiver = derivedActions.size() == 1 ? new CorrelationActionListener(ruleID, derivedActions.keySet(), new SingleActionAnalyzer(correlationRuleInput, callback)) : new CorrelationActionListener(ruleID, derivedActions.keySet(), new MultiActionAnalyzer(correlationRuleInput, callback));
        HashMap<Long, Set<String>> indexFields = new HashMap<Long, Set<String>>();
        HashMap<Long, ActionInput> actionInputDetails = new HashMap<Long, ActionInput>();
        for (Map.Entry entry : derivedActions.entrySet()) {
            Long actionConfigID = (Long)entry.getKey();
            ActionInfo actionInfo = (ActionInfo)entry.getValue();
            ActionInput input = new ActionInput(ruleID, actionConfigID);
            input.setFieldCriteria(actionInfo.fieldCriteria);
            input.setActionDelimiter(actionInfo.relation);
            input.setActiontype(actionInfo.actionType);
            input.setNotificationID(actionInfo.notificationID);
            input.setReverseFieldConversion(actionInfo.fieldsTranslation != null && !actionInfo.fieldsTranslation.isEmpty() ? actionInfo.fieldsTranslation : null);
            Set<String> fields = CorrelationInitializer.getIndexFieldsSet(actionConfigID, indexFields);
            if (actionInfo.actionType % ActionType.SHARED.getValue() == 0) {
                input.setSharedFieldRef(actionInfo.sharedFieldsMap);
                actionInfo.sharedFieldsMap.forEach((key, value) -> {
                    fields.add((String)key);
                    value.forEach(fieldsEntry -> {
                        Set<String> remoteActionFieldsSet = CorrelationInitializer.getIndexFieldsSet((Long)fieldsEntry.getKey(), indexFields);
                        remoteActionFieldsSet.add((String)fieldsEntry.getValue());
                    });
                });
            }
            if (actionInfo.actionType % ActionType.UNIQUE.getValue() == 0) {
                input.setUniqueField(actionInfo.uniqueField);
                UniqueFieldChain chain = actionInfo.uniqueField.getHead();
                do {
                    fields.add(chain.getFieldName());
                } while ((chain = chain.next()) != null);
            }
            input.setIndexFields(fields);
            actionInputDetails.put(actionConfigID, input);
        }
        Integer storeType = (Integer)dataContainer.getValue("CorrRuleInfo", "STORE_TYPE", new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 0));
        DataStore.StoreType sType = DataStore.StoreType.getStoreType(storeType);
        container.initialize(derivedActions.keySet(), indexFields, crossActionChain.getTotalPossibleTimeLimit(), sType);
        LinkedHashMap correlationActionMap = new LinkedHashMap();
        actionInputDetails.forEach((actionid, actioninput) -> correlationActionMap.put(actionid, new CorrelationActionImpl((ActionInput)actioninput, correlatedActionReceiver, container)));
        return new CorrelationInitializedRule(correlationActionMap, correlatedActionReceiver);
    }

    public static Set<String> getIndexFieldsSet(Long actionID, Map<Long, Set<String>> fieldsInfoMap) {
        Set<String> indexFields = fieldsInfoMap.get(actionID);
        if (indexFields == null) {
            indexFields = new HashSet<String>();
            fieldsInfoMap.put(actionID, indexFields);
        }
        return indexFields;
    }

    private static class ActionInfo {
        private Long notificationID = null;
        private ActionDelimiter relation = null;
        private FieldCriteria fieldCriteria = null;
        private Row actionDynamics = null;
        private int actionType = ActionType.COMMON.getValue();
        private UniqueFieldChain uniqueField = null;
        private Map<String, List<Map.Entry<Long, String>>> sharedFieldsMap = null;
        private Map<Long, Set<String>> sharedFieldsSet = null;
        private Map<String, List<String>> fieldsTranslation = null;

        private ActionInfo(DataObject dataContainer, Long actionID, Long actionConfigID) throws DataAccessException, JSONException, BaseStatusCode {
            this.actionDynamics = this.getActionDYnamics(dataContainer, actionConfigID);
            this.notificationID = this.getNotificationID(dataContainer, actionID);
            this.relation = this.getActionDelimiterInfo(this.actionDynamics);
            this.fillFieldCriteria(dataContainer, actionConfigID);
            if (dataContainer.size("CorrAssociatedFieldsInfo") > 0) {
                this.fieldsTranslation = this.getFieldTranslationInfo(dataContainer, actionID);
            }
        }

        private Map<String, List<String>> getFieldTranslationInfo(DataObject dataContainer, Long actionID) throws DataAccessException {
            HashMap<String, List<String>> fieldsTranslation = new HashMap<String, List<String>>();
            Criteria condnFieldsCriteria = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"), (Object)actionID, 0);
            Iterator itr = dataContainer.getRows("CorrActionCondnFields", condnFieldsCriteria);
            DataObject allIndexFieldsDobj = PersistenceDBUtil.getPersistence().get("NoSqlIndexFields", (Criteria)null);
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                String outterFieldName = this.getFieldNameFromDO((Long)row.get("CONDN_FIELD_ID"), dataContainer);
                if (outterFieldName == null) continue;
                Criteria transLationFieldsCriteria = new Criteria(Column.getColumn((String)"CorrAssociatedFieldsInfo", (String)"FIELD_CONFIG_ID"), row.get("FIELD_CONFIG_ID"), 0);
                Iterator fieldItr = dataContainer.getRows("CorrAssociatedFieldsInfo", transLationFieldsCriteria);
                ArrayList<String> fieldsList = new ArrayList<String>();
                while (fieldItr.hasNext()) {
                    Row aFieldsRow = (Row)fieldItr.next();
                    String innerFieldName = this.getFieldNameFromDO((Long)aFieldsRow.get("FIELD_ID"), allIndexFieldsDobj);
                    if (innerFieldName == null) continue;
                    fieldsList.add(innerFieldName);
                }
                if (fieldsList.size() <= 0) continue;
                fieldsTranslation.put(outterFieldName, fieldsList);
            }
            return fieldsTranslation;
        }

        private Row getActionDYnamics(DataObject dataContainer, Long actionConfigID) throws DataAccessException {
            Criteria dynamics = new Criteria(Column.getColumn((String)"CorrActionDynamics", (String)"ACTION_CONFIG_ID"), (Object)actionConfigID, 0);
            return dataContainer.getRow("CorrActionDynamics", dynamics);
        }

        private void fillFieldCriteria(DataObject dataContainer, Long actionConfigID) throws DataAccessException, JSONException, BaseStatusCode {
            Criteria customCri = new Criteria(Column.getColumn((String)"CorrActionGroups", (String)"ACTION_CONFIG_ID"), (Object)actionConfigID, 0);
            Iterator groupIter = dataContainer.getRows("CorrActionGroups", customCri);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NoSqlIndexCriteria"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject CriteriaDobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            while (groupIter.hasNext()) {
                Row groupRow = (Row)groupIter.next();
                FieldCriteria innerGroupComparisons = null;
                Criteria conditionCriteria = new Criteria(Column.getColumn((String)"CorrActionConditions", (String)"GROUP_ID"), groupRow.get("GROUP_ID"), 0);
                Iterator conditionIter = dataContainer.getRows("CorrActionConditions", conditionCriteria);
                while (conditionIter.hasNext()) {
                    Row conditionRow = (Row)conditionIter.next();
                    String fieldName = this.getFieldNameFromDO((Long)conditionRow.get("FIELD_ID"), dataContainer);
                    int operation = (Integer)conditionRow.get("OPERATION");
                    Row conditionType = CriteriaDobj.getRow("NoSqlIndexCriteria", new Criteria(Column.getColumn((String)"NoSqlIndexCriteria", (String)"OPERATION"), (Object)operation, 0));
                    switch ((Integer)conditionType.get("TYPE")) {
                        case 0: {
                            Criteria forComparison = new Criteria(Column.getColumn((String)"CorrCondnComparisons", (String)"CONDITION_ID"), conditionRow.get("CONDITION_ID"), 0);
                            Row comparisonRow = dataContainer.getRow("CorrCondnComparisons", forComparison);
                            if (comparisonRow == null) break;
                            FieldCriteria conditionComparison = new FieldCriteria(fieldName, comparisonRow.get("CRITERIA_STRING"), operation);
                            innerGroupComparisons = this.getCombinedCriteria(innerGroupComparisons, conditionComparison, (Integer)conditionRow.get("LINK_TO_PREV"));
                            break;
                        }
                        case 1: {
                            this.addUniqueField(fieldName, operation);
                            break;
                        }
                        case 2: {
                            Criteria linkedCriteria = new Criteria(Column.getColumn((String)"CorrConditionLinkedFields", (String)"CONDITION_ID"), conditionRow.get("CONDITION_ID"), 0);
                            Iterator sharedIter = dataContainer.getRows("CorrConditionLinkedFields", linkedCriteria);
                            this.addSharedFields(fieldName, sharedIter, dataContainer);
                        }
                    }
                }
                this.fieldCriteria = this.getCombinedCriteria(this.fieldCriteria, innerGroupComparisons, (Integer)groupRow.get("LINK_TO_PREV"));
            }
        }

        private void addUniqueField(String fieldName, int operation) {
            if (this.actionType % ActionType.UNIQUE.getValue() != 0) {
                this.actionType *= ActionType.UNIQUE.getValue();
            }
            this.uniqueField = this.uniqueField == null ? UniqueFieldChain.create(fieldName, operation) : this.uniqueField.add(fieldName, operation);
        }

        private void addSharedFields(String fieldName, Iterator<?> iter, DataObject dataContainer) throws JSONException, DataAccessException, BaseStatusCode {
            if (this.sharedFieldsMap == null) {
                this.sharedFieldsMap = new ConcurrentHashMap<String, List<Map.Entry<Long, String>>>();
            }
            if (this.sharedFieldsSet == null) {
                this.sharedFieldsSet = new ConcurrentHashMap<Long, Set<String>>();
            }
            List<AbstractMap.SimpleEntry<Long, String>> fieldList = Collections.synchronizedList(new ArrayList());
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String remoteFieldName = this.getFieldNameFromDO((Long)row.get("LINKED_FIELD_ID"), dataContainer);
                fieldList.add(new AbstractMap.SimpleEntry<Long, String>((Long)row.get("LINKED_ACTION_CONFIG_ID"), remoteFieldName));
            }
            if (!fieldList.isEmpty()) {
                if (this.actionType % ActionType.SHARED.getValue() != 0) {
                    this.actionType *= ActionType.SHARED.getValue();
                }
                this.sharedFieldsMap.put(fieldName, fieldList);
            }
        }

        private String getFieldNameFromDO(Long fieldID, DataObject dataContainer) throws DataAccessException {
            Criteria fieldCri = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), (Object)fieldID, 0);
            Row fieldInfo = dataContainer.getRow("NoSqlIndexFields", fieldCri);
            return (String)fieldInfo.get("FIELD_INDEX_NAME");
        }

        private Long getNotificationID(DataObject dataContainer, Long actionID) throws DataAccessException {
            Criteria actionCriteria = new Criteria(Column.getColumn((String)"CorrActionProfileMapping", (String)"ACTION_ID"), (Object)actionID, 0);
            Row profileMapRow = dataContainer.getRow("CorrActionProfileMapping", actionCriteria);
            return (Long)profileMapRow.get("NOTIFID");
        }

        private ActionDelimiter getActionDelimiterInfo(Row actionDynamics) throws DataAccessException {
            if (actionDynamics != null && actionDynamics.get("THRESHOLD_HITS") != null && actionDynamics.get("THRESHOLD_TIME") != null) {
                ActionDelimiter relation = new ActionDelimiter((Long)actionDynamics.get("THRESHOLD_TIME"), (Integer)actionDynamics.get("THRESHOLD_HITS"));
                return relation;
            }
            return null;
        }

        private FieldCriteria getCombinedCriteria(FieldCriteria criteria, FieldCriteria merge, int type) {
            if (criteria != null && merge != null) {
                if (type == 0) {
                    return criteria.and(merge);
                }
                return criteria.or(merge);
            }
            if (criteria == null) {
                return merge;
            }
            return criteria;
        }
    }

    static class CorrelationInitializedRule {
        private Map<Long, CorrelationAction> correlationActionMap;
        private CorrelationActionListener actionListener;

        private CorrelationInitializedRule(Map<Long, CorrelationAction> map, CorrelationActionListener listener) {
            this.correlationActionMap = map;
            this.actionListener = listener;
        }

        public Map<Long, CorrelationAction> getActionMap() {
            return this.correlationActionMap;
        }

        public CorrelationActionListener getActionListener() {
            return this.actionListener;
        }
    }
}

