/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.criteria;

import org.json.JSONObject;

public class CrossActionChain {
    private CrossActionChain head = null;
    private CrossActionChain next = null;
    private CrossActionChain previous = null;
    private Long timeLimit = null;
    private Long configActionID = null;
    private Integer occurance = null;

    private CrossActionChain(Long configActionID, Long timeLimit, Integer occurance) {
        this.setTimeLimit(timeLimit);
        this.setConfigActionID(configActionID);
        this.setOccurance(occurance);
    }

    public static CrossActionChain create(Long configActionID, Long timeLimit, Integer occurance) {
        CrossActionChain crossAction = new CrossActionChain(configActionID, timeLimit, occurance);
        crossAction.setHead(crossAction);
        return crossAction;
    }

    public CrossActionChain add(Long configActionID, Long timeLimit, Integer occurance) {
        CrossActionChain crossAction = new CrossActionChain(configActionID, timeLimit, occurance);
        crossAction.setPrevious(this);
        crossAction.setHead(this.getHead());
        this.setNext(crossAction);
        return crossAction;
    }

    public Long getTotalPossibleTimeLimit() {
        Long totalPossibleTime = 0L;
        for (CrossActionChain initial = this.getHead(); initial != null; initial = initial.next()) {
            if (initial.getTimeLimit() == null) continue;
            totalPossibleTime = totalPossibleTime + initial.getTimeLimit();
        }
        return totalPossibleTime;
    }

    public Long getTimeLimit() {
        return this.timeLimit;
    }

    private void setTimeLimit(Long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Long getConfigActionID() {
        return this.configActionID;
    }

    private void setConfigActionID(Long configActionID) {
        this.configActionID = configActionID;
    }

    public Integer getOccurance() {
        if (this.occurance == null) {
            return 1;
        }
        return this.occurance;
    }

    private void setOccurance(Integer occurance) {
        this.occurance = occurance;
    }

    public CrossActionChain next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean hasPrevious() {
        return this.previous != null;
    }

    private void setNext(CrossActionChain next) {
        this.next = next;
    }

    public CrossActionChain getHead() {
        return this.head;
    }

    private void setHead(CrossActionChain head) {
        this.head = head;
    }

    public CrossActionChain getPrevious() {
        return this.previous;
    }

    private void setPrevious(CrossActionChain previous) {
        this.previous = previous;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(" (").append(String.valueOf(new JSONObject().put("CONFIGACTIONID", (Object)this.configActionID).put("TIMELIMIT", (Object)this.timeLimit).put("OCCURANCE", (Object)this.occurance).toString())).append(") ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.next != null) {
            builder.append(" (").append(String.valueOf(this.next)).append(") ");
        }
        return builder.toString();
    }
}

