/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.criteria;

public class FieldCriteria {
    private FieldCriteria leftCriteria = null;
    private FieldCriteria rightCriteria = null;
    private FieldCriterion criterion = null;
    private boolean isConnector = false;
    private int connector;

    private FieldCriteria() {
    }

    public FieldCriteria(String field, Object fieldValue, int comparator) {
        this.setCriterion(new FieldCriterion(field, fieldValue, comparator, false));
    }

    public FieldCriteria and(FieldCriteria criteria) {
        FieldCriteria newCriteria = new FieldCriteria();
        newCriteria.setLeftCriteria(this);
        newCriteria.setRightCriteria(criteria);
        newCriteria.setConnector(0);
        newCriteria.setIsConnector(true);
        return newCriteria;
    }

    public FieldCriteria or(FieldCriteria criteria) {
        FieldCriteria newCriteria = new FieldCriteria();
        newCriteria.setLeftCriteria(this);
        newCriteria.setRightCriteria(criteria);
        newCriteria.setConnector(1);
        newCriteria.setIsConnector(true);
        return newCriteria;
    }

    public int getConnector() {
        return this.connector;
    }

    private void setConnector(int connector) {
        this.connector = connector;
    }

    public FieldCriteria getLeftCriteria() {
        return this.leftCriteria;
    }

    public void setLeftCriteria(FieldCriteria leftCriteria) {
        this.leftCriteria = leftCriteria;
    }

    public FieldCriteria getRightCriteria() {
        return this.rightCriteria;
    }

    private void setRightCriteria(FieldCriteria rightCriteria) {
        this.rightCriteria = rightCriteria;
    }

    public FieldCriterion getCriterion() {
        return this.criterion;
    }

    private void setCriterion(FieldCriterion criterion) {
        this.criterion = criterion;
    }

    public boolean isConnector() {
        return this.isConnector;
    }

    private void setIsConnector(boolean flag) {
        this.isConnector = flag;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        FieldCriteria.loadFormattedCriteria(this, buffer, true);
        return buffer.toString();
    }

    public static void loadFormattedCriteria(FieldCriteria criteria, StringBuffer buffer, boolean flag) {
        if (criteria.getCriterion() == null) {
            FieldCriteria left = criteria.getLeftCriteria();
            FieldCriteria.loadFormattedCriteria(left, buffer, false);
            buffer.append(" ").append(FieldCriteria.getConnector(criteria.getConnector())).append(" ");
            FieldCriteria right = criteria.getRightCriteria();
            FieldCriteria.loadFormattedCriteria(right, buffer, true);
        } else if (flag) {
            buffer.append(FieldCriteria.getCriterian(criteria.getCriterion()));
        } else {
            buffer.insert(0, FieldCriteria.getCriterian(criteria.getCriterion()));
        }
    }

    private static StringBuffer getCriterian(FieldCriterion criterian) {
        StringBuffer local = new StringBuffer();
        local.append(" (").append(criterian.getField()).append(FieldCriteria.getCondn(criterian.getComparator(), criterian.getFieldvalue())).append(") ");
        return local;
    }

    private static String getConnector(int con) {
        switch (con) {
            case 0: {
                return "AND";
            }
        }
        return "OR";
    }

    private static StringBuffer getCondn(int con, Object fieldvalue) {
        StringBuffer condition = new StringBuffer();
        switch (con) {
            case 0: {
                condition.append("==").append(fieldvalue);
                break;
            }
            case 1: {
                condition.append("!=").append(fieldvalue);
                break;
            }
            case 2: {
                condition.append("*").append(fieldvalue).append("*");
                break;
            }
            case 3: {
                condition.append(fieldvalue).append("*");
                break;
            }
            case 4: {
                condition.append("*").append(fieldvalue);
                break;
            }
            default: {
                condition.append("!*").append(fieldvalue);
            }
        }
        return condition;
    }

    public class FieldCriterion {
        private String field;
        private Object fieldvalue;
        private int comparator;
        private boolean caseSensitive = true;

        public FieldCriterion(String field, Object value, int comparator, boolean caseSensitive) {
            this.setField(field);
            this.setFieldvalue(value);
            this.setComparator(comparator);
            this.setCaseSensitive(caseSensitive);
        }

        public Object getFieldvalue() {
            return this.fieldvalue;
        }

        private void setFieldvalue(Object fieldvalue) {
            this.fieldvalue = fieldvalue;
        }

        public String getField() {
            return this.field;
        }

        private void setField(String field) {
            this.field = field;
        }

        public int getComparator() {
            return this.comparator;
        }

        private void setComparator(int comparator) {
            this.comparator = comparator;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        private void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }
    }
}

