/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.criteria;

import org.json.JSONObject;

public class UniqueFieldChain {
    private UniqueFieldChain head = null;
    private UniqueFieldChain next = null;
    private UniqueFieldChain previous = null;
    private final String fieldName;
    private final int comparator;

    private UniqueFieldChain(String fieldName, int comparator) {
        this.fieldName = fieldName;
        this.comparator = comparator;
    }

    public static UniqueFieldChain create(String fieldName, int comparator) {
        UniqueFieldChain crossAction = new UniqueFieldChain(fieldName, comparator);
        crossAction.setHead(crossAction);
        return crossAction;
    }

    public UniqueFieldChain add(String fieldName, int comparator) {
        UniqueFieldChain crossAction = new UniqueFieldChain(fieldName, comparator);
        crossAction.setPrevious(this);
        crossAction.setHead(this.getHead());
        this.setNext(crossAction);
        return crossAction;
    }

    public UniqueFieldChain next() {
        return this.next;
    }

    private void setNext(UniqueFieldChain next) {
        this.next = next;
    }

    public UniqueFieldChain getHead() {
        return this.head;
    }

    private void setHead(UniqueFieldChain head) {
        this.head = head;
    }

    public UniqueFieldChain getPrevious() {
        return this.previous;
    }

    private void setPrevious(UniqueFieldChain previous) {
        this.previous = previous;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getComparator() {
        return this.comparator;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(" (").append(String.valueOf(new JSONObject().put("FIELDNAME", (Object)this.fieldName).put("COMPARATOR", this.comparator).toString())).append(") ");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.next != null) {
            builder.append(" (").append(String.valueOf(this.next)).append(") ");
        }
        return builder.toString();
    }
}

