/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data;

import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.data.javaheap.JavaHeapDataStoreImpl;
import com.manageengine.ela.server.correlation.core.data.mapdb.MapDBDataStore;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public interface DataStore {
    public Map<String, Map<String, SortedContainer>> initializeAndLoadAvailableDataFromStore(Object var1, Set<String> var2);

    public void clearLiveData();

    public void flushDataFromLive();

    public void restoreDataFromDisk();

    public static DataStore getDataStore(Long identity, Lock controller, long coldDataPeriod, StoreType storeType) {
        switch (storeType) {
            case OFFHEAP_MAPDB: {
                return new MapDBDataStore(identity, controller, coldDataPeriod);
            }
        }
        return new JavaHeapDataStoreImpl(identity, controller, coldDataPeriod);
    }

    public Lock getStoreSwapLock();

    public SortedContainer getContainerFromExistingStore(Object var1, String var2, String var3, long var4);

    public static enum StoreType {
        JAVAHEAP(0),
        OFFHEAP_MAPDB(1);

        private Integer value;

        public Integer getValue() {
            return this.value;
        }

        private StoreType(int value) {
            this.value = value;
        }

        public static StoreType getStoreType(int value) {
            if (value == 0) {
                return JAVAHEAP;
            }
            return OFFHEAP_MAPDB;
        }
    }
}

