/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data;

import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.data.RuleContainer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DocDataManager {
    private static DocDataManager instence = null;
    private Map<Long, RuleContainer> correlation_data_container = new ConcurrentHashMap<Long, RuleContainer>();
    private final ScheduledThreadPoolExecutor docDataCleaner = new ScheduledThreadPoolExecutor(10){

        @Override
        protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
            paramThread.setName("correlation[data][cleanup]");
            super.beforeExecute(paramThread, paramRunnable);
        }
    };

    public static DocDataManager get() {
        return instence;
    }

    public RuleContainer createRuleContainer(Long ruleID) {
        RuleContainer ruleContainer = this.correlation_data_container.get(ruleID);
        if (ruleContainer != null) {
            return ruleContainer;
        }
        ruleContainer = new RuleContainer(ruleID, this.docDataCleaner);
        this.correlation_data_container.put(ruleID, ruleContainer);
        this.initializeCleanupProcess(ruleContainer);
        return ruleContainer;
    }

    public RuleContainer getRuleContainer(Long ruleID) {
        return this.correlation_data_container.get(ruleID);
    }

    public void removeRuleCache(Long ruleID) {
        this.removeCleanupProcess(this.correlation_data_container.get(ruleID));
        RuleContainer removedContainer = this.correlation_data_container.remove(ruleID);
        if (removedContainer != null) {
            removedContainer.flushLiveData();
        }
    }

    void initializeCleanupProcess(RuleContainer container) {
        if (container != null) {
            long cleanupDelay = CorrConfigInfo.getDefaultColdLogProcessingPeriod();
            this.docDataCleaner.scheduleWithFixedDelay(container.getCleanupProcessor(), 0L, cleanupDelay, TimeUnit.MILLISECONDS);
        }
    }

    private void removeCleanupProcess(RuleContainer container) {
        if (container != null) {
            this.docDataCleaner.remove(container.getCleanupProcessor());
        }
    }

    @Deprecated
    public Map<Long, RuleContainer> getDataContainer() {
        return this.correlation_data_container;
    }

    static {
        instence = new DocDataManager();
    }
}

