/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.core.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DocInfo {
    private final String id;
    private final String indexName;
    private Map<String, Object> docImportentData = null;

    private DocInfo(String docID, String index) {
        this.id = docID;
        this.indexName = index;
    }

    public static DocInfo get(String docID, String index) {
        if (docID == null || index == null) {
            throw new NullPointerException();
        }
        return new DocInfo(docID, index);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getID() {
        return this.id;
    }

    public void storeField(String field, Object fieldValue) {
        if (this.docImportentData == null) {
            this.docImportentData = new ConcurrentHashMap<String, Object>();
        }
        this.docImportentData.put(field, fieldValue);
    }

    public Object getField(String field) {
        if (this.docImportentData == null) {
            return null;
        }
        return this.docImportentData.get(field);
    }

    public String toString() {
        return this.indexName + "_" + this.id;
    }
}

